/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.item;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import toughasnails.api.item.ItemDrink;
import toughasnails.api.thirst.IDrink;

public class ItemFruitJuice
extends ItemDrink<JuiceType> {
    @Override
    public JuiceType getTypeFromMeta(int meta) {
        return JuiceType.values()[meta % JuiceType.values().length];
    }

    public String func_77667_c(ItemStack stack) {
        return "item.juice_" + this.getTypeFromMeta(stack.func_77960_j()).toString();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        for (JuiceType juiceType : JuiceType.values()) {
            subItems.add((Object)new ItemStack(item, 1, juiceType.ordinal()));
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        switch (this.getTypeFromMeta(stack.func_77960_j())) {
            case GLISTERING_MELON: 
            case GOLDEN_APPLE: 
            case GOLDEN_CARROT: {
                return true;
            }
        }
        return super.func_77636_d(stack);
    }

    public static enum JuiceType implements IDrink,
    IStringSerializable
    {
        APPLE(8, 0.8f),
        BEETROOT(10, 0.8f),
        CACTUS(9, 0.2f),
        CARROT(8, 0.6f),
        CHORUS_FRUIT(12, 0.6f),
        GLISTERING_MELON(16, 1.0f),
        GOLDEN_APPLE(20, 1.2f),
        GOLDEN_CARROT(14, 1.0f),
        MELON(8, 0.5f),
        PUMPKIN(7, 0.7f);

        private int thirst;
        private float hydration;

        private JuiceType(int thirst, float hydration) {
            this.thirst = thirst;
            this.hydration = hydration;
        }

        @Override
        public int getThirst() {
            return this.thirst;
        }

        @Override
        public float getHydration() {
            return this.hydration;
        }

        @Override
        public float getPoisonChance() {
            return 0.0f;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

