/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.item;

import java.util.Map;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import toughasnails.api.item.IColoredItem;
import toughasnails.init.ModEntities;

public class ItemTANSpawnEgg
extends Item
implements IColoredItem {
    public ItemTANSpawnEgg() {
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        for (Map.Entry<Integer, EntityList.EntityEggInfo> entry : ModEntities.entityEggs.entrySet()) {
            subItems.add((Object)new ItemStack(itemIn, 1, entry.getKey().intValue()));
        }
    }

    public static Entity spawnTANCreature(World worldIn, int entityID, double x, double y, double z) {
        Entity entity = ModEntities.createEntityByID(entityID, worldIn);
        if (entity instanceof EntityLivingBase) {
            EntityLiving entityliving = (EntityLiving)entity;
            entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            entityliving.field_70759_as = entityliving.field_70177_z;
            entityliving.field_70761_aq = entityliving.field_70177_z;
            entityliving.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)entityliving)), (IEntityLivingData)null);
            worldIn.func_72838_d(entity);
            entityliving.func_70642_aH();
        }
        return entity;
    }

    public String func_77667_c(ItemStack stack) {
        int bopEntityId = stack.func_77960_j();
        String entityName = ModEntities.idToTANEntityName.get(bopEntityId);
        return super.func_77667_c(stack) + "_" + entityName;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                EntityList.EntityEggInfo entityegginfo = ModEntities.entityEggs.get(stack.func_77960_j());
                return entityegginfo != null ? (tintIndex == 0 ? entityegginfo.field_75611_b : entityegginfo.field_75612_c) : 0xFFFFFF;
            }
        };
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Entity entity;
        TileEntity tileentity;
        ItemStack stack = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!playerIn.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (iblockstate.func_177230_c() == Blocks.field_150474_ac && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityMobSpawner) {
            MobSpawnerBaseLogic mobspawnerbaselogic = ((TileEntityMobSpawner)tileentity).func_145881_a();
            mobspawnerbaselogic.func_190894_a(ItemMonsterPlacer.func_190908_h((ItemStack)stack));
            tileentity.func_70296_d();
            worldIn.func_184138_a(pos, iblockstate, iblockstate, 3);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                stack.func_190920_e(stack.func_190916_E() - 1);
            }
            return EnumActionResult.SUCCESS;
        }
        pos = pos.func_177972_a(facing);
        double d0 = 0.0;
        if (facing == EnumFacing.UP && iblockstate instanceof BlockFence) {
            d0 = 0.5;
        }
        if ((entity = ItemTANSpawnEgg.spawnTANCreature(worldIn, stack.func_77960_j(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + d0, (double)pos.func_177952_p() + 0.5)) != null) {
            if (entity instanceof EntityLivingBase && stack.func_82837_s()) {
                entity.func_96094_a(stack.func_82833_r());
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                stack.func_190920_e(stack.func_190916_E() - 1);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        RayTraceResult movingobjectposition = this.func_77621_a(world, player, true);
        if (movingobjectposition == null) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK) {
            Entity entity;
            BlockPos blockpos = movingobjectposition.func_178782_a();
            if (!world.func_175660_a(player, blockpos)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            if (!player.func_175151_a(blockpos, movingobjectposition.field_178784_b, stack)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            if (world.func_180495_p(blockpos).func_177230_c() instanceof BlockLiquid && (entity = ItemTANSpawnEgg.spawnTANCreature(world, stack.func_77960_j(), (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5)) != null) {
                if (entity instanceof EntityLivingBase && stack.func_82837_s()) {
                    ((EntityLiving)entity).func_96094_a(stack.func_82833_r());
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190920_e(stack.func_190916_E() - 1);
                }
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

