/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.season;

import com.google.common.base.Preconditions;
import toughasnails.api.config.SeasonsOption;
import toughasnails.api.config.SyncedConfig;
import toughasnails.api.season.ISeasonData;
import toughasnails.api.season.Season;

public final class SeasonTime
implements ISeasonData {
    public static final SeasonTime ZERO = new SeasonTime(0);
    public final int time;

    public SeasonTime(int time) {
        Preconditions.checkArgument((time >= 0 ? 1 : 0) != 0, (Object)"Time cannot be negative!");
        this.time = time;
    }

    @Override
    public int getDayDuration() {
        return SyncedConfig.getIntValue(SeasonsOption.DAY_DURATION);
    }

    @Override
    public int getSubSeasonDuration() {
        return this.getDayDuration() * SyncedConfig.getIntValue(SeasonsOption.SUB_SEASON_DURATION);
    }

    @Override
    public int getSeasonDuration() {
        return this.getSubSeasonDuration() * 3;
    }

    @Override
    public int getCycleDuration() {
        return this.getSubSeasonDuration() * Season.SubSeason.values().length;
    }

    @Override
    public int getSeasonCycleTicks() {
        return this.time;
    }

    @Override
    public int getDay() {
        return this.time / this.getDayDuration();
    }

    @Override
    public Season.SubSeason getSubSeason() {
        int index = this.time / this.getSubSeasonDuration() % Season.SubSeason.values().length;
        return Season.SubSeason.values()[index];
    }

    @Override
    public Season getSeason() {
        return this.getSubSeason().getSeason();
    }
}

