/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature.modifier;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import toughasnails.api.config.SeasonsOption;
import toughasnails.api.config.SyncedConfig;
import toughasnails.api.season.Season;
import toughasnails.api.season.SeasonHelper;
import toughasnails.api.temperature.Temperature;
import toughasnails.init.ModConfig;
import toughasnails.temperature.TemperatureDebugger;
import toughasnails.temperature.modifier.TemperatureModifier;

public class SeasonModifier
extends TemperatureModifier {
    public SeasonModifier(TemperatureDebugger debugger) {
        super(debugger);
    }

    @Override
    public Temperature modifyTarget(World world, EntityPlayer player, Temperature temperature) {
        int temperatureLevel = temperature.getRawValue();
        Season.SubSeason season = SeasonHelper.getSeasonData(world).getSubSeason();
        if (!SyncedConfig.getBooleanValue(SeasonsOption.ENABLE_SEASONS)) {
            season = Season.SubSeason.MID_SUMMER;
        }
        this.debugger.start(TemperatureDebugger.Modifier.SEASON_TARGET, temperatureLevel);
        if (world.field_73011_w.func_76569_d()) {
            switch (season) {
                case EARLY_SPRING: {
                    temperatureLevel += ModConfig.temperature.earlySpringModifier;
                    break;
                }
                case MID_SPRING: {
                    temperatureLevel += ModConfig.temperature.midSpringModifier;
                    break;
                }
                case LATE_SPRING: {
                    temperatureLevel += ModConfig.temperature.lateSpringModifier;
                    break;
                }
                case EARLY_SUMMER: {
                    temperatureLevel += ModConfig.temperature.earlySummerModifier;
                    break;
                }
                case MID_SUMMER: {
                    temperatureLevel += ModConfig.temperature.midSummerModifier;
                    break;
                }
                case LATE_SUMMER: {
                    temperatureLevel += ModConfig.temperature.lateSummerModifier;
                    break;
                }
                case EARLY_AUTUMN: {
                    temperatureLevel += ModConfig.temperature.earlyAutumnModifier;
                    break;
                }
                case MID_AUTUMN: {
                    temperatureLevel += ModConfig.temperature.midAutumnModifier;
                    break;
                }
                case LATE_AUTUMN: {
                    temperatureLevel += ModConfig.temperature.lateAutumnModifier;
                    break;
                }
                case EARLY_WINTER: {
                    temperatureLevel += ModConfig.temperature.earlyWinterModifier;
                    break;
                }
                case MID_WINTER: {
                    temperatureLevel += ModConfig.temperature.midWinterModifier;
                    break;
                }
                case LATE_WINTER: {
                    temperatureLevel += ModConfig.temperature.lateWinterModifier;
                    break;
                }
            }
        }
        this.debugger.end(temperatureLevel);
        return new Temperature(temperatureLevel);
    }
}

