/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import toughasnails.api.TANCapabilities;
import toughasnails.api.TANPotions;
import toughasnails.api.config.GameplayOption;
import toughasnails.api.config.SyncedConfig;
import toughasnails.api.stat.StatHandlerBase;
import toughasnails.api.stat.capability.ITemperature;
import toughasnails.api.temperature.IModifierMonitor;
import toughasnails.api.temperature.ITemperatureModifier;
import toughasnails.api.temperature.Temperature;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.temperature.TemperatureScale;
import toughasnails.network.message.MessageUpdateStat;
import toughasnails.temperature.TemperatureDebugger;
import toughasnails.temperature.modifier.AltitudeModifier;
import toughasnails.temperature.modifier.ArmorModifier;
import toughasnails.temperature.modifier.BiomeModifier;
import toughasnails.temperature.modifier.ObjectProximityModifier;
import toughasnails.temperature.modifier.PlayerStateModifier;
import toughasnails.temperature.modifier.TemperatureModifier;
import toughasnails.temperature.modifier.TimeModifier;
import toughasnails.temperature.modifier.WeatherModifier;

public class TemperatureHandler
extends StatHandlerBase
implements ITemperature {
    private int temperatureLevel;
    private int prevTemperatureLevel;
    private int temperatureTimer;
    private Map<String, TemperatureModifier.ExternalModifier> externalModifiers;
    public final TemperatureDebugger debugger = new TemperatureDebugger();

    public TemperatureHandler() {
        this.prevTemperatureLevel = this.temperatureLevel = TemperatureScale.getScaleTotal() / 2;
        this.externalModifiers = Maps.newHashMap();
    }

    @Override
    public void update(EntityPlayer player, World world, TickEvent.Phase phase) {
        if (!SyncedConfig.getBooleanValue(GameplayOption.ENABLE_TEMPERATURE)) {
            return;
        }
        if (phase == TickEvent.Phase.END && !world.field_72995_K) {
            int targetTemperature = this.getPlayerTarget(player);
            int tempChangeTicks = TemperatureScale.getRateForTemperatures(this.temperatureLevel, targetTemperature);
            boolean incrementTemperature = ++this.temperatureTimer >= tempChangeTicks;
            boolean updateClient = ++this.debugger.debugTimer % 5 == 0;
            this.debugger.temperatureTimer = this.temperatureTimer;
            this.debugger.changeTicks = tempChangeTicks;
            for (Map.Entry<String, TemperatureModifier.ExternalModifier> entry : this.externalModifiers.entrySet()) {
                if (entry.getValue().getEndTime() >= this.temperatureTimer) continue;
                this.externalModifiers.remove(entry.getKey());
            }
            if (incrementTemperature) {
                if (!player.func_184812_l_() && (world.func_175659_aa() != EnumDifficulty.PEACEFUL || SyncedConfig.getBooleanValue(GameplayOption.ENABLE_PEACEFUL))) {
                    this.addTemperature(new Temperature((int)Math.signum(targetTemperature - this.temperatureLevel)));
                }
                this.temperatureTimer = 0;
            }
            this.addPotionEffects(player);
            if (updateClient) {
                this.debugger.finalize((EntityPlayerMP)player);
            }
        }
    }

    @Override
    public int getPlayerTarget(EntityPlayer player) {
        int targetTemperature = TemperatureHelper.getTargetAtPosUnclamped(player.field_70170_p, player.func_180425_c(), this.debugger).getRawValue();
        for (ITemperatureModifier modifier : TemperatureHelper.getTemperatureModifiers().values()) {
            if (!modifier.isPlayerSpecific()) continue;
            targetTemperature = modifier.applyPlayerModifiers(player, new Temperature(targetTemperature), this.debugger).getRawValue();
        }
        Temperature preClimatisationTemp = new Temperature(targetTemperature);
        for (TemperatureModifier.ExternalModifier modifier : this.externalModifiers.values()) {
            targetTemperature += modifier.getAmount();
        }
        this.debugger.addEntry(new IModifierMonitor.Context("climatisation", "Climatisation", preClimatisationTemp, new Temperature(targetTemperature)));
        this.debugger.targetTemperature = targetTemperature;
        return MathHelper.func_76125_a((int)targetTemperature, (int)0, (int)TemperatureScale.getScaleTotal());
    }

    private void addPotionEffects(EntityPlayer player) {
        TemperatureScale.TemperatureRange range = TemperatureScale.getTemperatureRange(this.temperatureLevel);
        float extremityDelta = 0.5f;
        int hypoRangeSize = (int)((float)TemperatureScale.TemperatureRange.ICY.getRangeSize() * extremityDelta);
        int hypoRangeStart = hypoRangeSize - 1;
        int hyperRangeSize = (int)((float)TemperatureScale.TemperatureRange.HOT.getRangeSize() * extremityDelta);
        int hyperRangeStart = TemperatureScale.getScaleTotal() + 1 - hyperRangeSize;
        if (!player.field_71075_bZ.field_75098_d && SyncedConfig.getBooleanValue(GameplayOption.ENABLE_TEMPERATURE)) {
            if (!(this.temperatureLevel > hypoRangeStart || player.func_70644_a(TANPotions.cold_resistance) || this.temperatureLevel >= this.prevTemperatureLevel && player.func_70644_a(TANPotions.hypothermia))) {
                player.func_184589_d(TANPotions.hypothermia);
                player.func_70690_d(new PotionEffect(TANPotions.hypothermia, 200, 0));
            } else if (!(this.temperatureLevel < hyperRangeStart || player.func_70644_a(TANPotions.heat_resistance) || this.temperatureLevel <= this.prevTemperatureLevel && player.func_70644_a(TANPotions.hyperthermia))) {
                player.func_184589_d(TANPotions.hyperthermia);
                player.func_70690_d(new PotionEffect(TANPotions.hyperthermia, 200, 0));
            }
        }
    }

    @Override
    public boolean hasChanged() {
        return this.prevTemperatureLevel != this.temperatureLevel;
    }

    @Override
    public void onSendClientUpdate() {
        this.prevTemperatureLevel = this.temperatureLevel;
    }

    @Override
    public IMessage createUpdateMessage() {
        NBTTagCompound data = (NBTTagCompound)TANCapabilities.TEMPERATURE.getStorage().writeNBT(TANCapabilities.TEMPERATURE, (Object)this, null);
        return new MessageUpdateStat(TANCapabilities.TEMPERATURE, data);
    }

    @Override
    public void setChangeTime(int ticks) {
        this.temperatureTimer = ticks;
    }

    @Override
    public int getChangeTime() {
        return this.temperatureTimer;
    }

    @Override
    public void setTemperature(Temperature temperature) {
        this.temperatureLevel = temperature.getRawValue();
    }

    @Override
    public void addTemperature(Temperature difference) {
        this.temperatureLevel = Math.max(Math.min(TemperatureScale.getScaleTotal(), this.temperatureLevel + difference.getRawValue()), 0);
    }

    @Override
    public void applyModifier(String name, int amount, int rate, int duration) {
        if (this.externalModifiers.containsKey(name)) {
            TemperatureModifier.ExternalModifier modifier = this.externalModifiers.get(name);
            modifier.setAmount(amount);
            modifier.setRate(rate);
            modifier.setEndTime(this.temperatureTimer + duration);
        } else {
            TemperatureModifier.ExternalModifier modifier = new TemperatureModifier.ExternalModifier(name, amount, rate, this.temperatureTimer + duration);
            this.externalModifiers.put(name, modifier);
        }
    }

    @Override
    public boolean hasModifier(String name) {
        return this.externalModifiers.containsKey(name);
    }

    @Override
    public ImmutableMap<String, TemperatureModifier.ExternalModifier> getExternalModifiers() {
        return ImmutableMap.copyOf(this.externalModifiers);
    }

    @Override
    public void setExternalModifiers(Map<String, TemperatureModifier.ExternalModifier> externalModifiers) {
        this.externalModifiers = externalModifiers;
    }

    @Override
    public Temperature getTemperature() {
        return new Temperature(this.temperatureLevel);
    }

    static {
        TemperatureHelper.registerTemperatureModifier(new AltitudeModifier("altitude"));
        TemperatureHelper.registerTemperatureModifier(new ArmorModifier("armor"));
        TemperatureHelper.registerTemperatureModifier(new BiomeModifier("biome"));
        TemperatureHelper.registerTemperatureModifier(new PlayerStateModifier("player_state"));
        TemperatureHelper.registerTemperatureModifier(new ObjectProximityModifier("object_proximity"));
        TemperatureHelper.registerTemperatureModifier(new WeatherModifier("weather"));
        TemperatureHelper.registerTemperatureModifier(new TimeModifier("time"));
    }
}

