/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import org.apache.commons.io.FileUtils;
import toughasnails.api.TANBlocks;
import toughasnails.block.BlockTANCampfire;
import toughasnails.config.ReadBlockState;
import toughasnails.core.ToughAsNails;
import toughasnails.temperature.BlockTemperatureData;
import toughasnails.temperature.MaterialTemperatureData;
import toughasnails.util.BlockStateUtils;

public class TANConfig {
    public static Gson serializer = new GsonBuilder().setPrettyPrinting().create();
    public static JsonParser parser = new JsonParser();
    public static HashMap<String, ArrayList<BlockTemperatureData>> blockTemperatureData;
    public static MaterialTemperatureData materialTemperatureData;

    public static void init(File configDir) {
        blockTemperatureData = new HashMap();
        File blockTemperatureConfigFile = new File(configDir, "block_temperature.json");
        if (!blockTemperatureConfigFile.exists()) {
            try {
                BlockTemperatureData[] defaultBlockTemperatureData = new BlockTemperatureData[]{new BlockTemperatureData(TANBlocks.campfire.func_176223_P().func_177226_a((IProperty)BlockTANCampfire.BURNING, (Comparable)Boolean.valueOf(true)), new String[]{BlockTANCampfire.BURNING.func_177701_a()}, 12.0f), new BlockTemperatureData(Blocks.field_150470_am.func_176223_P(), new String[0], 12.0f), new BlockTemperatureData(Blocks.field_150353_l.func_176223_P(), new String[0], 1.5f), new BlockTemperatureData(Blocks.field_150356_k.func_176223_P(), new String[0], 1.5f)};
                JsonArray tempAry = new JsonArray();
                for (BlockTemperatureData tempData : defaultBlockTemperatureData) {
                    tempAry.add((JsonElement)TANConfig.asJsonObject(tempData));
                }
                TANConfig.writeFile(blockTemperatureConfigFile, tempAry);
            }
            catch (Exception e) {
                ToughAsNails.logger.error("Error creating default block temperature config file: " + blockTemperatureConfigFile.toString(), (Throwable)e);
            }
        }
        try {
            String blockJsonString = FileUtils.readFileToString((File)blockTemperatureConfigFile);
            JsonElement blockAry = parser.parse(blockJsonString);
            if (blockAry == null) {
                ToughAsNails.logger.error("Error parsing block temperature config from json file: " + blockTemperatureConfigFile.toString() + " temperature information array does not exist.");
            }
            if (blockAry.isJsonArray()) {
                for (JsonElement ele : blockAry.getAsJsonArray()) {
                    BlockTemperatureData tempData = TANConfig.asBlockTemperatureData(ele, "Error parsing block temperature state configuration " + ele.toString());
                    String blockName = tempData.state.func_177230_c().getRegistryName().toString();
                    if (!blockTemperatureData.containsKey(blockName)) {
                        blockTemperatureData.put(blockName, new ArrayList());
                    }
                    blockTemperatureData.get(blockName).add(tempData);
                }
            }
        }
        catch (Exception e) {
            ToughAsNails.logger.error("Error parsing block temperature config from json: " + blockTemperatureConfigFile.toString(), (Throwable)e);
        }
        materialTemperatureData = new MaterialTemperatureData();
        File materialTemperatureConfigFile = new File(configDir, "material_temperature.json");
        try {
            if (!materialTemperatureConfigFile.exists()) {
                TANConfig.writeFile(materialTemperatureConfigFile, materialTemperatureData);
            }
        }
        catch (Exception e) {
            ToughAsNails.logger.error("Error creating default material temperature config file: " + materialTemperatureConfigFile.toString(), (Throwable)e);
        }
        try {
            String materialJsonString = FileUtils.readFileToString((File)materialTemperatureConfigFile);
            Gson gson = new Gson();
            materialTemperatureData = (MaterialTemperatureData)gson.fromJson(materialJsonString, MaterialTemperatureData.class);
        }
        catch (Exception e) {
            ToughAsNails.logger.error("Error parsing material temperature config from json: " + materialTemperatureConfigFile.toString(), (Throwable)e);
        }
    }

    protected static boolean writeFile(File outputFile, Object obj) {
        try {
            FileUtils.write((File)outputFile, (CharSequence)serializer.toJson(obj));
            return true;
        }
        catch (Exception e) {
            ToughAsNails.logger.error("Error writing config file " + outputFile.getAbsolutePath() + ": " + e.getMessage());
            return false;
        }
    }

    protected static Map<String, JsonElement> parse(String jsonString) {
        HashMap<String, JsonElement> members = new HashMap<String, JsonElement>();
        if (jsonString == null) {
            return members;
        }
        JsonElement rootElement = null;
        try {
            rootElement = parser.parse(jsonString);
            if (rootElement != null) {
                if (rootElement.isJsonObject()) {
                    for (Map.Entry entry : rootElement.getAsJsonObject().entrySet()) {
                        members.put((String)entry.getKey(), (JsonElement)entry.getValue());
                    }
                } else {
                    ToughAsNails.logger.error("Error parsing config: not a JSON object");
                }
            }
        }
        catch (Exception e) {
            ToughAsNails.logger.error("Error parsing config: " + e.getMessage());
        }
        return members;
    }

    protected static ReadBlockState asBlockState(JsonElement ele, String extraPrefix) {
        try {
            JsonObject obj = ele.getAsJsonObject();
            if (!obj.has("block")) {
                ToughAsNails.logger.error(extraPrefix + " Block name missing");
                return null;
            }
            JsonElement blockName = obj.get("block");
            if (!blockName.isJsonPrimitive()) {
                ToughAsNails.logger.error(extraPrefix + " Invalid block name - must be a string");
                return null;
            }
            Block block = Block.func_149684_b((String)blockName.getAsString());
            if (block == null) {
                ToughAsNails.logger.error(extraPrefix + " Unrecognised block name " + blockName.getAsString());
                return null;
            }
            IBlockState state = block.func_176223_P();
            ArrayList<String> usedProperties = new ArrayList<String>();
            if (obj.has("properties")) {
                JsonElement properties = obj.get("properties");
                if (!properties.isJsonObject()) {
                    ToughAsNails.logger.error(extraPrefix + " Invalid properties list - must be a JSON object");
                    return null;
                }
                for (Map.Entry entry : properties.getAsJsonObject().entrySet()) {
                    String propRawName = (String)entry.getKey();
                    IProperty property = BlockStateUtils.getPropertyByName(state, propRawName);
                    if (property != null) {
                        String propRawValue = ((JsonElement)entry.getValue()).getAsString();
                        if (propRawValue.equals("*")) continue;
                        Comparable propertyValue = BlockStateUtils.getPropertyValueByName(state, property, propRawValue);
                        if (propertyValue != null) {
                            state = state.func_177226_a(property, propertyValue);
                            usedProperties.add(propRawName);
                            continue;
                        }
                        ToughAsNails.logger.error(extraPrefix + " Invalid value " + propRawValue + " for property " + propRawName);
                        continue;
                    }
                    ToughAsNails.logger.error(extraPrefix + " Invalid property name: " + propRawName);
                }
            }
            return new ReadBlockState(state, usedProperties.toArray(new String[0]));
        }
        catch (Exception e) {
            ToughAsNails.logger.error(extraPrefix + " Error fetching blockstate: " + e.getMessage());
            return null;
        }
    }

    protected static JsonObject asJsonObject(IBlockState state, String[] useProperties) {
        try {
            JsonObject obj = new JsonObject();
            obj.addProperty("block", state.func_177230_c().getRegistryName().toString());
            JsonObject props = new JsonObject();
            for (IProperty blockProperty : state.func_177228_b().keySet()) {
                String propName = blockProperty.func_177701_a();
                String propValue = state.func_177229_b(blockProperty).toString();
                if (useProperties != null) {
                    boolean foundProp = false;
                    for (String useName : useProperties) {
                        if (!useName.equalsIgnoreCase(propName)) continue;
                        foundProp = true;
                        break;
                    }
                    if (!foundProp) {
                        propValue = "*";
                    }
                }
                props.addProperty(propName, propValue);
            }
            obj.add("properties", (JsonElement)props);
            return obj;
        }
        catch (Exception e) {
            ToughAsNails.logger.error("Error converting blockstate to Json: " + e.getMessage());
            return null;
        }
    }

    protected static JsonObject asJsonObject(IBlockState state) {
        try {
            return TANConfig.asJsonObject(state, null);
        }
        catch (Exception e) {
            ToughAsNails.logger.error("Error converting blockstate to Json: " + e.getMessage());
            return null;
        }
    }

    protected static JsonObject asJsonObject(BlockTemperatureData blockTemperatureData) {
        JsonObject blockTempJson = new JsonObject();
        JsonObject stateObject = TANConfig.asJsonObject(blockTemperatureData.state, blockTemperatureData.useProperties);
        blockTempJson.add("state", (JsonElement)stateObject);
        blockTempJson.addProperty("temperature", (Number)Float.valueOf(blockTemperatureData.blockTemperature));
        return blockTempJson;
    }

    protected static BlockTemperatureData asBlockTemperatureData(JsonElement ele, String extraPrefix) {
        try {
            JsonObject obj = ele.getAsJsonObject();
            if (!obj.has("state")) {
                ToughAsNails.logger.error(extraPrefix + " Block state missing");
                return null;
            }
            JsonElement blockState = obj.get("state");
            if (!blockState.isJsonObject()) {
                ToughAsNails.logger.error(extraPrefix + " Invalid block state - must be an object");
                return null;
            }
            ReadBlockState readState = TANConfig.asBlockState(blockState, extraPrefix);
            IBlockState state = readState.state;
            String[] use_properties = readState.usedProperties;
            if (!obj.has("temperature")) {
                ToughAsNails.logger.error(extraPrefix + " block temperature missing");
                return null;
            }
            JsonElement blockTemperature = obj.get("temperature");
            if (!blockTemperature.isJsonPrimitive()) {
                ToughAsNails.logger.error(extraPrefix + " Invalid block temperature - must be a float");
            }
            float temperature = blockTemperature.getAsFloat();
            return new BlockTemperatureData(state, use_properties, temperature);
        }
        catch (Exception e) {
            ToughAsNails.logger.error(extraPrefix + " Error fetching block temperature data: " + e.getMessage());
            return null;
        }
    }
}

