/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.core;

import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import toughasnails.command.TANCommand;
import toughasnails.config.TANConfig;
import toughasnails.core.CommonProxy;
import toughasnails.handler.BlockHarvestEventHandler;
import toughasnails.handler.LootTableEventHandler;
import toughasnails.init.ModAchievements;
import toughasnails.init.ModBlocks;
import toughasnails.init.ModConfig;
import toughasnails.init.ModCrafting;
import toughasnails.init.ModEntities;
import toughasnails.init.ModHandlers;
import toughasnails.init.ModItems;
import toughasnails.init.ModPotions;
import toughasnails.init.ModStats;
import toughasnails.init.ModVanillaCompat;

@Mod(modid="ToughAsNails", version="1.1.1.66", name="Tough As Nails", guiFactory="toughasnails.client.gui.GuiFactory", acceptedMinecraftVersions="[1.9.4]")
public class ToughAsNails {
    public static final String MOD_NAME = "Tough As Nails";
    public static final String MOD_ID = "ToughAsNails";
    public static final String MOD_VERSION = "1.1.1.66";
    public static final String GUI_FACTORY = "toughasnails.client.gui.GuiFactory";
    @Mod.Instance(value="ToughAsNails")
    public static ToughAsNails instance;
    @SidedProxy(clientSide="toughasnails.core.ClientProxy", serverSide="toughasnails.core.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    public static File configDirectory;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        configDirectory = new File(event.getModConfigurationDirectory(), "toughasnails");
        ModConfig.init(configDirectory);
        ModBlocks.init();
        ModEntities.init();
        ModItems.init();
        ModStats.init();
        ModPotions.init();
        ModVanillaCompat.init();
        ModHandlers.init();
        ModCrafting.init();
        ModAchievements.init();
        MinecraftForge.EVENT_BUS.register((Object)new LootTableEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new BlockHarvestEventHandler());
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        TANConfig.init(configDirectory);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new TANCommand());
    }

    static {
        logger = LogManager.getLogger((String)MOD_ID);
    }
}

