/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.handler;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import toughasnails.api.stat.IPlayerStat;
import toughasnails.api.stat.PlayerStatRegistry;
import toughasnails.api.stat.StatHandlerBase;
import toughasnails.handler.PacketHandler;

public class ExtendedStatHandler {
    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent.Entity event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            for (String identifier : PlayerStatRegistry.getCapabilityMap().keySet()) {
                ResourceLocation loc = new ResourceLocation("ToughAsNails", identifier);
                if (event.getCapabilities().containsKey(loc)) continue;
                event.addCapability(loc, PlayerStatRegistry.createCapabilityProvider(identifier));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            for (Capability capability : PlayerStatRegistry.getCapabilityMap().values()) {
                StatHandlerBase stat = (StatHandlerBase)player.getCapability(capability, null);
                capability.getStorage().readNBT(capability, (Object)stat, null, (NBTBase)player.getEntityData().func_74775_l(capability.getName()));
                stat.onSendClientUpdate();
                PacketHandler.instance.sendTo(stat.createUpdateMessage(), (EntityPlayerMP)player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            for (Capability capability : PlayerStatRegistry.getCapabilityMap().values()) {
                IPlayerStat stat = (IPlayerStat)player.getCapability(capability, null);
                stat.update(player, world, event.phase);
                if (event.phase != TickEvent.Phase.START || !stat.hasChanged()) continue;
                player.getEntityData().func_74782_a(capability.getName(), capability.getStorage().writeNBT(capability, (Object)stat, null));
                stat.onSendClientUpdate();
                PacketHandler.instance.sendTo(stat.createUpdateMessage(), (EntityPlayerMP)player);
            }
        }
    }
}

