/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.init;

import com.google.common.collect.ImmutableSet;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import toughasnails.api.ITANBlock;
import toughasnails.api.TANBlocks;
import toughasnails.block.BlockGlowstoneTorch;
import toughasnails.block.BlockRainCollector;
import toughasnails.block.BlockSeasonSensor;
import toughasnails.block.BlockTANCampfire;
import toughasnails.block.BlockTANDeadCrops;
import toughasnails.block.BlockTANTemperatureCoil;
import toughasnails.block.BlockTANTorchNew;
import toughasnails.core.ToughAsNails;
import toughasnails.tileentity.TileEntitySeasonSensor;
import toughasnails.tileentity.TileEntityTemperatureSpread;
import toughasnails.util.BlockStateUtils;
import toughasnails.util.inventory.CreativeTabTAN;

public class ModBlocks {
    public static void init() {
        TANBlocks.season_sensors[0] = ModBlocks.registerBlock((Block)new BlockSeasonSensor(BlockSeasonSensor.DetectorType.SPRING), "season_sensor_spring");
        TANBlocks.season_sensors[1] = ModBlocks.registerBlock((Block)new BlockSeasonSensor(BlockSeasonSensor.DetectorType.SUMMER), "season_sensor_summer").func_149647_a(null);
        TANBlocks.season_sensors[2] = ModBlocks.registerBlock((Block)new BlockSeasonSensor(BlockSeasonSensor.DetectorType.AUTUMN), "season_sensor_autumn").func_149647_a(null);
        TANBlocks.season_sensors[3] = ModBlocks.registerBlock((Block)new BlockSeasonSensor(BlockSeasonSensor.DetectorType.WINTER), "season_sensor_winter").func_149647_a(null);
        TANBlocks.campfire = ModBlocks.registerBlock(new BlockTANCampfire(), "campfire");
        TANBlocks.rain_collector = ModBlocks.registerBlock(new BlockRainCollector(), "rain_collector");
        TANBlocks.temperature_coil = ModBlocks.registerBlock((Block)new BlockTANTemperatureCoil(), "temperature_coil");
        TANBlocks.torch_new = ModBlocks.registerBlock(new BlockTANTorchNew(), "torch_new");
        TANBlocks.glowstone_torch = ModBlocks.registerBlock(new BlockGlowstoneTorch(), "glowstone_torch");
        TANBlocks.dead_crops = ModBlocks.registerBlock((Block)new BlockTANDeadCrops(), "dead_crops").func_149647_a(null);
        GameRegistry.registerTileEntity(TileEntityTemperatureSpread.class, (String)"temperature_spread");
        GameRegistry.registerTileEntity(TileEntitySeasonSensor.class, (String)"season_sensor");
    }

    public static void registerBlockVariant(Block block, String stateName, int stateMeta) {
        Item item = Item.func_150898_a((Block)block);
        ToughAsNails.proxy.registerItemVariantModel(item, stateName, stateMeta);
    }

    public static Block registerBlock(Block block, String blockName) {
        return ModBlocks.registerBlock(block, blockName, CreativeTabTAN.instance);
    }

    public static Block registerBlock(Block block, String blockName, CreativeTabs tab) {
        block.func_149663_c(blockName);
        block.func_149647_a(tab);
        if (block instanceof ITANBlock) {
            ImmutableSet<IBlockState> presets;
            ITANBlock bopBlock = (ITANBlock)block;
            ModBlocks.registerBlockWithItem(block, blockName, bopBlock.getItemClass());
            ToughAsNails.proxy.registerNonRenderingProperties(block);
            IBlockState defaultState = block.func_176223_P();
            if (defaultState == null) {
                defaultState = block.func_176194_O().func_177621_b();
                ToughAsNails.logger.error("missing default state for " + block.func_149739_a());
            }
            if ((presets = BlockStateUtils.getBlockPresets(block)).isEmpty()) {
                ModBlocks.registerBlockVariant(block, blockName, 0);
            } else {
                for (IBlockState state : presets) {
                    String stateName = bopBlock.getStateName(state);
                    int stateMeta = block.func_176201_c(state);
                    ModBlocks.registerBlockVariant(block, stateName, stateMeta);
                }
            }
        } else {
            ModBlocks.registerBlockWithItem(block, blockName, ItemBlock.class);
            ModBlocks.registerBlockVariant(block, blockName, 0);
        }
        return block;
    }

    private static void registerBlockWithItem(Block block, String blockName, Class<? extends ItemBlock> clazz) {
        try {
            Item itemBlock = clazz != null ? (Item)clazz.getConstructor(Block.class).newInstance(block) : null;
            ResourceLocation location = new ResourceLocation("ToughAsNails", blockName);
            GameRegistry.register((IForgeRegistryEntry)block, (ResourceLocation)location);
            if (itemBlock != null) {
                GameRegistry.register((IForgeRegistryEntry)itemBlock, (ResourceLocation)location);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred associating an item block during registration...");
        }
    }
}

