/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.init;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import toughasnails.config.SyncedConfigHandler;
import toughasnails.handler.AchievementEventHandler;
import toughasnails.handler.ExtendedStatHandler;
import toughasnails.handler.PacketHandler;
import toughasnails.handler.health.HealthOverlayHandler;
import toughasnails.handler.health.MaxHealthHandler;
import toughasnails.handler.season.ProviderIceHandler;
import toughasnails.handler.season.RandomUpdateHandler;
import toughasnails.handler.season.SeasonHandler;
import toughasnails.handler.season.SeasonSleepHandler;
import toughasnails.handler.season.StopSpawnHandler;
import toughasnails.handler.season.WeatherFrequencyHandler;
import toughasnails.handler.temperature.TemperatureDebugOverlayHandler;
import toughasnails.handler.temperature.TemperatureOverlayHandler;
import toughasnails.handler.thirst.FillBottleHandler;
import toughasnails.handler.thirst.ThirstOverlayHandler;
import toughasnails.handler.thirst.ThirstStatHandler;
import toughasnails.handler.thirst.VanillaDrinkHandler;
import toughasnails.season.SeasonTime;
import toughasnails.util.SeasonColourUtil;

public class ModHandlers {
    public static void init() {
        PacketHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)new ExtendedStatHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SyncedConfigHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ThirstStatHandler());
        MinecraftForge.EVENT_BUS.register((Object)new VanillaDrinkHandler());
        MinecraftForge.EVENT_BUS.register((Object)new FillBottleHandler());
        MinecraftForge.EVENT_BUS.register((Object)new MaxHealthHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SeasonHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RandomUpdateHandler());
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new ProviderIceHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SeasonSleepHandler());
        StopSpawnHandler stopSpawnHandler = new StopSpawnHandler();
        MinecraftForge.EVENT_BUS.register((Object)stopSpawnHandler);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)stopSpawnHandler);
        MinecraftForge.EVENT_BUS.register((Object)new WeatherFrequencyHandler());
        MinecraftForge.EVENT_BUS.register((Object)new AchievementEventHandler());
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)new TemperatureOverlayHandler());
            MinecraftForge.EVENT_BUS.register((Object)new TemperatureDebugOverlayHandler());
            MinecraftForge.EVENT_BUS.register((Object)new ThirstOverlayHandler());
            MinecraftForge.EVENT_BUS.register((Object)new HealthOverlayHandler());
            ModHandlers.registerSeasonColourHandlers();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerSeasonColourHandlers() {
        BiomeColorHelper.field_180291_a = new BiomeColorHelper.ColorResolver(){

            public int func_180283_a(Biome biome, BlockPos blockPosition) {
                SeasonTime calendar = new SeasonTime(SeasonHandler.clientSeasonCycleTicks);
                return SeasonColourUtil.applySeasonalGrassColouring(calendar.getSubSeason(), biome.func_180627_b(blockPosition));
            }
        };
        BiomeColorHelper.field_180289_b = new BiomeColorHelper.ColorResolver(){

            public int func_180283_a(Biome biome, BlockPos blockPosition) {
                SeasonTime calendar = new SeasonTime(SeasonHandler.clientSeasonCycleTicks);
                return SeasonColourUtil.applySeasonalFoliageColouring(calendar.getSubSeason(), biome.func_180625_c(blockPosition));
            }
        };
    }
}

