/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature.modifier;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import toughasnails.api.temperature.Temperature;
import toughasnails.temperature.TemperatureDebugger;
import toughasnails.temperature.TemperatureTrend;
import toughasnails.temperature.modifier.TemperatureModifier;
import toughasnails.util.BiomeUtils;

public class BiomeModifier
extends TemperatureModifier {
    public static final int MAX_TEMP_OFFSET = 10;

    public BiomeModifier(TemperatureDebugger debugger) {
        super(debugger);
    }

    @Override
    public int modifyChangeRate(World world, EntityPlayer player, int changeRate, TemperatureTrend trend) {
        Biome biome = world.func_180494_b(player.func_180425_c());
        float humidity = biome.func_76727_i();
        float humidityMultiplier = 2.0f * Math.abs(humidity % 1.0f - 0.5f);
        int newChangeRate = changeRate - (int)(10.0f * humidityMultiplier * 20.0f);
        this.debugger.start(TemperatureDebugger.Modifier.BIOME_HUMIDITY_RATE, changeRate);
        this.debugger.end(newChangeRate);
        return newChangeRate;
    }

    @Override
    public Temperature modifyTarget(World world, EntityPlayer player, Temperature temperature) {
        Biome biome = world.func_180494_b(player.func_180425_c());
        Biome biomeNorth = world.func_180494_b(player.func_180425_c().func_177982_a(0, 0, -10));
        Biome biomeSouth = world.func_180494_b(player.func_180425_c().func_177982_a(0, 0, 10));
        Biome biomeEast = world.func_180494_b(player.func_180425_c().func_177982_a(10, 0, 0));
        Biome biomeWest = world.func_180494_b(player.func_180425_c().func_177982_a(-10, 0, 0));
        float biomeTemp = (BiomeUtils.getBiomeTempNorm(biome) + BiomeUtils.getBiomeTempNorm(biomeNorth) + BiomeUtils.getBiomeTempNorm(biomeSouth) + BiomeUtils.getBiomeTempNorm(biomeEast) + BiomeUtils.getBiomeTempNorm(biomeWest)) / 5.0f;
        int newTemperatureLevel = temperature.getRawValue() + Math.round((biomeTemp * 2.0f - 1.0f) * 10.0f);
        this.debugger.start(TemperatureDebugger.Modifier.BIOME_TEMPERATURE_TARGET, temperature.getRawValue());
        this.debugger.end(newTemperatureLevel);
        return new Temperature(newTemperatureLevel);
    }
}

