/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature.modifier;

import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import toughasnails.api.temperature.Temperature;
import toughasnails.config.TANConfig;
import toughasnails.temperature.BlockTemperatureData;
import toughasnails.temperature.TemperatureDebugger;
import toughasnails.temperature.TemperatureTrend;
import toughasnails.temperature.modifier.TemperatureModifier;
import toughasnails.util.BlockStateUtils;

public class ObjectProximityModifier
extends TemperatureModifier {
    public ObjectProximityModifier(TemperatureDebugger debugger) {
        super(debugger);
    }

    @Override
    public int modifyChangeRate(World world, EntityPlayer player, int changeRate, TemperatureTrend trend) {
        int newChangeRate = changeRate;
        BlockPos playerPos = player.func_180425_c();
        int tempSourceBlocks = 0;
        for (int x = -3; x <= 3; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    BlockPos pos = playerPos.func_177982_a(x, y - 1, z);
                    IBlockState state = world.func_180495_p(pos);
                    if (ObjectProximityModifier.getBlockTemperature(player, state) == 0.0f) continue;
                    ++tempSourceBlocks;
                }
            }
        }
        this.debugger.start(TemperatureDebugger.Modifier.NEARBY_BLOCKS_RATE, newChangeRate);
        this.debugger.end(newChangeRate -= tempSourceBlocks * 20);
        return newChangeRate;
    }

    @Override
    public Temperature modifyTarget(World world, EntityPlayer player, Temperature temperature) {
        int temperatureLevel;
        int newTemperatureLevel = temperatureLevel = temperature.getRawValue();
        BlockPos playerPos = player.func_180425_c();
        float blockTemperatureModifier = 0.0f;
        for (int x = -3; x <= 3; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    BlockPos pos = playerPos.func_177982_a(x, y - 1, z);
                    IBlockState state = world.func_180495_p(pos);
                    blockTemperatureModifier += ObjectProximityModifier.getBlockTemperature(player, state);
                }
            }
        }
        this.debugger.start(TemperatureDebugger.Modifier.NEARBY_BLOCKS_TARGET, newTemperatureLevel);
        newTemperatureLevel = (int)((float)newTemperatureLevel + blockTemperatureModifier);
        this.debugger.end(newTemperatureLevel);
        return new Temperature(newTemperatureLevel);
    }

    public static float getBlockTemperature(EntityPlayer player, IBlockState state) {
        World world = player.field_70170_p;
        Material material = state.func_185904_a();
        Biome biome = world.func_180494_b(player.func_180425_c());
        if (state.func_177230_c().getRegistryName() == null) {
            return 0.0f;
        }
        String blockName = state.func_177230_c().getRegistryName().toString();
        if (TANConfig.blockTemperatureData.containsKey(blockName)) {
            ArrayList<BlockTemperatureData> blockTempData = TANConfig.blockTemperatureData.get(blockName);
            for (BlockTemperatureData tempData : blockTempData) {
                boolean bAllSpecifiedPropertiesMatch = true;
                for (String comparisonProperty : tempData.useProperties) {
                    IProperty targetProperty = BlockStateUtils.getPropertyByName(state, comparisonProperty);
                    if (state.func_177229_b(targetProperty) == tempData.state.func_177229_b(targetProperty)) continue;
                    bAllSpecifiedPropertiesMatch = false;
                }
                if (!bAllSpecifiedPropertiesMatch) continue;
                return tempData.blockTemperature;
            }
            return 0.0f;
        }
        if (material == Material.field_151581_o) {
            return TANConfig.materialTemperatureData.fire;
        }
        return 0.0f;
    }
}

