/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive;

import com.mojang.authlib.GameProfile;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.event.EMPReceiver;
import cr0s.warpdrive.event.ItemHandler;
import cr0s.warpdrive.event.LivingHandler;
import cr0s.warpdrive.event.PlayerHandler;
import java.lang.ref.WeakReference;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class CommonProxy {
    private static final WeakHashMap<GameProfile, WeakReference<EntityPlayer>> fakePlayers = new WeakHashMap(100);

    public boolean isDedicatedServer() {
        return true;
    }

    @Nullable
    private static EntityPlayerMP getPlayer(@Nonnull WorldServer world, UUID uuidPlayer) {
        assert (world.func_73046_m() != null);
        for (EntityPlayerMP entityPlayerMP : world.func_73046_m().func_184103_al().func_181057_v()) {
            if (entityPlayerMP.func_110124_au() != uuidPlayer) continue;
            return entityPlayerMP;
        }
        return null;
    }

    public static EntityPlayer getFakePlayer(@Nullable UUID uuidPlayer, @Nonnull WorldServer world, @Nonnull BlockPos blockPos) {
        EntityPlayer entityFakePlayer;
        EntityPlayerMP entityPlayer = uuidPlayer == null ? null : CommonProxy.getPlayer(world, uuidPlayer);
        GameProfile gameProfile = entityPlayer == null ? WarpDrive.gameProfile : entityPlayer.func_146103_bH();
        WeakReference<EntityPlayer> weakFakePlayer = fakePlayers.get(gameProfile);
        EntityPlayer entityPlayer2 = entityFakePlayer = weakFakePlayer == null ? null : (EntityPlayer)weakFakePlayer.get();
        if (entityFakePlayer == null) {
            entityFakePlayer = FakePlayerFactory.get((WorldServer)world, (GameProfile)gameProfile);
            ((EntityPlayerMP)entityFakePlayer).field_71134_c.func_73076_a(GameType.SURVIVAL);
            weakFakePlayer = new WeakReference<EntityPlayer>(entityFakePlayer);
            fakePlayers.put(gameProfile, weakFakePlayer);
        } else {
            entityFakePlayer.field_70170_p = world;
        }
        entityFakePlayer.field_70165_t = (double)blockPos.func_177958_n() + 0.5;
        entityFakePlayer.field_70163_u = (double)blockPos.func_177956_o() + 0.5;
        entityFakePlayer.field_70161_v = (double)blockPos.func_177952_p() + 0.5;
        return entityFakePlayer;
    }

    public static boolean isBlockBreakCanceled(UUID uuidPlayer, BlockPos blockPosSource, @Nonnull World world, BlockPos blockPosEvent) {
        IBlockState blockState;
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return false;
        }
        if (WarpDriveConfig.LOGGING_BREAK_PLACE) {
            WarpDrive.logger.info(String.format("isBlockBreakCanceled by %s %s to block %s", uuidPlayer, Commons.format(world, blockPosSource), Commons.format(world, blockPosEvent)));
        }
        if (!(blockState = world.func_180495_p(blockPosEvent)).func_177230_c().isAir(blockState, (IBlockAccess)world, blockPosEvent)) {
            BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(world, blockPosEvent, world.func_180495_p(blockPosEvent), CommonProxy.getFakePlayer(uuidPlayer, (WorldServer)world, blockPosSource));
            MinecraftForge.EVENT_BUS.post((Event)breakEvent);
            if (WarpDriveConfig.LOGGING_BREAK_PLACE) {
                WarpDrive.logger.info(String.format("isBlockBreakCanceled player %s isCanceled %s", breakEvent.getPlayer(), breakEvent.isCanceled()));
            }
            return breakEvent.isCanceled();
        }
        return false;
    }

    public static boolean isBlockPlaceCanceled(UUID uuidPlayer, BlockPos blockPosSource, @Nonnull World world, BlockPos blockPosEvent, IBlockState blockState) {
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return false;
        }
        if (WarpDriveConfig.LOGGING_BREAK_PLACE) {
            WarpDrive.logger.info(String.format("isBlockPlaceCanceled by %s %s to block %s %s", uuidPlayer, Commons.format(world, blockPosSource), Commons.format(world, blockPosEvent), blockState));
        }
        BlockEvent.PlaceEvent placeEvent = new BlockEvent.PlaceEvent(new BlockSnapshot(world, blockPosEvent, blockState), Blocks.field_150350_a.func_176223_P(), CommonProxy.getFakePlayer(uuidPlayer, (WorldServer)world, blockPosSource), EnumHand.MAIN_HAND);
        MinecraftForge.EVENT_BUS.post((Event)placeEvent);
        if (WarpDriveConfig.LOGGING_BREAK_PLACE) {
            WarpDrive.logger.info(String.format("isBlockPlaceCanceled player %s isCanceled %s", placeEvent.getPlayer(), placeEvent.isCanceled()));
        }
        return placeEvent.isCanceled();
    }

    public void onForgePreInitialisation() {
    }

    public void onModelInitialisation(Object object) {
    }

    public void onForgeInitialisation() {
        MinecraftForge.EVENT_BUS.register((Object)new ItemHandler());
        MinecraftForge.EVENT_BUS.register((Object)new LivingHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerHandler());
        MinecraftForge.EVENT_BUS.register(EMPReceiver.class);
    }
}

