/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class FastSetBlockState {
    public static boolean setBlockStateNoLight(@Nonnull World world, @Nonnull BlockPos blockPosPassed, @Nonnull IBlockState blockStateNew, int flags) {
        BlockPos blockPos;
        assert (!world.captureBlockSnapshots);
        if (!Commons.isSafeThread()) {
            throw new ConcurrentModificationException(String.format("setBlockstate %s to %s 0x%x", Commons.format(world, blockPosPassed), blockStateNew, flags));
        }
        if (!WarpDriveConfig.G_ENABLE_FAST_SET_BLOCKSTATE) {
            return world.func_180501_a(blockPosPassed, blockStateNew, flags);
        }
        if (world.func_189509_E(blockPosPassed)) {
            return false;
        }
        if (!world.field_72995_K && world.func_72912_H().func_76067_t() == WorldType.field_180272_g) {
            return false;
        }
        Chunk chunk = world.func_175726_f(blockPosPassed);
        IBlockState blockStateEffective = FastSetBlockState.chunk_setBlockState(chunk, blockPos = blockPosPassed instanceof BlockPos.MutableBlockPos ? blockPosPassed.func_185334_h() : blockPosPassed, blockStateNew);
        return blockStateEffective != null;
    }

    @Nullable
    public static IBlockState chunk_setBlockState(@Nonnull Chunk chunk, BlockPos pos, IBlockState state) {
        TileEntity te;
        World world = chunk.func_177412_p();
        ExtendedBlockStorage[] storageArrays = chunk.func_76587_i();
        int i = pos.func_177958_n() & 0xF;
        int j = pos.func_177956_o();
        int k = pos.func_177952_p() & 0xF;
        IBlockState iblockstate = chunk.func_177435_g(pos);
        if (iblockstate == state) {
            return null;
        }
        Block block = state.func_177230_c();
        Block block1 = iblockstate.func_177230_c();
        ExtendedBlockStorage extendedblockstorage = storageArrays[j >> 4];
        if (extendedblockstorage == Chunk.field_186036_a) {
            if (block == Blocks.field_150350_a) {
                return null;
            }
            storageArrays[j >> 4] = extendedblockstorage = new ExtendedBlockStorage(j >> 4 << 4, chunk.func_177412_p().field_73011_w.func_191066_m());
        }
        extendedblockstorage.func_177484_a(i, j & 0xF, k, state);
        if (!world.field_72995_K) {
            if (block1 != block) {
                block1.func_180663_b(world, pos, iblockstate);
            }
            if ((te = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK)) != null && te.shouldRefresh(world, pos, iblockstate, state)) {
                world.func_175713_t(pos);
            }
        } else if (block1.hasTileEntity(iblockstate) && (te = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK)) != null && te.shouldRefresh(world, pos, iblockstate, state)) {
            world.func_175713_t(pos);
        }
        if (extendedblockstorage.func_177485_a(i, j & 0xF, k).func_177230_c() != block) {
            return null;
        }
        if (!(world.field_72995_K || block1 == block || world.captureBlockSnapshots && !block.hasTileEntity(state))) {
            block.func_176213_c(world, pos, state);
        }
        if (block.hasTileEntity(state)) {
            TileEntity tileentity1 = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
            if (tileentity1 == null) {
                tileentity1 = block.createTileEntity(world, state);
                world.func_175690_a(pos, tileentity1);
            }
            if (tileentity1 != null) {
                tileentity1.func_145836_u();
            }
        }
        chunk.func_76630_e();
        return iblockstate;
    }
}

