/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class LocalProfiler {
    private static final long CALL_STATS_PERIOD_MS = 300000L;
    private static final AtomicLong timerStats = new AtomicLong(System.currentTimeMillis() + 300000L);
    private static final Map<String, Integer> stats = new ConcurrentHashMap<String, Integer>(32);
    private static final Stack<StackElement> stack = new Stack();

    public static void updateCallStat(String usage) {
        Integer value;
        String key;
        if (!WarpDriveConfig.LOGGING_PROFILING_THREAD_SAFETY) {
            return;
        }
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        String threadName = Thread.currentThread().getName();
        StringBuilder stringBuilderKey = new StringBuilder(threadName).append(" ").append(usage);
        if (!threadName.equals("Server thread") && !threadName.equals("Client thread")) {
            int depth = 0;
            for (StackTraceElement stackTraceElement : stacktrace) {
                if (depth++ <= 2 || depth >= 30) continue;
                stringBuilderKey.append("\n  ").append(stackTraceElement.getClassName());
                stringBuilderKey.append(".").append(stackTraceElement.getMethodName());
                stringBuilderKey.append(":").append(stackTraceElement.getLineNumber());
            }
        }
        stats.put(key, (value = stats.get(key = stringBuilderKey.toString())) != null ? value + 1 : 1);
        long now = System.currentTimeMillis();
        if (timerStats.get() <= now) {
            timerStats.set(now + 300000L);
            LocalProfiler.printCallStats();
        }
    }

    public static void printCallStats() {
        if (!WarpDriveConfig.LOGGING_PROFILING_THREAD_SAFETY) {
            WarpDrive.logger.info("Consider enabling thread safety profiling to get more details next time");
            return;
        }
        WarpDrive.logger.info("Dumping chunk stats:");
        if (stats.isEmpty()) {
            WarpDrive.logger.info("-none-");
            return;
        }
        for (Map.Entry<String, Integer> entryStat : stats.entrySet()) {
            WarpDrive.logger.info(String.format("%10d x %s", entryStat.getValue(), entryStat.getKey()));
        }
    }

    public static void start(String name) {
        if (WarpDriveConfig.LOGGING_PROFILING_CPU_USAGE) {
            StackElement stackElement = new StackElement();
            stackElement.start = System.nanoTime();
            stackElement.internal = 0L;
            stackElement.name = name;
            stack.push(stackElement);
        }
    }

    public static void stop() {
        LocalProfiler.stop(0L);
    }

    public static void stop(long tolerance_us) {
        if (stack.isEmpty()) {
            return;
        }
        StackElement stackElement = stack.pop();
        long end = System.nanoTime();
        long timeElapsed = end - stackElement.start;
        if (!stack.isEmpty()) {
            StackElement nextStackElement = stack.peek();
            nextStackElement.internal += timeElapsed;
        }
        long self = (timeElapsed - stackElement.internal) / 1000L;
        long total = timeElapsed / 1000L;
        if (self > tolerance_us) {
            if (total == self) {
                WarpDrive.logger.info(String.format("Profiling %s: %.3f ms", stackElement.name, Float.valueOf((float)self / 1000.0f)));
            } else {
                WarpDrive.logger.info(String.format("Profiling %s: %.3f ms, total; %.3f ms", stackElement.name, Float.valueOf((float)self / 1000.0f), Float.valueOf((float)total / 1000.0f)));
            }
        }
    }

    private static class StackElement {
        public long start;
        public long internal;
        public String name;

        private StackElement() {
        }
    }
}

