/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive;

import com.mojang.authlib.GameProfile;
import cr0s.warpdrive.CommonProxy;
import cr0s.warpdrive.LocalProfiler;
import cr0s.warpdrive.LoggerPrintStream;
import cr0s.warpdrive.WarpDrivePeripheralHandler;
import cr0s.warpdrive.api.IBlockBase;
import cr0s.warpdrive.block.BlockChunkLoader;
import cr0s.warpdrive.block.BlockLaser;
import cr0s.warpdrive.block.BlockLaserMedium;
import cr0s.warpdrive.block.BlockSecurityStation;
import cr0s.warpdrive.block.TileEntityChunkLoader;
import cr0s.warpdrive.block.TileEntityLaser;
import cr0s.warpdrive.block.TileEntityLaserMedium;
import cr0s.warpdrive.block.TileEntitySecurityStation;
import cr0s.warpdrive.block.atomic.BlockAcceleratorControlPoint;
import cr0s.warpdrive.block.atomic.BlockAcceleratorCore;
import cr0s.warpdrive.block.atomic.BlockChiller;
import cr0s.warpdrive.block.atomic.BlockElectromagnetGlass;
import cr0s.warpdrive.block.atomic.BlockElectromagnetPlain;
import cr0s.warpdrive.block.atomic.BlockParticlesCollider;
import cr0s.warpdrive.block.atomic.BlockParticlesInjector;
import cr0s.warpdrive.block.atomic.BlockVoidShellGlass;
import cr0s.warpdrive.block.atomic.BlockVoidShellPlain;
import cr0s.warpdrive.block.atomic.TileEntityAcceleratorControlPoint;
import cr0s.warpdrive.block.atomic.TileEntityAcceleratorCore;
import cr0s.warpdrive.block.atomic.TileEntityParticlesInjector;
import cr0s.warpdrive.block.breathing.BlockAirFlow;
import cr0s.warpdrive.block.breathing.BlockAirGeneratorTiered;
import cr0s.warpdrive.block.breathing.BlockAirShield;
import cr0s.warpdrive.block.breathing.BlockAirSource;
import cr0s.warpdrive.block.breathing.TileEntityAirGeneratorTiered;
import cr0s.warpdrive.block.building.BlockShipScanner;
import cr0s.warpdrive.block.building.TileEntityShipScanner;
import cr0s.warpdrive.block.collection.BlockLaserTreeFarm;
import cr0s.warpdrive.block.collection.BlockMiningLaser;
import cr0s.warpdrive.block.collection.TileEntityLaserTreeFarm;
import cr0s.warpdrive.block.collection.TileEntityMiningLaser;
import cr0s.warpdrive.block.decoration.BlockBedrockGlass;
import cr0s.warpdrive.block.decoration.BlockDecorative;
import cr0s.warpdrive.block.decoration.BlockGas;
import cr0s.warpdrive.block.decoration.BlockLamp_bubble;
import cr0s.warpdrive.block.decoration.BlockLamp_flat;
import cr0s.warpdrive.block.decoration.BlockLamp_long;
import cr0s.warpdrive.block.detection.BlockBiometricScanner;
import cr0s.warpdrive.block.detection.BlockCamera;
import cr0s.warpdrive.block.detection.BlockCloakingCoil;
import cr0s.warpdrive.block.detection.BlockCloakingCore;
import cr0s.warpdrive.block.detection.BlockEnvironmentalSensor;
import cr0s.warpdrive.block.detection.BlockMonitor;
import cr0s.warpdrive.block.detection.BlockRadar;
import cr0s.warpdrive.block.detection.BlockSiren;
import cr0s.warpdrive.block.detection.BlockSpeaker;
import cr0s.warpdrive.block.detection.BlockVirtualAssistant;
import cr0s.warpdrive.block.detection.BlockWarpIsolation;
import cr0s.warpdrive.block.detection.TileEntityBiometricScanner;
import cr0s.warpdrive.block.detection.TileEntityCamera;
import cr0s.warpdrive.block.detection.TileEntityCloakingCore;
import cr0s.warpdrive.block.detection.TileEntityEnvironmentalSensor;
import cr0s.warpdrive.block.detection.TileEntityMonitor;
import cr0s.warpdrive.block.detection.TileEntityRadar;
import cr0s.warpdrive.block.detection.TileEntitySiren;
import cr0s.warpdrive.block.detection.TileEntitySpeaker;
import cr0s.warpdrive.block.detection.TileEntityVirtualAssistant;
import cr0s.warpdrive.block.energy.BlockCapacitor;
import cr0s.warpdrive.block.energy.BlockEnanReactorCore;
import cr0s.warpdrive.block.energy.BlockEnanReactorLaser;
import cr0s.warpdrive.block.energy.BlockIC2reactorLaserCooler;
import cr0s.warpdrive.block.energy.TileEntityCapacitor;
import cr0s.warpdrive.block.energy.TileEntityEnanReactorCore;
import cr0s.warpdrive.block.energy.TileEntityEnanReactorLaser;
import cr0s.warpdrive.block.energy.TileEntityIC2reactorLaserMonitor;
import cr0s.warpdrive.block.forcefield.BlockForceField;
import cr0s.warpdrive.block.forcefield.BlockForceFieldProjector;
import cr0s.warpdrive.block.forcefield.BlockForceFieldRelay;
import cr0s.warpdrive.block.forcefield.TileEntityForceField;
import cr0s.warpdrive.block.forcefield.TileEntityForceFieldProjector;
import cr0s.warpdrive.block.forcefield.TileEntityForceFieldRelay;
import cr0s.warpdrive.block.hull.BlockHullGlass;
import cr0s.warpdrive.block.hull.BlockHullOmnipanel;
import cr0s.warpdrive.block.hull.BlockHullPlain;
import cr0s.warpdrive.block.hull.BlockHullSlab;
import cr0s.warpdrive.block.hull.BlockHullStairs;
import cr0s.warpdrive.block.movement.BlockLift;
import cr0s.warpdrive.block.movement.BlockShipController;
import cr0s.warpdrive.block.movement.BlockShipCore;
import cr0s.warpdrive.block.movement.BlockTransporterBeacon;
import cr0s.warpdrive.block.movement.BlockTransporterContainment;
import cr0s.warpdrive.block.movement.BlockTransporterCore;
import cr0s.warpdrive.block.movement.BlockTransporterScanner;
import cr0s.warpdrive.block.movement.TileEntityJumpGateCore;
import cr0s.warpdrive.block.movement.TileEntityLift;
import cr0s.warpdrive.block.movement.TileEntityShipController;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.block.movement.TileEntityTransporterBeacon;
import cr0s.warpdrive.block.movement.TileEntityTransporterCore;
import cr0s.warpdrive.block.passive.BlockHighlyAdvancedMachine;
import cr0s.warpdrive.block.passive.BlockIridium;
import cr0s.warpdrive.block.weapon.BlockLaserCamera;
import cr0s.warpdrive.block.weapon.BlockWeaponController;
import cr0s.warpdrive.block.weapon.TileEntityLaserCamera;
import cr0s.warpdrive.block.weapon.TileEntityWeaponController;
import cr0s.warpdrive.client.CreativeTabHull;
import cr0s.warpdrive.client.CreativeTabMain;
import cr0s.warpdrive.command.CommandBed;
import cr0s.warpdrive.command.CommandDebug;
import cr0s.warpdrive.command.CommandDump;
import cr0s.warpdrive.command.CommandEntity;
import cr0s.warpdrive.command.CommandFind;
import cr0s.warpdrive.command.CommandGenerate;
import cr0s.warpdrive.command.CommandInvisible;
import cr0s.warpdrive.command.CommandNPC;
import cr0s.warpdrive.command.CommandReload;
import cr0s.warpdrive.command.CommandRender;
import cr0s.warpdrive.command.CommandSpace;
import cr0s.warpdrive.config.Recipes;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.damage.DamageAsphyxia;
import cr0s.warpdrive.damage.DamageCold;
import cr0s.warpdrive.damage.DamageIrradiation;
import cr0s.warpdrive.damage.DamageLaser;
import cr0s.warpdrive.damage.DamageShock;
import cr0s.warpdrive.damage.DamageTeleportation;
import cr0s.warpdrive.damage.DamageWarm;
import cr0s.warpdrive.data.CamerasRegistry;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.CloakManager;
import cr0s.warpdrive.data.EnumAirTankTier;
import cr0s.warpdrive.data.EnumComponentType;
import cr0s.warpdrive.data.EnumHullPlainType;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.data.SoundEvents;
import cr0s.warpdrive.entity.EntityLaserExploder;
import cr0s.warpdrive.entity.EntityNPC;
import cr0s.warpdrive.entity.EntityOfflineAvatar;
import cr0s.warpdrive.entity.EntityParticleBunch;
import cr0s.warpdrive.entity.EntitySeat;
import cr0s.warpdrive.event.ChatHandler;
import cr0s.warpdrive.event.ChunkHandler;
import cr0s.warpdrive.event.ChunkLoadingHandler;
import cr0s.warpdrive.event.CommonWorldGenerator;
import cr0s.warpdrive.event.WorldHandler;
import cr0s.warpdrive.item.ItemAirTank;
import cr0s.warpdrive.item.ItemComponent;
import cr0s.warpdrive.item.ItemElectromagneticCell;
import cr0s.warpdrive.item.ItemForceFieldShape;
import cr0s.warpdrive.item.ItemForceFieldUpgrade;
import cr0s.warpdrive.item.ItemIC2reactorLaserFocus;
import cr0s.warpdrive.item.ItemPlasmaTorch;
import cr0s.warpdrive.item.ItemShipToken;
import cr0s.warpdrive.item.ItemTuningDriver;
import cr0s.warpdrive.item.ItemTuningFork;
import cr0s.warpdrive.item.ItemWarpArmor;
import cr0s.warpdrive.item.ItemWrench;
import cr0s.warpdrive.network.PacketHandler;
import cr0s.warpdrive.render.EntityCamera;
import cr0s.warpdrive.world.BiomeSpace;
import cr0s.warpdrive.world.EntitySphereGen;
import cr0s.warpdrive.world.EntityStarCore;
import cr0s.warpdrive.world.HyperSpaceWorldProvider;
import cr0s.warpdrive.world.SpaceWorldProvider;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="warpdrive", name="WarpDrive", version="1.12.2-1.5.19.SNAPSHOT", dependencies="required-after:forge@[14.23.5.2817,);after:appliedenergistics;after:cofhcore;after:ccturtle;after:computercraft@[1.82.1,);after:enderio@[5.1.52,);after:gregtech;after:ic2;after:icbmclassic@[1.12.2-4.0.0,);after:matteroverdrive;after:metalchests@[v5.8.1,);after:opencomputers;", certificateFingerprint="f7be6b40743c6a8205df86c5e57547d578605d8a", acceptedMinecraftVersions="[1.12.2]")
public class WarpDrive {
    public static final String MODID = "warpdrive";
    public static final String VERSION = "1.12.2-1.5.19.SNAPSHOT";
    public static final boolean isDev = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0 || "1.12.2-1.5.19.SNAPSHOT".contains("-dev");
    public static GameProfile gameProfile = new GameProfile(UUID.nameUUIDFromBytes("[WarpDrive]".getBytes()), "[WarpDrive]");
    public static Block blockLaser;
    public static Block[] blockChunkLoaders;
    public static Block[] blockLaserMediums;
    public static ItemComponent itemComponent;
    public static Block blockAcceleratorCore;
    public static Block blockAcceleratorControlPoint;
    public static Block blockParticlesCollider;
    public static Block blockParticlesInjector;
    public static Block blockVoidShellPlain;
    public static Block blockVoidShellGlass;
    public static Block[] blockElectromagnets_plain;
    public static Block[] blockElectromagnets_glass;
    public static Block[] blockChillers;
    public static ItemElectromagneticCell[] itemElectromagneticCell;
    public static ItemPlasmaTorch[] itemPlasmaTorch;
    public static Block[] blockShipScanners;
    public static ItemShipToken itemShipToken;
    public static Block blockAirFlow;
    public static Block blockAirSource;
    public static Block blockAirShield;
    public static Block[] blockAirGeneratorTiered;
    public static Block blockMiningLaser;
    public static Block blockLaserTreeFarm;
    public static Block blockBedrockGlass;
    public static Block blockDecorative;
    public static Block blockGas;
    public static Block blockLamp_bubble;
    public static Block blockLamp_flat;
    public static Block blockLamp_long;
    public static Block blockBiometricScanner;
    public static Block blockCamera;
    public static Block blockCloakingCoil;
    public static Block blockCloakingCore;
    public static Block blockEnvironmentalSensor;
    public static Block blockMonitor;
    public static Block blockRadar;
    public static Block[] blockSirenIndustrial;
    public static Block[] blockSirenMilitary;
    public static Block[] blockSpeaker;
    public static Block[] blockVirtualAssistant;
    public static Block blockWarpIsolation;
    public static Block[] blockCapacitor;
    public static Block[] blockEnanReactorCores;
    public static Block blockEnanReactorLaser;
    public static Block blockIC2reactorLaserCooler;
    public static Item itemIC2reactorLaserFocus;
    public static Block[] blockForceFields;
    public static Block[] blockForceFieldProjectors;
    public static Block[] blockForceFieldRelays;
    public static Block blockSecurityStation;
    public static ItemForceFieldShape itemForceFieldShape;
    public static ItemForceFieldUpgrade itemForceFieldUpgrade;
    public static Block[][] blockHulls_plain;
    public static Block[] blockHulls_glass;
    public static Block[] blockHulls_omnipanel;
    public static Block[][] blockHulls_stairs;
    public static Block[][] blockHulls_slab;
    public static Block blockLift;
    public static Block[] blockShipCores;
    public static Block[] blockShipControllers;
    public static Block blockTransporterBeacon;
    public static Block blockTransporterCore;
    public static Block blockTransporterContainment;
    public static Block blockTransporterScanner;
    public static Block blockHighlyAdvancedMachine;
    public static Block blockIridium;
    public static Block blockLaserCamera;
    public static Block blockWeaponController;
    public static final ItemArmor.ArmorMaterial[] armorMaterial;
    public static ItemAirTank[] itemAirTanks;
    public static ItemTuningFork itemTuningFork;
    public static ItemTuningDriver itemTuningDriver;
    public static ItemWrench itemWrench;
    public static ItemArmor[][] itemWarpArmor;
    public static DamageAsphyxia damageAsphyxia;
    public static DamageCold damageCold;
    public static DamageIrradiation damageIrradiation;
    public static DamageLaser damageLaser;
    public static DamageShock damageShock;
    public static DamageTeleportation damageTeleportation;
    public static DamageWarm damageWarm;
    public static Biome biomeSpace;
    public static DimensionType dimensionTypeSpace;
    public static DimensionType dimensionTypeHyperSpace;
    private CommonWorldGenerator commonWorldGenerator;
    public static Method methodBlock_getSilkTouch;
    public static final CreativeTabs creativeTabMain;
    public static final CreativeTabs creativeTabHull;
    @Mod.Instance(value="warpdrive")
    public static WarpDrive instance;
    @SidedProxy(clientSide="cr0s.warpdrive.client.ClientProxy", serverSide="cr0s.warpdrive.CommonProxy")
    public static CommonProxy proxy;
    public static CloakManager cloaks;
    public static CamerasRegistry cameras;
    private static WarpDrivePeripheralHandler peripheralHandler;
    public static Logger logger;
    public static LoggerPrintStream printStreamError;
    public static LoggerPrintStream printStreamWarn;
    public static LoggerPrintStream printStreamInfo;
    public static final ArrayList<Biome> biomes;
    public static final ArrayList<Block> blocks;
    public static final ArrayList<Enchantment> enchantments;
    public static final ArrayList<Item> items;
    public static final ArrayList<Potion> potions;
    public static final ArrayList<PotionType> potionTypes;
    public static final ArrayList<SoundEvent> soundEvents;
    public static final HashMap<ResourceLocation, IRecipe> recipes;
    public static final ArrayList<VillagerRegistry.VillagerProfession> villagerProfessions;

    @Mod.EventHandler
    public void onFMLPreInitialization(@Nonnull FMLPreInitializationEvent event) {
        int index;
        logger = event.getModLog();
        printStreamError = new LoggerPrintStream(Level.ERROR);
        printStreamWarn = new LoggerPrintStream(Level.WARN);
        printStreamInfo = new LoggerPrintStream(Level.INFO);
        WarpDriveConfig.onFMLpreInitialization(event.getModConfigurationDirectory().getAbsolutePath());
        methodBlock_getSilkTouch = ReflectionHelper.findMethod(Block.class, (String)"getSilkTouchDrop", (String)"func_180643_i", (Class[])new Class[]{IBlockState.class});
        blockLaser = new BlockLaser("laser", EnumTier.BASIC);
        blockChunkLoaders = new Block[EnumTier.length];
        for (EnumTier enumTier : EnumTier.nonCreative()) {
            index = enumTier.getIndex();
            WarpDrive.blockChunkLoaders[index] = new BlockChunkLoader("chunk_loader." + enumTier.func_176610_l(), enumTier);
        }
        blockLaserMediums = new Block[EnumTier.length];
        for (EnumTier enumTier : EnumTier.nonCreative()) {
            index = enumTier.getIndex();
            WarpDrive.blockLaserMediums[index] = new BlockLaserMedium("laser_medium." + enumTier.func_176610_l(), enumTier);
        }
        itemComponent = new ItemComponent("component", EnumTier.BASIC);
        WarpDrive.armorMaterial[EnumTier.BASIC.getIndex()] = EnumHelper.addArmorMaterial((String)"rubber", (String)"warpdrive:warp", (int)6, (int[])new int[]{1, 2, 3, 1}, (int)12, (SoundEvent)net.minecraft.init.SoundEvents.field_187728_s, (float)0.0f);
        armorMaterial[EnumTier.BASIC.getIndex()].setRepairItem(ItemComponent.getItemStack(EnumComponentType.RUBBER));
        WarpDrive.armorMaterial[EnumTier.ADVANCED.getIndex()] = EnumHelper.addArmorMaterial((String)"ceramic", (String)"warpdrive:warp", (int)18, (int[])new int[]{2, 6, 5, 2}, (int)9, (SoundEvent)net.minecraft.init.SoundEvents.field_187725_r, (float)1.0f);
        armorMaterial[EnumTier.ADVANCED.getIndex()].setRepairItem(ItemComponent.getItemStack(EnumComponentType.CERAMIC));
        WarpDrive.armorMaterial[EnumTier.SUPERIOR.getIndex()] = EnumHelper.addArmorMaterial((String)"carbon_fiber", (String)"warpdrive:warp", (int)40, (int[])new int[]{3, 6, 8, 3}, (int)10, (SoundEvent)net.minecraft.init.SoundEvents.field_187716_o, (float)2.5f);
        armorMaterial[EnumTier.SUPERIOR.getIndex()].setRepairItem(ItemComponent.getItemStack(EnumComponentType.CARBON_FIBER));
        if (WarpDriveConfig.ACCELERATOR_ENABLE) {
            blockAcceleratorCore = new BlockAcceleratorCore("accelerator_core", EnumTier.BASIC);
            blockAcceleratorControlPoint = new BlockAcceleratorControlPoint("accelerator_control_point", EnumTier.BASIC, false);
            blockParticlesCollider = new BlockParticlesCollider("particles_collider", EnumTier.BASIC);
            blockParticlesInjector = new BlockParticlesInjector("particles_injector", EnumTier.BASIC);
            blockVoidShellPlain = new BlockVoidShellPlain("void_shell.plain", EnumTier.BASIC);
            blockVoidShellGlass = new BlockVoidShellGlass("void_shell.glass", EnumTier.BASIC);
            blockElectromagnets_plain = new Block[EnumTier.length];
            blockElectromagnets_glass = new Block[EnumTier.length];
            blockChillers = new Block[EnumTier.length];
            itemElectromagneticCell = new ItemElectromagneticCell[EnumTier.length];
            itemPlasmaTorch = new ItemPlasmaTorch[EnumTier.length];
            for (Enum enum_ : EnumTier.nonCreative()) {
                index = ((EnumTier)enum_).getIndex();
                WarpDrive.blockElectromagnets_plain[index] = new BlockElectromagnetPlain("electromagnet." + ((EnumTier)enum_).func_176610_l() + ".plain", (EnumTier)enum_);
                WarpDrive.blockElectromagnets_glass[index] = new BlockElectromagnetGlass("electromagnet." + ((EnumTier)enum_).func_176610_l() + ".glass", (EnumTier)enum_);
                WarpDrive.blockChillers[index] = new BlockChiller("chiller." + ((EnumTier)enum_).func_176610_l(), (EnumTier)enum_);
                WarpDrive.itemElectromagneticCell[index] = new ItemElectromagneticCell("electromagnetic_cell." + ((EnumTier)enum_).func_176610_l(), (EnumTier)enum_);
            }
        }
        blockShipScanners = new Block[EnumTier.length];
        for (EnumTier enumTier : EnumTier.nonCreative()) {
            index = enumTier.getIndex();
            WarpDrive.blockShipScanners[index] = new BlockShipScanner("ship_scanner." + enumTier.func_176610_l(), enumTier);
        }
        itemShipToken = new ItemShipToken("ship_token", EnumTier.BASIC);
        blockAirFlow = new BlockAirFlow("air_flow", EnumTier.BASIC);
        blockAirSource = new BlockAirSource("air_source", EnumTier.BASIC);
        blockAirShield = new BlockAirShield("air_shield", EnumTier.BASIC);
        blockAirGeneratorTiered = new Block[EnumTier.length];
        for (EnumTier enumTier : EnumTier.nonCreative()) {
            index = enumTier.getIndex();
            WarpDrive.blockAirGeneratorTiered[index] = new BlockAirGeneratorTiered("air_generator." + enumTier.func_176610_l(), enumTier);
        }
        itemAirTanks = new ItemAirTank[4];
        for (Enum enum_ : EnumAirTankTier.values()) {
            WarpDrive.itemAirTanks[((EnumAirTankTier)enum_).getIndex()] = new ItemAirTank("air_tank." + ((EnumAirTankTier)enum_).func_176610_l(), (EnumAirTankTier)enum_);
        }
        blockMiningLaser = new BlockMiningLaser("mining_laser", EnumTier.BASIC);
        blockLaserTreeFarm = new BlockLaserTreeFarm("laser_tree_farm", EnumTier.BASIC);
        blockBedrockGlass = new BlockBedrockGlass("bedrock_glass", EnumTier.CREATIVE);
        blockDecorative = new BlockDecorative("decorative", EnumTier.BASIC);
        blockGas = new BlockGas("gas", EnumTier.BASIC);
        blockLamp_bubble = new BlockLamp_bubble("lamp_bubble", EnumTier.BASIC);
        blockLamp_flat = new BlockLamp_flat("lamp_flat", EnumTier.BASIC);
        blockLamp_long = new BlockLamp_long("lamp_long", EnumTier.BASIC);
        blockBiometricScanner = new BlockBiometricScanner("biometric_scanner", EnumTier.BASIC);
        blockCamera = new BlockCamera("camera", EnumTier.BASIC);
        blockCloakingCoil = new BlockCloakingCoil("cloaking_coil", EnumTier.BASIC);
        blockCloakingCore = new BlockCloakingCore("cloaking_core", EnumTier.BASIC);
        blockEnvironmentalSensor = new BlockEnvironmentalSensor("environmental_sensor", EnumTier.BASIC);
        blockMonitor = new BlockMonitor("monitor", EnumTier.BASIC);
        blockRadar = new BlockRadar("radar", EnumTier.BASIC);
        blockSirenIndustrial = new Block[EnumTier.length];
        blockSirenMilitary = new Block[EnumTier.length];
        blockSpeaker = new Block[EnumTier.length];
        blockVirtualAssistant = new Block[EnumTier.length];
        for (Enum enum_ : EnumTier.nonCreative()) {
            index = ((EnumTier)enum_).getIndex();
            WarpDrive.blockSirenIndustrial[index] = new BlockSiren("siren_industrial." + ((EnumTier)enum_).func_176610_l(), (EnumTier)enum_, true);
            WarpDrive.blockSirenMilitary[index] = new BlockSiren("siren_military." + ((EnumTier)enum_).func_176610_l(), (EnumTier)enum_, false);
            WarpDrive.blockSpeaker[index] = new BlockSpeaker("speaker." + ((EnumTier)enum_).func_176610_l(), (EnumTier)enum_);
            WarpDrive.blockVirtualAssistant[index] = new BlockVirtualAssistant("virtual_assistant." + ((EnumTier)enum_).func_176610_l(), (EnumTier)enum_);
        }
        blockWarpIsolation = new BlockWarpIsolation("warp_isolation", EnumTier.BASIC);
        blockCapacitor = new Block[EnumTier.length];
        for (Enum enum_ : EnumTier.values()) {
            index = ((EnumTier)enum_).getIndex();
            WarpDrive.blockCapacitor[index] = new BlockCapacitor("capacitor." + ((EnumTier)enum_).func_176610_l(), (EnumTier)enum_);
        }
        blockEnanReactorCores = new Block[EnumTier.length];
        for (Enum enum_ : EnumTier.nonCreative()) {
            index = ((EnumTier)enum_).getIndex();
            WarpDrive.blockEnanReactorCores[index] = new BlockEnanReactorCore("enan_reactor_core." + ((EnumTier)enum_).func_176610_l(), (EnumTier)enum_);
        }
        blockEnanReactorLaser = new BlockEnanReactorLaser("enan_reactor_laser", EnumTier.BASIC);
        if (WarpDriveConfig.isIndustrialCraft2Loaded) {
            blockIC2reactorLaserCooler = new BlockIC2reactorLaserCooler("ic2_reactor_laser_cooler", EnumTier.BASIC);
            itemIC2reactorLaserFocus = new ItemIC2reactorLaserFocus("ic2_reactor_laser_focus", EnumTier.BASIC);
        }
        blockForceFields = new Block[EnumTier.length];
        blockForceFieldProjectors = new Block[EnumTier.length];
        blockForceFieldRelays = new Block[EnumTier.length];
        for (Enum enum_ : EnumTier.nonCreative()) {
            index = ((EnumTier)enum_).getIndex();
            WarpDrive.blockForceFields[index] = new BlockForceField("force_field." + ((EnumTier)enum_).func_176610_l(), (EnumTier)enum_);
            WarpDrive.blockForceFieldProjectors[index] = new BlockForceFieldProjector("projector." + ((EnumTier)enum_).func_176610_l(), (EnumTier)enum_);
            WarpDrive.blockForceFieldRelays[index] = new BlockForceFieldRelay("force_field_relay." + ((EnumTier)enum_).func_176610_l(), (EnumTier)enum_);
        }
        blockSecurityStation = new BlockSecurityStation("security_station", EnumTier.BASIC);
        itemForceFieldShape = new ItemForceFieldShape("force_field_shape", EnumTier.BASIC);
        itemForceFieldUpgrade = new ItemForceFieldUpgrade("force_field_upgrade", EnumTier.BASIC);
        blockHulls_plain = new Block[EnumTier.length][EnumHullPlainType.length];
        blockHulls_glass = new Block[EnumTier.length];
        blockHulls_omnipanel = new Block[EnumTier.length];
        blockHulls_stairs = new Block[EnumTier.length][16];
        blockHulls_slab = new Block[EnumTier.length][16];
        for (Enum enum_ : EnumTier.nonCreative()) {
            index = ((EnumTier)enum_).getIndex();
            for (EnumHullPlainType enumHullPlainType : EnumHullPlainType.values()) {
                WarpDrive.blockHulls_plain[index][enumHullPlainType.ordinal()] = new BlockHullPlain("hull." + ((EnumTier)enum_).func_176610_l() + "." + enumHullPlainType.func_176610_l(), (EnumTier)enum_, enumHullPlainType);
            }
            WarpDrive.blockHulls_glass[index] = new BlockHullGlass("hull." + ((EnumTier)enum_).func_176610_l() + ".glass", (EnumTier)enum_);
            WarpDrive.blockHulls_omnipanel[index] = new BlockHullOmnipanel("hull." + ((EnumTier)enum_).func_176610_l() + ".omnipanel", (EnumTier)enum_);
            for (EnumHullPlainType enumHullPlainType : EnumDyeColor.values()) {
                int metadata = enumHullPlainType.func_176765_a();
                WarpDrive.blockHulls_stairs[index][metadata] = new BlockHullStairs("hull." + ((EnumTier)enum_).func_176610_l() + ".stairs_" + enumHullPlainType.func_176610_l(), (EnumTier)enum_, blockHulls_plain[index][0].func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)((Object)enumHullPlainType)));
                WarpDrive.blockHulls_slab[index][metadata] = new BlockHullSlab("hull." + ((EnumTier)enum_).func_176610_l() + ".slab_" + enumHullPlainType.func_176610_l(), (EnumTier)enum_, blockHulls_plain[index][0].func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)((Object)enumHullPlainType)));
            }
        }
        blockLift = new BlockLift("lift", EnumTier.BASIC);
        blockShipControllers = new Block[EnumTier.length];
        blockShipCores = new Block[EnumTier.length];
        for (Enum enum_ : EnumTier.nonCreative()) {
            index = ((EnumTier)enum_).getIndex();
            WarpDrive.blockShipControllers[index] = new BlockShipController("ship_controller." + ((EnumTier)enum_).func_176610_l(), (EnumTier)enum_);
            WarpDrive.blockShipCores[index] = new BlockShipCore("ship_core." + ((EnumTier)enum_).func_176610_l(), (EnumTier)enum_);
        }
        blockTransporterBeacon = new BlockTransporterBeacon("transporter_beacon", EnumTier.BASIC);
        blockTransporterContainment = new BlockTransporterContainment("transporter_containment", EnumTier.BASIC);
        blockTransporterCore = new BlockTransporterCore("transporter_core", EnumTier.BASIC);
        blockTransporterScanner = new BlockTransporterScanner("transporter_scanner", EnumTier.BASIC);
        blockHighlyAdvancedMachine = new BlockHighlyAdvancedMachine("highly_advanced_machine", EnumTier.BASIC);
        blockIridium = new BlockIridium("iridium_block", EnumTier.BASIC);
        blockLaserCamera = new BlockLaserCamera("laser_camera", EnumTier.BASIC);
        blockWeaponController = new BlockWeaponController("weapon_controller", EnumTier.BASIC);
        itemTuningFork = new ItemTuningFork("tuning_fork", EnumTier.BASIC);
        itemTuningDriver = new ItemTuningDriver("tuning_driver", EnumTier.ADVANCED);
        itemWrench = new ItemWrench("wrench", EnumTier.BASIC);
        itemWarpArmor = new ItemArmor[EnumTier.length][4];
        for (Enum enum_ : EnumTier.nonCreative()) {
            index = ((EnumTier)enum_).getIndex();
            WarpDrive.itemWarpArmor[index][EntityEquipmentSlot.HEAD.func_188454_b()] = new ItemWarpArmor("warp_armor." + ((EnumTier)enum_).func_176610_l() + "." + ItemWarpArmor.suffixes[EntityEquipmentSlot.HEAD.func_188454_b()], (EnumTier)enum_, armorMaterial[index], 3, EntityEquipmentSlot.HEAD);
            WarpDrive.itemWarpArmor[index][EntityEquipmentSlot.CHEST.func_188454_b()] = new ItemWarpArmor("warp_armor." + ((EnumTier)enum_).func_176610_l() + "." + ItemWarpArmor.suffixes[EntityEquipmentSlot.CHEST.func_188454_b()], (EnumTier)enum_, armorMaterial[index], 3, EntityEquipmentSlot.CHEST);
            WarpDrive.itemWarpArmor[index][EntityEquipmentSlot.LEGS.func_188454_b()] = new ItemWarpArmor("warp_armor." + ((EnumTier)enum_).func_176610_l() + "." + ItemWarpArmor.suffixes[EntityEquipmentSlot.LEGS.func_188454_b()], (EnumTier)enum_, armorMaterial[index], 3, EntityEquipmentSlot.LEGS);
            WarpDrive.itemWarpArmor[index][EntityEquipmentSlot.FEET.func_188454_b()] = new ItemWarpArmor("warp_armor." + ((EnumTier)enum_).func_176610_l() + "." + ItemWarpArmor.suffixes[EntityEquipmentSlot.FEET.func_188454_b()], (EnumTier)enum_, armorMaterial[index], 3, EntityEquipmentSlot.FEET);
        }
        damageAsphyxia = new DamageAsphyxia();
        damageCold = new DamageCold();
        damageIrradiation = new DamageIrradiation();
        damageLaser = new DamageLaser();
        damageShock = new DamageShock();
        damageTeleportation = new DamageTeleportation();
        damageWarm = new DamageWarm();
        Biome.BiomeProperties biomeProperties = new Biome.BiomeProperties("space").func_185396_a().func_185402_a(0);
        biomeSpace = new BiomeSpace(biomeProperties);
        WarpDrive.register(biomeSpace);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)ChunkLoadingHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)this);
        proxy.onForgePreInitialisation();
    }

    @Mod.EventHandler
    public void onFMLInitialization(FMLInitializationEvent event) {
        PacketHandler.init();
        WarpDriveConfig.onFMLInitialization();
        this.commonWorldGenerator = new CommonWorldGenerator();
        GameRegistry.registerWorldGenerator((IWorldGenerator)this.commonWorldGenerator, (int)0);
        dimensionTypeSpace = DimensionType.register((String)"space", (String)"_space", (int)WarpDriveConfig.G_SPACE_PROVIDER_ID, SpaceWorldProvider.class, (boolean)true);
        dimensionTypeHyperSpace = DimensionType.register((String)"hyperspace", (String)"_hyperspace", (int)WarpDriveConfig.G_HYPERSPACE_PROVIDER_ID, HyperSpaceWorldProvider.class, (boolean)true);
        cloaks = new CloakManager();
        cameras = new CamerasRegistry();
        CelestialObjectManager.onFMLInitialization();
        proxy.onForgeInitialisation();
    }

    @Mod.EventHandler
    public void onFMLPostInitialization(FMLPostInitializationEvent event) {
        WarpDriveConfig.onFMLPostInitialization();
        if (WarpDriveConfig.isComputerCraftLoaded) {
            peripheralHandler = new WarpDrivePeripheralHandler();
            peripheralHandler.register();
        }
        WorldHandler worldHandler = new WorldHandler();
        MinecraftForge.EVENT_BUS.register((Object)worldHandler);
        ChunkHandler chunkHandler = new ChunkHandler();
        MinecraftForge.EVENT_BUS.register((Object)chunkHandler);
        ChatHandler chatHandler = new ChatHandler();
        MinecraftForge.EVENT_BUS.register((Object)chatHandler);
    }

    @Mod.EventHandler
    public void onFMLServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBed());
        event.registerServerCommand((ICommand)new CommandDebug());
        event.registerServerCommand((ICommand)new CommandDump());
        event.registerServerCommand((ICommand)new CommandEntity());
        event.registerServerCommand((ICommand)new CommandFind());
        event.registerServerCommand((ICommand)new CommandGenerate());
        event.registerServerCommand((ICommand)new CommandInvisible());
        event.registerServerCommand((ICommand)new CommandNPC());
        event.registerServerCommand((ICommand)new CommandReload());
        event.registerServerCommand((ICommand)new CommandRender());
        event.registerServerCommand((ICommand)new CommandSpace());
    }

    public static <BIOME extends Biome> BIOME register(@Nonnull BIOME biome) {
        biomes.add(biome);
        return biome;
    }

    public static <BLOCK extends Block> BLOCK register(@Nonnull BLOCK block) {
        assert (block instanceof IBlockBase);
        return WarpDrive.register(block, ((IBlockBase)block).createItemBlock());
    }

    public static <BLOCK extends Block> BLOCK register(@Nonnull BLOCK block, @Nullable ItemBlock itemBlock) {
        ResourceLocation resourceLocation = block.getRegistryName();
        if (resourceLocation == null) {
            logger.error(String.format("Missing registry name for block %s, ignoring registration...", block));
            return block;
        }
        assert (!blocks.contains(block));
        blocks.add(block);
        if (itemBlock != null) {
            itemBlock.setRegistryName(resourceLocation);
            WarpDrive.register(itemBlock);
        }
        return block;
    }

    public static <ENCHANTMENT extends Enchantment> ENCHANTMENT register(@Nonnull ENCHANTMENT enchantment) {
        enchantments.add(enchantment);
        return enchantment;
    }

    public static <ITEM extends Item> ITEM register(@Nonnull ITEM item) {
        items.add(item);
        return item;
    }

    public static <POTION extends Potion> POTION register(@Nonnull POTION potion) {
        potions.add(potion);
        return potion;
    }

    public static <POTION_TYPE extends PotionType> POTION_TYPE register(@Nonnull POTION_TYPE potionType) {
        potionTypes.add(potionType);
        return potionType;
    }

    public static <RECIPE extends IRecipe> RECIPE register(@Nonnull RECIPE recipe) {
        return WarpDrive.register(recipe, "");
    }

    public static <RECIPE extends IRecipe> RECIPE register(@Nonnull RECIPE recipe, String suffix) {
        ResourceLocation registryName = recipe.getRegistryName();
        if (registryName == null) {
            ItemStack itemStackOutput = recipe.func_77571_b();
            assert (itemStackOutput.func_77973_b().getRegistryName() != null);
            String path = itemStackOutput.func_190926_b() ? recipe.toString() : (itemStackOutput.func_190916_E() == 1 ? String.format("%s@%d%s", itemStackOutput.func_77973_b().getRegistryName().func_110623_a(), itemStackOutput.func_77952_i(), suffix) : String.format("%s@%dx%d%s", itemStackOutput.func_77973_b().getRegistryName().func_110623_a(), itemStackOutput.func_77952_i(), itemStackOutput.func_190916_E(), suffix));
            registryName = new ResourceLocation(MODID, path);
            if (recipes.containsKey(registryName)) {
                logger.error(String.format("Overlapping recipe detected, please report this to the mod author %s", registryName));
                registryName = new ResourceLocation(MODID, path + "!" + System.nanoTime());
                assert (false);
            }
            recipe.setRegistryName(registryName);
        }
        recipes.put(registryName, recipe);
        return recipe;
    }

    public static <SOUND_EVENT extends SoundEvent> SOUND_EVENT register(@Nonnull SOUND_EVENT soundEvent) {
        soundEvents.add(soundEvent);
        return soundEvent;
    }

    public static <VILLAGER_PROFESSION extends VillagerRegistry.VillagerProfession> VILLAGER_PROFESSION register(@Nonnull VILLAGER_PROFESSION villagerProfession) {
        villagerProfessions.add(villagerProfession);
        return villagerProfession;
    }

    @SubscribeEvent
    public void onRegisterBiomes(@Nonnull RegistryEvent.Register<Biome> event) {
        LocalProfiler.start(String.format("Registering %s", event.getName()));
        for (Biome biome : biomes) {
            event.getRegistry().register((IForgeRegistryEntry)biome);
        }
        BiomeDictionary.addTypes((Biome)biomeSpace, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD, BiomeDictionary.Type.WASTELAND});
        LocalProfiler.stop(1000L);
    }

    @SubscribeEvent
    public void onRegisterBlocks(@Nonnull RegistryEvent.Register<Block> event) {
        LocalProfiler.start(String.format("Registering %s", event.getName()));
        for (Block block : blocks) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        GameRegistry.registerTileEntity(TileEntityAcceleratorCore.class, (ResourceLocation)new ResourceLocation(MODID, "accelerator_core"));
        GameRegistry.registerTileEntity(TileEntityAcceleratorControlPoint.class, (ResourceLocation)new ResourceLocation(MODID, "accelerator_control_point"));
        GameRegistry.registerTileEntity(TileEntityAirGeneratorTiered.class, (ResourceLocation)new ResourceLocation(MODID, "air_generator"));
        GameRegistry.registerTileEntity(TileEntityBiometricScanner.class, (ResourceLocation)new ResourceLocation(MODID, "biometric_scanner"));
        GameRegistry.registerTileEntity(TileEntityCamera.class, (ResourceLocation)new ResourceLocation(MODID, "camera"));
        GameRegistry.registerTileEntity(TileEntityCapacitor.class, (ResourceLocation)new ResourceLocation(MODID, "capacitor"));
        GameRegistry.registerTileEntity(TileEntityChunkLoader.class, (ResourceLocation)new ResourceLocation(MODID, "chunk_loader"));
        GameRegistry.registerTileEntity(TileEntityCloakingCore.class, (ResourceLocation)new ResourceLocation(MODID, "cloaking_core"));
        GameRegistry.registerTileEntity(TileEntityEnanReactorCore.class, (ResourceLocation)new ResourceLocation(MODID, "enan_reactor_core"));
        GameRegistry.registerTileEntity(TileEntityEnanReactorLaser.class, (ResourceLocation)new ResourceLocation(MODID, "enan_reactor_laser"));
        GameRegistry.registerTileEntity(TileEntityEnvironmentalSensor.class, (ResourceLocation)new ResourceLocation(MODID, "environmental_sensor"));
        GameRegistry.registerTileEntity(TileEntityForceField.class, (ResourceLocation)new ResourceLocation(MODID, "force_field"));
        GameRegistry.registerTileEntity(TileEntityForceFieldProjector.class, (ResourceLocation)new ResourceLocation(MODID, "force_field_projector"));
        GameRegistry.registerTileEntity(TileEntityForceFieldRelay.class, (ResourceLocation)new ResourceLocation(MODID, "force_field_relay"));
        GameRegistry.registerTileEntity(TileEntityIC2reactorLaserMonitor.class, (ResourceLocation)new ResourceLocation(MODID, "ic2_reactor_laser_monitor"));
        GameRegistry.registerTileEntity(TileEntityJumpGateCore.class, (ResourceLocation)new ResourceLocation(MODID, "jump_gate_core"));
        GameRegistry.registerTileEntity(TileEntityLaser.class, (ResourceLocation)new ResourceLocation(MODID, "laser"));
        GameRegistry.registerTileEntity(TileEntityLaserCamera.class, (ResourceLocation)new ResourceLocation(MODID, "laser_camera"));
        GameRegistry.registerTileEntity(TileEntityLaserMedium.class, (ResourceLocation)new ResourceLocation(MODID, "laser_medium"));
        GameRegistry.registerTileEntity(TileEntityLaserTreeFarm.class, (ResourceLocation)new ResourceLocation(MODID, "laser_tree_farm"));
        GameRegistry.registerTileEntity(TileEntityLift.class, (ResourceLocation)new ResourceLocation(MODID, "lift"));
        GameRegistry.registerTileEntity(TileEntityMiningLaser.class, (ResourceLocation)new ResourceLocation(MODID, "mining_laser"));
        GameRegistry.registerTileEntity(TileEntityMonitor.class, (ResourceLocation)new ResourceLocation(MODID, "monitor"));
        GameRegistry.registerTileEntity(TileEntityParticlesInjector.class, (ResourceLocation)new ResourceLocation(MODID, "particles_injector"));
        GameRegistry.registerTileEntity(TileEntityRadar.class, (ResourceLocation)new ResourceLocation(MODID, "radar"));
        GameRegistry.registerTileEntity(TileEntitySecurityStation.class, (ResourceLocation)new ResourceLocation(MODID, "security_station"));
        GameRegistry.registerTileEntity(TileEntityShipController.class, (ResourceLocation)new ResourceLocation(MODID, "ship_controller"));
        GameRegistry.registerTileEntity(TileEntityShipCore.class, (ResourceLocation)new ResourceLocation(MODID, "ship_core"));
        GameRegistry.registerTileEntity(TileEntityShipScanner.class, (ResourceLocation)new ResourceLocation(MODID, "ship_scanner"));
        GameRegistry.registerTileEntity(TileEntitySiren.class, (ResourceLocation)new ResourceLocation(MODID, "siren"));
        GameRegistry.registerTileEntity(TileEntitySpeaker.class, (ResourceLocation)new ResourceLocation(MODID, "speaker"));
        GameRegistry.registerTileEntity(TileEntityTransporterBeacon.class, (ResourceLocation)new ResourceLocation(MODID, "transporter_beacon"));
        GameRegistry.registerTileEntity(TileEntityTransporterCore.class, (ResourceLocation)new ResourceLocation(MODID, "transporter_core"));
        GameRegistry.registerTileEntity(TileEntityVirtualAssistant.class, (ResourceLocation)new ResourceLocation(MODID, "virtual_assistant"));
        GameRegistry.registerTileEntity(TileEntityWeaponController.class, (ResourceLocation)new ResourceLocation(MODID, "weapon_controller"));
        LocalProfiler.stop(1000L);
    }

    @SubscribeEvent
    public void onRegisterEnchantments(@Nonnull RegistryEvent.Register<Enchantment> event) {
        LocalProfiler.start(String.format("Registering %s", event.getName()));
        for (Enchantment enchantment : enchantments) {
            event.getRegistry().register((IForgeRegistryEntry)enchantment);
        }
        LocalProfiler.stop(1000L);
    }

    @SubscribeEvent
    public void onRegisterEntities(@Nonnull RegistryEvent.Register<EntityEntry> event) {
        LocalProfiler.start(String.format("Registering %s", event.getName()));
        EntityEntry entityEntry = EntityEntryBuilder.create().entity(EntitySphereGen.class).factory(EntitySphereGen::new).tracker(200, 1, false).id("entitySphereGenerator", WarpDriveConfig.G_ENTITY_SPHERE_GENERATOR_ID).name("EntitySphereGenerator").build();
        event.getRegistry().register((IForgeRegistryEntry)entityEntry);
        entityEntry = EntityEntryBuilder.create().entity(EntityStarCore.class).factory(EntityStarCore::new).tracker(300, 1, false).id("entity_star_sore", WarpDriveConfig.G_ENTITY_STAR_CORE_ID).name("EntityStarCore").build();
        event.getRegistry().register((IForgeRegistryEntry)entityEntry);
        entityEntry = EntityEntryBuilder.create().entity(EntityCamera.class).factory(EntityCamera::new).tracker(300, 1, false).id("entity_camera", WarpDriveConfig.G_ENTITY_CAMERA_ID).name("EntityCamera").build();
        event.getRegistry().register((IForgeRegistryEntry)entityEntry);
        entityEntry = EntityEntryBuilder.create().entity(EntityParticleBunch.class).factory(EntityParticleBunch::new).tracker(300, 1, false).id("entity_particle_bunch", WarpDriveConfig.G_ENTITY_PARTICLE_BUNCH_ID).name("EntityParticleBunch").build();
        event.getRegistry().register((IForgeRegistryEntry)entityEntry);
        entityEntry = EntityEntryBuilder.create().entity(EntityLaserExploder.class).factory(EntityLaserExploder::new).tracker(8, 1000, false).id("entity_laser_exploder", WarpDriveConfig.G_ENTITY_LASER_EXPLODER_ID).name("entityLaserExploder").build();
        event.getRegistry().register((IForgeRegistryEntry)entityEntry);
        entityEntry = EntityEntryBuilder.create().entity(EntityNPC.class).factory(EntityNPC::new).tracker(200, 1, false).id("entity_npc", WarpDriveConfig.G_ENTITY_NPC_ID).name("EntityNPC").build();
        event.getRegistry().register((IForgeRegistryEntry)entityEntry);
        entityEntry = EntityEntryBuilder.create().entity(EntityOfflineAvatar.class).factory(EntityOfflineAvatar::new).tracker(200, 1, false).id("entity_offline_avatar", WarpDriveConfig.G_ENTITY_OFFLINE_AVATAR_ID).name("EntityOfflineAvatar").build();
        event.getRegistry().register((IForgeRegistryEntry)entityEntry);
        entityEntry = EntityEntryBuilder.create().entity(EntitySeat.class).factory(EntitySeat::new).tracker(200, 1, false).id("entity_seat", WarpDriveConfig.G_ENTITY_SEAT_ID).name("EntitySeat").build();
        event.getRegistry().register((IForgeRegistryEntry)entityEntry);
        LocalProfiler.stop(1000L);
    }

    @SubscribeEvent
    public void onRegisterItems(@Nonnull RegistryEvent.Register<Item> event) {
        LocalProfiler.start(String.format("Registering %s", event.getName()));
        for (Item item : items) {
            event.getRegistry().register((IForgeRegistryEntry)item);
            proxy.onModelInitialisation(item);
        }
        for (Block block : blocks) {
            proxy.onModelInitialisation(block);
        }
        LocalProfiler.stop(1000L);
    }

    @SubscribeEvent
    public void onRegisterPotions(@Nonnull RegistryEvent.Register<Potion> event) {
        LocalProfiler.start(String.format("Registering %s", event.getName()));
        for (Potion potion : potions) {
            event.getRegistry().register((IForgeRegistryEntry)potion);
        }
        LocalProfiler.stop(1000L);
    }

    @SubscribeEvent
    public void onRegisterPotionTypes(@Nonnull RegistryEvent.Register<PotionType> event) {
        LocalProfiler.start(String.format("Registering %s", event.getName()));
        for (PotionType potionType : potionTypes) {
            event.getRegistry().register((IForgeRegistryEntry)potionType);
        }
        LocalProfiler.stop(1000L);
    }

    @SubscribeEvent
    public void onRegisterRecipes(@Nonnull RegistryEvent.Register<IRecipe> event) {
        LocalProfiler.start(String.format("Registering %s step 1", event.getName()));
        Recipes.initOreDictionary();
        Recipes.initDynamic();
        LocalProfiler.stop(1000L);
        LocalProfiler.start(String.format("Registering %s step 2", event.getName()));
        for (IRecipe recipe : recipes.values()) {
            event.getRegistry().register((IForgeRegistryEntry)recipe);
        }
        LocalProfiler.stop(1000L);
    }

    @SubscribeEvent
    public void onRegisterSoundEvents(@Nonnull RegistryEvent.Register<SoundEvent> event) {
        LocalProfiler.start(String.format("Registering %s", event.getName()));
        SoundEvents.registerSounds();
        for (SoundEvent soundEvent : soundEvents) {
            event.getRegistry().register((IForgeRegistryEntry)soundEvent);
        }
        LocalProfiler.stop(1000L);
    }

    @SubscribeEvent
    public void onRegisterVillagerProfessions(@Nonnull RegistryEvent.Register<VillagerRegistry.VillagerProfession> event) {
        LocalProfiler.start(String.format("Registering %s", event.getName()));
        for (VillagerRegistry.VillagerProfession villagerProfession : villagerProfessions) {
            event.getRegistry().register((IForgeRegistryEntry)villagerProfession);
        }
        LocalProfiler.stop(1000L);
    }

    static {
        armorMaterial = new ItemArmor.ArmorMaterial[EnumTier.length];
        methodBlock_getSilkTouch = null;
        creativeTabMain = new CreativeTabMain(MODID.toLowerCase() + ".main");
        creativeTabHull = new CreativeTabHull(MODID.toLowerCase() + ".hull");
        peripheralHandler = null;
        biomes = new ArrayList(10);
        blocks = new ArrayList(100);
        enchantments = new ArrayList(10);
        items = new ArrayList(50);
        potions = new ArrayList(10);
        potionTypes = new ArrayList(10);
        soundEvents = new ArrayList(100);
        recipes = new HashMap(100);
        villagerProfessions = new ArrayList(10);
    }
}

