/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockBase;
import cr0s.warpdrive.api.IVideoChannel;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.ItemBlockAbstractBase;
import cr0s.warpdrive.block.TileEntityAbstractBase;
import cr0s.warpdrive.block.TileEntityAbstractMachine;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.render.ClientCameraHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockAbstractBase
extends Block
implements IBlockBase {
    protected final EnumTier enumTier;
    protected boolean ignoreFacingOnPlacement = false;

    protected BlockAbstractBase(String registryName, EnumTier enumTier, Material material) {
        super(material);
        this.enumTier = enumTier;
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(WarpDrive.creativeTabMain);
        this.setRegistryName(registryName);
        WarpDrive.register(this);
    }

    @Override
    @Nullable
    public ItemBlock createItemBlock() {
        return new ItemBlockAbstractBase(this, false, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void modelInitialisation() {
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int metadata, @Nonnull EntityLivingBase entityLivingBase, @Nonnull EnumHand enumHand) {
        boolean isRotating;
        IBlockState blockState = super.getStateForPlacement(world, blockPos, facing, hitX, hitY, hitZ, metadata, entityLivingBase, enumHand);
        boolean bl = isRotating = !this.ignoreFacingOnPlacement && blockState.func_177228_b().containsKey((Object)BlockProperties.FACING);
        if (isRotating) {
            if (blockState.func_185913_b()) {
                EnumFacing enumFacing = Commons.getFacingFromEntity(entityLivingBase);
                return blockState.func_177226_a((IProperty)BlockProperties.FACING, (Comparable)enumFacing);
            }
            return blockState.func_177226_a((IProperty)BlockProperties.FACING, (Comparable)facing);
        }
        return blockState;
    }

    public boolean rotateBlock(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull EnumFacing axis) {
        return super.rotateBlock(world, blockPos, axis);
    }

    @Override
    @Nonnull
    public EnumTier getTier(ItemStack itemStack) {
        return this.enumTier;
    }

    @Override
    @Nonnull
    public IRarity getForgeRarity(@Nonnull ItemStack itemStack) {
        return this.getTier(itemStack).getForgeRarity();
    }

    public static boolean onCommonBlockActivated(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumHand enumHand, @Nonnull EnumFacing enumFacing, float hitX, float hitY, float hitZ) {
        if (enumHand != EnumHand.MAIN_HAND) {
            return true;
        }
        if (world.field_72995_K && ClientCameraHandler.isOverlayEnabled) {
            return true;
        }
        ItemStack itemStackHeld = entityPlayer.func_184586_b(enumHand);
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (!(tileEntity instanceof TileEntityAbstractBase)) {
            return false;
        }
        TileEntityAbstractBase tileEntityAbstractBase = (TileEntityAbstractBase)tileEntity;
        boolean hasVideoChannel = tileEntity instanceof IVideoChannel;
        if (world.field_72995_K && !hasVideoChannel) {
            return tileEntityAbstractBase instanceof TileEntityAbstractMachine && itemStackHeld.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150429_aA);
        }
        TileEntityAbstractBase.UpgradeSlot upgradeSlot = tileEntityAbstractBase.getUpgradeSlot(itemStackHeld);
        if (!world.field_72995_K && entityPlayer.func_70093_af()) {
            if (tileEntityAbstractBase.isUpgradeable() && (itemStackHeld.func_190926_b() || upgradeSlot != null)) {
                if (upgradeSlot == null || !tileEntityAbstractBase.hasUpgrade(upgradeSlot)) {
                    upgradeSlot = tileEntityAbstractBase.getFirstUpgradeOfType(itemStackHeld.func_190926_b() ? Item.class : itemStackHeld.func_77973_b().getClass(), null);
                }
                if (upgradeSlot == null) {
                    Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.upgrade.result.no_upgrade_to_dismount", new Object[0]));
                    return true;
                }
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    ItemStack itemStackDrop = new ItemStack(upgradeSlot.itemStack.func_77973_b(), upgradeSlot.itemStack.func_190916_E(), upgradeSlot.itemStack.func_77960_j());
                    EntityItem entityItem = new EntityItem(world, entityPlayer.field_70165_t, entityPlayer.field_70163_u + 0.5, entityPlayer.field_70161_v, itemStackDrop);
                    entityItem.func_174868_q();
                    boolean isSuccess = world.func_72838_d((Entity)entityItem);
                    if (!isSuccess) {
                        Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.upgrade.result.spawn_denied", entityItem));
                        return true;
                    }
                }
                tileEntityAbstractBase.dismountUpgrade(upgradeSlot);
                Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.upgrade.result.dismounted", new TextComponentTranslation(upgradeSlot.itemStack.func_77977_a() + ".name", new Object[0])));
                return true;
            }
        } else {
            if (!entityPlayer.func_70093_af() && itemStackHeld.func_190926_b()) {
                Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)tileEntityAbstractBase.getStatus());
                return true;
            }
            if (!world.field_72995_K && tileEntityAbstractBase.isUpgradeable() && upgradeSlot != null) {
                if (tileEntityAbstractBase.getUpgradeMaxCount(upgradeSlot) < tileEntityAbstractBase.getUpgradeCount(upgradeSlot) + 1) {
                    Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.upgrade.result.too_many_upgrades", tileEntityAbstractBase.getUpgradeMaxCount(upgradeSlot)));
                    return true;
                }
                if (!tileEntityAbstractBase.canMountUpgrade(upgradeSlot)) {
                    Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.upgrade.result.invalid_upgrade", new Object[0]));
                    return true;
                }
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    int countRequired = upgradeSlot.itemStack.func_190916_E();
                    if (itemStackHeld.func_190916_E() < countRequired) {
                        Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.upgrade.result.not_enough_upgrades", new Object[0]));
                        return true;
                    }
                    itemStackHeld.func_190918_g(countRequired);
                }
                tileEntityAbstractBase.mountUpgrade(upgradeSlot);
                Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.upgrade.result.mounted", new TextComponentTranslation(upgradeSlot.itemStack.func_77977_a() + ".name", new Object[0])));
                return true;
            }
            if (!world.field_72995_K && tileEntityAbstractBase instanceof TileEntityAbstractMachine && itemStackHeld.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150429_aA)) {
                TileEntityAbstractMachine tileEntityAbstractMachine;
                boolean isEnabledOld = (tileEntityAbstractMachine = (TileEntityAbstractMachine)tileEntityAbstractBase).getIsEnabled();
                tileEntityAbstractMachine.setIsEnabled(!isEnabledOld);
                boolean isEnabledNew = tileEntityAbstractMachine.getIsEnabled();
                if (isEnabledOld != isEnabledNew) {
                    if (isEnabledNew) {
                        Commons.addChatMessage((ICommandSender)entityPlayer, Commons.getChatPrefix(blockState.func_177230_c()).func_150257_a((ITextComponent)new TextComponentTranslation("warpdrive.machine.is_enabled.set.enabled", new Object[0])));
                    } else {
                        Commons.addChatMessage((ICommandSender)entityPlayer, Commons.getChatPrefix(blockState.func_177230_c()).func_150257_a((ITextComponent)new TextComponentTranslation("warpdrive.machine.is_enabled.set.disabled", new Object[0])));
                    }
                } else if (isEnabledNew) {
                    Commons.addChatMessage((ICommandSender)entityPlayer, Commons.getChatPrefix(blockState.func_177230_c()).func_150257_a((ITextComponent)new TextComponentTranslation("warpdrive.machine.is_enabled.get.enabled", new Object[0])));
                } else {
                    Commons.addChatMessage((ICommandSender)entityPlayer, Commons.getChatPrefix(blockState.func_177230_c()).func_150257_a((ITextComponent)new TextComponentTranslation("warpdrive.machine.is_enabled.get.disabled", new Object[0])));
                }
                return true;
            }
            if (!world.field_72995_K && itemStackHeld.func_77973_b() == Items.field_151045_i && entityPlayer.func_184812_l_()) {
                tileEntityAbstractBase.setDebugValues();
                Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)tileEntityAbstractBase.getStatus());
                return true;
            }
        }
        return false;
    }

    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumHand enumHand, @Nonnull EnumFacing enumFacing, float hitX, float hitY, float hitZ) {
        if (BlockAbstractBase.onCommonBlockActivated(world, blockPos, blockState, entityPlayer, enumHand, enumFacing, hitX, hitY, hitZ)) {
            return true;
        }
        return super.func_180639_a(world, blockPos, blockState, entityPlayer, enumHand, enumFacing, hitX, hitY, hitZ);
    }
}

