/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockBase;
import cr0s.warpdrive.api.IBlockUpdateDetector;
import cr0s.warpdrive.block.BlockAbstractBase;
import cr0s.warpdrive.block.ItemBlockAbstractBase;
import cr0s.warpdrive.block.TileEntityAbstractBase;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.block.TileEntityAbstractMachine;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.EnumHorizontalSpinning;
import cr0s.warpdrive.data.EnumTier;
import java.util.ConcurrentModificationException;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockAbstractContainer
extends BlockContainer
implements IBlockBase {
    private static long timeUpdated = -1L;
    private static int dimensionIdUpdated = Integer.MAX_VALUE;
    private static int xUpdated = Integer.MAX_VALUE;
    private static int yUpdated = Integer.MAX_VALUE;
    private static int zUpdated = Integer.MAX_VALUE;
    protected EnumTier enumTier;
    protected boolean hasSubBlocks = false;
    protected boolean ignoreFacingOnPlacement = false;

    protected BlockAbstractContainer(String registryName, EnumTier enumTier, Material material) {
        super(material);
        this.enumTier = enumTier;
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(WarpDrive.creativeTabMain);
        this.setRegistryName(registryName);
        WarpDrive.register(this);
    }

    @Override
    @Nullable
    public ItemBlock createItemBlock() {
        return new ItemBlockAbstractBase((Block)this, false, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void modelInitialisation() {
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState blockState) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_176213_c(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState) {
        super.func_176213_c(world, blockPos, blockState);
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof IBlockUpdateDetector) {
            ((IBlockUpdateDetector)tileEntity).onBlockUpdateDetected();
        }
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int metadata, @Nonnull EntityLivingBase entityLivingBase, @Nonnull EnumHand enumHand) {
        IBlockState blockState = super.getStateForPlacement(world, blockPos, facing, hitX, hitY, hitZ, metadata, entityLivingBase, enumHand);
        if (!this.ignoreFacingOnPlacement) {
            if (blockState.func_177228_b().containsKey(BlockProperties.HORIZONTAL_SPINNING)) {
                EnumFacing enumSpinning;
                EnumFacing enumFacing;
                if (blockState.func_185913_b()) {
                    enumFacing = Commons.getFacingFromEntity(entityLivingBase);
                    enumSpinning = Commons.getHorizontalDirectionFromEntity(entityLivingBase).func_176734_d();
                } else {
                    enumFacing = facing;
                    enumSpinning = Commons.getHorizontalDirectionFromEntity(entityLivingBase);
                }
                EnumHorizontalSpinning enumHorizontalSpinning = EnumHorizontalSpinning.get(enumFacing, enumSpinning);
                return blockState.func_177226_a(BlockProperties.HORIZONTAL_SPINNING, (Comparable)((Object)enumHorizontalSpinning));
            }
            if (blockState.func_177228_b().containsKey((Object)BlockProperties.FACING)) {
                if (blockState.func_185913_b()) {
                    EnumFacing enumFacing = Commons.getFacingFromEntity(entityLivingBase);
                    return blockState.func_177226_a((IProperty)BlockProperties.FACING, (Comparable)enumFacing);
                }
                return blockState.func_177226_a((IProperty)BlockProperties.FACING, (Comparable)facing);
            }
            if (blockState.func_177228_b().containsKey((Object)BlockProperties.FACING_HORIZONTAL)) {
                EnumFacing enumFacing = Commons.getHorizontalDirectionFromEntity(entityLivingBase);
                if (blockState.func_185913_b()) {
                    return blockState.func_177226_a((IProperty)BlockProperties.FACING_HORIZONTAL, (Comparable)enumFacing.func_176734_d());
                }
                return blockState.func_177226_a((IProperty)BlockProperties.FACING_HORIZONTAL, (Comparable)enumFacing);
            }
        }
        return blockState;
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState, @Nonnull EntityLivingBase entityLivingBase, @Nonnull ItemStack itemStack) {
        super.func_180633_a(world, blockPos, blockState, entityLivingBase, itemStack);
        TileEntity tileEntity = world.func_175625_s(blockPos);
        assert (tileEntity instanceof TileEntityAbstractBase);
        if (itemStack.func_77978_p() != null) {
            NBTTagCompound tagCompound = itemStack.func_77978_p().func_74737_b();
            tagCompound.func_74768_a("x", blockPos.func_177958_n());
            tagCompound.func_74768_a("y", blockPos.func_177956_o());
            tagCompound.func_74768_a("z", blockPos.func_177952_p());
            tileEntity.func_145839_a(tagCompound);
            tileEntity.func_70296_d();
            world.func_184138_a(blockPos, blockState, blockState, 3);
        }
    }

    public boolean removedByPlayer(@Nonnull IBlockState blockState, @Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull EntityPlayer entityPlayer, boolean willHarvest) {
        boolean bResult;
        if (willHarvest) {
            this.func_176208_a(world, blockPos, blockState, entityPlayer);
            bResult = true;
        } else {
            bResult = super.removedByPlayer(blockState, world, blockPos, entityPlayer, false);
        }
        return bResult;
    }

    public void func_180653_a(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState, float chance, int fortune) {
        super.func_180653_a(world, blockPos, blockState, chance, fortune);
        if (!world.field_72995_K && !world.restoringBlockSnapshots) {
            world.func_175698_g(blockPos);
        }
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState, int fortune) {
        TileEntity tileEntity = blockAccess.func_175625_s(blockPos);
        if (!(tileEntity instanceof TileEntityAbstractBase)) {
            WarpDrive.logger.error(String.format("Missing tile entity for %s %s, reverting to vanilla getDrops logic", this, Commons.format(blockAccess, blockPos)));
            super.getDrops(drops, blockAccess, blockPos, blockState, fortune);
            return;
        }
        Random rand = blockAccess instanceof World ? ((World)blockAccess).field_73012_v : RANDOM;
        int count = this.quantityDropped(blockState, fortune, rand);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_180660_a(blockState, rand, fortune);
            if (item == Items.field_190931_a) continue;
            ItemStack itemStack = new ItemStack(item, 1, this.func_180651_a(blockState));
            NBTTagCompound tagCompound = new NBTTagCompound();
            ((TileEntityAbstractBase)tileEntity).writeItemDropNBT(tagCompound);
            if (!tagCompound.func_82582_d()) {
                itemStack.func_77982_d(tagCompound);
            }
            drops.add((Object)itemStack);
        }
    }

    public void func_180663_b(World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState) {
        assert (world != null);
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof TileEntityAbstractBase) {
            ((TileEntityAbstractBase)tileEntity).onBlockBroken(world, blockPos, blockState);
        }
        super.func_180663_b(world, blockPos, blockState);
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState blockState, @Nullable RayTraceResult target, @Nonnull World world, @Nonnull BlockPos blockPos, @Nullable EntityPlayer entityPlayer) {
        ItemStack itemStack = super.getPickBlock(blockState, target, world, blockPos, entityPlayer);
        TileEntity tileEntity = world.func_175625_s(blockPos);
        NBTTagCompound tagCompound = new NBTTagCompound();
        if (tileEntity instanceof TileEntityAbstractBase) {
            ((TileEntityAbstractBase)tileEntity).writeItemDropNBT(tagCompound);
            if (!tagCompound.func_82582_d()) {
                itemStack.func_77982_d(tagCompound);
            }
        }
        return itemStack;
    }

    public boolean rotateBlock(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull EnumFacing axis) {
        TileEntity tileEntity;
        boolean isRotated = super.rotateBlock(world, blockPos, axis);
        if (isRotated && (tileEntity = world.func_175625_s(blockPos)) instanceof TileEntityAbstractMachine) {
            ((TileEntityAbstractMachine)tileEntity).markDirtyAssembly();
        }
        return isRotated;
    }

    public void func_189540_a(@Nonnull IBlockState blockState, @Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull Block block, @Nonnull BlockPos blockPosFrom) {
        super.func_189540_a(blockState, world, blockPos, block, blockPosFrom);
        this.onBlockUpdateDetected((IBlockAccess)world, blockPos, blockPosFrom);
    }

    public void onNeighborChange(@Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos, @Nonnull BlockPos blockPosNeighbor) {
        super.onNeighborChange(blockAccess, blockPos, blockPosNeighbor);
        this.onBlockUpdateDetected(blockAccess, blockPos, blockPosNeighbor);
    }

    public void observedNeighborChange(@Nonnull IBlockState observerState, @Nonnull World world, @Nonnull BlockPos blockPosObserver, @Nonnull Block blockChanged, @Nonnull BlockPos blockPosChanged) {
        super.observedNeighborChange(observerState, world, blockPosObserver, blockChanged, blockPosChanged);
        this.onBlockUpdateDetected((IBlockAccess)world, blockPosObserver, blockPosChanged);
    }

    protected void onBlockUpdateDetected(@Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos, @Nonnull BlockPos blockPosUpdated) {
        TileEntity tileEntity;
        if (!Commons.isSafeThread()) {
            if (WarpDriveConfig.LOGGING_PROFILING_THREAD_SAFETY) {
                Block blockNeighbor = blockAccess.func_180495_p(blockPosUpdated).func_177230_c();
                ResourceLocation registryName = blockNeighbor.getRegistryName();
                WarpDrive.logger.error(String.format("Bad multithreading detected from mod %s %s, please report to mod author", registryName == null ? blockNeighbor : registryName.func_110624_b(), Commons.format(blockAccess, blockPosUpdated)));
                new ConcurrentModificationException().printStackTrace(WarpDrive.printStreamError);
            }
            return;
        }
        if (blockAccess instanceof World) {
            World world = (World)blockAccess;
            if (timeUpdated == world.func_82737_E() && dimensionIdUpdated == world.field_73011_w.getDimension() && xUpdated == blockPos.func_177958_n() && yUpdated == blockPos.func_177956_o() && zUpdated == blockPos.func_177952_p()) {
                return;
            }
            timeUpdated = world.func_82737_E();
            dimensionIdUpdated = world.field_73011_w.getDimension();
            xUpdated = blockPos.func_177958_n();
            yUpdated = blockPos.func_177956_o();
            zUpdated = blockPos.func_177952_p();
        }
        if ((tileEntity = blockAccess.func_175625_s(blockPos)) == null || tileEntity.func_145831_w().field_72995_K) {
            return;
        }
        if (tileEntity instanceof IBlockUpdateDetector) {
            ((IBlockUpdateDetector)tileEntity).onBlockUpdateDetected();
        }
    }

    public void onEMP(@Nonnull World world, @Nonnull BlockPos blockPos, float efficiency) {
        TileEntityAbstractEnergy tileEntityAbstractEnergy;
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof TileEntityAbstractEnergy && (tileEntityAbstractEnergy = (TileEntityAbstractEnergy)tileEntity).energy_getMaxStorage() > 0L) {
            tileEntityAbstractEnergy.energy_consume(Math.round((float)tileEntityAbstractEnergy.energy_getEnergyStored() * efficiency), false);
        }
    }

    @Override
    @Nonnull
    public EnumTier getTier(ItemStack itemStack) {
        return this.enumTier;
    }

    @Override
    @Nonnull
    public IRarity getForgeRarity(@Nonnull ItemStack itemStack) {
        return this.getTier(itemStack).getForgeRarity();
    }

    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumHand enumHand, @Nonnull EnumFacing enumFacing, float hitX, float hitY, float hitZ) {
        if (BlockAbstractBase.onCommonBlockActivated(world, blockPos, blockState, entityPlayer, enumHand, enumFacing, hitX, hitY, hitZ)) {
            return true;
        }
        return super.func_180639_a(world, blockPos, blockState, entityPlayer, enumHand, enumFacing, hitX, hitY, hitZ);
    }
}

