/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.api.IBlockBase;
import cr0s.warpdrive.api.IItemBase;
import cr0s.warpdrive.block.BlockAbstractContainer;
import cr0s.warpdrive.block.TileEntityAbstractBase;
import cr0s.warpdrive.client.ClientProxy;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.event.TooltipHandler;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockAbstractBase
extends ItemBlock
implements IItemBase {
    final boolean hasUniqueName;

    public ItemBlockAbstractBase(Block block, boolean hasSubtypes, boolean hasUniqueName) {
        super(block);
        this.func_77627_a(hasSubtypes);
        this.func_77655_b(block.func_149739_a());
        this.hasUniqueName = hasUniqueName;
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    @Nonnull
    public String func_77667_c(@Nonnull ItemStack itemStack) {
        if (this.hasUniqueName || !(this.field_150939_a instanceof BlockAbstractContainer) || !((BlockAbstractContainer)this.field_150939_a).hasSubBlocks) {
            return this.func_77658_a();
        }
        return this.func_77658_a() + itemStack.func_77952_i();
    }

    @Override
    @Nonnull
    public EnumTier getTier(@Nonnull ItemStack itemStack) {
        if (!(this.field_150939_a instanceof IBlockBase)) {
            return EnumTier.BASIC;
        }
        return ((IBlockBase)this.field_150939_a).getTier(itemStack);
    }

    @Nonnull
    public IRarity getForgeRarity(@Nonnull ItemStack itemStack) {
        IRarity rarityDefault = super.getForgeRarity(itemStack);
        if (!(this.field_150939_a instanceof IBlockBase)) {
            return rarityDefault;
        }
        IRarity rarityItemStack = ((IBlockBase)this.field_150939_a).getForgeRarity(itemStack);
        if (rarityItemStack instanceof EnumRarity && rarityDefault instanceof EnumRarity) {
            return ((EnumRarity)rarityItemStack).ordinal() > ((EnumRarity)rarityDefault).ordinal() ? rarityItemStack : rarityDefault;
        }
        return rarityItemStack;
    }

    public ITextComponent getStatus(World world, @Nonnull ItemStack itemStack) {
        IBlockState blockState = TooltipHandler.getStateForPlacement(this.field_150939_a, world, null, EnumFacing.DOWN, 0.0f, 0.0f, 0.0f, itemStack.func_77960_j(), null, EnumHand.MAIN_HAND);
        TileEntity tileEntity = this.field_150939_a.createTileEntity(world, blockState);
        if (tileEntity instanceof TileEntityAbstractBase) {
            return ((TileEntityAbstractBase)tileEntity).getStatus(itemStack, blockState);
        }
        return new TextComponentString("");
    }

    @Override
    public void onEntityExpireEvent(EntityItem entityItem, ItemStack itemStack) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void modelInitialisation() {
        ClientProxy.modelInitialisation((Item)this);
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModelResourceLocation(ItemStack itemStack) {
        if (this.hasUniqueName) {
            ResourceLocation resourceLocation = this.getRegistryName();
            assert (resourceLocation != null);
            return new ModelResourceLocation(resourceLocation, "inventory");
        }
        return ClientProxy.getModelResourceLocation(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemStack, @Nullable World world, @Nonnull List<String> list, @Nonnull ITooltipFlag advancedItemTooltips) {
        String tooltipName;
        String tooltipItemStack = this.func_77667_c(itemStack) + ".tooltip";
        if (I18n.func_188566_a((String)tooltipItemStack)) {
            Commons.addTooltip(list, new TextComponentTranslation(tooltipItemStack, new Object[0]).func_150254_d());
        }
        if (!tooltipItemStack.equals(tooltipName = this.func_77658_a() + ".tooltip") && I18n.func_188566_a((String)tooltipName)) {
            Commons.addTooltip(list, new TextComponentTranslation(tooltipName, new Object[0]).func_150254_d());
        }
        String tooltipNameWithoutTier = tooltipName;
        for (EnumTier enumTier : EnumTier.values()) {
            tooltipNameWithoutTier = tooltipNameWithoutTier.replace("." + enumTier.func_176610_l(), "");
        }
        if (!tooltipNameWithoutTier.equals(tooltipItemStack) && I18n.func_188566_a((String)tooltipNameWithoutTier)) {
            Commons.addTooltip(list, new TextComponentTranslation(tooltipNameWithoutTier, new Object[0]).func_150254_d());
        }
        Commons.addTooltip(list, this.getStatus(world, itemStack).func_150254_d());
        super.func_77624_a(itemStack, world, list, advancedItemTooltips);
    }

    public String toString() {
        return String.format("%s@%s {%s} %s", this.getClass().getSimpleName(), Integer.toHexString(this.hashCode()), field_150901_e.func_177774_c((Object)this), this.func_77658_a());
    }
}

