/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.api.IGlobalRegionProvider;
import cr0s.warpdrive.api.computer.IEnergyConsumer;
import cr0s.warpdrive.api.computer.IMultiBlockCore;
import cr0s.warpdrive.api.computer.IMultiBlockCoreOrController;
import cr0s.warpdrive.block.TileEntityAbstractEnergyConsumer;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.GlobalRegionManager;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileEntityAbstractEnergyCoreOrController
extends TileEntityAbstractEnergyConsumer
implements IMultiBlockCoreOrController,
IEnergyConsumer {
    public UUID uuid = null;
    private boolean isDirtyGlobalRegion = true;
    private int tickUpdateGlobalRegion = 0;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K && !(this instanceof TileEntityShipCore)) {
            return;
        }
        if (this instanceof IGlobalRegionProvider) {
            if (this.isDirtyGlobalRegion) {
                this.tickUpdateGlobalRegion = 0;
            }
            --this.tickUpdateGlobalRegion;
            if (this.tickUpdateGlobalRegion <= 0) {
                this.tickUpdateGlobalRegion = WarpDriveConfig.G_REGISTRY_UPDATE_INTERVAL_TICKS;
                boolean isDirty = this.isDirtyGlobalRegion;
                this.isDirtyGlobalRegion = false;
                this.doRegisterGlobalRegion(isDirty);
            }
        }
    }

    protected void markDirtyGlobalRegion() {
        assert (this instanceof IGlobalRegionProvider);
        this.isDirtyGlobalRegion = true;
    }

    protected void doRegisterGlobalRegion(boolean isDirty) {
        if (this.uuid == null || this.uuid.getMostSignificantBits() == 0L && this.uuid.getLeastSignificantBits() == 0L) {
            this.uuid = UUID.randomUUID();
        }
        GlobalRegionManager.updateInRegistry((IGlobalRegionProvider)((Object)this));
    }

    @Override
    public void onBlockBroken(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState) {
        if (!world.field_72995_K && this instanceof IGlobalRegionProvider) {
            GlobalRegionManager.removeFromRegistry((IGlobalRegionProvider)((Object)this));
        }
        super.onBlockBroken(world, blockPos, blockState);
    }

    @Override
    public void onCoreUpdated(@Nonnull IMultiBlockCore multiblockCore) {
        assert (multiblockCore instanceof TileEntityAbstractEnergyCoreOrController);
        this.name = ((TileEntityAbstractEnergyCoreOrController)((Object)multiblockCore)).name;
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.uuid = new UUID(tagCompound.func_74763_f("uuidMost"), tagCompound.func_74763_f("uuidLeast"));
        if (this.uuid.getMostSignificantBits() == 0L && this.uuid.getLeastSignificantBits() == 0L) {
            this.uuid = UUID.randomUUID();
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        if (this.uuid != null && this.uuid.getMostSignificantBits() != 0L && this.uuid.getLeastSignificantBits() != 0L) {
            tagCompound.func_74772_a("uuidMost", this.uuid.getMostSignificantBits());
            tagCompound.func_74772_a("uuidLeast", this.uuid.getLeastSignificantBits());
        }
        return tagCompound;
    }

    @Override
    @Nullable
    public UUID getSignatureUUID() {
        return this.uuid;
    }

    @Override
    public String getSignatureName() {
        return this.name;
    }

    @Override
    public boolean setSignature(UUID uuidSignature, String nameSignature) {
        if (this instanceof IMultiBlockCore) {
            return false;
        }
        this.uuid = uuidSignature;
        this.name = nameSignature;
        return true;
    }

    @Override
    public String toString() {
        return String.format("%s '%s' %s %s", this.getClass().getSimpleName(), this.name, Commons.format(this.field_145850_b, this.field_174879_c), this.computer_isConnected() ? "Connected" : "Disconnected");
    }
}

