/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.FunctionGet;
import cr0s.warpdrive.api.FunctionSetVector;
import cr0s.warpdrive.api.computer.IInterfaced;
import cr0s.warpdrive.block.TileEntityAbstractBase;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumComponentType;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.item.ItemComponent;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc.api.Network;
import li.cil.oc.api.fs.FileSystem;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Component;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="opencomputers"), @Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="computercraft")})
public abstract class TileEntityAbstractInterfaced
extends TileEntityAbstractBase
implements IPeripheral,
Environment,
IInterfaced {
    private static final ConcurrentHashMap<String, Object> CC_mountGlobals = new ConcurrentHashMap(32);
    private static final TileEntityAbstractBase.UpgradeSlot upgradeSlotComputerInterface = new TileEntityAbstractBase.UpgradeSlot("base.computer_interface", ItemComponent.getItemStackNoCache(EnumComponentType.COMPUTER_INTERFACE, 1), 1);
    protected String peripheralName = null;
    private String[] methodsArray = new String[0];
    private boolean isAlwaysInterfaced = true;
    public static final String COMPUTER_ERROR_TAG = "!ERROR!";
    private static final HashMap<String, Boolean> hashAssetExist = new HashMap(128);
    private volatile ManagedEnvironment OC_fileSystem = null;
    private volatile boolean CC_hasResource = false;
    private volatile boolean OC_hasResource = false;
    protected volatile List<String> CC_scripts = null;
    private Node OC_node = null;
    private boolean OC_addedToNetwork = false;
    private final ConcurrentHashMap<IComputerAccess, CopyOnWriteArraySet<String>> CC_connectedComputers = new ConcurrentHashMap();

    public TileEntityAbstractInterfaced() {
        this.addMethods(new String[]{"isInterfaced", "getLocalPosition", "getTier", "getUpgrades", "getVersion"});
    }

    protected void doRequireUpgradeToInterface() {
        assert (this.isAlwaysInterfaced);
        this.isAlwaysInterfaced = false;
        this.registerUpgradeSlot(upgradeSlotComputerInterface);
    }

    @Override
    protected void onUpgradeChanged(@Nonnull TileEntityAbstractBase.UpgradeSlot upgradeSlot, int countNew, boolean isAdded) {
        if (upgradeSlot.equals(upgradeSlotComputerInterface)) {
            if (isAdded) {
                if (WarpDriveConfig.isComputerCraftLoaded) {
                    this.CC_mount();
                }
                if (WarpDriveConfig.isOpenComputersLoaded) {
                    this.OC_constructor();
                }
            } else {
                if (WarpDriveConfig.isComputerCraftLoaded) {
                    this.CC_unmount();
                }
                if (WarpDriveConfig.isOpenComputersLoaded) {
                    this.OC_destructor();
                }
            }
        }
        super.onUpgradeChanged(upgradeSlot, countNew, isAdded);
    }

    @Override
    public boolean isInterfaceEnabled() {
        return this.isAlwaysInterfaced || this.getUpgradeCount(upgradeSlotComputerInterface) > 0;
    }

    protected void addMethods(String[] methodsToAdd) {
        if (this.methodsArray == null) {
            this.methodsArray = methodsToAdd;
        } else {
            int currentLength = this.methodsArray.length;
            this.methodsArray = Arrays.copyOf(this.methodsArray, this.methodsArray.length + methodsToAdd.length);
            String[] stringArray = methodsToAdd;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String method;
                this.methodsArray[currentLength] = method = stringArray[i];
                ++currentLength;
            }
        }
    }

    private boolean assetExist(String resourcePath) {
        Boolean exist = hashAssetExist.get(resourcePath);
        if (exist == null) {
            URL url = this.getClass().getResource(resourcePath);
            exist = url != null;
            hashAssetExist.put(resourcePath, exist);
        }
        return exist;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (WarpDriveConfig.isOpenComputersLoaded && !this.OC_addedToNetwork && this.isInterfaceEnabled()) {
            this.OC_addedToNetwork = true;
            Network.joinOrCreateNetwork((TileEntity)this);
        }
    }

    public void func_145829_t() {
        if (WarpDriveConfig.isComputerCraftLoaded) {
            String CC_path = "/assets/" + "warpdrive".toLowerCase() + "/lua.ComputerCraft/" + this.peripheralName;
            this.CC_hasResource = this.assetExist(CC_path);
        }
        if (WarpDriveConfig.isOpenComputersLoaded && this.OC_node == null && this.isInterfaceEnabled()) {
            this.OC_constructor();
        }
        super.func_145829_t();
    }

    public void func_145843_s() {
        if (WarpDriveConfig.isOpenComputersLoaded) {
            this.OC_destructor();
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (WarpDriveConfig.isOpenComputersLoaded) {
            this.OC_destructor();
        }
        super.onChunkUnload();
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (WarpDriveConfig.isOpenComputersLoaded && FMLCommonHandler.instance().getEffectiveSide().isServer() && this.isInterfaceEnabled()) {
            if (this.OC_node == null) {
                this.OC_constructor();
            }
            if (this.OC_node != null && this.OC_node.host() == this) {
                this.OC_node.load(tagCompound.func_74775_l("oc:node"));
            } else if (tagCompound.func_74764_b("oc:node")) {
                WarpDrive.logger.error(String.format("%s OC node failed to construct or wrong host, ignoring NBT node data read...", this));
            }
            if (this.OC_fileSystem != null && this.OC_fileSystem.node() != null) {
                this.OC_fileSystem.node().load(tagCompound.func_74775_l("oc:fs"));
            } else if (this.OC_hasResource) {
                WarpDrive.logger.error(String.format("%s OC filesystem failed to construct or wrong node, ignoring NBT filesystem data read...", this));
            }
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        if (WarpDriveConfig.isOpenComputersLoaded) {
            if (this.OC_node != null && this.OC_node.host() == this) {
                NBTTagCompound nbtNode = new NBTTagCompound();
                this.OC_node.save(nbtNode);
                tagCompound.func_74782_a("oc:node", (NBTBase)nbtNode);
            }
            if (this.OC_fileSystem != null && this.OC_fileSystem.node() != null) {
                NBTTagCompound nbtFileSystem = new NBTTagCompound();
                this.OC_fileSystem.node().save(nbtFileSystem);
                tagCompound.func_74782_a("oc:fs", (NBTBase)nbtFileSystem);
            }
        }
        return tagCompound;
    }

    @Override
    public NBTTagCompound writeItemDropNBT(NBTTagCompound tagCompound) {
        tagCompound = super.writeItemDropNBT(tagCompound);
        tagCompound.func_82580_o("oc:node");
        tagCompound.func_82580_o("oc:fs");
        return tagCompound;
    }

    public int hashCode() {
        return (((super.hashCode() + (this.field_145850_b == null ? 0 : this.field_145850_b.field_73011_w.getDimension()) << 4) + this.field_174879_c.func_177958_n() << 4) + this.field_174879_c.func_177956_o() << 4) + this.field_174879_c.func_177952_p();
    }

    @Optional.Method(modid="opencomputers")
    protected Object[] OC_convertArgumentsAndLogCall(@Nonnull Context context, @Nonnull Arguments args) {
        Object[] arguments = new Object[args.count()];
        int index = 0;
        for (Object arg : args) {
            arguments[index] = args.isString(index) ? args.checkString(index) : arg;
            ++index;
        }
        if (WarpDriveConfig.LOGGING_LUA) {
            String methodName = Commons.getMethodName(1);
            WarpDrive.logger.info(String.format("[OC] LUA call %s from %s to %s.%s(%s)", Commons.format(this.field_145850_b, this.field_174879_c), context.node().address(), this.peripheralName, methodName, Commons.format(arguments)));
        }
        if (!this.isInterfaceEnabled()) {
            throw new RuntimeException("Missing Computer interface upgrade.");
        }
        return arguments;
    }

    @Optional.Method(modid="computercraft")
    private String CC_getMethodNameAndLogCall(@Nonnull IComputerAccess computerAccess, int methodIndex, @Nonnull Object[] arguments) {
        String methodName = this.methodsArray[methodIndex];
        if (WarpDriveConfig.LOGGING_LUA) {
            WarpDrive.logger.info(String.format("[CC] LUA call %s from %d:%s to %s.%s(%s)", Commons.format(this.field_145850_b, this.field_174879_c), computerAccess.getID(), computerAccess.getAttachmentName(), this.peripheralName, methodName, Commons.format(arguments)));
        }
        if (!this.isInterfaceEnabled() && !"isInterfaced".equals(methodName)) {
            throw new RuntimeException("Missing Computer interface upgrade.");
        }
        return methodName;
    }

    @Override
    public Object[] isInterfaced() {
        if (this.isInterfaceEnabled()) {
            return new Object[]{true, "I'm a WarpDrive computer interfaced tile entity."};
        }
        return new Object[]{false, "Missing Computer interface upgrade."};
    }

    @Override
    public Object[] getLocalPosition() {
        return new Object[]{this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()};
    }

    @Override
    public Object[] getTier() {
        return new Object[]{this.enumTier.getIndex(), this.enumTier.func_176610_l()};
    }

    @Override
    public Object[] getUpgrades() {
        return new Object[]{this.isUpgradeable(), Commons.removeFormatting(this.getUpgradeStatus(false).func_150260_c())};
    }

    @Override
    public Integer[] getVersion() {
        if (WarpDriveConfig.LOGGING_LUA) {
            WarpDrive.logger.info(String.format("Version is %s isDev %s", "1.12.2-1.5.19.SNAPSHOT", WarpDrive.isDev));
        }
        String[] strings = "1.12.2-1.5.19.SNAPSHOT".split("-");
        strings = WarpDrive.isDev ? strings[strings.length - 2].split("\\.") : strings[strings.length - 1].split("\\.");
        ArrayList<Integer> integers = new ArrayList<Integer>(strings.length);
        for (String string : strings) {
            integers.add(Integer.parseInt(string));
        }
        return integers.toArray(new Integer[0]);
    }

    public boolean computer_isConnected() {
        if (WarpDriveConfig.isComputerCraftLoaded && !this.CC_connectedComputers.isEmpty()) {
            return true;
        }
        if (WarpDriveConfig.isOpenComputersLoaded && this.OC_node != null) {
            Iterable iterableNodes = this.OC_node.reachableNodes();
            return iterableNodes.iterator().hasNext();
        }
        return false;
    }

    protected VectorI computer_getVectorI(VectorI vDefault, @Nonnull Object[] arguments) {
        try {
            if (arguments.length == 3) {
                int x = Commons.toInt(arguments[0]);
                int y = Commons.toInt(arguments[1]);
                int z = Commons.toInt(arguments[2]);
                return new VectorI(x, y, z);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return vDefault;
    }

    @Nonnull
    protected Object[] computer_getOrSetVector3(@Nonnull FunctionGet<Vector3> getVector, @Nonnull FunctionSetVector<Float> setVector, Object[] arguments) {
        if (arguments != null && arguments.length > 0 && arguments[0] != null) {
            try {
                if (arguments.length == 1) {
                    float value = Commons.toFloat(arguments[0]);
                    setVector.apply(Float.valueOf(value), Float.valueOf(value), Float.valueOf(value));
                } else if (arguments.length == 2) {
                    float valueXZ = Commons.toFloat(arguments[0]);
                    float valueY = Commons.toFloat(arguments[1]);
                    setVector.apply(Float.valueOf(valueXZ), Float.valueOf(valueY), Float.valueOf(valueXZ));
                } else if (arguments.length == 3) {
                    float valueX = Commons.toFloat(arguments[0]);
                    float valueY = Commons.toFloat(arguments[1]);
                    float valueZ = Commons.toFloat(arguments[2]);
                    setVector.apply(Float.valueOf(valueX), Float.valueOf(valueY), Float.valueOf(valueZ));
                }
            }
            catch (Exception exception) {
                String message = String.format("Float expected for all arguments %s", Arrays.toString(arguments));
                if (WarpDriveConfig.LOGGING_LUA) {
                    WarpDrive.logger.error(String.format("%s LUA error on %s: %s", this, setVector, message));
                }
                Vector3 v3Actual = getVector.apply();
                return new Object[]{v3Actual.x, v3Actual.y, v3Actual.z, message};
            }
        }
        Vector3 v3Actual = getVector.apply();
        return new Double[]{v3Actual.x, v3Actual.y, v3Actual.z};
    }

    protected UUID computer_getUUID(UUID uuidDefault, @Nonnull Object[] arguments) {
        try {
            if (arguments.length == 1 && arguments[0] != null) {
                if (arguments[0] instanceof UUID) {
                    return (UUID)arguments[0];
                }
                if (arguments[0] instanceof String) {
                    return UUID.fromString((String)arguments[0]);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return uuidDefault;
    }

    @Nonnull
    @Optional.Method(modid="computercraft")
    public String getType() {
        assert (this.peripheralName != null);
        return this.peripheralName;
    }

    @Nonnull
    @Optional.Method(modid="computercraft")
    public String[] getMethodNames() {
        return this.methodsArray;
    }

    @Optional.Method(modid="computercraft")
    public final Object[] callMethod(@Nonnull IComputerAccess computerAccess, @Nonnull ILuaContext context, int method, @Nonnull Object[] arguments) throws LuaException {
        String methodName = this.CC_getMethodNameAndLogCall(computerAccess, method, arguments);
        try {
            Object[] result = this.CC_callMethod(methodName, arguments);
            if (WarpDriveConfig.LOGGING_LUA) {
                WarpDrive.logger.info(String.format("[CC] LUA call is returning %s", Commons.format(result)));
            }
            return result;
        }
        catch (Exception exception) {
            if (WarpDriveConfig.LOGGING_LUA || Commons.throttleMe("LUA exception")) {
                exception.printStackTrace(WarpDrive.printStreamError);
            }
            throw new LuaException(String.format("Internal exception %s from %d:%s to %s.%s(%s)\nCheck server logs for details.", Commons.format(this.field_145850_b, this.field_174879_c), computerAccess.getID(), computerAccess.getAttachmentName(), this.peripheralName, methodName, Commons.format(arguments)));
        }
    }

    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "isInterfaced": {
                return this.isInterfaced();
            }
            case "getLocalPosition": {
                return this.getLocalPosition();
            }
            case "getTier": {
                return this.getTier();
            }
            case "getUpgrades": {
                return this.getUpgrades();
            }
            case "getVersion": {
                return this.getVersion();
            }
        }
        return null;
    }

    @Optional.Method(modid="computercraft")
    public void attach(@Nonnull IComputerAccess computerAccess) {
        if (this.CC_connectedComputers.containsKey(computerAccess)) {
            WarpDrive.logger.error(String.format("[CC] Already attached %s %s with %d:%s, ignoring...", this.peripheralName, Commons.format(this.field_145850_b, this.field_174879_c), computerAccess.getID(), computerAccess.getAttachmentName()));
            return;
        }
        if (WarpDriveConfig.LOGGING_LUA) {
            WarpDrive.logger.info(String.format("[CC] Attaching %s %s with %d:%s", this.peripheralName, Commons.format(this.field_145850_b, this.field_174879_c), computerAccess.getID(), computerAccess.getAttachmentName()));
        }
        CopyOnWriteArraySet<String> mountedLocations = new CopyOnWriteArraySet<String>();
        this.CC_connectedComputers.put(computerAccess, mountedLocations);
        if (this.isInterfaceEnabled()) {
            this.CC_mount(computerAccess, mountedLocations);
        }
    }

    @Optional.Method(modid="computercraft")
    private void CC_mount() {
        for (Map.Entry<IComputerAccess, CopyOnWriteArraySet<String>> entry : this.CC_connectedComputers.entrySet()) {
            this.CC_mount(entry.getKey(), entry.getValue());
        }
    }

    @Optional.Method(modid="computercraft")
    private void CC_mount(@Nonnull IComputerAccess computerAccess, @Nonnull CopyOnWriteArraySet<String> mountedLocations) {
        if (this.CC_hasResource && WarpDriveConfig.G_LUA_SCRIPTS != 0) {
            try {
                this.CC_mount(computerAccess, mountedLocations, "lua.ComputerCraft/common", "/warpdrive");
                String folderPeripheral = this.peripheralName.replace("warpdrive", "warpdrive/");
                this.CC_mount(computerAccess, mountedLocations, "lua.ComputerCraft/" + this.peripheralName, "/" + folderPeripheral);
                if (WarpDriveConfig.G_LUA_SCRIPTS == 2) {
                    for (String script : this.CC_scripts) {
                        this.CC_mount(computerAccess, mountedLocations, "lua.ComputerCraft/" + this.peripheralName + "/" + script, "/" + script);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(WarpDrive.printStreamError);
                WarpDrive.logger.error(String.format("Failed to mount ComputerCraft scripts for %s %s, isFirstTick %s", this.peripheralName, Commons.format(this.field_145850_b, this.field_174879_c), this.isFirstTick()));
            }
        }
    }

    @Optional.Method(modid="computercraft")
    private void CC_mount(@Nonnull IComputerAccess computerAccess, @Nonnull CopyOnWriteArraySet<String> mountedLocations, @Nonnull String pathAsset, @Nonnull String pathLUA) {
        IMount mountCommon = (IMount)CC_mountGlobals.get(pathAsset);
        if (mountCommon == null) {
            mountCommon = ComputerCraftAPI.createResourceMount(WarpDrive.class, (String)"warpdrive", (String)pathAsset);
            assert (mountCommon != null);
            CC_mountGlobals.put(pathAsset, mountCommon);
        }
        String pathLUA_actual = computerAccess.mount(pathLUA, mountCommon);
        if (WarpDriveConfig.LOGGING_LUA) {
            WarpDrive.logger.info(String.format("[CC] %s Mounted %s to %s as %s", Commons.format(this.field_145850_b, this.field_174879_c), pathAsset, pathLUA, pathLUA_actual));
        }
        if (pathLUA_actual != null) {
            mountedLocations.add(pathLUA_actual);
        }
    }

    @Optional.Method(modid="computercraft")
    private void CC_unmount() {
        for (Map.Entry<IComputerAccess, CopyOnWriteArraySet<String>> entry : this.CC_connectedComputers.entrySet()) {
            this.CC_unmount(entry.getKey(), entry.getValue());
        }
    }

    @Optional.Method(modid="computercraft")
    private void CC_unmount(@Nonnull IComputerAccess computerAccess) {
        CopyOnWriteArraySet<String> mountedLocations = this.CC_connectedComputers.get(computerAccess);
        if (mountedLocations != null) {
            this.CC_unmount(computerAccess, mountedLocations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Optional.Method(modid="computercraft")
    private void CC_unmount(@Nonnull IComputerAccess computerAccess, @Nonnull CopyOnWriteArraySet<String> mountedLocation) {
        if (this.CC_hasResource && WarpDriveConfig.G_LUA_SCRIPTS != 0) {
            try {
                for (String pathLUA : mountedLocation) {
                    if (WarpDriveConfig.LOGGING_LUA) {
                        WarpDrive.logger.info(String.format("[CC] %s Unmounting %s", Commons.format(this.field_145850_b, this.field_174879_c), pathLUA));
                    }
                    computerAccess.unmount(pathLUA);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(WarpDrive.printStreamError);
                WarpDrive.logger.error(String.format("Failed to unmount ComputerCraft scripts for %s %s, isFirstTick %s", this.peripheralName, Commons.format(this.field_145850_b, this.field_174879_c), this.isFirstTick()));
            }
            finally {
                mountedLocation.clear();
            }
        }
    }

    @Optional.Method(modid="computercraft")
    public void detach(@Nonnull IComputerAccess computerAccess) {
        if (!this.CC_connectedComputers.containsKey(computerAccess)) {
            WarpDrive.logger.error(String.format("[CC] Already detached %s %s from %d:%s, ignoring...", this.peripheralName, Commons.format(this.field_145850_b, this.field_174879_c), computerAccess.getID(), computerAccess.getAttachmentName()));
            return;
        }
        if (WarpDriveConfig.LOGGING_LUA) {
            WarpDrive.logger.info(String.format("[CC] Detaching %s %s from %d:%s", this.peripheralName, Commons.format(this.field_145850_b, this.field_174879_c), computerAccess.getID(), computerAccess.getAttachmentName()));
        }
        if (this.isInterfaceEnabled()) {
            this.CC_unmount(computerAccess);
        }
        this.CC_connectedComputers.remove(computerAccess);
    }

    @Optional.Method(modid="computercraft")
    public boolean equals(@Nullable IPeripheral other) {
        return other != null && other.hashCode() == this.hashCode();
    }

    protected void sendEvent(String eventName, Object ... arguments) {
        if (!this.isInterfaceEnabled()) {
            return;
        }
        if (WarpDriveConfig.LOGGING_LUA) {
            WarpDrive.logger.info(this + " Sending event '" + eventName + "'");
        }
        if (WarpDriveConfig.isComputerCraftLoaded) {
            for (IComputerAccess computerAccess : this.CC_connectedComputers.keySet()) {
                computerAccess.queueEvent(eventName, arguments);
            }
        }
        if (WarpDriveConfig.isOpenComputersLoaded && this.OC_node != null && this.OC_node.network() != null) {
            if (arguments == null || arguments.length == 0) {
                this.OC_node.sendToReachable("computer.signal", new Object[]{eventName});
            } else {
                Object[] eventWithArguments = new Object[arguments.length + 1];
                eventWithArguments[0] = eventName;
                int index = 1;
                Object[] objectArray = arguments;
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object object;
                    eventWithArguments[index] = object = objectArray[i];
                    ++index;
                }
                this.OC_node.sendToReachable("computer.signal", eventWithArguments);
            }
        }
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] isInterfaced(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.isInterfaced();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getLocalPosition(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getLocalPosition();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getUpgrades(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getUpgrades();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getTier(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getTier();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getVersion(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getVersion();
    }

    @Optional.Method(modid="opencomputers")
    private void OC_constructor() {
        assert (this.OC_node == null);
        String OC_path = "/assets/" + "warpdrive".toLowerCase() + "/lua.OpenComputers/" + this.peripheralName;
        this.OC_hasResource = this.assetExist(OC_path);
        this.OC_node = Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.peripheralName).create();
        if (this.OC_node != null && this.OC_hasResource && WarpDriveConfig.G_LUA_SCRIPTS != 0) {
            this.OC_fileSystem = li.cil.oc.api.FileSystem.asManagedEnvironment((FileSystem)li.cil.oc.api.FileSystem.fromClass(this.getClass(), (String)"warpdrive".toLowerCase(), (String)("lua.OpenComputers/" + this.peripheralName)), (String)this.peripheralName);
            ((Component)this.OC_fileSystem.node()).setVisibility(Visibility.Network);
        }
    }

    @Optional.Method(modid="opencomputers")
    private void OC_destructor() {
        if (this.OC_node != null) {
            if (this.OC_fileSystem != null) {
                this.OC_fileSystem.node().remove();
                this.OC_fileSystem = null;
            }
            this.OC_node.remove();
            this.OC_node = null;
            this.OC_addedToNetwork = false;
        }
    }

    @Optional.Method(modid="opencomputers")
    public Node node() {
        return this.OC_node;
    }

    @Optional.Method(modid="opencomputers")
    public void onConnect(@Nonnull Node node) {
        if (node.host() instanceof Context && this.OC_fileSystem != null) {
            node.connect(this.OC_fileSystem.node());
        }
    }

    @Optional.Method(modid="opencomputers")
    public void onDisconnect(@Nonnull Node node) {
        if (this.OC_fileSystem != null) {
            if (node.host() instanceof Context) {
                node.disconnect(this.OC_fileSystem.node());
            } else if (node.equals(this.OC_node)) {
                this.OC_fileSystem.node().remove();
            }
        }
    }

    @Optional.Method(modid="opencomputers")
    public void onMessage(@Nonnull Message message) {
    }
}

