/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.api.computer.IAbstractLaser;
import cr0s.warpdrive.block.TileEntityAbstractEnergyBase;
import cr0s.warpdrive.block.TileEntityLaserMedium;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnergyWrapper;
import cr0s.warpdrive.data.EnumTier;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Optional;

public abstract class TileEntityAbstractLaser
extends TileEntityAbstractEnergyBase
implements IAbstractLaser {
    protected EnumFacing[] laserMedium_directionsValid = EnumFacing.values();
    protected int laserMedium_maxCount = 0;
    protected EnumFacing laserMedium_direction = null;
    protected int cache_laserMedium_count = 0;
    protected double cache_laserMedium_factor = 1.0;
    protected long cache_laserMedium_energyStored = 0L;
    protected long cache_laserMedium_maxStorage = 0L;

    public TileEntityAbstractLaser() {
        this.addMethods(new String[]{"getEnergyRequired", "laserMediumDirection", "laserMediumCount"});
    }

    @Override
    protected boolean doScanAssembly(boolean isDirty, WarpDriveText textReason) {
        boolean isValid = super.doScanAssembly(isDirty, textReason);
        assert (this.laserMedium_maxCount != 0);
        for (EnumFacing facing : this.laserMedium_directionsValid) {
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (!(tileEntity instanceof TileEntityLaserMedium)) continue;
            EnumTier enumTier = ((TileEntityLaserMedium)tileEntity).enumTier;
            if (enumTier == null) {
                WarpDrive.logger.error(String.format("Invalid NULL tier for %s, isFirstTick %s", tileEntity, ((TileEntityLaserMedium)tileEntity).isFirstTick()));
                WarpDrive.logger.error(String.format("NBT is %s", tileEntity.func_189515_b(new NBTTagCompound())));
                continue;
            }
            long energyStored = 0L;
            long maxStorage = 0L;
            int count = 0;
            while (tileEntity instanceof TileEntityLaserMedium && count <= this.laserMedium_maxCount && enumTier == ((TileEntityLaserMedium)tileEntity).enumTier) {
                energyStored += ((TileEntityLaserMedium)tileEntity).energy_getEnergyStored();
                maxStorage += ((TileEntityLaserMedium)tileEntity).energy_getMaxStorage();
                tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(facing, ++count + 1));
            }
            this.laserMedium_direction = facing;
            this.cache_laserMedium_count = count;
            this.cache_laserMedium_factor = Math.max(1.0, (double)count * WarpDriveConfig.LASER_MEDIUM_FACTOR_BY_TIER[enumTier.getIndex()]);
            this.cache_laserMedium_energyStored = energyStored;
            this.cache_laserMedium_maxStorage = maxStorage;
            return isValid;
        }
        this.laserMedium_direction = null;
        this.cache_laserMedium_count = 0;
        this.cache_laserMedium_factor = 0.0;
        this.cache_laserMedium_energyStored = 0L;
        this.cache_laserMedium_maxStorage = 0L;
        textReason.append(Commons.getStyleWarning(), "warpdrive.laser.status_line.missing_laser_medium", Commons.format(this.laserMedium_directionsValid));
        return false;
    }

    public int laserMedium_getEnergyStored(boolean isCached) {
        if (isCached) {
            return (int)this.cache_laserMedium_energyStored;
        }
        return this.laserMedium_consumeUpTo(Integer.MAX_VALUE, true);
    }

    public int laserMedium_getCount() {
        return this.cache_laserMedium_count;
    }

    protected boolean laserMedium_consumeExactly(int amountRequested, boolean simulate) {
        int amountSimulated = this.laserMedium_consumeUpTo(amountRequested, true);
        if (simulate) {
            return amountRequested <= amountSimulated;
        }
        if (amountRequested > amountSimulated) {
            return false;
        }
        return amountRequested <= this.laserMedium_consumeUpTo(amountRequested, false);
    }

    protected int laserMedium_consumeUpTo(int amount, boolean simulate) {
        TileEntity tileEntity;
        int count;
        if (this.laserMedium_direction == null) {
            return 0;
        }
        long totalEnergy = 0L;
        LinkedList<TileEntityLaserMedium> laserMediums = new LinkedList<TileEntityLaserMedium>();
        for (count = 1; count <= this.laserMedium_maxCount && (tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(this.laserMedium_direction, count))) instanceof TileEntityLaserMedium; ++count) {
            laserMediums.add((TileEntityLaserMedium)tileEntity);
            totalEnergy += ((TileEntityLaserMedium)tileEntity).energy_getEnergyStored();
        }
        this.cache_laserMedium_energyStored = totalEnergy;
        if (--count == 0) {
            this.laserMedium_direction = null;
            this.cache_laserMedium_factor = 1.0;
            this.cache_laserMedium_count = 0;
            this.cache_laserMedium_maxStorage = 0L;
            return 0;
        }
        if (simulate) {
            return (int)Math.min((long)amount, totalEnergy);
        }
        int energyAverage = amount / count;
        int energyLeftOver = amount - energyAverage * count;
        if (energyAverage >= WarpDriveConfig.LASER_MEDIUM_MAX_ENERGY_STORED_BY_TIER[EnumTier.SUPERIOR.getIndex()]) {
            energyAverage = WarpDriveConfig.LASER_MEDIUM_MAX_ENERGY_STORED_BY_TIER[EnumTier.SUPERIOR.getIndex()];
            energyLeftOver = 0;
        }
        for (TileEntityLaserMedium laserMedium : laserMediums) {
            long energyStored = laserMedium.energy_getEnergyStored();
            if (energyStored >= (long)energyAverage) continue;
            energyLeftOver = (int)((long)energyLeftOver + ((long)energyAverage - energyStored));
        }
        int energyTotalConsumed = 0;
        for (TileEntityLaserMedium laserMedium : laserMediums) {
            long energyStored = laserMedium.energy_getEnergyStored();
            long energyToConsume = Math.min(energyStored, (long)(energyAverage + energyLeftOver));
            energyLeftOver = (int)((long)energyLeftOver - Math.max(0L, energyToConsume - (long)energyAverage));
            laserMedium.energy_consume(energyToConsume, false);
            energyTotalConsumed = (int)((long)energyTotalConsumed + energyToConsume);
        }
        this.cache_laserMedium_energyStored -= (long)energyTotalConsumed;
        return energyTotalConsumed;
    }

    @Override
    public Object[] getEnergyStatus() {
        String units = this.energy_getDisplayUnits();
        return new Object[]{EnergyWrapper.convert(this.cache_laserMedium_energyStored, units), EnergyWrapper.convert(this.cache_laserMedium_maxStorage, units), units};
    }

    @Override
    public abstract Object[] getEnergyRequired();

    @Override
    public Object[] laserMediumDirection() {
        return new Object[]{this.laserMedium_direction.name(), this.laserMedium_direction.func_82601_c(), this.laserMedium_direction.func_96559_d(), this.laserMedium_direction.func_82599_e()};
    }

    @Override
    public Object[] laserMediumCount() {
        return new Object[]{this.cache_laserMedium_count};
    }

    @Override
    protected WarpDriveText getEnergyStatusText() {
        WarpDriveText text = new WarpDriveText();
        long energy_maxStorage = this.cache_laserMedium_maxStorage;
        if (energy_maxStorage != 0L) {
            EnergyWrapper.formatAndAppendCharge(text, this.cache_laserMedium_energyStored, energy_maxStorage, null);
        }
        return text;
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getEnergyRequired(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getEnergyRequired();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] laserMediumDirection(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.laserMediumDirection();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] laserMediumCount(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.laserMediumCount();
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "getEnergyRequired": {
                return this.getEnergyRequired();
            }
            case "laserMediumDirection": {
                return this.laserMediumDirection();
            }
            case "laserMediumCount": {
                return this.laserMediumCount();
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }
}

