/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IGlobalRegionProvider;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.api.computer.IMachine;
import cr0s.warpdrive.block.TileEntityAbstractInterfaced;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.Optional;

public abstract class TileEntityAbstractMachine
extends TileEntityAbstractInterfaced
implements IMachine {
    private static final WarpDriveText VALIDITY_ISSUES_UNKNOWN = new WarpDriveText(Commons.getStyleWarning(), "unknown", new Object[0]);
    public String name = "";
    protected boolean isEnabled = true;
    private boolean isDirtyAssembly = true;
    private int tickScanAssembly = 0;
    protected boolean isAssemblyValid = true;
    protected WarpDriveText textValidityIssues = VALIDITY_ISSUES_UNKNOWN;
    private boolean isDirtyParameters = true;
    private int tickUpdateParameters = 0;
    protected static final AtomicBoolean isGlobalThreadRunning = new AtomicBoolean(false);
    protected final AtomicBoolean isThreadRunning = new AtomicBoolean(false);
    protected final AtomicBoolean isDirty = new AtomicBoolean(true);
    private static final Predicate<EntityPlayerMP> ALIVE_NOT_SPECTATING_PLAYER = entityPlayerMP -> entityPlayerMP != null && entityPlayerMP.func_70089_S() && !entityPlayerMP.func_175149_v();

    public TileEntityAbstractMachine() {
        this.addMethods(new String[]{"name", "enable", "getAssemblyStatus"});
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.tickScanAssembly = WarpDriveConfig.G_ASSEMBLY_SCAN_INTERVAL_TICKS;
        this.isDirtyAssembly = false;
        this.doScanAssembly(true);
        this.tickUpdateParameters = WarpDriveConfig.G_PARAMETERS_UPDATE_INTERVAL_TICKS;
        this.isDirtyParameters = false;
        this.doUpdateParameters(true);
    }

    @Override
    public void func_73660_a() {
        boolean isDirty;
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isDirtyAssembly) {
            this.tickScanAssembly = Math.min(10, this.tickScanAssembly);
        }
        --this.tickScanAssembly;
        if (this.tickScanAssembly <= 0) {
            this.tickScanAssembly = WarpDriveConfig.G_ASSEMBLY_SCAN_INTERVAL_TICKS;
            isDirty = this.isDirtyAssembly;
            this.isDirtyAssembly = false;
            this.doScanAssembly(isDirty);
        }
        if (this.isDirtyParameters) {
            this.tickUpdateParameters = 0;
        }
        --this.tickUpdateParameters;
        if (this.tickUpdateParameters <= 0) {
            this.tickUpdateParameters = WarpDriveConfig.G_PARAMETERS_UPDATE_INTERVAL_TICKS;
            isDirty = this.isDirtyParameters;
            this.isDirtyParameters = false;
            this.doUpdateParameters(isDirty);
        }
    }

    public boolean isDirtyAssembly() {
        return this.isDirtyAssembly;
    }

    public void markDirtyAssembly() {
        this.isDirtyAssembly = true;
    }

    private void doScanAssembly(boolean isDirty) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        WarpDriveText textReason = new WarpDriveText();
        boolean isValid = this.doScanAssembly(isDirty, textReason);
        if (!isValid && textReason.isEmpty()) {
            textReason.append(Commons.getStyleWarning(), "unknown", new Object[0]);
            WarpDrive.logger.warn(String.format("Unknown assembly status %s %s, please report to mod author", this, Commons.format(this.field_145850_b, this.field_174879_c)));
        }
        this.isAssemblyValid = isValid;
        this.textValidityIssues = textReason;
    }

    protected boolean doScanAssembly(boolean isDirty, WarpDriveText textReason) {
        return true;
    }

    protected void markDirtyParameters() {
        this.isDirtyParameters = true;
    }

    protected void doUpdateParameters(boolean isDirty) {
    }

    @Override
    public WarpDriveText getStatus() {
        WarpDriveText textStatus = super.getStatus();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && !this.textValidityIssues.isEmpty()) {
            textStatus.append((ITextComponent)this.textValidityIssues);
        }
        return textStatus;
    }

    public boolean isCalculated() {
        return !this.isDirty.get() && !this.isThreadRunning.get();
    }

    protected boolean calculation_start() {
        assert (!this.field_145850_b.field_72995_K);
        if (this.isAssemblyValid && !isGlobalThreadRunning.getAndSet(true)) {
            this.isThreadRunning.set(true);
            this.isDirty.set(false);
            return true;
        }
        return false;
    }

    protected final void calculation_done() {
        this.isThreadRunning.set(false);
        isGlobalThreadRunning.set(false);
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.name = tagCompound.func_74779_i("name");
        this.setIsEnabled(!tagCompound.func_74764_b("isEnabled") || tagCompound.func_74767_n("isEnabled"));
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        if (!this.name.equals("")) {
            tagCompound.func_74778_a("name", this.name);
        }
        tagCompound.func_74757_a("isEnabled", this.isEnabled);
        return tagCompound;
    }

    @Override
    public NBTTagCompound writeItemDropNBT(NBTTagCompound tagCompound) {
        tagCompound = super.writeItemDropNBT(tagCompound);
        tagCompound.func_82580_o("isEnabled");
        return tagCompound;
    }

    public String getAllPlayersInArea() {
        AxisAlignedBB axisalignedbb = this instanceof IGlobalRegionProvider ? ((IGlobalRegionProvider)((Object)this)).getGlobalRegionArea() : new AxisAlignedBB(this.field_174879_c).func_186662_g(10.0);
        List entityPlayers = this.field_145850_b.func_175661_b(EntityPlayerMP.class, ALIVE_NOT_SPECTATING_PLAYER::test);
        StringBuilder stringBuilderResult = new StringBuilder();
        boolean isFirst = true;
        for (EntityPlayerMP entityPlayerMP : entityPlayers) {
            if (!entityPlayerMP.func_174813_aQ().func_72326_a(axisalignedbb)) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                stringBuilderResult.append(", ");
            }
            stringBuilderResult.append(entityPlayerMP.func_70005_c_());
        }
        return stringBuilderResult.toString();
    }

    public boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(boolean isEnabled) {
        boolean isEnabledOld = this.isEnabled;
        this.isEnabled = isEnabled;
        if (isEnabledOld != isEnabled) {
            this.func_70296_d();
        }
    }

    @Override
    public String[] name(Object[] arguments) {
        if (arguments != null && arguments.length == 1 && arguments[0] != null) {
            String namePrevious = this.name;
            this.name = Commons.sanitizeFileName((String)arguments[0]);
            if (!this.name.equals(namePrevious)) {
                WarpDrive.logger.info(String.format("Machine renamed from '%s' to '%s' with player(s) %s", namePrevious == null ? "-null-" : namePrevious, this.name, this.getAllPlayersInArea()));
            }
        }
        return new String[]{this.name};
    }

    @Override
    public Object[] enable(Object[] arguments) {
        if (arguments != null && arguments.length == 1 && arguments[0] != null) {
            boolean enableRequest;
            try {
                enableRequest = Commons.toBool(arguments[0]);
            }
            catch (Exception exception) {
                String message = String.format("%s LUA error on enable(): Boolean expected for 1st argument %s", this, arguments[0]);
                if (WarpDriveConfig.LOGGING_LUA) {
                    WarpDrive.logger.error(message);
                }
                return new Object[]{this.isEnabled, message};
            }
            if (this.isEnabled && !enableRequest) {
                this.setIsEnabled(false);
                this.sendEvent("disabled", this.name);
            } else if (!this.isEnabled && enableRequest) {
                this.setIsEnabled(true);
                this.sendEvent("enabled", this.name);
            }
        }
        return new Object[]{this.isEnabled};
    }

    @Override
    public Object[] getAssemblyStatus() {
        if (this.isAssemblyValid && this.textValidityIssues.isEmpty()) {
            return new Object[]{this.isAssemblyValid, "ok"};
        }
        return new Object[]{this.isAssemblyValid, Commons.removeFormatting(this.textValidityIssues.func_150260_c())};
    }

    @Override
    public boolean isAssemblyValid() {
        return this.isAssemblyValid;
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] name(Context context, Arguments arguments) {
        return this.name(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] enable(Context context, Arguments arguments) {
        return this.enable(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getAssemblyStatus(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getAssemblyStatus();
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "name": {
                return this.name(arguments);
            }
            case "enable": {
                return this.enable(arguments);
            }
            case "getAssemblyStatus": {
                return this.getAssemblyStatus();
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }

    @Override
    public String toString() {
        return String.format("%s '%s' %s", this.getClass().getSimpleName(), this.name, Commons.format(this.field_145850_b, this.field_174879_c));
    }
}

