/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.block.TileEntityAbstractBase;
import cr0s.warpdrive.block.TileEntityAbstractChunkLoading;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.EnergyWrapper;
import cr0s.warpdrive.data.EnumComponentType;
import cr0s.warpdrive.item.ItemComponent;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.fml.common.Optional;

public class TileEntityChunkLoader
extends TileEntityAbstractChunkLoading {
    private static final TileEntityAbstractBase.UpgradeSlot upgradeSlotEfficiency = new TileEntityAbstractBase.UpgradeSlot("chunk_loader.efficiency", ItemComponent.getItemStackNoCache(EnumComponentType.SUPERCONDUCTOR, 1), 5);
    private static final TileEntityAbstractBase.UpgradeSlot upgradeSlotRange = new TileEntityAbstractBase.UpgradeSlot("chunk_loader.range", ItemComponent.getItemStackNoCache(EnumComponentType.EMERALD_CRYSTAL, 1), WarpDriveConfig.CHUNK_LOADER_MAX_RADIUS);
    private int radiusXneg = 0;
    private int radiusXpos = 0;
    private int radiusZneg = 0;
    private int radiusZpos = 0;
    private boolean isPowered = false;

    public TileEntityChunkLoader() {
        this.peripheralName = "warpdriveChunkLoader";
        this.addMethods(new String[]{"bounds", "radius"});
        this.doRequireUpgradeToInterface();
        this.registerUpgradeSlot(upgradeSlotEfficiency);
        this.registerUpgradeSlot(upgradeSlotRange);
    }

    @Override
    public boolean energy_canInput(EnumFacing from) {
        return true;
    }

    @Override
    protected void onUpgradeChanged(@Nonnull TileEntityAbstractBase.UpgradeSlot upgradeSlot, int countNew, boolean isAdded) {
        super.onUpgradeChanged(upgradeSlot, countNew, isAdded);
        if (isAdded) {
            int maxRange = this.getMaxRange();
            this.setBounds(maxRange, maxRange, maxRange, maxRange);
        }
    }

    private int getMaxRange() {
        return this.getValidUpgradeCount(upgradeSlotRange);
    }

    private double getEnergyFactor() {
        int upgradeCount = this.getValidUpgradeCount(upgradeSlotEfficiency);
        return 1.0 - 0.1 * (double)upgradeCount;
    }

    public int calculateEnergyRequired() {
        return (int)Math.ceil(this.getEnergyFactor() * (double)this.chunkloading_getArea() * (double)WarpDriveConfig.CHUNK_LOADER_ENERGY_PER_CHUNK);
    }

    @Override
    public boolean shouldChunkLoad() {
        return this.isEnabled && this.isPowered;
    }

    @Override
    protected void onConstructed() {
        super.onConstructed();
        this.energy_setParameters(WarpDriveConfig.CHUNK_LOADER_MAX_ENERGY_STORED, 1024, 0, "MV", 2, "MV", 0);
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.refreshChunkRange();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.isPowered = this.energy_consume(this.calculateEnergyRequired(), !this.isEnabled);
        this.updateBlockState((IBlockState)null, BlockProperties.ACTIVE, this.isEnabled && this.isPowered);
    }

    private void setBounds(int negX, int posX, int negZ, int posZ) {
        int maxRange = this.getMaxRange();
        int radiusXneg_new = -Commons.clamp(0, 1000, Math.abs(negX));
        int radiusXpos_new = Commons.clamp(0, 1000, Math.abs(posX));
        int radiusZneg_new = -Commons.clamp(0, 1000, Math.abs(negZ));
        int radiusZpos_new = Commons.clamp(0, 1000, Math.abs(posZ));
        int areaMax = (1 + 2 * maxRange) * (1 + 2 * maxRange);
        int areaCurrent = (-this.radiusXneg + 1 + this.radiusXpos) * (-this.radiusZneg + 1 + this.radiusZpos);
        int areaNew = (-radiusXneg_new + 1 + radiusXpos_new) * (-radiusZneg_new + 1 + radiusZpos_new);
        if (areaNew <= areaMax) {
            this.radiusXneg = radiusXneg_new;
            this.radiusXpos = radiusXpos_new;
            this.radiusZneg = radiusZneg_new;
            this.radiusZpos = radiusZpos_new;
            this.refreshChunkRange();
        } else if (areaCurrent > areaMax) {
            this.radiusXneg = -maxRange;
            this.radiusXpos = maxRange;
            this.radiusZneg = -maxRange;
            this.radiusZpos = maxRange;
            this.refreshChunkRange();
        }
    }

    private void refreshChunkRange() {
        if (this.field_145850_b == null) {
            return;
        }
        ChunkPos chunkSelf = this.field_145850_b.func_175726_f(this.field_174879_c).func_76632_l();
        this.chunkMin = new ChunkPos(chunkSelf.field_77276_a + this.radiusXneg, chunkSelf.field_77275_b + this.radiusZneg);
        this.chunkMax = new ChunkPos(chunkSelf.field_77276_a + this.radiusXpos, chunkSelf.field_77275_b + this.radiusZpos);
        this.refreshChunkLoading();
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.setBounds(tagCompound.func_74762_e("radiusXneg"), tagCompound.func_74762_e("radiusXpos"), tagCompound.func_74762_e("radiusZneg"), tagCompound.func_74762_e("radiusZpos"));
        this.isPowered = tagCompound.func_74767_n("isPowered");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("radiusXneg", this.radiusXneg);
        tagCompound.func_74768_a("radiusZneg", this.radiusZneg);
        tagCompound.func_74768_a("radiusXpos", this.radiusXpos);
        tagCompound.func_74768_a("radiusZpos", this.radiusZpos);
        tagCompound.func_74757_a("isPowered", this.isPowered);
        return tagCompound;
    }

    public Object[] bounds(Object[] arguments) {
        if (arguments.length == 4) {
            this.setBounds(Commons.toInt(arguments[0]), Commons.toInt(arguments[1]), Commons.toInt(arguments[2]), Commons.toInt(arguments[3]));
        }
        return new Object[]{this.radiusXneg, this.radiusXpos, this.radiusZneg, this.radiusZpos};
    }

    public Object[] radius(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            int radius = Commons.toInt(arguments[0]);
            this.setBounds(radius, radius, radius, radius);
        }
        return new Object[]{this.radiusXneg, this.radiusXpos, this.radiusZneg, this.radiusZpos};
    }

    @Override
    public Object[] getEnergyRequired() {
        String units = this.energy_getDisplayUnits();
        return new Object[]{true, EnergyWrapper.convert(this.calculateEnergyRequired(), units)};
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] bounds(Context context, Arguments arguments) {
        return this.bounds(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] radius(Context context, Arguments arguments) {
        return this.radius(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "bounds": {
                return this.bounds(arguments);
            }
            case "radius": {
                return this.radius(arguments);
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }
}

