/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBeamFrequency;
import cr0s.warpdrive.api.IDamageReceiver;
import cr0s.warpdrive.block.TileEntityAbstractLaser;
import cr0s.warpdrive.block.forcefield.BlockForceField;
import cr0s.warpdrive.block.forcefield.TileEntityForceField;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.EnergyWrapper;
import cr0s.warpdrive.data.ForceFieldSetup;
import cr0s.warpdrive.data.SoundEvents;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.entity.EntityLaserExploder;
import cr0s.warpdrive.network.PacketHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

public class TileEntityLaser
extends TileEntityAbstractLaser
implements IBeamFrequency {
    private float yaw;
    private float pitch;
    protected int beamFrequency = -1;
    private float r;
    private float g;
    private float b;
    private boolean isEmitting = false;
    private int delayTicks = 0;
    private int energyFromOtherBeams = 0;
    private ScanResultType scanResult_type = ScanResultType.IDLE;
    private BlockPos scanResult_position = null;
    private String scanResult_blockUnlocalizedName;
    private int scanResult_blockMetadata = 0;
    private float scanResult_blockResistance = -2.0f;

    public TileEntityLaser() {
        this.peripheralName = "warpdriveLaser";
        this.addMethods(new String[]{"emitBeam", "beamFrequency", "getScanResult"});
        this.doRequireUpgradeToInterface();
        this.laserMedium_maxCount = WarpDriveConfig.LASER_CANNON_MAX_MEDIUMS_COUNT;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!IBeamFrequency.isValid(this.beamFrequency)) {
            return;
        }
        ++this.delayTicks;
        if (this.isEmitting && (this.beamFrequency != 1420 && this.delayTicks > WarpDriveConfig.LASER_CANNON_EMIT_FIRE_DELAY_TICKS || this.beamFrequency == 1420 && this.delayTicks > WarpDriveConfig.LASER_CANNON_EMIT_SCAN_DELAY_TICKS)) {
            this.delayTicks = 0;
            this.isEmitting = false;
            int beamEnergy = Math.min(this.laserMedium_consumeUpTo(Integer.MAX_VALUE, false) + MathHelper.func_76128_c((double)((double)this.energyFromOtherBeams * WarpDriveConfig.LASER_CANNON_BOOSTER_BEAM_ENERGY_EFFICIENCY)), WarpDriveConfig.LASER_CANNON_MAX_LASER_ENERGY);
            this.emitBeam(beamEnergy);
            this.energyFromOtherBeams = 0;
            this.sendEvent("laserSend", this.beamFrequency, beamEnergy);
        }
    }

    public void initiateBeamEmission(float parYaw, float parPitch) {
        this.yaw = parYaw;
        this.pitch = parPitch;
        this.delayTicks = 0;
        this.isEmitting = true;
    }

    private void addBeamEnergy(int amount) {
        if (this.isEmitting) {
            this.energyFromOtherBeams += amount;
            if (WarpDriveConfig.LOGGING_WEAPON) {
                WarpDrive.logger.info(String.format("%s Added boosting energy %d for a total accumulation of %d", this, amount, this.energyFromOtherBeams));
            }
        } else if (WarpDriveConfig.LOGGING_WEAPON) {
            WarpDrive.logger.warn(String.format("%s Ignored boosting energy %d", this, amount));
        }
    }

    public static RayTraceResult rayTraceBlocks(World world, Vec3d vSource, Vec3d vTarget, int beamFrequency, boolean stopOnLiquid, boolean checkBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        RayTraceResult rayTraceResult;
        if (Double.isNaN(vSource.field_72450_a) || Double.isNaN(vSource.field_72448_b) || Double.isNaN(vSource.field_72449_c)) {
            return null;
        }
        if (Double.isNaN(vTarget.field_72450_a) || Double.isNaN(vTarget.field_72448_b) || Double.isNaN(vTarget.field_72449_c)) {
            return null;
        }
        int xSource = MathHelper.func_76128_c((double)vSource.field_72450_a);
        int ySource = MathHelper.func_76128_c((double)vSource.field_72448_b);
        int zSource = MathHelper.func_76128_c((double)vSource.field_72449_c);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(xSource, ySource, zSource);
        IBlockState blockStateSource = world.func_180495_p((BlockPos)mutableBlockPos);
        if ((checkBlockWithoutBoundingBox || blockStateSource.func_185890_d((IBlockAccess)world, (BlockPos)mutableBlockPos) != Block.field_185506_k) && blockStateSource.func_177230_c().func_176209_a(blockStateSource, stopOnLiquid) && (rayTraceResult = blockStateSource.func_185910_a(world, (BlockPos)mutableBlockPos, vSource, vTarget)) != null) {
            return rayTraceResult;
        }
        int xTarget = MathHelper.func_76128_c((double)vTarget.field_72450_a);
        int yTarget = MathHelper.func_76128_c((double)vTarget.field_72448_b);
        int zTarget = MathHelper.func_76128_c((double)vTarget.field_72449_c);
        Vector3 v3Current = new Vector3(vSource.field_72450_a, vSource.field_72448_b, vSource.field_72449_c);
        int xCurrent = xSource;
        int yCurrent = ySource;
        int zCurrent = zSource;
        RayTraceResult rayTraceResultMissed = null;
        int countLoop = WarpDriveConfig.LASER_CANNON_RANGE_MAX * 2;
        while (countLoop-- >= 0) {
            TileEntity tileEntity;
            EnumFacing enumFacing;
            if (Double.isNaN(v3Current.x) || Double.isNaN(v3Current.y) || Double.isNaN(v3Current.z)) {
                WarpDrive.logger.error(String.format("Critical error while ray tracing blocks from %s to %s in %s", vSource, vTarget, Commons.format(world)));
                return null;
            }
            if (xCurrent == xTarget && yCurrent == yTarget && zCurrent == zTarget) {
                return returnLastUncollidableBlock ? rayTraceResultMissed : null;
            }
            boolean hasOffsetX = true;
            boolean hasOffsetY = true;
            boolean hasOffsetZ = true;
            double xProposed = 999.0;
            double yProposed = 999.0;
            double zProposed = 999.0;
            if (xTarget > xCurrent) {
                xProposed = (double)xCurrent + 1.0;
            } else if (xTarget < xCurrent) {
                xProposed = (double)xCurrent + 0.0;
            } else {
                hasOffsetX = false;
            }
            if (yTarget > yCurrent) {
                yProposed = (double)yCurrent + 1.0;
            } else if (yTarget < yCurrent) {
                yProposed = (double)yCurrent + 0.0;
            } else {
                hasOffsetY = false;
            }
            if (zTarget > zCurrent) {
                zProposed = (double)zCurrent + 1.0;
            } else if (zTarget < zCurrent) {
                zProposed = (double)zCurrent + 0.0;
            } else {
                hasOffsetZ = false;
            }
            double xDeltaNormalized = 999.0;
            double yDeltaNormalized = 999.0;
            double zDeltaNormalized = 999.0;
            double xDeltaToTarget = vTarget.field_72450_a - v3Current.x;
            double yDeltaToTarget = vTarget.field_72448_b - v3Current.y;
            double zDeltaToTarget = vTarget.field_72449_c - v3Current.z;
            if (hasOffsetX && (xDeltaNormalized = (xProposed - v3Current.x) / xDeltaToTarget) == -0.0) {
                xDeltaNormalized = -1.0E-4;
            }
            if (hasOffsetY && (yDeltaNormalized = (yProposed - v3Current.y) / yDeltaToTarget) == -0.0) {
                yDeltaNormalized = -1.0E-4;
            }
            if (hasOffsetZ && (zDeltaNormalized = (zProposed - v3Current.z) / zDeltaToTarget) == -0.0) {
                zDeltaNormalized = -1.0E-4;
            }
            if (xDeltaNormalized < yDeltaNormalized && xDeltaNormalized < zDeltaNormalized) {
                enumFacing = xTarget > xSource ? EnumFacing.WEST : EnumFacing.EAST;
                v3Current.x = xProposed;
                v3Current.y += yDeltaToTarget * xDeltaNormalized;
                v3Current.z += zDeltaToTarget * xDeltaNormalized;
            } else if (yDeltaNormalized < zDeltaNormalized) {
                enumFacing = yTarget > ySource ? EnumFacing.DOWN : EnumFacing.UP;
                v3Current.x += xDeltaToTarget * yDeltaNormalized;
                v3Current.y = yProposed;
                v3Current.z += zDeltaToTarget * yDeltaNormalized;
            } else {
                enumFacing = zTarget > zSource ? EnumFacing.NORTH : EnumFacing.SOUTH;
                v3Current.x += xDeltaToTarget * zDeltaNormalized;
                v3Current.y += yDeltaToTarget * zDeltaNormalized;
                v3Current.z = zProposed;
            }
            xCurrent = MathHelper.func_76128_c((double)v3Current.x) - (enumFacing == EnumFacing.EAST ? 1 : 0);
            yCurrent = MathHelper.func_76128_c((double)v3Current.y) - (enumFacing == EnumFacing.UP ? 1 : 0);
            zCurrent = MathHelper.func_76128_c((double)v3Current.z) - (enumFacing == EnumFacing.SOUTH ? 1 : 0);
            IBlockState blockStateCurrent = world.func_180495_p((BlockPos)mutableBlockPos.func_181079_c(xCurrent, yCurrent, zCurrent));
            if (blockStateCurrent.func_177230_c() instanceof BlockForceField && (tileEntity = world.func_175625_s((BlockPos)mutableBlockPos)) instanceof TileEntityForceField) {
                ForceFieldSetup forceFieldSetup = ((TileEntityForceField)tileEntity).getForceFieldSetup();
                if (forceFieldSetup == null) {
                    WarpDrive.logger.warn(String.format("Laser beam stopped by non-loaded force field projector at %s", tileEntity));
                } else if (forceFieldSetup.beamFrequency == beamFrequency) {
                    if (!WarpDriveConfig.LOGGING_WEAPON) continue;
                    WarpDrive.logger.info(String.format("Laser beam passing through force field %s", tileEntity));
                    continue;
                }
            }
            if (!checkBlockWithoutBoundingBox && blockStateCurrent.func_185904_a() != Material.field_151567_E && blockStateCurrent.func_185890_d((IBlockAccess)world, (BlockPos)mutableBlockPos) == null) continue;
            if (blockStateCurrent.func_177230_c().func_176209_a(blockStateCurrent, stopOnLiquid)) {
                RayTraceResult rayTraceResult2 = blockStateCurrent.func_185910_a(world, (BlockPos)mutableBlockPos, v3Current.toVec3d(), vTarget);
                if (rayTraceResult2 == null) continue;
                return rayTraceResult2;
            }
            rayTraceResultMissed = new RayTraceResult(RayTraceResult.Type.MISS, v3Current.toVec3d(), enumFacing, (BlockPos)mutableBlockPos);
        }
        return returnLastUncollidableBlock ? rayTraceResultMissed : null;
    }

    private void emitBeam(int beamEnergy) {
        int energy = beamEnergy;
        int beamLengthBlocks = Commons.clamp(0, WarpDriveConfig.LASER_CANNON_RANGE_MAX, energy / 200);
        if (energy == 0 || this.beamFrequency > 65000 || this.beamFrequency <= 0) {
            if (WarpDriveConfig.LOGGING_WEAPON) {
                WarpDrive.logger.info(this + " Beam canceled (energy " + energy + " over " + beamLengthBlocks + " blocks, beamFrequency " + this.beamFrequency + ")");
            }
            return;
        }
        float yawZ = MathHelper.func_76134_b((float)(-this.yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float yawX = MathHelper.func_76126_a((float)(-this.yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float pitchHorizontal = -MathHelper.func_76134_b((float)(-this.pitch * ((float)Math.PI / 180)));
        float pitchVertical = MathHelper.func_76126_a((float)(-this.pitch * ((float)Math.PI / 180)));
        float directionX = yawX * pitchHorizontal;
        float directionZ = yawZ * pitchHorizontal;
        Vector3 vDirection = new Vector3(directionX, pitchVertical, directionZ);
        Vector3 vSource = new Vector3(this).translate(0.5).translate(vDirection);
        Vector3 vReachPoint = vSource.clone().translateFactor(vDirection, beamLengthBlocks);
        if (WarpDriveConfig.LOGGING_WEAPON) {
            WarpDrive.logger.info(this + " Energy " + energy + " over " + beamLengthBlocks + " blocks, Orientation " + this.yaw + " " + this.pitch + ", Direction " + vDirection + ", From " + vSource + " to " + vReachPoint);
        }
        this.playSoundCorrespondsEnergy(energy);
        EntityLaserExploder entityExploder = new EntityLaserExploder(this.field_145850_b, this.field_174879_c);
        if (this.beamFrequency == 1420) {
            RayTraceResult mopResult = TileEntityLaser.rayTraceBlocks(this.field_145850_b, vSource.toVec3d(), vReachPoint.toVec3d(), this.beamFrequency, false, true, false);
            this.scanResult_blockUnlocalizedName = null;
            this.scanResult_blockMetadata = 0;
            this.scanResult_blockResistance = -2.0f;
            if (mopResult != null) {
                this.scanResult_type = ScanResultType.BLOCK;
                this.scanResult_position = mopResult.func_178782_a();
                IBlockState blockState = this.field_145850_b.func_180495_p(this.scanResult_position);
                this.scanResult_blockUnlocalizedName = blockState.func_177230_c().func_149739_a();
                this.scanResult_blockMetadata = blockState.func_177230_c().func_176201_c(blockState);
                Explosion explosion = new Explosion(this.field_145850_b, (Entity)entityExploder, (double)this.scanResult_position.func_177958_n(), (double)this.scanResult_position.func_177956_o(), (double)this.scanResult_position.func_177952_p(), 1.0f, true, true);
                this.scanResult_blockResistance = blockState.func_177230_c().getExplosionResistance(this.field_145850_b, this.scanResult_position, (Entity)entityExploder, explosion);
                PacketHandler.sendBeamPacket(this.field_145850_b, vSource, new Vector3(mopResult.field_72307_f), this.r, this.g, this.b, 50, energy, 200);
            } else {
                this.scanResult_type = ScanResultType.NONE;
                this.scanResult_position = vReachPoint.getBlockPos();
                PacketHandler.sendBeamPacket(this.field_145850_b, vSource, vReachPoint, this.r, this.g, this.b, 50, energy, 200);
            }
            if (WarpDriveConfig.LOGGING_WEAPON) {
                WarpDrive.logger.info(String.format("Scan result type %s %s block %s@%d resistance %.1f", this.scanResult_type.name, Commons.format(this.field_145850_b, this.scanResult_position), this.scanResult_blockUnlocalizedName, this.scanResult_blockMetadata, Float.valueOf(this.scanResult_blockResistance)));
            }
            this.sendEvent("laserScanning", this.scanResult_type.name, this.scanResult_position.func_177958_n(), this.scanResult_position.func_177956_o(), this.scanResult_position.func_177952_p(), this.scanResult_blockUnlocalizedName, this.scanResult_blockMetadata, Float.valueOf(this.scanResult_blockResistance));
            return;
        }
        TreeMap<Double, RayTraceResult> entityHits = this.raytraceEntities(vSource.clone(), vDirection.clone(), beamLengthBlocks);
        if (WarpDriveConfig.LOGGING_WEAPON) {
            WarpDrive.logger.info(String.format("Entity hits are (%d) %s", entityHits == null ? 0 : entityHits.size(), entityHits));
        }
        Vector3 vHitPoint = vReachPoint.clone();
        double distanceTravelled = 0.0;
        for (int passedBlocks = 0; passedBlocks < beamLengthBlocks; ++passedBlocks) {
            TileEntityLaser tileEntityLaser;
            float hardness;
            IBlockState blockState;
            double blockHitDistance;
            RayTraceResult blockHit;
            block39: {
                blockHit = TileEntityLaser.rayTraceBlocks(this.field_145850_b, vSource.toVec3d(), vReachPoint.toVec3d(), this.beamFrequency, false, true, false);
                blockHitDistance = (double)beamLengthBlocks + 0.1;
                if (blockHit != null) {
                    blockHitDistance = blockHit.field_72307_f.func_72438_d(vSource.toVec3d());
                }
                if (entityHits != null) {
                    Map.Entry<Double, RayTraceResult> entityHitEntry;
                    double entityHitDistance;
                    Iterator<Map.Entry<Double, RayTraceResult>> iterator = entityHits.entrySet().iterator();
                    while (iterator.hasNext() && !((entityHitDistance = (entityHitEntry = iterator.next()).getKey().doubleValue()) >= blockHitDistance)) {
                        RayTraceResult mopEntity = entityHitEntry.getValue();
                        if (mopEntity == null) continue;
                        EntityLivingBase entity = null;
                        if (mopEntity.field_72308_g instanceof EntityLivingBase) {
                            entity = (EntityLivingBase)mopEntity.field_72308_g;
                            if (WarpDriveConfig.LOGGING_WEAPON) {
                                WarpDrive.logger.info(String.format("Entity is a valid target (living) %s", entity));
                            }
                        } else {
                            if (!Dictionary.isNonLivingTarget(mopEntity.field_72308_g)) {
                                if (WarpDriveConfig.LOGGING_WEAPON) {
                                    WarpDrive.logger.info(String.format("Entity is an invalid target (non-living %s) %s", Dictionary.getId(mopEntity.field_72308_g), mopEntity.field_72308_g));
                                }
                                entityHits.put(entityHitDistance, null);
                                continue;
                            }
                            if (WarpDriveConfig.LOGGING_WEAPON) {
                                WarpDrive.logger.info(String.format("Entity is a valid target (non-living %s) %s", Dictionary.getId(mopEntity.field_72308_g), mopEntity.field_72308_g));
                            }
                        }
                        energy = (int)((double)energy * this.getTransmittance(entityHitDistance - distanceTravelled));
                        distanceTravelled = entityHitDistance;
                        vHitPoint = new Vector3(mopEntity.field_72307_f);
                        if ((energy -= WarpDriveConfig.LASER_CANNON_ENTITY_HIT_ENERGY) <= 0) break;
                        mopEntity.field_72308_g.func_70015_d(WarpDriveConfig.LASER_CANNON_ENTITY_HIT_SET_ON_FIRE_SECONDS);
                        if (entity != null) {
                            float damage = (float)Commons.clamp(0.0, (double)WarpDriveConfig.LASER_CANNON_ENTITY_HIT_MAX_DAMAGE, (double)WarpDriveConfig.LASER_CANNON_ENTITY_HIT_BASE_DAMAGE + (double)energy / (double)WarpDriveConfig.LASER_CANNON_ENTITY_HIT_ENERGY_PER_DAMAGE);
                            entity.func_70097_a(DamageSource.field_76372_a, damage);
                        } else {
                            mopEntity.field_72308_g.func_70106_y();
                        }
                        if (energy > WarpDriveConfig.LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_THRESHOLD) {
                            float strength = (float)Commons.clamp(0.0, (double)WarpDriveConfig.LASER_CANNON_ENTITY_HIT_EXPLOSION_MAX_STRENGTH, (double)WarpDriveConfig.LASER_CANNON_ENTITY_HIT_EXPLOSION_BASE_STRENGTH + (double)energy / (double)WarpDriveConfig.LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_PER_STRENGTH);
                            this.field_145850_b.func_72885_a((Entity)entityExploder, mopEntity.field_72308_g.field_70165_t, mopEntity.field_72308_g.field_70163_u, mopEntity.field_72308_g.field_70161_v, strength, true, true);
                        }
                        entityHits.put(entityHitDistance, null);
                    }
                    if (energy <= 0) break;
                }
                if (blockHitDistance >= (double)beamLengthBlocks || blockHit == null) {
                    if (WarpDriveConfig.LOGGING_WEAPON) {
                        WarpDrive.logger.info(String.format("No more blocks to hit or too far: blockHitDistance is %.1f, blockHit is %s", blockHitDistance, blockHit));
                    }
                    vHitPoint = vReachPoint;
                    break;
                }
                blockState = this.field_145850_b.func_180495_p(blockHit.func_178782_a());
                hardness = -2.0f;
                try {
                    hardness = blockState.func_185887_b(this.field_145850_b, blockHit.func_178782_a());
                }
                catch (Exception exception) {
                    if (!Commons.throttleMe("TileEntityLaser.getBlockHardness")) break block39;
                    exception.printStackTrace(WarpDrive.printStreamError);
                    WarpDrive.logger.error(String.format("Unable to access block hardness value of %s", blockState.func_177230_c()));
                }
            }
            if (blockState.func_177230_c() instanceof IDamageReceiver) {
                hardness = ((IDamageReceiver)blockState.func_177230_c()).getBlockHardness(blockState, this.field_145850_b, blockHit.func_178782_a(), WarpDrive.damageLaser, this.beamFrequency, vDirection, energy);
            }
            if (WarpDriveConfig.LOGGING_WEAPON) {
                WarpDrive.logger.info(String.format("Block collision found %s with block %s of hardness %.2f", Commons.format(this.field_145850_b, blockHit.func_178782_a()), blockState.func_177230_c().getRegistryName(), Float.valueOf(hardness)));
            }
            if (this.isBlockBreakCanceled(null, this.field_145850_b, blockHit.func_178782_a())) {
                if (WarpDriveConfig.LOGGING_WEAPON) {
                    WarpDrive.logger.info(String.format("Laser weapon cancelled %s", Commons.format(this.field_145850_b, blockHit.func_178782_a())));
                }
                vHitPoint = new Vector3(blockHit.field_72307_f);
                break;
            }
            if ((blockState.func_177230_c().func_149667_c(WarpDrive.blockLaser) || blockState.func_177230_c().func_149667_c(WarpDrive.blockLaserCamera)) && (tileEntityLaser = (TileEntityLaser)this.field_145850_b.func_175625_s(blockHit.func_178782_a())) != null && tileEntityLaser.getBeamFrequency() == this.beamFrequency) {
                tileEntityLaser.addBeamEnergy(energy);
                vHitPoint = new Vector3(blockHit.field_72307_f);
                break;
            }
            if (hardness < 0.0f) {
                float strength = (float)Commons.clamp(0.0, (double)WarpDriveConfig.LASER_CANNON_BLOCK_HIT_EXPLOSION_MAX_STRENGTH, (double)WarpDriveConfig.LASER_CANNON_BLOCK_HIT_EXPLOSION_BASE_STRENGTH + (double)energy / (double)WarpDriveConfig.LASER_CANNON_BLOCK_HIT_EXPLOSION_ENERGY_PER_STRENGTH);
                if (WarpDriveConfig.LOGGING_WEAPON) {
                    WarpDrive.logger.info(String.format("Explosion triggered with strength %.1f", Float.valueOf(strength)));
                }
                this.field_145850_b.func_72885_a((Entity)entityExploder, blockHit.field_72307_f.field_72450_a, blockHit.field_72307_f.field_72448_b, blockHit.field_72307_f.field_72449_c, strength, true, true);
                vHitPoint = new Vector3(blockHit.field_72307_f);
                break;
            }
            int energyCost = Commons.clamp(WarpDriveConfig.LASER_CANNON_BLOCK_HIT_ENERGY_MIN, WarpDriveConfig.LASER_CANNON_BLOCK_HIT_ENERGY_MAX, Math.round(hardness * (float)WarpDriveConfig.LASER_CANNON_BLOCK_HIT_ENERGY_PER_BLOCK_HARDNESS));
            double absorptionChance = Commons.clamp(0.0, WarpDriveConfig.LASER_CANNON_BLOCK_HIT_ABSORPTION_MAX, (double)hardness * WarpDriveConfig.LASER_CANNON_BLOCK_HIT_ABSORPTION_PER_BLOCK_HARDNESS);
            if (WarpDriveConfig.LOGGING_WEAPON) {
                WarpDrive.logger.info(String.format("Block energy cost is %d with %.1f %% of absorption", energyCost, absorptionChance * 100.0));
            }
            energy = (int)((double)energy * this.getTransmittance(blockHitDistance - distanceTravelled));
            do {
                distanceTravelled = blockHitDistance;
                vHitPoint = new Vector3(blockHit.field_72307_f);
                if ((energy -= energyCost) <= 0) {
                    if (!WarpDriveConfig.LOGGING_WEAPON) break;
                    WarpDrive.logger.info("Beam died out of energy");
                    break;
                }
                if (!WarpDriveConfig.LOGGING_WEAPON) continue;
                WarpDrive.logger.info(String.format("Beam energy down to %d", energy));
            } while (!(this.field_145850_b.field_73012_v.nextDouble() > absorptionChance));
            if (energy <= 0) break;
            Vector3 origin = new Vector3((double)blockHit.func_178782_a().func_177958_n() - 0.3 * vDirection.x + (double)this.field_145850_b.field_73012_v.nextFloat() - (double)this.field_145850_b.field_73012_v.nextFloat(), (double)blockHit.func_178782_a().func_177956_o() - 0.3 * vDirection.y + (double)this.field_145850_b.field_73012_v.nextFloat() - (double)this.field_145850_b.field_73012_v.nextFloat(), (double)blockHit.func_178782_a().func_177952_p() - 0.3 * vDirection.z + (double)this.field_145850_b.field_73012_v.nextFloat() - (double)this.field_145850_b.field_73012_v.nextFloat());
            Vector3 direction = new Vector3(-0.2 * vDirection.x + 0.05 * (double)(this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()), -0.2 * vDirection.y + 0.05 * (double)(this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()), -0.2 * vDirection.z + 0.05 * (double)(this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()));
            PacketHandler.sendSpawnParticlePacket(this.field_145850_b, "explosionNormal", (byte)5, origin, direction, this.r, this.g, this.b, this.r, this.g, this.b, 96);
            if (blockState.func_177230_c() instanceof IDamageReceiver) {
                energy = ((IDamageReceiver)blockState.func_177230_c()).applyDamage(blockState, this.field_145850_b, blockHit.func_178782_a(), WarpDrive.damageLaser, this.beamFrequency, vDirection, energy);
                if (WarpDriveConfig.LOGGING_WEAPON) {
                    WarpDrive.logger.info(String.format("IDamageReceiver damage applied, remaining energy is %d", energy));
                }
                if (energy <= 0) break;
            }
            if (hardness >= WarpDriveConfig.LASER_CANNON_BLOCK_HIT_EXPLOSION_HARDNESS_THRESHOLD) {
                float strength = (float)Commons.clamp(0.0, (double)WarpDriveConfig.LASER_CANNON_BLOCK_HIT_EXPLOSION_MAX_STRENGTH, (double)WarpDriveConfig.LASER_CANNON_BLOCK_HIT_EXPLOSION_BASE_STRENGTH + (double)energy / (double)WarpDriveConfig.LASER_CANNON_BLOCK_HIT_EXPLOSION_ENERGY_PER_STRENGTH);
                if (WarpDriveConfig.LOGGING_WEAPON) {
                    WarpDrive.logger.info(String.format("Explosion triggered with strength %.1f", Float.valueOf(strength)));
                }
                this.field_145850_b.func_72885_a((Entity)entityExploder, blockHit.field_72307_f.field_72450_a, blockHit.field_72307_f.field_72448_b, blockHit.field_72307_f.field_72449_c, strength, true, true);
                this.field_145850_b.func_175656_a(blockHit.func_178782_a(), this.field_145850_b.field_73012_v.nextBoolean() ? Blocks.field_150480_ab.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                continue;
            }
            this.field_145850_b.func_175698_g(blockHit.func_178782_a());
        }
        PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(this).translate(0.5).translate(vDirection.scale(0.5)), vHitPoint, this.r, this.g, this.b, 50, energy, beamLengthBlocks);
    }

    private double getTransmittance(double distance) {
        if (distance <= 0.0) {
            return 1.0;
        }
        double attenuation = CelestialObjectManager.hasAtmosphere(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p()) ? WarpDriveConfig.LASER_CANNON_ENERGY_ATTENUATION_PER_AIR_BLOCK : WarpDriveConfig.LASER_CANNON_ENERGY_ATTENUATION_PER_VOID_BLOCK;
        double transmittance = Math.exp(-attenuation * distance);
        if (WarpDriveConfig.LOGGING_WEAPON) {
            WarpDrive.logger.info(String.format("Transmittance over %.1f blocks is %.3f", distance, transmittance));
        }
        return transmittance;
    }

    private TreeMap<Double, RayTraceResult> raytraceEntities(Vector3 vSource, Vector3 vDirection, double reachDistance) {
        double raytraceTolerance = 2.0;
        Vec3d vec3Source = vSource.toVec3d();
        Vec3d vec3Target = new Vec3d(vec3Source.field_72450_a + vDirection.x * reachDistance, vec3Source.field_72448_b + vDirection.y * reachDistance, vec3Source.field_72449_c + vDirection.z * reachDistance);
        AxisAlignedBB boxToScan = new AxisAlignedBB(Math.min((double)this.field_174879_c.func_177958_n() - 2.0, vec3Target.field_72450_a - 2.0), Math.min((double)this.field_174879_c.func_177956_o() - 2.0, vec3Target.field_72448_b - 2.0), Math.min((double)this.field_174879_c.func_177952_p() - 2.0, vec3Target.field_72449_c - 2.0), Math.max((double)this.field_174879_c.func_177958_n() + 2.0, vec3Target.field_72450_a + 2.0), Math.max((double)this.field_174879_c.func_177956_o() + 2.0, vec3Target.field_72448_b + 2.0), Math.max((double)this.field_174879_c.func_177952_p() + 2.0, vec3Target.field_72449_c + 2.0));
        List entities = this.field_145850_b.func_72839_b(null, boxToScan);
        if (entities.isEmpty()) {
            if (WarpDriveConfig.LOGGING_WEAPON) {
                WarpDrive.logger.info("No entity on trajectory (box)");
            }
            return null;
        }
        HashMap<Double, RayTraceResult> entityHits = new HashMap<Double, RayTraceResult>(entities.size());
        for (Entity entity : entities) {
            if (entity == null || !entity.func_70067_L()) continue;
            double border = entity.func_70111_Y();
            AxisAlignedBB aabbEntity = entity.func_174813_aQ().func_72321_a(border, border, border);
            RayTraceResult hitMOP = aabbEntity.func_72327_a(vec3Source, vec3Target);
            if (WarpDriveConfig.LOGGING_WEAPON) {
                WarpDrive.logger.info(String.format("Checking %s boundingBox %s border %s aabbEntity %s hitMOP %s", entity, aabbEntity, border, aabbEntity, hitMOP));
            }
            if (hitMOP == null) continue;
            RayTraceResult mopEntity = new RayTraceResult(entity);
            mopEntity.field_72307_f = hitMOP.field_72307_f;
            double distance = vec3Source.func_72438_d(hitMOP.field_72307_f);
            if (entityHits.containsKey(distance)) {
                distance += this.field_145850_b.field_73012_v.nextDouble() / 10.0;
            }
            entityHits.put(distance, mopEntity);
        }
        if (entityHits.isEmpty()) {
            return null;
        }
        return new TreeMap<Double, RayTraceResult>(entityHits);
    }

    @Override
    public int getBeamFrequency() {
        return this.beamFrequency;
    }

    @Override
    public void setBeamFrequency(int parBeamFrequency) {
        if (this.beamFrequency != parBeamFrequency && IBeamFrequency.isValid(parBeamFrequency)) {
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info(this + " Beam frequency set from " + this.beamFrequency + " to " + parBeamFrequency);
            }
            this.beamFrequency = parBeamFrequency;
        }
        Vector3 vRGB = IBeamFrequency.getBeamColor(this.beamFrequency);
        this.r = (float)vRGB.x;
        this.g = (float)vRGB.y;
        this.b = (float)vRGB.z;
    }

    private void playSoundCorrespondsEnergy(int energy) {
        if (energy <= 500000) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.LASER_LOW, SoundCategory.HOSTILE, 4.0f, 1.0f);
        } else if (energy <= 1000000) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.LASER_MEDIUM, SoundCategory.HOSTILE, 4.0f, 1.0f);
        } else {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.LASER_HIGH, SoundCategory.HOSTILE, 4.0f, 1.0f);
        }
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.setBeamFrequency(tagCompound.func_74762_e("beamFrequency"));
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        if (IBeamFrequency.isValid(this.beamFrequency)) {
            tagCompound.func_74768_a("beamFrequency", this.beamFrequency);
        }
        return tagCompound;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tagCompound = super.func_189517_E_();
        tagCompound.func_82580_o("beamFrequency");
        return tagCompound;
    }

    @Override
    public Object[] getEnergyRequired() {
        String units = this.energy_getDisplayUnits();
        return new Object[]{true, EnergyWrapper.convert(WarpDriveConfig.LASER_CANNON_MAX_LASER_ENERGY, units)};
    }

    public Object[] beamFrequency(Object[] arguments) {
        if (arguments.length == 1) {
            this.setBeamFrequency(Commons.toInt(arguments[0]));
        }
        return new Integer[]{this.getBeamFrequency()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] emitBeam(Context context, Arguments arguments) {
        return this.emitBeam(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] beamFrequency(Context context, Arguments arguments) {
        return this.beamFrequency(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getScanResult(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getScanResult();
    }

    private Object[] emitBeam(Object[] arguments) {
        try {
            if (arguments.length == 2) {
                float newYaw = Commons.toFloat(arguments[0]);
                float newPitch = Commons.toFloat(arguments[1]);
                this.initiateBeamEmission(newYaw, newPitch);
            } else if (arguments.length == 3) {
                float deltaX = -Commons.toFloat(arguments[0]);
                float deltaY = -Commons.toFloat(arguments[1]);
                float deltaZ = Commons.toFloat(arguments[2]);
                double horizontalDistance = MathHelper.func_76129_c((float)(deltaX * deltaX + deltaZ * deltaZ));
                float newYaw = (float)(Math.atan2(deltaX, deltaZ) * 180.0 / Math.PI);
                float newPitch = (float)(Math.atan2(deltaY, horizontalDistance) * 180.0 / Math.PI);
                this.initiateBeamEmission(newYaw, newPitch);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
            return new Object[]{false};
        }
        return new Object[]{true};
    }

    private Object[] getScanResult() {
        if (this.scanResult_type != ScanResultType.IDLE) {
            try {
                Object[] info = new Object[]{this.scanResult_type.name, this.scanResult_position.func_177958_n(), this.scanResult_position.func_177956_o(), this.scanResult_position.func_177952_p(), this.scanResult_blockUnlocalizedName, this.scanResult_blockMetadata, Float.valueOf(this.scanResult_blockResistance)};
                this.scanResult_type = ScanResultType.IDLE;
                this.scanResult_position = null;
                this.scanResult_blockUnlocalizedName = null;
                this.scanResult_blockMetadata = 0;
                this.scanResult_blockResistance = -2.0f;
                return info;
            }
            catch (Exception exception) {
                exception.printStackTrace(WarpDrive.printStreamError);
                return new Object[]{"!ERROR!", 0, 0, 0, null, 0, -3};
            }
        }
        return new Object[]{this.scanResult_type.name, 0, 0, 0, null, 0, -1};
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "beamFrequency": {
                return this.beamFrequency(arguments);
            }
            case "emitBeam": {
                return this.emitBeam(arguments);
            }
            case "getScanResult": {
                return this.getScanResult();
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }

    @Override
    public String toString() {
        return String.format("%s Beam %d %s", this.getClass().getSimpleName(), this.beamFrequency, Commons.format(this.field_145850_b, this.field_174879_c));
    }

    private static enum ScanResultType {
        IDLE("IDLE"),
        BLOCK("BLOCK"),
        NONE("NONE");

        public final String name;

        private ScanResultType(String name) {
            this.name = name;
        }
    }
}

