/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.api.computer.ISecurityStation;
import cr0s.warpdrive.block.TileEntityAbstractMachine;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fml.common.Optional;

public class TileEntitySecurityStation
extends TileEntityAbstractMachine
implements ISecurityStation {
    public final ArrayList<String> players = new ArrayList();

    public TileEntitySecurityStation() {
        this.peripheralName = "warpdriveSecurityStation";
        this.addMethods(new String[]{"getAttachedPlayers"});
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.players.clear();
        NBTTagList tagListPlayers = tagCompound.func_150295_c("players", 8);
        for (int index = 0; index < tagListPlayers.func_74745_c(); ++index) {
            String namePlayer = tagListPlayers.func_150307_f(index);
            this.players.add(namePlayer);
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        NBTTagList tagListPlayers = new NBTTagList();
        for (String namePlayer : this.players) {
            NBTTagString tagStringPlayer = new NBTTagString(namePlayer);
            tagListPlayers.func_74742_a((NBTBase)tagStringPlayer);
        }
        tagCompound.func_74782_a("players", (NBTBase)tagListPlayers);
        return tagCompound;
    }

    @Override
    public NBTTagCompound writeItemDropNBT(NBTTagCompound tagCompound) {
        tagCompound = super.writeItemDropNBT(tagCompound);
        tagCompound.func_82580_o("players");
        return tagCompound;
    }

    @Override
    public WarpDriveText getStatus() {
        return super.getStatus().append(null, "warpdrive.security_station.guide.registered_players", this.getAttachedPlayersList());
    }

    public WarpDriveText attachPlayer(EntityPlayer entityPlayer) {
        for (int i = 0; i < this.players.size(); ++i) {
            String name = this.players.get(i);
            if (!entityPlayer.func_70005_c_().equals(name)) continue;
            this.players.remove(i);
            WarpDriveText text = Commons.getChatPrefix(this.func_145838_q());
            text.appendSibling(new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.security_station.guide.player_unregistered", this.getAttachedPlayersList()));
            return text;
        }
        entityPlayer.func_70097_a(DamageSource.field_76377_j, 1.0f);
        this.players.add(entityPlayer.func_70005_c_());
        WarpDriveText text = Commons.getChatPrefix(this.func_145838_q());
        text.appendSibling(new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.security_station.guide.player_registered", this.getAttachedPlayersList()));
        return text;
    }

    protected String getAttachedPlayersList() {
        if (this.players.isEmpty()) {
            return "<nobody>";
        }
        StringBuilder list = new StringBuilder();
        for (int i = 0; i < this.players.size(); ++i) {
            String nick = this.players.get(i);
            list.append(nick).append(i == this.players.size() - 1 ? "" : ", ");
        }
        return list.toString();
    }

    public String getFirstOnlinePlayer() {
        if (this.players == null || this.players.isEmpty()) {
            return null;
        }
        for (String namePlayer : this.players) {
            EntityPlayerMP entityPlayer = Commons.getOnlinePlayerByName(namePlayer);
            if (entityPlayer == null) continue;
            return namePlayer;
        }
        return null;
    }

    @Override
    public Object[] getAttachedPlayers() {
        StringBuilder list = new StringBuilder();
        if (!this.players.isEmpty()) {
            for (int i = 0; i < this.players.size(); ++i) {
                String nick = this.players.get(i);
                list.append(nick).append(i == this.players.size() - 1 ? "" : ",");
            }
        }
        return new Object[]{list.toString(), this.players.toArray()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getAttachedPlayers(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getAttachedPlayers();
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "getAttachedPlayers": {
                return this.getAttachedPlayers();
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }
}

