/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.atomic;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.atomic.BlockAbstractAccelerator;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.data.SoundEvents;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.network.PacketHandler;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockChiller
extends BlockAbstractAccelerator {
    private static final float BOUNDING_TOLERANCE = 0.05f;
    private static final AxisAlignedBB CHILLER_COLLISION_AABB = new AxisAlignedBB((double)0.05f, 0.0, (double)0.05f, 0.9499999992549419, 1.0, 0.9499999992549419);

    public BlockChiller(String registryName, EnumTier enumTier) {
        super(registryName, enumTier);
        this.func_149663_c("warpdrive.atomic.chiller." + enumTier.func_176610_l());
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockProperties.ACTIVE});
    }

    @Nonnull
    public IBlockState func_176203_a(int metadata) {
        return this.func_176223_P().func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf((metadata & 8) != 0));
    }

    public int func_176201_c(@Nonnull IBlockState blockState) {
        return (Boolean)blockState.func_177229_b((IProperty)BlockProperties.ACTIVE) != false ? 8 : 0;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos) {
        return CHILLER_COLLISION_AABB;
    }

    public void func_180634_a(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState, @Nonnull Entity entity) {
        super.func_180634_a(world, blockPos, blockState, entity);
        if (world.field_72995_K) {
            return;
        }
        this.onEntityEffect(world, blockPos, entity);
    }

    public void func_176199_a(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull Entity entity) {
        super.func_176199_a(world, blockPos, entity);
        if (world.field_72995_K) {
            return;
        }
        this.onEntityEffect(world, blockPos, entity);
    }

    public void func_180649_a(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull EntityPlayer entityPlayer) {
        super.func_180649_a(world, blockPos, entityPlayer);
        if (world.field_72995_K) {
            return;
        }
        this.onEntityEffect(world, blockPos, (Entity)entityPlayer);
    }

    private void onEntityEffect(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull Entity entity) {
        if (entity.field_70128_L || !(entity instanceof EntityLivingBase)) {
            return;
        }
        if (!((Boolean)world.func_180495_p(blockPos).func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue()) {
            return;
        }
        if (!entity.func_70045_F()) {
            entity.func_70015_d(1);
        }
        entity.func_70097_a((DamageSource)WarpDrive.damageWarm, (float)(1 + this.enumTier.getIndex()));
        Vector3 v3Entity = new Vector3(entity);
        Vector3 v3Chiller = new Vector3((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5);
        Vector3 v3Direction = new Vector3(entity).subtract(v3Chiller).normalize();
        v3Chiller.translateFactor(v3Direction, 0.6);
        v3Entity.translateFactor(v3Direction, -0.6);
        v3Direction.scale(0.2);
        PacketHandler.sendSpawnParticlePacket(world, "snowShovel", (byte)5, v3Entity, v3Direction, 0.9f + 0.1f * world.field_73012_v.nextFloat(), 0.35f + 0.25f * world.field_73012_v.nextFloat(), 0.3f + 0.15f * world.field_73012_v.nextFloat(), 0.0f, 0.0f, 0.0f, 32);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@Nonnull IBlockState blockState, @Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull Random random) {
        if (!((Boolean)blockState.func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue()) {
            return;
        }
        int countNearby = 17 - (world.func_180495_p(blockPos.func_177974_f()).func_177230_c() == this ? 1 : 0) - (world.func_180495_p(blockPos.func_177976_e()).func_177230_c() == this ? 1 : 0) - (world.func_180495_p(blockPos.func_177978_c()).func_177230_c() == this ? 1 : 0) - (world.func_180495_p(blockPos.func_177968_d()).func_177230_c() == this ? 1 : 0) - (world.func_180495_p(blockPos.func_177965_g(2)).func_177230_c() == this ? 1 : 0) - (world.func_180495_p(blockPos.func_177985_f(2)).func_177230_c() == this ? 1 : 0) - (world.func_180495_p(blockPos.func_177964_d(2)).func_177230_c() == this ? 1 : 0) - (world.func_180495_p(blockPos.func_177970_e(2)).func_177230_c() == this ? 1 : 0) - (world.func_180495_p(blockPos.func_177981_b(2).func_177974_f()).func_177230_c() == this ? 1 : 0) - (world.func_180495_p(blockPos.func_177981_b(2).func_177976_e()).func_177230_c() == this ? 1 : 0) - (world.func_180495_p(blockPos.func_177981_b(2).func_177978_c()).func_177230_c() == this ? 1 : 0) - (world.func_180495_p(blockPos.func_177981_b(2).func_177968_d()).func_177230_c() == this ? 1 : 0) - (world.func_180495_p(blockPos.func_177979_c(2).func_177974_f()).func_177230_c() == this ? 1 : 0) - (world.func_180495_p(blockPos.func_177979_c(2).func_177976_e()).func_177230_c() == this ? 1 : 0) - (world.func_180495_p(blockPos.func_177979_c(2).func_177978_c()).func_177230_c() == this ? 1 : 0) - (world.func_180495_p(blockPos.func_177979_c(2).func_177968_d()).func_177230_c() == this ? 1 : 0);
        if (world.field_73012_v.nextInt(17) < countNearby) {
            world.func_184133_a(null, blockPos, SoundEvents.CHILLER, SoundCategory.AMBIENT, 1.0f, 1.0f);
        }
        if (world.field_73012_v.nextInt(8) != 1) {
            double dOffset = 0.0625;
            for (int l = 0; l < 6; ++l) {
                double dX = (float)blockPos.func_177958_n() + random.nextFloat();
                double dY = (float)blockPos.func_177956_o() + random.nextFloat();
                double dZ = (float)blockPos.func_177952_p() + random.nextFloat();
                boolean isValidSide = false;
                if (l == 0 && !world.func_180495_p(blockPos.func_177984_a()).func_185914_p()) {
                    dY = (double)blockPos.func_177956_o() + 1.0 + 0.0625;
                    isValidSide = true;
                }
                if (l == 1 && !world.func_180495_p(blockPos.func_177977_b()).func_185914_p()) {
                    dY = (double)blockPos.func_177956_o() - 0.0625;
                    isValidSide = true;
                }
                if (l == 2 && !world.func_180495_p(blockPos.func_177968_d()).func_185914_p()) {
                    dZ = (double)blockPos.func_177952_p() + 1.0 + 0.0625;
                    isValidSide = true;
                }
                if (l == 3 && !world.func_180495_p(blockPos.func_177978_c()).func_185914_p()) {
                    dZ = (double)blockPos.func_177952_p() - 0.0625;
                    isValidSide = true;
                }
                if (l == 4 && !world.func_180495_p(blockPos.func_177974_f()).func_185914_p()) {
                    dX = (double)blockPos.func_177958_n() + 1.0 + 0.0625;
                    isValidSide = true;
                }
                if (l == 5 && !world.func_180495_p(blockPos.func_177976_e()).func_185914_p()) {
                    dX = (double)blockPos.func_177958_n() - 0.0625;
                    isValidSide = true;
                }
                if (!isValidSide) continue;
                world.func_175688_a(EnumParticleTypes.REDSTONE, dX, dY, dZ, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }
}

