/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.atomic;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IGlobalRegionProvider;
import cr0s.warpdrive.api.IParticleContainerItem;
import cr0s.warpdrive.api.Particle;
import cr0s.warpdrive.api.ParticleRegistry;
import cr0s.warpdrive.api.ParticleStack;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.TileEntityAbstractEnergyCoreOrController;
import cr0s.warpdrive.block.atomic.BlockAbstractAccelerator;
import cr0s.warpdrive.block.atomic.BlockChiller;
import cr0s.warpdrive.block.atomic.BlockVoidShellPlain;
import cr0s.warpdrive.block.atomic.TileEntityParticlesInjector;
import cr0s.warpdrive.block.energy.BlockCapacitor;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.AcceleratorControlParameter;
import cr0s.warpdrive.data.AcceleratorSetup;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.EnergyWrapper;
import cr0s.warpdrive.data.EnumGlobalRegionType;
import cr0s.warpdrive.data.InventoryWrapper;
import cr0s.warpdrive.data.ParticleBunch;
import cr0s.warpdrive.data.SoundEvents;
import cr0s.warpdrive.data.TrajectoryPoint;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.network.PacketHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.Optional;

public class TileEntityAcceleratorCore
extends TileEntityAbstractEnergyCoreOrController
implements IGlobalRegionProvider {
    private static final int ACCELERATOR_COOLDOWN_TICKS = 300;
    private static final int ACCELERATOR_GUIDE_UPDATE_TICKS = 300;
    private static final double ACCELERATOR_AMBIENT_TEMPERATURE_K = 300.0;
    private static final double ACCELERATOR_AMBIENT_WARMING_RATE = 0.01;
    private static final double ACCELERATOR_TEMPERATURE_TOLERANCE_K = 0.05;
    public static final double[] PARTICLE_BUNCH_ENERGY_MINIMUM = new double[]{0.1, 0.8, 8.0};
    public static final double[] PARTICLE_BUNCH_ENERGY_MAXIMUM = new double[]{1.0, 10.0, 100.0};
    public static final double[] PARTICLE_BUNCH_ENERGY_FACTOR_PER_MAGNET = new double[]{0.02457, 0.0060324, 5.625E-4};
    public static final double[] PARTICLE_BUNCH_TURN_COEFFICIENTS_AT_MIN_ENERGY = new double[]{0.7866, 0.8555, 0.9678};
    public static final double[] PARTICLE_BUNCH_TURN_COEFFICIENTS_AT_MAX_ENERGY = new double[]{0.7504, 0.8455, 0.9677};
    public static final double[] PARTICLE_BUNCH_ENERGY_TO_SPEEDS_X = new double[]{0.1, 1.0, 10.0, 100.0};
    public static final double[] PARTICLE_BUNCH_ENERGY_TO_SPEEDS_Y = new double[]{0.01, 0.6, 1.5, 3.0};
    public static final double[] PARTICLE_BUNCH_ENERGY_TO_EXPLOSION_STRENGTH_X = new double[]{0.0, PARTICLE_BUNCH_ENERGY_MAXIMUM[0], PARTICLE_BUNCH_ENERGY_MAXIMUM[1], PARTICLE_BUNCH_ENERGY_MAXIMUM[2], PARTICLE_BUNCH_ENERGY_MAXIMUM[2] * 2.0};
    public static final double[] PARTICLE_BUNCH_ENERGY_TO_EXPLOSION_STRENGTH_Y = new double[]{0.0, 1.5, 3.0, 6.0, 10.0};
    private static final double[] ACCELERATOR_COLLISION_ENERGY_TO_PARTICLE_INDEX_X = new double[]{0.0, PARTICLE_BUNCH_ENERGY_MAXIMUM[0] * 0.4, PARTICLE_BUNCH_ENERGY_MAXIMUM[1] * 0.5, PARTICLE_BUNCH_ENERGY_MAXIMUM[2] * 0.5, PARTICLE_BUNCH_ENERGY_MAXIMUM[2] * 1.5, PARTICLE_BUNCH_ENERGY_MAXIMUM[2] * 2.0};
    private static final double[] ACCELERATOR_COLLISION_ENERGY_TO_PARTICLE_INDEX_Y = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
    private static final Particle[] ACCELERATOR_COLLISION_PARTICLES = new Particle[]{null, ParticleRegistry.ION, ParticleRegistry.PROTON, ParticleRegistry.ANTIMATTER, ParticleRegistry.STRANGE_MATTER};
    private final Collection<ParticleBunch> setParticleBunches = new CopyOnWriteArraySet<ParticleBunch>();
    private double temperatureCurrent_K = 300.0;
    private final Map<Integer, AcceleratorControlParameter> mapControlParameters = new HashMap<Integer, AcceleratorControlParameter>();
    private int injectionPeriodTicks = 60;
    private int injectionTicks = 0;
    private int indexNextInjector = 0;
    private boolean legacy_isOn = false;
    private int cooldownTicks;
    private int guideTicks;
    protected boolean isPowered = true;
    private AcceleratorSetup acceleratorSetup;

    public TileEntityAcceleratorCore() {
        this.peripheralName = "warpdriveAccelerator";
        this.addMethods(new String[]{"enable", "getControlPoints", "getControlPointsCount", "getControlPoint", "getParameters", "getParametersControlChannels", "parameter", "injectionPeriod", "state"});
        this.CC_scripts = Collections.singletonList("startup");
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        this.cooldownTicks = 0;
        this.guideTicks = 300;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        assert (this.acceleratorSetup != null);
        if (this.cooldownTicks > 0) {
            --this.cooldownTicks;
        }
        if (this.guideTicks > 0) {
            --this.guideTicks;
        }
        int tierCurrentTemperature = this.temperatureCurrent_K <= WarpDriveConfig.ACCELERATOR_TEMPERATURES_K[1] ? 3 : (this.temperatureCurrent_K <= WarpDriveConfig.ACCELERATOR_TEMPERATURES_K[0] ? 2 : 1);
        this.reportJammed(this.acceleratorSetup);
        boolean needsCooling = this.acceleratorSetup.temperatureTarget_K < this.temperatureCurrent_K;
        int energyRequired = needsCooling ? (int)Math.round(this.acceleratorSetup.temperature_coolingEnergyCost_perTick) : (int)Math.round(this.acceleratorSetup.temperatures_sustainEnergyCost_perTick[tierCurrentTemperature - 1]);
        energyRequired = (int)((double)energyRequired + this.acceleratorSetup.particleEnergy_energyCost_perTick * (0.1 + 1.0 * (double)this.setParticleBunches.size()));
        int energyPotential = this.acceleratorSetup.energy_getPotentialOutput();
        boolean bl = this.isPowered = energyRequired > 0 && energyPotential >= energyRequired;
        if (!this.acceleratorSetup.isLoaded()) {
            this.cooldownTicks = 300;
            return;
        }
        boolean isEnabledAndValid = this.isEnabled && this.isAssemblyValid;
        boolean isOn = isEnabledAndValid && this.cooldownTicks <= 0 && this.isPowered;
        this.updateBlockState((IBlockState)null, BlockProperties.ACTIVE, isOn);
        if (isOn) {
            if (!this.legacy_isOn) {
                this.updateChillers(this.acceleratorSetup, true, needsCooling, false);
                if (WarpDriveConfig.LOGGING_ACCELERATOR) {
                    WarpDrive.logger.info(this + " starting up...");
                }
                this.legacy_isOn = true;
            } else if ((this.field_145850_b.func_82737_E() + (long)Math.abs(this.field_174879_c.func_177958_n() - this.field_174879_c.func_177952_p())) % 20L == 0L) {
                this.updateChillers(this.acceleratorSetup, true, needsCooling, false);
            }
            this.cooldownTicks = 0;
            this.acceleratorSetup.energy_consume(energyRequired);
            this.temperatureCurrent_K = this.acceleratorSetup.temperatureTarget_K <= this.temperatureCurrent_K ? TileEntityAcceleratorCore.updateTemperature(this.temperatureCurrent_K, this.acceleratorSetup.temperatures_cooling_K_perTick[tierCurrentTemperature - 1], this.acceleratorSetup.temperatureTarget_K) : TileEntityAcceleratorCore.updateTemperature(this.temperatureCurrent_K, 0.01, this.acceleratorSetup.temperatureTarget_K);
            if (needsCooling && this.temperatureCurrent_K <= this.acceleratorSetup.temperatureTarget_K) {
                this.sendEvent("acceleratorCoolingDone", new Object[0]);
            }
            --this.injectionTicks;
            if (this.injectionTicks <= 0 && !needsCooling && this.setParticleBunches.size() < WarpDriveConfig.ACCELERATOR_MAX_PARTICLE_BUNCHES && !this.acceleratorSetup.mapInjectors.isEmpty()) {
                this.injectionTicks = this.injectionPeriodTicks;
                int countInjectors = this.acceleratorSetup.keyInjectors.length;
                if (this.indexNextInjector < countInjectors) {
                    this.onInject(this.acceleratorSetup.mapInjectors.get(this.acceleratorSetup.keyInjectors[this.indexNextInjector]));
                } else {
                    this.rebootAccelerator(this.acceleratorSetup, false, true);
                }
                this.indexNextInjector = (this.indexNextInjector + 1) % countInjectors;
            }
            this.doSimulate(needsCooling ? null : this.acceleratorSetup);
        } else {
            if (this.legacy_isOn) {
                this.rebootAccelerator(this.acceleratorSetup, false, false);
                if (WarpDriveConfig.LOGGING_ACCELERATOR) {
                    WarpDrive.logger.info(this + " shutting down...");
                }
                this.legacy_isOn = false;
                this.cooldownTicks = 300;
                this.guideTicks = 0;
            } else if ((this.field_145850_b.func_72820_D() + (long)Math.abs(this.field_174879_c.func_177958_n() - this.field_174879_c.func_177952_p())) % 20L == 0L) {
                this.updateChillers(this.acceleratorSetup, false, false, false);
            }
            this.temperatureCurrent_K = TileEntityAcceleratorCore.updateTemperature(this.temperatureCurrent_K, 0.01, 300.0);
            if (isEnabledAndValid && this.guideTicks <= 0) {
                this.guideTicks = 300;
                WarpDriveText text = this.getStatusPrefix();
                String energyUnits = this.energy_getDisplayUnits();
                if (energyRequired > this.acceleratorSetup.energy_getMaxStorage()) {
                    text.append(Commons.getStyleWarning(), "warpdrive.accelerator.guide.low_power.not_enough_storage", EnergyWrapper.format(energyRequired, energyUnits), EnergyWrapper.format(this.acceleratorSetup.energy_getMaxStorage(), energyUnits), energyUnits);
                } else if (this.acceleratorSetup.setChillers.isEmpty()) {
                    text.append(Commons.getStyleWarning(), "warpdrive.accelerator.guide.no_chiller", new Object[0]);
                } else if (this.setParticleBunches.isEmpty()) {
                    text.append(Commons.getStyleWarning(), "warpdrive.accelerator.guide.low_power.no_particles", EnergyWrapper.format(energyRequired, energyUnits), EnergyWrapper.format(energyPotential, energyUnits), energyUnits);
                } else {
                    text.append(Commons.getStyleWarning(), "warpdrive.accelerator.guide.low_power.accelerating", EnergyWrapper.format(energyRequired, energyUnits), EnergyWrapper.format(energyPotential, energyUnits), energyUnits);
                }
                AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 10), (double)(this.field_174879_c.func_177956_o() - 10), (double)(this.field_174879_c.func_177952_p() - 10), (double)(this.field_174879_c.func_177958_n() + 10), (double)(this.field_174879_c.func_177956_o() + 10), (double)(this.field_174879_c.func_177952_p() + 10));
                List list = this.field_145850_b.func_72839_b(null, axisalignedbb);
                for (Entity entity : list) {
                    if (!(entity instanceof EntityPlayer) || entity instanceof FakePlayer) continue;
                    Commons.addChatMessage((ICommandSender)entity, (ITextComponent)text);
                }
            }
            this.doSimulate(null);
        }
    }

    private static double updateTemperature(double actual_K, double rate, double target_K) {
        double delta_K = target_K - actual_K;
        if (Math.abs(delta_K) < 0.05) {
            return target_K;
        }
        if (!WarpDriveConfig.LOGGING_ACCELERATOR || WarpDrive.isDev) {
            // empty if block
        }
        return actual_K + rate * Math.signum(delta_K) * Math.sqrt(Math.abs(delta_K) / 300.0);
    }

    boolean isOn() {
        return this.legacy_isOn;
    }

    private void reportJammed(@Nonnull AcceleratorSetup acceleratorSetup) {
        assert (!this.field_145850_b.field_72995_K);
        if (acceleratorSetup.setJammed.isEmpty()) {
            return;
        }
        for (VectorI vector : acceleratorSetup.setJammed) {
            PacketHandler.sendSpawnParticlePacket(this.field_145850_b, "jammed", (byte)5, new Vector3((double)vector.x + 0.5, (double)vector.y + 0.5, (double)vector.z + 0.5), new Vector3(0.0, 0.0, 0.0), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 32);
        }
    }

    private void updateChillers(AcceleratorSetup acceleratorSetup, boolean isOn, boolean needsCooling, boolean isChunkLoading) {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K || acceleratorSetup == null) {
            return;
        }
        if (!acceleratorSetup.setChillers.isEmpty()) {
            for (BlockPos blockPos : acceleratorSetup.setChillers) {
                IBlockState blockState;
                if (!isChunkLoading && (!this.field_145850_b.func_175667_e(blockPos) || !this.field_145850_b.func_72964_e(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4).func_177410_o()) || !((blockState = this.field_145850_b.func_180495_p(blockPos)).func_177230_c() instanceof BlockChiller)) continue;
                if (!blockState.func_177228_b().containsKey((Object)BlockProperties.ACTIVE)) {
                    WarpDrive.logger.error(String.format("Invalid blockstate property for BlockChiller %s %s %s, please report to mod author", blockState, blockState.func_177230_c(), Commons.format(this.field_145850_b, blockPos)));
                }
                if (isOn && needsCooling) {
                    if (((Boolean)blockState.func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue()) continue;
                    this.field_145850_b.func_175656_a(blockPos, blockState.func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(true)));
                    continue;
                }
                if (!((Boolean)blockState.func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue()) continue;
                this.field_145850_b.func_175656_a(blockPos, blockState.func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    private void onInject(@Nonnull VectorI vInjector) {
        assert (this.setParticleBunches.size() < WarpDriveConfig.ACCELERATOR_MAX_PARTICLE_BUNCHES);
        TileEntity tileEntity = vInjector.getTileEntity((IBlockAccess)this.field_145850_b);
        if (!(tileEntity instanceof TileEntityParticlesInjector)) {
            if (WarpDriveConfig.LOGGING_ACCELERATOR) {
                WarpDrive.logger.info(String.format("%s Unable to inject with missing injector %s %s", this, tileEntity, Commons.format(this.field_145850_b, this.field_174879_c)));
            }
            this.markDirtyAssembly();
            return;
        }
        if (!((TileEntityParticlesInjector)tileEntity).getIsEnabled()) {
            return;
        }
        Collection<Object> inventories = InventoryWrapper.getConnectedInventories(tileEntity.func_145831_w(), tileEntity.func_174877_v());
        if (inventories.isEmpty()) {
            PacketHandler.sendSpawnParticlePacket(this.field_145850_b, "jammed", (byte)5, new Vector3((double)vInjector.x + 0.5, (double)vInjector.y + 0.5, (double)vInjector.z + 0.5), new Vector3(0.0, 0.0, 0.0), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 32);
            return;
        }
        int slotIndex = 0;
        boolean found = false;
        Object inventory = null;
        for (Object inventoryLoop : inventories) {
            if (!found) {
                slotIndex = 0;
            }
            int sizeInventory = InventoryWrapper.getSize(inventoryLoop);
            while (slotIndex < sizeInventory && !found) {
                ItemStack itemStack = InventoryWrapper.getStackInSlot(inventoryLoop, slotIndex);
                if (itemStack.func_190926_b()) {
                    ++slotIndex;
                    continue;
                }
                Block blockFromItem = Block.func_149634_a((Item)itemStack.func_77973_b());
                if (blockFromItem == Blocks.field_150350_a) {
                    ++slotIndex;
                    continue;
                }
                found = true;
                inventory = inventoryLoop;
            }
        }
        if (inventory == null) {
            if (WarpDriveConfig.LOGGING_ACCELERATOR) {
                WarpDrive.logger.debug(this + " No valid item found to inject");
            }
            PacketHandler.sendSpawnParticlePacket(this.field_145850_b, "jammed", (byte)5, new Vector3((double)vInjector.x + 0.5, (double)vInjector.y + 0.5, (double)vInjector.z + 0.5), new Vector3(0.0, 0.0, 0.0), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 32);
            return;
        }
        assert (found);
        EnumFacing directionStart = EnumFacing.NORTH;
        VectorI vPosition = vInjector;
        for (EnumFacing forgeDirection : EnumFacing.field_176754_o) {
            vPosition = vInjector.clone(forgeDirection);
            Block block = vPosition.getBlock((IBlockAccess)this.field_145850_b);
            if (!(block instanceof BlockVoidShellPlain)) continue;
            directionStart = forgeDirection;
            break;
        }
        InventoryWrapper.decrStackSize(inventory, slotIndex, 1);
        Vector3 v3Start = new Vector3(directionStart);
        this.setParticleBunches.add(new ParticleBunch(vPosition.x, vPosition.y, vPosition.z, directionStart, v3Start));
        if (WarpDriveConfig.LOGGING_ACCELERATOR) {
            WarpDrive.logger.info(this + " injecting from " + vInjector);
        }
        Vector3 v3Speed = v3Start.clone().invert();
        PacketHandler.sendSpawnParticlePacket(this.field_145850_b, "mobSpell", (byte)10, new Vector3((double)vInjector.x + 0.5 * (1.0 + v3Speed.x + this.field_145850_b.field_73012_v.nextGaussian()), (double)vInjector.y + 0.5 * (1.0 + v3Speed.y + this.field_145850_b.field_73012_v.nextGaussian()), (double)vInjector.z + 0.5 * (1.0 + v3Speed.z + this.field_145850_b.field_73012_v.nextGaussian())), v3Speed, 0.7f, 0.7f, 0.9f, 0.0f, 0.0f, 0.0f, 32);
        this.sendEvent("particleBunchInjected", new Object[0]);
    }

    private void doSimulate(AcceleratorSetup acceleratorSetup) {
        if (this.setParticleBunches.isEmpty()) {
            return;
        }
        for (ParticleBunch particleBunch : this.setParticleBunches) {
            boolean isAlive = particleBunch.onUpdate(this.field_145850_b, this.mapControlParameters, acceleratorSetup);
            if (isAlive) continue;
            this.setParticleBunches.remove(particleBunch);
        }
        if (acceleratorSetup == null) {
            return;
        }
        ArrayList<ParticleBunch> setInRange = new ArrayList<ParticleBunch>(this.setParticleBunches.size());
        block1: for (TrajectoryPoint trajectoryPointCollider : acceleratorSetup.listColliders) {
            AcceleratorControlParameter acceleratorControlParameter = this.mapControlParameters.get(trajectoryPointCollider.controlChannel);
            if (acceleratorControlParameter != null && !acceleratorControlParameter.isEnabled) continue;
            double threshold = acceleratorControlParameter == null ? 0.95 : acceleratorControlParameter.threshold;
            double energyThreshold = threshold * PARTICLE_BUNCH_ENERGY_MAXIMUM[trajectoryPointCollider.getTier() - 1];
            AxisAlignedBB axisAlignedBB = new AxisAlignedBB((double)((float)trajectoryPointCollider.x + 0.5f - 2.0f), (double)((float)trajectoryPointCollider.y + 0.5f - 2.0f), (double)((float)trajectoryPointCollider.z + 0.5f - 2.0f), (double)((float)trajectoryPointCollider.x + 0.5f + 2.0f), (double)((float)trajectoryPointCollider.y + 0.5f + 2.0f), (double)((float)trajectoryPointCollider.z + 0.5f + 2.0f));
            setInRange.clear();
            boolean hasCollided = false;
            for (ParticleBunch particleBunch : this.setParticleBunches) {
                if (hasCollided) break;
                if (!(axisAlignedBB.field_72340_a <= particleBunch.x) || !(particleBunch.x <= axisAlignedBB.field_72336_d) || !(axisAlignedBB.field_72338_b <= particleBunch.y) || !(particleBunch.y <= axisAlignedBB.field_72337_e) || !(axisAlignedBB.field_72339_c <= particleBunch.z) || !(particleBunch.z <= axisAlignedBB.field_72334_f)) continue;
                if (particleBunch.energy >= energyThreshold) {
                    this.doCollision(this.field_145850_b.field_73012_v, trajectoryPointCollider, particleBunch, null);
                    this.setParticleBunches.remove(particleBunch);
                    particleBunch.onCollided(this.field_145850_b, trajectoryPointCollider);
                    hasCollided = true;
                    continue;
                }
                setInRange.add(particleBunch);
            }
            if (hasCollided || setInRange.size() <= 1) continue;
            block3: for (ParticleBunch particleBunch1 : setInRange) {
                if (hasCollided) continue block1;
                for (ParticleBunch particleBunch2 : setInRange) {
                    if (hasCollided) continue block3;
                    if (!(particleBunch1.energy + particleBunch2.energy >= energyThreshold) || particleBunch1.directionCurrentMotion.func_176734_d() != particleBunch2.directionCurrentMotion) continue;
                    this.doCollision(this.field_145850_b.field_73012_v, trajectoryPointCollider, particleBunch1, particleBunch2);
                    this.setParticleBunches.remove(particleBunch1);
                    particleBunch1.onCollided(this.field_145850_b, trajectoryPointCollider);
                    this.setParticleBunches.remove(particleBunch2);
                    particleBunch2.onCollided(this.field_145850_b, trajectoryPointCollider);
                    hasCollided = true;
                }
            }
        }
    }

    private void doCollision(@Nonnull Random random, @Nonnull TrajectoryPoint trajectoryPointCollider, @Nonnull ParticleBunch particleBunch1, ParticleBunch particleBunch2) {
        int quantityGenerated;
        double energyTotal = particleBunch1.energy + (particleBunch2 != null ? particleBunch2.energy : 0.0);
        int tier = trajectoryPointCollider.getTier();
        double indexParticle = Commons.interpolate(ACCELERATOR_COLLISION_ENERGY_TO_PARTICLE_INDEX_X, ACCELERATOR_COLLISION_ENERGY_TO_PARTICLE_INDEX_Y, energyTotal);
        Particle particle = ACCELERATOR_COLLISION_PARTICLES[(int)Math.floor(indexParticle)];
        double energyExtra = indexParticle - Math.floor(indexParticle);
        int overflow = quantityGenerated = Math.max(0, (int)Math.round((10.0 + 5.0 * random.nextGaussian()) * (1.0 - 0.2 * (double)tier) * (0.5 + 2.0 * energyExtra)));
        if (particle != null) {
            Collection<Object> inventories = InventoryWrapper.getConnectedInventories(this.field_145850_b, trajectoryPointCollider.vControlPoint.getBlockPos());
            ParticleStack particleStack = this.addParticleToInventories(new ParticleStack(particle, quantityGenerated), inventories);
            int n = overflow = particleStack == null || particleStack.isEmpty() ? 0 : particleStack.getAmount();
        }
        SoundEvent soundEvent = tier == 1 ? SoundEvents.COLLISION_LOW : (tier == 2 ? SoundEvents.COLLISION_MEDIUM : SoundEvents.COLLISION_HIGH);
        this.field_145850_b.func_184133_a(null, trajectoryPointCollider.getBlockPos(), soundEvent, SoundCategory.BLOCKS, 0.5f + (float)energyExtra, 0.85f + 0.5f * (float)energyExtra + 0.1f * this.field_145850_b.field_73012_v.nextFloat());
        if (overflow > 0) {
            float strength = 3.0f + (float)tier;
            this.field_145850_b.func_72885_a(null, (double)trajectoryPointCollider.x + 0.5, (double)trajectoryPointCollider.y + 0.5, (double)trajectoryPointCollider.z + 0.5, strength, true, true);
        } else {
            for (int countParticles = 0; countParticles < 5; ++countParticles) {
                PacketHandler.sendSpawnParticlePacket(this.field_145850_b, "explosionNormal", (byte)5, new Vector3((double)trajectoryPointCollider.x + 0.5 + 2.5 * this.field_145850_b.field_73012_v.nextGaussian(), (double)trajectoryPointCollider.y + 0.5 + 2.5 * this.field_145850_b.field_73012_v.nextGaussian(), (double)trajectoryPointCollider.z + 0.5 + 2.5 * this.field_145850_b.field_73012_v.nextGaussian()), new Vector3(0.15 * this.field_145850_b.field_73012_v.nextGaussian(), 0.15 * this.field_145850_b.field_73012_v.nextGaussian(), 0.15 * this.field_145850_b.field_73012_v.nextGaussian()), 0.7f, 0.7f, 0.9f, 0.0f, 0.0f, 0.0f, 32);
            }
        }
        this.sendEvent("particleBunchCollided", new Object[0]);
    }

    protected ParticleStack addParticleToInventories(ParticleStack particleStack, Collection<Object> inventories) {
        if (particleStack == null || particleStack.isEmpty()) {
            return null;
        }
        ParticleStack particleStackLeft = particleStack.copy();
        for (Object inventory : inventories) {
            if ((particleStackLeft = TileEntityAcceleratorCore.addParticleToInventory(particleStackLeft, inventory)) != null && !particleStackLeft.isEmpty()) continue;
            return null;
        }
        if (WarpDriveConfig.LOGGING_COLLECTION) {
            WarpDrive.logger.info(this + " Overflow detected");
        }
        return particleStackLeft;
    }

    private static ParticleStack addParticleToInventory(ParticleStack particleStack, Object inventory) {
        if (particleStack == null || particleStack.isEmpty()) {
            return null;
        }
        ParticleStack particleStackLeft = particleStack.copy();
        if (inventory != null) {
            int transfer;
            IParticleContainerItem particleContainerItem;
            ItemStack itemStack;
            int i;
            int sizeInventory = InventoryWrapper.getSize(inventory);
            for (i = 0; i < sizeInventory; ++i) {
                itemStack = InventoryWrapper.getStackInSlot(inventory, i);
                if (itemStack == null || !(itemStack.func_77973_b() instanceof IParticleContainerItem) || (particleContainerItem = (IParticleContainerItem)itemStack.func_77973_b()).isEmpty(itemStack)) continue;
                transfer = particleContainerItem.fill(itemStack, particleStackLeft, true);
                particleStackLeft.fill(-transfer);
                if (!particleStackLeft.isEmpty()) continue;
                return null;
            }
            for (i = 0; i < sizeInventory; ++i) {
                itemStack = InventoryWrapper.getStackInSlot(inventory, i);
                if (itemStack == null || !(itemStack.func_77973_b() instanceof IParticleContainerItem) || !(particleContainerItem = (IParticleContainerItem)itemStack.func_77973_b()).isEmpty(itemStack)) continue;
                transfer = particleContainerItem.fill(itemStack, particleStackLeft, true);
                particleStackLeft.fill(-transfer);
                if (!particleStackLeft.isEmpty()) continue;
                return null;
            }
        }
        return particleStackLeft;
    }

    private void rebootAccelerator(AcceleratorSetup acceleratorSetup, boolean isChunkLoading, boolean isLeaking) {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.markDirtyGlobalRegion();
        this.updateChillers(acceleratorSetup, false, false, isChunkLoading);
        this.legacy_isOn = false;
        if (isLeaking) {
            this.temperatureCurrent_K = 300.0;
            if (this.isEnabled) {
                this.sendEvent("acceleratorCoolingReset", new Object[0]);
            }
        }
    }

    @Override
    public WarpDriveText getStatusHeader() {
        return super.getStatusHeader();
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagListParticleBunches = tagCompound.func_150295_c("particleBunches", 10);
        this.setParticleBunches.clear();
        for (int index = 0; index < tagListParticleBunches.func_74745_c(); ++index) {
            ParticleBunch particleBunch = new ParticleBunch(tagListParticleBunches.func_150305_b(index));
            this.setParticleBunches.add(particleBunch);
        }
        if (tagCompound.func_74764_b("temperatureCurrent")) {
            this.temperatureCurrent_K = tagCompound.func_74769_h("temperatureCurrent");
        }
        NBTTagList tagListControlParameters = tagCompound.func_150295_c("controlParameters", 10);
        this.mapControlParameters.clear();
        for (int index = 0; index < tagListControlParameters.func_74745_c(); ++index) {
            AcceleratorControlParameter acceleratorControlParameter = new AcceleratorControlParameter(tagListControlParameters.func_150305_b(index));
            this.mapControlParameters.put(acceleratorControlParameter.controlChannel, acceleratorControlParameter);
        }
        this.injectionPeriodTicks = tagCompound.func_74762_e("injectionPeriod");
        if (tagCompound.func_74764_b("injectionTicks")) {
            this.injectionTicks = tagCompound.func_74762_e("injectionTicks");
        }
        if (tagCompound.func_74764_b("nextInjector")) {
            this.indexNextInjector = tagCompound.func_74762_e("nextInjector");
        }
        if (tagCompound.func_74764_b("isOn")) {
            this.legacy_isOn = tagCompound.func_74767_n("isOn");
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        NBTTagList tagListParticleBunches = new NBTTagList();
        for (ParticleBunch particleBunch : this.setParticleBunches) {
            NBTTagCompound tagCompoundParticleBunch = new NBTTagCompound();
            particleBunch.writeToNBT(tagCompoundParticleBunch);
            tagListParticleBunches.func_74742_a((NBTBase)tagCompoundParticleBunch);
        }
        tagCompound.func_74782_a("particleBunches", (NBTBase)tagListParticleBunches);
        tagCompound.func_74780_a("temperatureCurrent", this.temperatureCurrent_K);
        NBTTagList tagListControlParameters = new NBTTagList();
        for (AcceleratorControlParameter acceleratorControlParameter : this.mapControlParameters.values()) {
            NBTTagCompound tagCompoundControlParameter = new NBTTagCompound();
            acceleratorControlParameter.writeToNBT(tagCompoundControlParameter);
            tagListControlParameters.func_74742_a((NBTBase)tagCompoundControlParameter);
        }
        tagCompound.func_74782_a("controlParameters", (NBTBase)tagListControlParameters);
        tagCompound.func_74768_a("injectionPeriod", this.injectionPeriodTicks);
        tagCompound.func_74768_a("injectionTicks", this.injectionTicks);
        tagCompound.func_74768_a("nextInjector", this.indexNextInjector);
        tagCompound.func_74757_a("isOn", this.legacy_isOn);
        return tagCompound;
    }

    @Override
    public NBTTagCompound writeItemDropNBT(NBTTagCompound tagCompound) {
        super.writeItemDropNBT(tagCompound);
        tagCompound.func_82580_o("temperatureCurrent");
        tagCompound.func_82580_o("injectionTicks");
        tagCompound.func_82580_o("nextInjector");
        tagCompound.func_82580_o("isOn");
        return tagCompound;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tagCompound = super.func_189517_E_();
        tagCompound.func_74757_a("isPowered", this.isPowered);
        return tagCompound;
    }

    @Override
    public void onDataPacket(@Nonnull NetworkManager networkManager, @Nonnull SPacketUpdateTileEntity packet) {
        super.onDataPacket(networkManager, packet);
        NBTTagCompound tagCompound = packet.func_148857_g();
        this.isPowered = tagCompound.func_74767_n("isPowered");
    }

    @Override
    public void onBlockBroken(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState) {
        if (!world.field_72995_K) {
            if (this.acceleratorSetup == null) {
                WarpDriveText textAssemblyValid = new WarpDriveText();
                this.doScanAssembly(true, textAssemblyValid);
            }
            this.rebootAccelerator(this.acceleratorSetup, true, true);
        }
        super.onBlockBroken(world, blockPos, blockState);
    }

    @Override
    protected boolean doScanAssembly(boolean isDirty, WarpDriveText textReason) {
        boolean isValid = super.doScanAssembly(isDirty, textReason);
        AcceleratorSetup legacy_acceleratorSetup = this.acceleratorSetup;
        if (isDirty || this.acceleratorSetup == null || this.acceleratorSetup.isDirty()) {
            this.acceleratorSetup = new AcceleratorSetup(this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c);
            if (!this.acceleratorSetup.getAssemblyStatus(textReason)) {
                if (WarpDriveConfig.LOGGING_ACCELERATOR) {
                    WarpDrive.logger.info(String.format("%s invalid accelerator setup: %s", this, textReason.func_150260_c()));
                }
            } else if (WarpDriveConfig.LOGGING_ACCELERATOR) {
                WarpDrive.logger.info(String.format("%s valid accelerator setup", this));
            }
        } else {
            this.acceleratorSetup.getAssemblyStatus(textReason);
        }
        if (isDirty) {
            if (legacy_acceleratorSetup != null && this.acceleratorSetup.isMajorChange(legacy_acceleratorSetup)) {
                if (WarpDriveConfig.LOGGING_ACCELERATOR) {
                    WarpDrive.logger.info(this + " rebooting due to major change...");
                }
                this.rebootAccelerator(legacy_acceleratorSetup, true, true);
            }
            this.sendEvent("acceleratorUpdated", new Object[0]);
        }
        return isValid;
    }

    @Override
    protected void doUpdateParameters(boolean isDirty) {
    }

    @Override
    public long energy_getEnergyStored() {
        if (!this.func_145830_o()) {
            return 0L;
        }
        if (this.acceleratorSetup == null) {
            return 0L;
        }
        return this.acceleratorSetup.energy_getEnergyStored();
    }

    @Override
    public long energy_getMaxStorage() {
        if (!this.func_145830_o()) {
            return 0L;
        }
        if (this.acceleratorSetup == null) {
            return 0L;
        }
        return this.acceleratorSetup.energy_getMaxStorage();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getControlPoints(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getControlPoints();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getControlPointsCount(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getControlPointsCount();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] injectionPeriod(Context context, Arguments arguments) {
        return this.injectionPeriod(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getParameters(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getParameters();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getParametersControlChannels(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getParametersControlChannels();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] parameter(Context context, Arguments arguments) {
        return this.parameter(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getControlPoint(Context context, Arguments arguments) {
        return this.getControlPoint(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] state(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.state();
    }

    @Override
    public Object[] getEnergyRequired() {
        if (this.acceleratorSetup == null) {
            return new Object[]{0, 0, 0, 0};
        }
        String units = this.energy_getDisplayUnits();
        long energyCoolingCost_perTick = EnergyWrapper.convert(Math.round(this.acceleratorSetup.temperature_coolingEnergyCost_perTick + this.acceleratorSetup.particleEnergy_energyCost_perTick * 0.1), units);
        int tierTargetTemperature = this.acceleratorSetup.temperatureTarget_K <= WarpDriveConfig.ACCELERATOR_TEMPERATURES_K[1] ? 3 : (this.acceleratorSetup.temperatureTarget_K <= WarpDriveConfig.ACCELERATOR_TEMPERATURES_K[0] ? 2 : 1);
        long energySustainCost_perTick = EnergyWrapper.convert(Math.round(this.acceleratorSetup.temperatures_sustainEnergyCost_perTick[tierTargetTemperature - 1] + this.acceleratorSetup.particleEnergy_energyCost_perTick * 0.1), units);
        long energySingleCost_perTick = EnergyWrapper.convert(Math.round(this.acceleratorSetup.temperatures_sustainEnergyCost_perTick[tierTargetTemperature - 1] + this.acceleratorSetup.particleEnergy_energyCost_perTick * 1.1), units);
        long energyMaxCost_perTick = EnergyWrapper.convert(Math.round(this.acceleratorSetup.temperatures_sustainEnergyCost_perTick[tierTargetTemperature - 1] + this.acceleratorSetup.particleEnergy_energyCost_perTick * (0.1 + (double)WarpDriveConfig.ACCELERATOR_MAX_PARTICLE_BUNCHES)), units);
        return new Object[]{energyCoolingCost_perTick, energySustainCost_perTick, energySingleCost_perTick, energyMaxCost_perTick};
    }

    private Object[] getControlPoints() {
        if (this.acceleratorSetup != null) {
            return this.acceleratorSetup.getControlPoints();
        }
        return new Object[0];
    }

    @Nonnull
    private Object[] getControlPointsCount() {
        if (this.acceleratorSetup != null && this.acceleratorSetup.isAssemblyValid()) {
            Object[][] controlPoints = this.acceleratorSetup.getControlPoints();
            return new Integer[]{controlPoints.length};
        }
        return new Integer[]{-1};
    }

    @Nonnull
    private Object[] getControlPoint(@Nonnull Object[] arguments) {
        int index;
        if (this.acceleratorSetup == null) {
            return new Object[]{false, "No accelerator setup"};
        }
        if (arguments.length != 1 || arguments[0] == null) {
            return new Object[]{false, "Expecting 1 argument: Integer index"};
        }
        try {
            index = Commons.toInt(arguments[0]);
        }
        catch (Exception exception) {
            return new Object[]{false, "Integer expected for 1st argument"};
        }
        Object[][] controlPoints = this.acceleratorSetup.getControlPoints();
        if (index < 0 || index >= controlPoints.length) {
            return new Object[]{false, "Index out of range"};
        }
        assert (controlPoints[index].length == 7);
        return new Object[]{true, controlPoints[index][0], controlPoints[index][1], controlPoints[index][2], controlPoints[index][3], controlPoints[index][4], controlPoints[index][5], controlPoints[index][6]};
    }

    private Object[] getParameters() {
        Object[] results = new Object[this.mapControlParameters.size()];
        int index = 0;
        for (AcceleratorControlParameter acceleratorControlParameter : this.mapControlParameters.values()) {
            results[index++] = new Object[]{acceleratorControlParameter.controlChannel, acceleratorControlParameter.isEnabled, acceleratorControlParameter.threshold, acceleratorControlParameter.description};
        }
        return results;
    }

    @Nonnull
    private Object[] getParametersControlChannels() {
        return this.mapControlParameters.keySet().toArray();
    }

    @Nonnull
    private Object[] parameter(@Nonnull Object[] arguments) {
        int controlChannel;
        if (arguments.length == 0 || arguments.length > 4) {
            return new Object[]{false, "Expecting 1 to 4 arguments: Integer controlChannel, Boolean isEnabled, Double threshold, String description"};
        }
        try {
            controlChannel = Commons.clamp(0, 0xFFFFFFF, Commons.toInt(arguments[0]));
        }
        catch (Exception exception) {
            return new Object[]{false, "Integer expected for 1st argument"};
        }
        AcceleratorControlParameter acceleratorControlParameter = this.mapControlParameters.get(controlChannel);
        if (acceleratorControlParameter == null) {
            acceleratorControlParameter = new AcceleratorControlParameter(controlChannel);
        }
        if (arguments.length == 1) {
            return new Object[]{true, controlChannel, acceleratorControlParameter.isEnabled, acceleratorControlParameter.threshold, acceleratorControlParameter.description};
        }
        if (arguments[1] != null) {
            boolean isEnabled_new;
            try {
                isEnabled_new = Commons.toBool(arguments[1]);
            }
            catch (Exception exception) {
                return new Object[]{false, "Boolean expected for 2nd argument"};
            }
            acceleratorControlParameter.isEnabled = isEnabled_new;
        }
        if (arguments.length >= 3 && arguments[2] != null) {
            double threshold_new;
            try {
                threshold_new = Commons.clamp(0.0, 2.0, Commons.toDouble(arguments[2]));
            }
            catch (Exception exception) {
                return new Object[]{false, "Double expected for 3rd argument"};
            }
            acceleratorControlParameter.threshold = threshold_new;
        }
        if (arguments.length >= 4 && arguments[3] != null) {
            String description_new;
            try {
                description_new = (String)arguments[3];
            }
            catch (Exception exception) {
                return new Object[]{false, "String expected for 4th argument"};
            }
            acceleratorControlParameter.description = description_new;
        }
        this.mapControlParameters.put(controlChannel, acceleratorControlParameter);
        return new Object[]{true, controlChannel, acceleratorControlParameter.isEnabled, acceleratorControlParameter.threshold, acceleratorControlParameter.description};
    }

    @Nonnull
    private Object[] injectionPeriod(@Nonnull Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            double injectionPeriod_new;
            try {
                injectionPeriod_new = Commons.toDouble(arguments[0]);
            }
            catch (Exception exception) {
                return new Double[]{(double)this.injectionPeriodTicks / 20.0};
            }
            this.injectionPeriodTicks = Commons.clamp(1, 18000, (int)Math.round(injectionPeriod_new * 20.0));
        }
        return new Double[]{(double)this.injectionPeriodTicks / 20.0};
    }

    private Object[] state() {
        String units = this.energy_getDisplayUnits();
        long energy = EnergyWrapper.convert(this.acceleratorSetup.energy_getEnergyStored(), units);
        String status = this.getStatusHeaderInPureText();
        return new Object[]{status, this.isEnabled, this.isPowered, energy, this.temperatureCurrent_K, this.acceleratorSetup.temperatureTarget_K};
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "enable": {
                return this.enable(arguments);
            }
            case "getControlPoints": {
                return this.getControlPoints();
            }
            case "getControlPointsCount": {
                return this.getControlPointsCount();
            }
            case "getControlPoint": {
                return this.getControlPoint(arguments);
            }
            case "getParameters": {
                return this.getParameters();
            }
            case "getParametersControlChannels": {
                return this.getParametersControlChannels();
            }
            case "parameter": {
                return this.parameter(arguments);
            }
            case "injectionPeriod": {
                return this.injectionPeriod(arguments);
            }
            case "state": {
                return this.state();
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }

    @Override
    public EnumGlobalRegionType getGlobalRegionType() {
        return EnumGlobalRegionType.ACCELERATOR;
    }

    @Override
    public AxisAlignedBB getGlobalRegionArea() {
        if (this.acceleratorSetup == null) {
            return null;
        }
        return this.acceleratorSetup.getBoundingBox();
    }

    @Override
    public int getMass() {
        if (this.acceleratorSetup != null) {
            return this.acceleratorSetup.getMass();
        }
        return 0;
    }

    @Override
    public double getIsolationRate() {
        return 0.0;
    }

    @Override
    public String getSignatureName() {
        return null;
    }

    @Override
    public boolean onBlockUpdatingInArea(@Nullable Entity entity, BlockPos blockPos, IBlockState blockState) {
        if (this.isDirtyAssembly()) {
            return true;
        }
        if (blockState.func_177230_c() instanceof BlockAbstractAccelerator || blockState.func_177230_c() instanceof BlockCapacitor) {
            if (WarpDriveConfig.LOGGING_ACCELERATOR) {
                WarpDrive.logger.info(String.format("onBlockUpdatingInArea %s %s", blockState, Commons.format(this.field_145850_b, blockPos)));
            }
            this.markDirtyAssembly();
        }
        return true;
    }
}

