/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.building;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.block.BlockAbstractContainer;
import cr0s.warpdrive.block.building.TileEntityShipScanner;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.render.TileEntityShipScannerRenderer;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockShipScanner
extends BlockAbstractContainer {
    public BlockShipScanner(String registryName, EnumTier enumTier) {
        super(registryName, enumTier, Material.field_151573_f);
        this.func_149663_c("warpdrive.building.ship_scanner." + enumTier.func_176610_l());
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockProperties.ACTIVE});
    }

    @Nonnull
    public IBlockState func_176203_a(int metadata) {
        return this.func_176223_P().func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf((metadata & 8) != 0));
    }

    public int func_176201_c(@Nonnull IBlockState blockState) {
        return (Boolean)blockState.func_177229_b((IProperty)BlockProperties.ACTIVE) != false ? 8 : 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void modelInitialisation() {
        super.modelInitialisation();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityShipScanner.class, (TileEntitySpecialRenderer)new TileEntityShipScannerRenderer());
    }

    public boolean func_149751_l(@Nonnull IBlockState blockState) {
        return true;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    @Nonnull
    public TileEntity func_149915_a(@Nonnull World world, int metadata) {
        return new TileEntityShipScanner();
    }

    @Override
    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumHand enumHand, @Nonnull EnumFacing enumFacing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (world.field_72995_K) {
            return super.func_180639_a(world, blockPos, blockState, entityPlayer, enumHand, enumFacing, hitX, hitY, hitZ);
        }
        if (enumHand != EnumHand.MAIN_HAND) {
            return super.func_180639_a(world, blockPos, blockState, entityPlayer, enumHand, enumFacing, hitX, hitY, hitZ);
        }
        ItemStack itemStackHeld = entityPlayer.func_184586_b(enumHand);
        if (itemStackHeld.func_190926_b() && (tileEntity = world.func_175625_s(blockPos)) instanceof TileEntityShipScanner) {
            BlockPos blockPosAbove = blockPos.func_177982_a(0, 2, 0);
            IBlockState blockStateAbove = world.func_180495_p(blockPosAbove);
            if (blockStateAbove.func_177230_c().isAir(blockStateAbove, (IBlockAccess)world, blockPosAbove) || !entityPlayer.func_70093_af()) {
                Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)((TileEntityShipScanner)tileEntity).getStatus());
                return true;
            }
            if (blockStateAbove.func_177230_c() != this) {
                ((TileEntityShipScanner)tileEntity).blockCamouflage = blockStateAbove.func_177230_c();
                ((TileEntityShipScanner)tileEntity).metadataCamouflage = blockStateAbove.func_177230_c().func_176201_c(blockStateAbove);
                ((TileEntityShipScanner)tileEntity).colorMultiplierCamouflage = 0x808080;
                ((TileEntityShipScanner)tileEntity).lightCamouflage = blockStateAbove.getLightValue((IBlockAccess)world, blockPosAbove);
                tileEntity.func_70296_d();
            } else {
                ((TileEntityShipScanner)tileEntity).blockCamouflage = null;
                ((TileEntityShipScanner)tileEntity).metadataCamouflage = 0;
                ((TileEntityShipScanner)tileEntity).colorMultiplierCamouflage = 0;
                ((TileEntityShipScanner)tileEntity).lightCamouflage = 0;
                tileEntity.func_70296_d();
            }
        }
        return super.func_180639_a(world, blockPos, blockState, entityPlayer, enumHand, enumFacing, hitX, hitY, hitZ);
    }
}

