/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.building;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.ISequencerCallbacks;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.TileEntityAbstractMachine;
import cr0s.warpdrive.block.movement.BlockShipCore;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.EnumShipScannerState;
import cr0s.warpdrive.data.JumpBlock;
import cr0s.warpdrive.data.JumpShip;
import cr0s.warpdrive.data.SoundEvents;
import cr0s.warpdrive.data.Transformation;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.event.DeploySequencer;
import cr0s.warpdrive.item.ItemShipToken;
import cr0s.warpdrive.network.PacketHandler;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityShipScanner
extends TileEntityAbstractMachine
implements ISequencerCallbacks {
    private String schematicFileName = "";
    private int targetX;
    private int targetY;
    private int targetZ;
    private byte rotationSteps;
    public Block blockCamouflage;
    public int metadataCamouflage;
    protected int colorMultiplierCamouflage;
    protected int lightCamouflage;
    private AxisAlignedBB aabbRender = null;
    private boolean isShipToken;
    private EnumShipScannerState enumShipScannerState = EnumShipScannerState.IDLE;
    private TileEntityShipCore shipCore = null;
    private int laserTicks = 0;
    private int scanTicks = 0;
    private int deployTicks = 0;
    private String playerName = "";
    private JumpShip jumpShip;
    private int blocksToDeployCount;
    private static final int SHIP_TOKEN_UPDATE_PERIOD_TICKS = 20;
    private static final int SHIP_TOKEN_UPDATE_DELAY_FAILED_PRECONDITION_TICKS = 60;
    private static final int SHIP_TOKEN_UPDATE_DELAY_FAILED_DEPLOY_TICKS = 100;
    private int shipToken_nextUpdate_ticks = 5;
    private static final int SHIP_TOKEN_PLAYER_WARMUP_PERIODS = 5;
    private UUID shipToken_idPlayer = null;
    private int shipToken_countWarmup = 5;
    private String shipToken_nameSchematic = "";

    public TileEntityShipScanner() {
        this.peripheralName = "warpdriveShipScanner";
        this.addMethods(new String[]{"scan", "fileName", "deploy", "state"});
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.aabbRender == null) {
            this.aabbRender = new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - 1.0, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() - 1.0, (double)this.field_174879_c.func_177958_n() + 2.0, (double)this.field_174879_c.func_177956_o() + 2.0, (double)this.field_174879_c.func_177952_p() + 2.0);
        }
        return this.aabbRender;
    }

    @Override
    public void func_73660_a() {
        boolean isSetupDone;
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.updateBlockState(blockState, BlockProperties.ACTIVE, this.enumShipScannerState != EnumShipScannerState.IDLE);
        if (!this.isEnabled) {
            this.enumShipScannerState = EnumShipScannerState.IDLE;
            return;
        }
        boolean bl = isSetupDone = this.targetX != 0 || this.targetY != 0 || this.targetZ != 0;
        if (isSetupDone) {
            if (this.enumShipScannerState == EnumShipScannerState.IDLE) {
                this.checkPlayerForShipToken();
            }
            if (this.enumShipScannerState != EnumShipScannerState.DEPLOYING) {
                this.enumShipScannerState = EnumShipScannerState.IDLE;
                return;
            }
        } else if (this.enumShipScannerState != EnumShipScannerState.DEPLOYING && this.shipCore == null) {
            ++this.laserTicks;
            if (this.laserTicks > 20) {
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(this).translate(0.5), new Vector3(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 5, this.field_174879_c.func_177952_p()).translate(0.5), 1.0f, 0.2f, 0.0f, 40, 0, 100);
                this.laserTicks = 0;
            }
            return;
        }
        switch (this.enumShipScannerState) {
            case IDLE: {
                if (this.shipCore == null) break;
                ++this.laserTicks;
                if (this.laserTicks <= 20) break;
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(this).translate(0.5), new Vector3(this.shipCore).translate(0.5), 0.0f, 1.0f, 0.2f, 40, 0, 100);
                this.laserTicks = 0;
                break;
            }
            case SCANNING: {
                ++this.laserTicks;
                if (this.laserTicks > 5) {
                    this.laserTicks = 0;
                    for (int index = 0; index < 10; ++index) {
                        int randomX = this.shipCore.minX + this.field_145850_b.field_73012_v.nextInt(this.shipCore.maxX - this.shipCore.minX + 1);
                        int randomY = this.shipCore.minY + this.field_145850_b.field_73012_v.nextInt(this.shipCore.maxY - this.shipCore.minY + 1);
                        int randomZ = this.shipCore.minZ + this.field_145850_b.field_73012_v.nextInt(this.shipCore.maxZ - this.shipCore.minZ + 1);
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.LASER_LOW, SoundCategory.BLOCKS, 4.0f, 1.0f);
                        float r = this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat();
                        float g = this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat();
                        float b = this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat();
                        PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(this).translate(0.5), new Vector3(randomX, randomY, randomZ).translate(0.5), r, g, b, 15, 0, 100);
                    }
                }
                ++this.scanTicks;
                if (this.scanTicks <= 20 * (1 + this.shipCore.shipMass / WarpDriveConfig.SS_SCAN_BLOCKS_PER_SECOND)) break;
                this.enumShipScannerState = EnumShipScannerState.IDLE;
                break;
            }
            case DEPLOYING: {
                if (this.deployTicks == 0) {
                    DeploySequencer sequencer = new DeploySequencer(this.jumpShip, this.func_145831_w(), this.isShipToken, this.targetX, this.targetY, this.targetZ, this.rotationSteps);
                    int optimumSpeed = Math.round((float)(this.blocksToDeployCount * WarpDriveConfig.SS_DEPLOY_INTERVAL_TICKS) / 200.0f);
                    int blockToDeployPerTick = Math.max(WarpDriveConfig.SS_DEPLOY_BLOCKS_PER_INTERVAL, Math.min(WarpDriveConfig.G_BLOCKS_PER_TICK / 4, optimumSpeed));
                    if (WarpDrive.isDev && WarpDriveConfig.LOGGING_BUILDING) {
                        WarpDrive.logger.info(String.format("optimumSpeed %d blockToDeployPerTick %d", optimumSpeed, blockToDeployPerTick));
                    }
                    sequencer.setBlocksPerTick(blockToDeployPerTick);
                    sequencer.setRequester(this.playerName, this.isShipToken);
                    sequencer.setEffectSource(new Vector3(this).translate(0.5));
                    sequencer.setCallback(this);
                    sequencer.enable();
                }
                ++this.deployTicks;
                if (!((float)this.deployTicks > 1200.0f)) break;
                WarpDrive.logger.info(this + " Deployment timeout?");
                this.deployTicks = 0;
                this.enumShipScannerState = EnumShipScannerState.IDLE;
                this.shipToken_nextUpdate_ticks = 60;
                break;
            }
            default: {
                WarpDrive.logger.error("Invalid ship scanner state, forcing to IDLE...");
                this.enumShipScannerState = EnumShipScannerState.IDLE;
            }
        }
    }

    @Override
    public void sequencer_finished() {
        switch (this.enumShipScannerState) {
            case DEPLOYING: {
                this.enumShipScannerState = EnumShipScannerState.IDLE;
                if (WarpDriveConfig.LOGGING_BUILDING) {
                    WarpDrive.logger.info(this + " Deployment done");
                }
                this.shipToken_nextUpdate_ticks = 60;
                break;
            }
            default: {
                WarpDrive.logger.error(String.format("%s Invalid ship scanner state, forcing to IDLE...", this));
                this.enumShipScannerState = EnumShipScannerState.IDLE;
            }
        }
    }

    @Override
    protected boolean doScanAssembly(boolean isDirty, WarpDriveText textReason) {
        boolean isValid = super.doScanAssembly(isDirty, textReason);
        IBlockState blockStateShipCoreTooHigh = null;
        TileEntityShipCore tileEntityShipCore = null;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(this.field_174879_c);
        for (int newY = this.field_174879_c.func_177956_o() + 1; newY <= 255; ++newY) {
            TileEntity tileEntity;
            mutableBlockPos.func_185336_p(newY);
            IBlockState blockState = this.field_145850_b.func_180495_p((BlockPos)mutableBlockPos);
            if (!(blockState.func_177230_c() instanceof BlockShipCore) || !((tileEntity = this.field_145850_b.func_175625_s((BlockPos)mutableBlockPos)) instanceof TileEntityShipCore) || tileEntity.func_145837_r() || !((TileEntityShipCore)tileEntity).isAssemblyValid()) continue;
            if (((BlockShipCore)blockState.func_177230_c()).getTier(null).getIndex() > this.enumTier.getIndex()) {
                blockStateShipCoreTooHigh = blockState;
                continue;
            }
            tileEntityShipCore = (TileEntityShipCore)tileEntity;
            break;
        }
        this.shipCore = tileEntityShipCore;
        if (this.shipCore == null) {
            if (blockStateShipCoreTooHigh == null) {
                textReason.append(Commons.getStyleWarning(), "warpdrive.builder.status_line.no_ship_core_in_range", new Object[0]);
            } else {
                textReason.append(Commons.getStyleWarning(), "warpdrive.builder.status_line.ship_is_higher_tier", blockStateShipCoreTooHigh.func_177230_c().func_149732_F(), this.func_145838_q().func_149732_F());
            }
        }
        return isValid && this.shipCore != null;
    }

    private boolean saveShipToSchematic(String fileName, WarpDriveText reason) {
        if (!this.shipCore.isAssemblyValid()) {
            return false;
        }
        int width = this.shipCore.maxX - this.shipCore.minX + 1;
        int length = this.shipCore.maxZ - this.shipCore.minZ + 1;
        int height = this.shipCore.maxY - this.shipCore.minY + 1;
        int size = width * length * height;
        if (width <= 0 || length <= 0 || height <= 0) {
            reason.append(Commons.getStyleWarning(), "warpdrive.scanner.guide.invalid_ship_dimensions", new Object[0]);
            return false;
        }
        NBTTagCompound schematic = new NBTTagCompound();
        schematic.func_74777_a("Width", (short)width);
        schematic.func_74777_a("Length", (short)length);
        schematic.func_74777_a("Height", (short)height);
        schematic.func_74768_a("shipMass", this.shipCore.shipMass);
        schematic.func_74778_a("shipName", this.shipCore.name);
        schematic.func_74768_a("shipVolume", this.shipCore.shipVolume);
        JumpShip ship = new JumpShip();
        ship.world = this.shipCore.func_145831_w();
        ship.core = this.shipCore.func_174877_v();
        ship.dx = this.shipCore.facing.func_82601_c();
        ship.dz = this.shipCore.facing.func_82599_e();
        ship.minX = this.shipCore.minX;
        ship.maxX = this.shipCore.maxX;
        ship.minY = this.shipCore.minY;
        ship.maxY = this.shipCore.maxY;
        ship.minZ = this.shipCore.minZ;
        ship.maxZ = this.shipCore.maxZ;
        ship.shipCore = this.shipCore;
        if (!ship.save(reason)) {
            return false;
        }
        NBTTagCompound tagCompoundShip = new NBTTagCompound();
        ship.writeToNBT(tagCompoundShip);
        schematic.func_74782_a("ship", (NBTBase)tagCompoundShip);
        String[] stringBlockRegistryNames = new String[size];
        byte[] byteMetadatas = new byte[size];
        NBTTagList tileEntitiesList = new NBTTagList();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    TileEntity tileEntity;
                    BlockPos blockPos = new BlockPos(this.shipCore.minX + x, this.shipCore.minY + y, this.shipCore.minZ + z);
                    IBlockState blockState = this.field_145850_b.func_180495_p(blockPos);
                    if (Dictionary.BLOCKS_LEFTBEHIND.contains(blockState.func_177230_c()) || Dictionary.BLOCKS_ANCHOR.contains(blockState.func_177230_c())) {
                        blockState = Blocks.field_150350_a.func_176223_P();
                    }
                    int index = x + (y * length + z) * width;
                    stringBlockRegistryNames[index] = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)blockState.func_177230_c())).toString();
                    byteMetadatas[index] = (byte)blockState.func_177230_c().func_176201_c(blockState);
                    if (blockState.func_177230_c().func_149667_c(Blocks.field_150350_a) || (tileEntity = this.field_145850_b.func_175625_s(blockPos)) == null) continue;
                    try {
                        NBTTagCompound tagTileEntity = new NBTTagCompound();
                        tileEntity.func_189515_b(tagTileEntity);
                        JumpBlock.removeUniqueIDs(tagTileEntity);
                        tagTileEntity.func_74768_a("x", tileEntity.func_174877_v().func_177958_n() - this.shipCore.minX);
                        tagTileEntity.func_74768_a("y", tileEntity.func_174877_v().func_177956_o() - this.shipCore.minY);
                        tagTileEntity.func_74768_a("z", tileEntity.func_174877_v().func_177952_p() - this.shipCore.minZ);
                        tileEntitiesList.func_74742_a((NBTBase)tagTileEntity);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(WarpDrive.printStreamError);
                    }
                }
            }
        }
        schematic.func_74778_a("Materials", "Alpha");
        NBTTagList tagListBlocks = new NBTTagList();
        for (String stringRegistryName : stringBlockRegistryNames) {
            tagListBlocks.func_74742_a((NBTBase)new NBTTagString(stringRegistryName));
        }
        schematic.func_74782_a("Blocks", (NBTBase)tagListBlocks);
        schematic.func_74773_a("Data", byteMetadatas);
        schematic.func_74782_a("Entities", (NBTBase)new NBTTagList());
        schematic.func_74782_a("TileEntities", (NBTBase)tileEntitiesList);
        Commons.writeNBTToFile(fileName, schematic);
        return true;
    }

    private boolean scanShip(WarpDriveText reason) {
        this.enumShipScannerState = EnumShipScannerState.SCANNING;
        File file = new File(WarpDriveConfig.G_SCHEMATICS_LOCATION);
        if (!(file.exists() && file.isDirectory() || file.mkdirs())) {
            return false;
        }
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd_HH'h'mm'm'ss's'SSS");
        String shipName = Commons.sanitizeFileName(this.shipCore.name.replaceAll("[^-~]", "").replaceAll(" ", "_"));
        do {
            Date now = new Date();
            this.schematicFileName = shipName + "_" + sdfDate.format(now);
        } while (new File(WarpDriveConfig.G_SCHEMATICS_LOCATION + "/" + this.schematicFileName + ".schematic").exists());
        if (!this.saveShipToSchematic(WarpDriveConfig.G_SCHEMATICS_LOCATION + "/" + this.schematicFileName + ".schematic", reason)) {
            return false;
        }
        reason.func_150257_a((ITextComponent)new TextComponentString(this.schematicFileName));
        return true;
    }

    private boolean deployShip(String fileName, int offsetX, int offsetY, int offsetZ, byte rotationSteps, boolean isForced, WarpDriveText reason) {
        double dZ;
        double dY;
        this.targetX = this.field_174879_c.func_177958_n() + offsetX;
        this.targetY = this.field_174879_c.func_177956_o() + offsetY;
        this.targetZ = this.field_174879_c.func_177952_p() + offsetZ;
        this.rotationSteps = rotationSteps;
        this.jumpShip = JumpShip.createFromFile(fileName, reason);
        if (this.jumpShip == null) {
            return false;
        }
        this.blocksToDeployCount = this.jumpShip.jumpBlocks.length;
        if (WarpDriveConfig.LOGGING_BUILDING) {
            WarpDrive.logger.info(String.format("%s Loaded %d blocks to deploy", this, this.blocksToDeployCount));
        }
        if (this.jumpShip.maxX - this.jumpShip.minX + 1 > WarpDriveConfig.SHIP_SIZE_MAX_PER_SIDE_BY_TIER[this.enumTier.getIndex()] || this.jumpShip.maxY - this.jumpShip.minY + 1 > WarpDriveConfig.SHIP_SIZE_MAX_PER_SIDE_BY_TIER[this.enumTier.getIndex()] || this.jumpShip.maxZ - this.jumpShip.minZ + 1 > WarpDriveConfig.SHIP_SIZE_MAX_PER_SIDE_BY_TIER[this.enumTier.getIndex()]) {
            reason.append(Commons.getStyleWarning(), "warpdrive.builder.guide.ship_is_higher_tier", new Object[0]);
            return false;
        }
        if (this.jumpShip.actualMass > WarpDriveConfig.SHIP_MASS_MAX_ON_PLANET_SURFACE && CelestialObjectManager.isPlanet(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p())) {
            reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.too_much_mass_for_planet", WarpDriveConfig.SHIP_MASS_MAX_ON_PLANET_SURFACE, this.jumpShip.actualMass);
            return false;
        }
        if (this.jumpShip.actualMass > WarpDriveConfig.SHIP_MASS_MAX_BY_TIER[this.enumTier.getIndex()]) {
            reason.append(Commons.getStyleWarning(), "warpdrive.builder.guide.ship_is_higher_tier", new Object[0]);
            return false;
        }
        double dX = this.field_174879_c.func_177958_n() - this.targetX;
        double distance = MathHelper.func_76133_a((double)(dX * dX + (dY = (double)(this.field_174879_c.func_177956_o() - this.targetY)) * dY + (dZ = (double)(this.field_174879_c.func_177952_p() - this.targetZ)) * dZ));
        if (distance > (double)WarpDriveConfig.SS_MAX_DEPLOY_RADIUS_BLOCKS) {
            reason.append(Commons.getStyleWarning(), "warpdrive.builder.guide.deploying_out_of_range", WarpDriveConfig.SS_MAX_DEPLOY_RADIUS_BLOCKS);
            return false;
        }
        Transformation transformation = new Transformation(this.jumpShip, this.field_145850_b, this.targetX - this.jumpShip.core.func_177958_n(), this.targetY - this.jumpShip.core.func_177956_o(), this.targetZ - this.jumpShip.core.func_177952_p(), rotationSteps);
        BlockPos targetLocation1 = transformation.apply(this.jumpShip.minX, this.jumpShip.minY, this.jumpShip.minZ);
        BlockPos targetLocation2 = transformation.apply(this.jumpShip.maxX, this.jumpShip.maxY, this.jumpShip.maxZ);
        BlockPos targetLocationMin = new BlockPos(Math.min(targetLocation1.func_177958_n(), targetLocation2.func_177958_n()) - 1, Math.max(0, Math.min(targetLocation1.func_177956_o(), targetLocation2.func_177956_o()) - 1), Math.min(targetLocation1.func_177952_p(), targetLocation2.func_177952_p()) - 1);
        BlockPos targetLocationMax = new BlockPos(Math.max(targetLocation1.func_177958_n(), targetLocation2.func_177958_n()) + 1, Math.min(255, Math.max(targetLocation1.func_177956_o(), targetLocation2.func_177956_o()) + 1), Math.max(targetLocation1.func_177952_p(), targetLocation2.func_177952_p()) + 1);
        if (isForced) {
            if (!TileEntityShipScanner.isShipCoreClear(this.field_145850_b, new BlockPos(this.targetX, this.targetY, this.targetZ), this.playerName, reason)) {
                if (WarpDriveConfig.LOGGING_BUILDING) {
                    WarpDrive.logger.info(String.format("Deployment collision detected at (%d %d %d): no room for Ship core", this.targetX, this.targetY, this.targetZ));
                }
                return false;
            }
            for (int x = targetLocationMin.func_177958_n(); x <= targetLocationMax.func_177958_n(); ++x) {
                for (int y = targetLocationMin.func_177956_o(); y <= targetLocationMax.func_177956_o(); ++y) {
                    for (int z = targetLocationMin.func_177952_p(); z <= targetLocationMax.func_177952_p(); ++z) {
                        this.field_145850_b.func_175698_g(new BlockPos(x, y, z));
                    }
                }
            }
        } else {
            int occupiedBlockCount = 0;
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (int x = targetLocationMin.func_177958_n(); x <= targetLocationMax.func_177958_n(); ++x) {
                for (int y = targetLocationMin.func_177956_o(); y <= targetLocationMax.func_177956_o(); ++y) {
                    for (int z = targetLocationMin.func_177952_p(); z <= targetLocationMax.func_177952_p(); ++z) {
                        mutableBlockPos.func_181079_c(x, y, z);
                        if (this.field_145850_b.func_175623_d((BlockPos)mutableBlockPos)) continue;
                        if (++occupiedBlockCount == 1 || occupiedBlockCount <= 100 && this.field_145850_b.field_73012_v.nextInt(10) == 0) {
                            PacketHandler.sendSpawnParticlePacket(this.field_145850_b, "explosionLarge", (byte)5, new Vector3((BlockPos)mutableBlockPos), new Vector3(0.0, 0.0, 0.0), 0.7f + 0.25f * this.field_145850_b.field_73012_v.nextFloat(), 0.7f + 0.25f * this.field_145850_b.field_73012_v.nextFloat(), 0.2f + 0.3f * this.field_145850_b.field_73012_v.nextFloat(), 0.1f + 0.1f * this.field_145850_b.field_73012_v.nextFloat(), 0.1f + 0.2f * this.field_145850_b.field_73012_v.nextFloat(), 0.1f + 0.3f * this.field_145850_b.field_73012_v.nextFloat(), WarpDriveConfig.SS_MAX_DEPLOY_RADIUS_BLOCKS);
                        }
                        if (!WarpDriveConfig.LOGGING_BUILDING) continue;
                        WarpDrive.logger.info(String.format("Deployment collision detected %s", Commons.format(this.field_145850_b, x, y, z)));
                    }
                }
            }
            if (occupiedBlockCount > 0) {
                reason.append(Commons.getStyleWarning(), "warpdrive.builder.guide.deployment_area_occupied_by_blocks", occupiedBlockCount);
                return false;
            }
        }
        this.deployTicks = 0;
        this.isShipToken = isForced;
        this.enumShipScannerState = EnumShipScannerState.DEPLOYING;
        reason.append(Commons.getStyleCorrect(), "warpdrive.builder.guide.deploying_ship", fileName);
        return true;
    }

    private static boolean isShipCoreClear(@Nonnull World world, BlockPos blockPos, String nameRequestingPlayer, WarpDriveText reason) {
        IBlockState blockState = world.func_180495_p(blockPos);
        if (blockState.func_177230_c().isAir(blockState, (IBlockAccess)world, blockPos)) {
            return true;
        }
        if (!(blockState.func_177230_c() instanceof BlockShipCore)) {
            PacketHandler.sendSpawnParticlePacket(world, "explosionLarge", (byte)5, new Vector3(blockPos), new Vector3(0.0, 0.0, 0.0), 0.7f + 0.25f * world.field_73012_v.nextFloat(), 0.7f + 0.25f * world.field_73012_v.nextFloat(), 0.2f + 0.3f * world.field_73012_v.nextFloat(), 0.1f + 0.1f * world.field_73012_v.nextFloat(), 0.1f + 0.2f * world.field_73012_v.nextFloat(), 0.1f + 0.3f * world.field_73012_v.nextFloat(), WarpDriveConfig.SS_MAX_DEPLOY_RADIUS_BLOCKS);
            reason.append(Commons.getStyleWarning(), "warpdrive.builder.guide.deployment_area_occupied_by_block", blockState.func_177230_c().func_149732_F(), blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
            return false;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (!(tileEntity instanceof TileEntityShipCore)) {
            reason.append(Commons.getStyleWarning(), "warpdrive.builder.guide.deployment_area_corrupted_tile_entity", tileEntity);
            reason.append(Commons.getStyleCommand(), "warpdrive.builder.guide.contact_an_admin", Commons.format(world, blockPos));
            WarpDrive.logger.error(reason.toString());
            PacketHandler.sendSpawnParticlePacket(world, "explosionLarge", (byte)5, new Vector3(blockPos), new Vector3(0.0, 0.0, 0.0), 0.7f + 0.25f * world.field_73012_v.nextFloat(), 0.7f + 0.25f * world.field_73012_v.nextFloat(), 0.2f + 0.3f * world.field_73012_v.nextFloat(), 0.1f + 0.1f * world.field_73012_v.nextFloat(), 0.1f + 0.2f * world.field_73012_v.nextFloat(), 0.1f + 0.3f * world.field_73012_v.nextFloat(), WarpDriveConfig.SS_MAX_DEPLOY_RADIUS_BLOCKS);
            return false;
        }
        TileEntityShipCore tileEntityShipCore = (TileEntityShipCore)tileEntity;
        String namePlayersAboard = tileEntityShipCore.getAllPlayersInArea();
        if (!namePlayersAboard.isEmpty()) {
            reason.append(Commons.getStyleWarning(), "warpdrive.builder.guide.deployment_area_with_active_crew", namePlayersAboard);
            reason.append(Commons.getStyleCommand(), "warpdrive.builder.guide.wait_your_turn", new Object[0]);
            return false;
        }
        if (tileEntityShipCore.isBusy()) {
            reason.append(Commons.getStyleWarning(), "warpdrive.builder.guide.deployment_area_is_busy", new Object[0]);
            reason.append(Commons.getStyleCommand(), "warpdrive.builder.guide.wait_your_turn", new Object[0]);
            return false;
        }
        String nameOnlineCrew = tileEntityShipCore.getFirstOnlineCrew();
        if (nameOnlineCrew == null || nameOnlineCrew.isEmpty()) {
            return true;
        }
        if (nameOnlineCrew.equals(nameRequestingPlayer)) {
            reason.append(Commons.getStyleWarning(), "warpdrive.builder.guide.deployment_area_occupied_by_your_ship1", nameOnlineCrew);
            reason.append(Commons.getStyleCommand(), "warpdrive.builder.guide.deployment_area_occupied_by_your_ship2", new Object[0]);
            return false;
        }
        reason.append(Commons.getStyleWarning(), "warpdrive.builder.guide.deployment_area_occupied_by_online_player1", nameOnlineCrew);
        reason.append(Commons.getStyleCommand(), "warpdrive.builder.guide.deployment_area_occupied_by_online_player2", new Object[0]);
        return false;
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.schematicFileName = tagCompound.func_74779_i("schematic");
        this.targetX = tagCompound.func_74762_e("targetX");
        this.targetY = tagCompound.func_74762_e("targetY");
        this.targetZ = tagCompound.func_74762_e("targetZ");
        this.rotationSteps = tagCompound.func_74771_c("rotationSteps");
        if (tagCompound.func_74764_b("camouflageBlock")) {
            try {
                this.blockCamouflage = Block.func_149684_b((String)tagCompound.func_74779_i("camouflageBlock"));
                this.metadataCamouflage = tagCompound.func_74771_c("camouflageMeta");
                this.colorMultiplierCamouflage = tagCompound.func_74762_e("camouflageColorMultiplier");
                this.lightCamouflage = tagCompound.func_74771_c("camouflageLight");
                if (Dictionary.BLOCKS_NOCAMOUFLAGE.contains(this.blockCamouflage)) {
                    this.blockCamouflage = null;
                    this.metadataCamouflage = 0;
                    this.colorMultiplierCamouflage = 0;
                    this.lightCamouflage = 0;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(WarpDrive.printStreamError);
            }
        } else {
            this.blockCamouflage = null;
            this.metadataCamouflage = 0;
            this.colorMultiplierCamouflage = 0;
            this.lightCamouflage = 0;
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        tagCompound.func_74778_a("schematic", this.schematicFileName);
        tagCompound.func_74768_a("targetX", this.targetX);
        tagCompound.func_74768_a("targetY", this.targetY);
        tagCompound.func_74768_a("targetZ", this.targetZ);
        tagCompound.func_74774_a("rotationSteps", this.rotationSteps);
        if (this.blockCamouflage != null) {
            assert (this.blockCamouflage.getRegistryName() != null);
            tagCompound.func_74778_a("camouflageBlock", this.blockCamouflage.getRegistryName().toString());
            tagCompound.func_74774_a("camouflageMeta", (byte)this.metadataCamouflage);
            tagCompound.func_74768_a("camouflageColorMultiplier", this.colorMultiplierCamouflage);
            tagCompound.func_74774_a("camouflageLight", (byte)this.lightCamouflage);
        }
        return tagCompound;
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] scan(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.scan();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] filename(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.filename();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] deploy(Context context, Arguments arguments) {
        return this.deploy(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] state(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.state();
    }

    @Nonnull
    private Object[] scan() {
        if (this.enumShipScannerState != EnumShipScannerState.IDLE) {
            return new Object[]{false, "Already active"};
        }
        if (this.shipCore == null) {
            return new Object[]{false, "No ship core in range"};
        }
        WarpDriveText reason = new WarpDriveText();
        boolean success = this.scanShip(reason);
        return new Object[]{success, 3, Commons.removeFormatting(reason.func_150260_c())};
    }

    @Nonnull
    private Object[] filename() {
        if (this.enumShipScannerState != EnumShipScannerState.IDLE && !this.schematicFileName.isEmpty()) {
            if (this.enumShipScannerState == EnumShipScannerState.DEPLOYING) {
                return new Object[]{false, "Deployment in progress. Please wait..."};
            }
            return new Object[]{false, "Scan in progress. Please wait..."};
        }
        return new Object[]{true, this.schematicFileName};
    }

    @Nonnull
    private Object[] deploy(Object[] arguments) {
        byte rotationSteps;
        int z;
        int y;
        int x;
        String fileName;
        if (arguments == null || arguments.length != 5) {
            return new Object[]{false, "Invalid arguments count, you need <.schematic file name>, <offsetX>, <offsetY>, <offsetZ>, <rotationSteps>!"};
        }
        try {
            fileName = Commons.toString(arguments[0]);
            x = Commons.toInt(arguments[1]);
            y = Commons.toInt(arguments[2]);
            z = Commons.toInt(arguments[3]);
            int intRotationSteps = Commons.toInt(arguments[4]);
            rotationSteps = (byte)((1024 + intRotationSteps) % 4);
        }
        catch (Exception exception) {
            if (WarpDriveConfig.LOGGING_LUA) {
                WarpDrive.logger.info(String.format("%s Invalid arguments to deploy(): %s", this, Commons.format(arguments)));
            }
            return new Object[]{false, "Invalid argument format, you need <.schematic file name>, <offsetX>, <offsetY>, <offsetZ>, <rotationSteps>!"};
        }
        if (this.enumShipScannerState != EnumShipScannerState.IDLE) {
            return new Object[]{false, String.format("Invalid state, expecting IDLE, found %s", this.enumShipScannerState.toString())};
        }
        WarpDriveText reason = new WarpDriveText();
        boolean isSuccess = this.deployShip(fileName, x, y, z, rotationSteps, false, reason);
        EntityPlayer entityPlayer = this.field_145850_b.func_184137_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 8.0, false);
        this.playerName = entityPlayer != null ? entityPlayer.func_70005_c_() : "";
        return new Object[]{isSuccess, Commons.removeFormatting(reason.func_150260_c())};
    }

    @Nonnull
    private Object[] state() {
        switch (this.enumShipScannerState) {
            default: {
                return new Object[]{false, "IDLE", 0, 0};
            }
            case SCANNING: {
                return new Object[]{true, "Scanning", 0, 0};
            }
            case DEPLOYING: 
        }
        return new Object[]{true, "Deploying", 0, this.blocksToDeployCount};
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "scan": {
                return this.scan();
            }
            case "fileName": {
                return this.filename();
            }
            case "deploy": {
                return this.deploy(arguments);
            }
            case "state": {
                return this.state();
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }

    private void checkPlayerForShipToken() {
        int slotIndex;
        --this.shipToken_nextUpdate_ticks;
        if (this.shipToken_nextUpdate_ticks > 0) {
            return;
        }
        this.shipToken_nextUpdate_ticks = 20;
        AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - 1.0, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() - 1.0, (double)this.field_174879_c.func_177958_n() + 1.99, (double)this.field_174879_c.func_177956_o() + 5.0, (double)this.field_174879_c.func_177952_p() + 1.99);
        List list = this.field_145850_b.func_72839_b(null, axisalignedbb);
        ArrayList<EntityPlayer> entityPlayers = new ArrayList<EntityPlayer>(10);
        for (Object object : list) {
            if (!(object instanceof EntityPlayer)) continue;
            entityPlayers.add((EntityPlayer)object);
        }
        if (entityPlayers.isEmpty()) {
            this.shipToken_idPlayer = null;
            return;
        }
        if (entityPlayers.size() > 1) {
            for (EntityPlayer entityPlayer : entityPlayers) {
                Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.builder.guide.too_many_players", new Object[0]));
                this.shipToken_nextUpdate_ticks = 60;
            }
            this.shipToken_idPlayer = null;
            return;
        }
        EntityPlayer entityPlayer = (EntityPlayer)entityPlayers.get(0);
        ItemStack itemStack = null;
        for (slotIndex = 0; slotIndex < entityPlayer.field_71071_by.func_70302_i_() && ((itemStack = entityPlayer.field_71071_by.func_70301_a(slotIndex)).func_190926_b() || itemStack.func_77973_b() != WarpDrive.itemShipToken || itemStack.func_190916_E() < 1); ++slotIndex) {
        }
        if (itemStack == null || slotIndex >= entityPlayer.field_71071_by.func_70302_i_()) {
            Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.builder.guide.no_ship_token", new Object[0]));
            this.shipToken_nextUpdate_ticks = 60;
            this.shipToken_idPlayer = null;
            return;
        }
        if (entityPlayer.func_110124_au() != this.shipToken_idPlayer || !this.shipToken_nameSchematic.equals(ItemShipToken.getSchematicName(itemStack))) {
            this.shipToken_idPlayer = entityPlayer.func_110124_au();
            this.shipToken_countWarmup = 6;
            this.shipToken_nameSchematic = ItemShipToken.getSchematicName(itemStack);
            Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.builder.guide.ship_token_detected", this.shipToken_nameSchematic));
        }
        --this.shipToken_countWarmup;
        if (this.shipToken_countWarmup > 0) {
            Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleNormal(), "warpdrive.builder.guide.ship_materialization_countdown", this.shipToken_nameSchematic, this.shipToken_countWarmup));
            return;
        }
        this.shipToken_idPlayer = null;
        this.playerName = entityPlayer.func_70005_c_();
        WarpDriveText reason = new WarpDriveText();
        boolean isSuccess = this.deployShip(ItemShipToken.getSchematicName(itemStack), this.targetX - this.field_174879_c.func_177958_n(), this.targetY - this.field_174879_c.func_177956_o(), this.targetZ - this.field_174879_c.func_177952_p(), this.rotationSteps, true, reason);
        if (!isSuccess) {
            Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)reason);
            this.shipToken_nextUpdate_ticks = 100;
            return;
        }
        Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)reason);
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            itemStack.func_190918_g(1);
            entityPlayer.field_71071_by.func_70299_a(slotIndex, itemStack);
            entityPlayer.field_71071_by.func_70296_d();
        }
    }
}

