/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.collection;

import cr0s.warpdrive.CommonProxy;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.ExceptionChunkNotLoaded;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.collection.BlockLaserTreeFarm;
import cr0s.warpdrive.block.collection.TileEntityAbstractMiner;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.BlockStatePos;
import cr0s.warpdrive.data.EnergyWrapper;
import cr0s.warpdrive.data.EnumComponentType;
import cr0s.warpdrive.data.EnumLaserTreeFarmMode;
import cr0s.warpdrive.data.EnumTaskResult;
import cr0s.warpdrive.data.InventoryWrapper;
import cr0s.warpdrive.data.SoundEvents;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.item.ItemComponent;
import cr0s.warpdrive.network.PacketHandler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.Optional;

public class TileEntityLaserTreeFarm
extends TileEntityAbstractMiner {
    private int radiusX_requested = WarpDriveConfig.TREE_FARM_totalMaxRadius;
    private int radiusZ_requested = WarpDriveConfig.TREE_FARM_totalMaxRadius;
    private boolean breakLeaves = false;
    private boolean tapTrees = false;
    private static final int STATE_IDLE = 0;
    private static final int STATE_WARMING_UP = 1;
    private static final int STATE_SCANNING = 2;
    private static final int STATE_PLANTING = 3;
    private static final int STATE_HARVESTING = 4;
    private int currentState = 0;
    private int radiusX_actual = this.radiusX_requested;
    private int radiusZ_actual = this.radiusZ_requested;
    private AxisAlignedBB axisAlignedBBSoil = null;
    private AxisAlignedBB axisAlignedBBScan = null;
    private int maxDistance = 0;
    private int energyScanning;
    private int energyTappingWetSpot;
    private int energyTappingRubberLog;
    private int energyHarvestingLog;
    private int energyHarvestingLeaf;
    private int energyPlanting;
    private boolean isPowered = false;
    private int totalHarvested = 0;
    private int tickCurrentTask = 0;
    private ArrayList<BlockPos> blockPosSoils = new ArrayList(0);
    private int indexSoil = 0;
    private ArrayList<BlockStatePos> blockPosValuables = new ArrayList(0);
    private int indexValuable = 0;

    public TileEntityLaserTreeFarm() {
        this.laserOutputSide = EnumFacing.UP;
        this.peripheralName = "warpdriveLaserTreeFarm";
        this.addMethods(new String[]{"start", "stop", "radius", "state", "breakLeaves", "silktouch", "tapTrees"});
        this.CC_scripts = Arrays.asList("farm", "stop");
        this.doRequireUpgradeToInterface();
        this.laserMedium_maxCount = WarpDriveConfig.TREE_FARM_MAX_MEDIUMS_COUNT;
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        if (this.currentState == 3 || this.currentState == 4) {
            this.updateParameters();
            try {
                this.blockPosSoils = TileEntityLaserTreeFarm.calculate_getSoilPositions((IBlockAccess)this.field_145850_b, this.axisAlignedBBSoil);
                this.indexSoil = 0;
                this.blockPosValuables = TileEntityLaserTreeFarm.calculate_getValuableStatePositions((IBlockAccess)this.field_145850_b, this.axisAlignedBBScan, this.breakLeaves, this.maxDistance, this::comparatorSortLogsAndLeaves);
                this.indexValuable = 0;
            }
            catch (Exception exception) {
                exception.printStackTrace(WarpDrive.printStreamError);
                WarpDrive.logger.error(String.format("%s Calculation failed, please report to mod author %s", this, exception.getMessage()));
                this.currentState = 2;
                this.tickCurrentTask = 2;
            }
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!this.isEnabled) {
            this.currentState = 0;
            this.tickCurrentTask = 0;
            this.updateBlockState(blockState, BlockLaserTreeFarm.MODE, EnumLaserTreeFarmMode.INACTIVE);
            if (!this.isInterfaceEnabled()) {
                this.breakLeaves = true;
                this.enableSilktouch = false;
                this.tapTrees = true;
                this.setIsEnabled(true);
            }
            return;
        }
        --this.tickCurrentTask;
        this.updateParameters();
        if (this.currentState == 0) {
            this.totalHarvested = 0;
            this.currentState = 1;
            this.tickCurrentTask = 0;
        } else {
            if (this.currentState == 1) {
                if (this.isPowered) {
                    this.updateBlockState(blockState, BlockLaserTreeFarm.MODE, EnumLaserTreeFarmMode.SCANNING_POWERED);
                } else {
                    this.updateBlockState(blockState, BlockLaserTreeFarm.MODE, EnumLaserTreeFarmMode.SCANNING_LOW_POWER);
                }
                if (this.tickCurrentTask >= 0) {
                    return;
                }
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                IBlockState blockStateMinMin = Commons.getBlockState_noChunkLoading((IBlockAccess)this.field_145850_b, (BlockPos)mutableBlockPos.func_189532_c(this.axisAlignedBBScan.field_72340_a, this.axisAlignedBBScan.field_72338_b, this.axisAlignedBBScan.field_72339_c));
                IBlockState blockStateMinMax = Commons.getBlockState_noChunkLoading((IBlockAccess)this.field_145850_b, (BlockPos)mutableBlockPos.func_189532_c(this.axisAlignedBBScan.field_72340_a, this.axisAlignedBBScan.field_72338_b, this.axisAlignedBBScan.field_72334_f));
                IBlockState blockStateMaxMin = Commons.getBlockState_noChunkLoading((IBlockAccess)this.field_145850_b, (BlockPos)mutableBlockPos.func_189532_c(this.axisAlignedBBScan.field_72336_d, this.axisAlignedBBScan.field_72337_e, this.axisAlignedBBScan.field_72339_c));
                IBlockState blockStateMaxMax = Commons.getBlockState_noChunkLoading((IBlockAccess)this.field_145850_b, (BlockPos)mutableBlockPos.func_189532_c(this.axisAlignedBBScan.field_72336_d, this.axisAlignedBBScan.field_72337_e, this.axisAlignedBBScan.field_72334_f));
                if (blockStateMinMin == null || blockStateMinMax == null || blockStateMaxMin == null || blockStateMaxMax == null) {
                    this.currentState = 1;
                    this.tickCurrentTask = WarpDriveConfig.TREE_FARM_WARM_UP_DELAY_TICKS;
                    return;
                }
                IBlockState blockStateAbove = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a());
                Block blockAbove = blockStateAbove.func_177230_c();
                if (!(Dictionary.isLog(blockAbove) || Dictionary.isLeaf(blockAbove) || blockAbove.isAir(blockStateAbove, (IBlockAccess)this.field_145850_b, this.field_174879_c.func_177984_a()))) {
                    PacketHandler.sendSpawnParticlePacket(this.field_145850_b, "jammed", (byte)5, new Vector3((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5), new Vector3(0.0, 0.0, 0.0), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 32);
                    this.currentState = 1;
                    this.tickCurrentTask = WarpDriveConfig.TREE_FARM_WARM_UP_DELAY_TICKS;
                    return;
                }
                this.isPowered = this.laserMedium_consumeExactly(this.energyScanning, false);
                if (!this.isPowered) {
                    this.currentState = 1;
                    this.tickCurrentTask = WarpDriveConfig.TREE_FARM_WARM_UP_DELAY_TICKS;
                    return;
                }
                int age = Math.max(40, 2 * WarpDriveConfig.TREE_FARM_SCAN_DELAY_TICKS);
                int y = this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextInt(9);
                PacketHandler.sendScanningPacket(this.field_145850_b, this.field_174879_c.func_177958_n() - this.radiusX_actual, y, this.field_174879_c.func_177952_p() - this.radiusZ_actual, this.field_174879_c.func_177958_n() + this.radiusX_actual + 1, y, this.field_174879_c.func_177952_p() + this.radiusZ_actual + 1, 0.3f, 0.0f, 1.0f, age);
                if (WarpDriveConfig.LOGGING_COLLECTION) {
                    WarpDrive.logger.debug("Start scanning");
                }
                this.isDirty.set(true);
                this.currentState = 2;
                this.tickCurrentTask = WarpDriveConfig.TREE_FARM_SCAN_DELAY_TICKS;
                return;
            }
            if (this.currentState == 2) {
                if (this.isPowered) {
                    this.updateBlockState(blockState, BlockLaserTreeFarm.MODE, EnumLaserTreeFarmMode.SCANNING_POWERED);
                } else {
                    this.updateBlockState(blockState, BlockLaserTreeFarm.MODE, EnumLaserTreeFarmMode.SCANNING_LOW_POWER);
                }
                if (!this.isCalculated()) {
                    this.calculation_start();
                    return;
                }
                if (this.tickCurrentTask >= 0) {
                    return;
                }
                if (WarpDriveConfig.LOGGING_COLLECTION) {
                    WarpDrive.logger.debug("Scanning done");
                }
                if (!this.blockPosSoils.isEmpty() && !InventoryWrapper.getConnectedInventories(this.field_145850_b, this.field_174879_c).isEmpty()) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.LASER_HIGH, SoundCategory.BLOCKS, 4.0f, 1.0f);
                    this.currentState = 3;
                    this.tickCurrentTask = WarpDriveConfig.TREE_FARM_PLANT_DELAY_TICKS;
                    return;
                }
                if (!this.blockPosValuables.isEmpty()) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.LASER_HIGH, SoundCategory.BLOCKS, 4.0f, 1.0f);
                    this.currentState = 4;
                    this.tickCurrentTask = WarpDriveConfig.TREE_FARM_HARVEST_LOG_DELAY_TICKS;
                    return;
                }
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.LASER_LOW, SoundCategory.BLOCKS, 4.0f, 1.0f);
                this.currentState = 1;
                this.tickCurrentTask = WarpDriveConfig.TREE_FARM_WARM_UP_DELAY_TICKS;
                return;
            }
            if (this.currentState == 3) {
                if (this.isPowered) {
                    this.updateBlockState(blockState, BlockLaserTreeFarm.MODE, EnumLaserTreeFarmMode.PLANTING_POWERED);
                } else {
                    this.updateBlockState(blockState, BlockLaserTreeFarm.MODE, EnumLaserTreeFarmMode.PLANTING_LOW_POWER);
                }
                if (this.tickCurrentTask >= 0) {
                    return;
                }
                if (WarpDriveConfig.LOGGING_COLLECTION) {
                    WarpDrive.logger.debug("Planting");
                }
                if (this.indexSoil >= this.blockPosSoils.size()) {
                    this.currentState = 4;
                    this.tickCurrentTask = WarpDriveConfig.TREE_FARM_HARVEST_LOG_DELAY_TICKS;
                    return;
                }
                BlockPos blockPosSoil = this.blockPosSoils.get(this.indexSoil);
                IBlockState blockStateSoil = this.field_145850_b.func_180495_p(blockPosSoil);
                ++this.indexSoil;
                switch (this.doPlanting(blockPosSoil, blockStateSoil)) {
                    case CONTINUE: {
                        break;
                    }
                    case RETRY: {
                        this.tickCurrentTask = WarpDriveConfig.TREE_FARM_WARM_UP_DELAY_TICKS;
                        --this.indexSoil;
                        break;
                    }
                    case SKIP: {
                        this.indexSoil = this.blockPosSoils.size();
                    }
                }
            } else if (this.currentState == 4) {
                if (this.isPowered) {
                    this.updateBlockState(blockState, BlockLaserTreeFarm.MODE, EnumLaserTreeFarmMode.FARMING_POWERED);
                } else {
                    this.updateBlockState(blockState, BlockLaserTreeFarm.MODE, EnumLaserTreeFarmMode.FARMING_LOW_POWER);
                }
                if (this.tickCurrentTask >= 0) {
                    return;
                }
                if (WarpDriveConfig.LOGGING_COLLECTION) {
                    WarpDrive.logger.debug("Harvest/tap tick");
                }
                if (this.indexValuable >= this.blockPosValuables.size()) {
                    this.currentState = 1;
                    this.tickCurrentTask = 0;
                    return;
                }
                BlockStatePos blockStatePosValuable = this.blockPosValuables.get(this.indexValuable);
                BlockPos blockPosValuable = blockStatePosValuable.blockPos;
                IBlockState blockStateValuable = this.field_145850_b.func_180495_p(blockPosValuable);
                ++this.indexValuable;
                if (blockStateValuable.func_177230_c() != blockStatePosValuable.blockState.func_177230_c()) {
                    return;
                }
                switch (this.doHarvesting(blockPosValuable, blockStateValuable)) {
                    case CONTINUE: {
                        break;
                    }
                    case RETRY: {
                        this.tickCurrentTask = WarpDriveConfig.TREE_FARM_WARM_UP_DELAY_TICKS;
                        --this.indexValuable;
                        break;
                    }
                    case SKIP: {
                        this.indexValuable = this.blockPosValuables.size();
                    }
                }
            }
        }
    }

    private EnumTaskResult doPlanting(BlockPos blockPosSoil, IBlockState blockStateSoil) {
        BlockPos blockPosPlant = blockPosSoil.func_177982_a(0, 1, 0);
        Collection<Object> inventories = InventoryWrapper.getConnectedInventories(this.field_145850_b, this.field_174879_c);
        int indexSlotPlant = 0;
        int countPlantable = 0;
        ItemStack itemStackPlant = null;
        IBlockState blockStatePlant = null;
        Object inventoryPlant = null;
        for (Object inventoryLoop : inventories) {
            indexSlotPlant = 0;
            while (indexSlotPlant < InventoryWrapper.getSize(inventoryLoop) && blockStatePlant == null) {
                itemStackPlant = InventoryWrapper.getStackInSlot(inventoryLoop, indexSlotPlant);
                if (itemStackPlant.func_190926_b()) {
                    ++indexSlotPlant;
                    continue;
                }
                Block blockFromItem = Block.func_149634_a((Item)itemStackPlant.func_77973_b());
                if (!(itemStackPlant.func_77973_b() instanceof IPlantable) && !(blockFromItem instanceof IPlantable)) {
                    ++indexSlotPlant;
                    continue;
                }
                ++countPlantable;
                IPlantable plantable = (IPlantable)(itemStackPlant.func_77973_b() instanceof IPlantable ? itemStackPlant.func_77973_b() : blockFromItem);
                if (itemStackPlant.func_77973_b() instanceof ItemBlock) {
                    ItemBlock itemBlock = (ItemBlock)itemStackPlant.func_77973_b();
                    int metadata = itemBlock.func_77647_b(itemStackPlant.func_77960_j());
                    Block block = itemBlock.func_179223_d();
                    EntityPlayer playerFake = CommonProxy.getFakePlayer(null, (WorldServer)this.field_145850_b, blockPosPlant);
                    blockStatePlant = block.getStateForPlacement(this.field_145850_b, blockPosPlant, EnumFacing.UP, 0.5f, 0.0f, 0.5f, metadata, (EntityLivingBase)playerFake, EnumHand.MAIN_HAND);
                } else {
                    blockStatePlant = plantable.getPlant((IBlockAccess)this.field_145850_b, blockPosPlant);
                }
                if (WarpDriveConfig.LOGGING_COLLECTION) {
                    WarpDrive.logger.info(String.format("Slot %d as %s which plantable %s as block %s", indexSlotPlant, itemStackPlant, plantable, blockStatePlant));
                }
                if (!blockStateSoil.func_177230_c().canSustainPlant(blockStateSoil, (IBlockAccess)this.field_145850_b, blockPosSoil, EnumFacing.UP, plantable)) {
                    blockStatePlant = null;
                    ++indexSlotPlant;
                    continue;
                }
                if (!blockStatePlant.func_177230_c().func_176196_c(this.field_145850_b, blockPosPlant)) {
                    blockStatePlant = null;
                    ++indexSlotPlant;
                    continue;
                }
                inventoryPlant = inventoryLoop;
            }
            if (blockStatePlant == null) continue;
            break;
        }
        if (countPlantable <= 0) {
            return EnumTaskResult.SKIP;
        }
        if (blockStatePlant == null || itemStackPlant.func_190926_b() || inventoryPlant == null) {
            if (WarpDriveConfig.LOGGING_COLLECTION) {
                WarpDrive.logger.debug("No sapling found");
            }
            return EnumTaskResult.SKIP;
        }
        if (this.isBlockPlaceCanceled(null, this.field_145850_b, blockPosPlant, blockStatePlant)) {
            if (WarpDriveConfig.LOGGING_COLLECTION) {
                WarpDrive.logger.info(String.format("%s Planting cancelled %s", this, Commons.format(this.field_145850_b, blockPosPlant)));
            }
            return EnumTaskResult.CONTINUE;
        }
        this.isPowered = this.laserMedium_consumeExactly(this.energyPlanting, false);
        if (!this.isPowered) {
            return EnumTaskResult.RETRY;
        }
        InventoryWrapper.decrStackSize(inventoryPlant, indexSlotPlant, 1);
        int age = Math.max(10, Math.round((4.0f + this.field_145850_b.field_73012_v.nextFloat()) * (float)WarpDriveConfig.MINING_LASER_MINE_DELAY_TICKS));
        PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(blockPosPlant).translate(0.5), 0.2f, 0.7f, 0.4f, age, 0, 50);
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.LASER_LOW, SoundCategory.BLOCKS, 4.0f, 1.0f);
        this.field_145850_b.func_180501_a(blockPosPlant, blockStatePlant, 3);
        this.tickCurrentTask = WarpDriveConfig.TREE_FARM_PLANT_DELAY_TICKS;
        return EnumTaskResult.CONTINUE;
    }

    private EnumTaskResult doHarvesting(BlockPos blockPosValuable, IBlockState blockStateValuable) {
        if (this.isBlockBreakCanceled(null, this.field_145850_b, blockPosValuable)) {
            if (WarpDriveConfig.LOGGING_COLLECTION) {
                WarpDrive.logger.info(String.format("%s Harvesting cancelled %s", this, Commons.format(this.field_145850_b, blockPosValuable)));
            }
            return EnumTaskResult.CONTINUE;
        }
        boolean isLog = Dictionary.isLog(blockStateValuable.func_177230_c());
        if (isLog && this.tapTrees) {
            if (blockStateValuable.func_177230_c().func_149667_c(WarpDriveConfig.IC2_rubberWood)) {
                int metadata = blockStateValuable.func_177230_c().func_176201_c(blockStateValuable);
                if (metadata >= 2 && metadata <= 5) {
                    if (WarpDriveConfig.LOGGING_COLLECTION) {
                        WarpDrive.logger.info(String.format("Tapping rubber wood wet-spot %s (%d) %s", blockStateValuable, metadata, Commons.format(this.field_145850_b, blockPosValuable)));
                    }
                    this.isPowered = this.laserMedium_consumeExactly(this.energyTappingWetSpot, false);
                    if (!this.isPowered) {
                        return EnumTaskResult.RETRY;
                    }
                    ItemStack itemStackResin = WarpDriveConfig.IC2_Resin.func_77946_l();
                    itemStackResin.func_190920_e((int)Math.round(Math.random() * 4.0));
                    if (InventoryWrapper.addToConnectedInventories(this.field_145850_b, this.field_174879_c, itemStackResin)) {
                        this.setIsEnabled(false);
                    }
                    this.totalHarvested += itemStackResin.func_190916_E();
                    int age = Math.max(10, Math.round((4.0f + this.field_145850_b.field_73012_v.nextFloat()) * (float)WarpDriveConfig.TREE_FARM_HARVEST_LOG_DELAY_TICKS));
                    PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(blockPosValuable).translate(0.5), 0.8f, 0.8f, 0.2f, age, 0, 50);
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.LASER_LOW, SoundCategory.BLOCKS, 4.0f, 0.5f);
                    this.field_145850_b.func_180501_a(blockPosValuable, blockStateValuable.func_177230_c().func_176203_a(metadata + 6), 3);
                    this.tickCurrentTask = WarpDriveConfig.TREE_FARM_TAP_WET_SPOT_DELAY_TICKS;
                    return EnumTaskResult.CONTINUE;
                }
                if (metadata != 0 && metadata != 1) {
                    this.tickCurrentTask = WarpDriveConfig.TREE_FARM_TAP_DRY_SPOT_DELAY_TICKS;
                    return EnumTaskResult.CONTINUE;
                }
            }
            if (blockStateValuable.func_177230_c() instanceof BlockOldLog && blockStateValuable.func_177229_b((IProperty)BlockOldLog.field_176301_b) == BlockPlanks.EnumType.JUNGLE) {
                if (WarpDriveConfig.LOGGING_COLLECTION) {
                    WarpDrive.logger.info(String.format("Tapping jungle wood %s %s", blockStateValuable, Commons.format(this.field_145850_b, blockPosValuable)));
                }
                this.isPowered = this.laserMedium_consumeExactly(this.energyTappingRubberLog, false);
                if (!this.isPowered) {
                    return EnumTaskResult.RETRY;
                }
                ItemStack itemStackRawRubber = ItemComponent.getItemStackNoCache(EnumComponentType.RAW_RUBBER, 1);
                if (InventoryWrapper.addToConnectedInventories(this.field_145850_b, this.field_174879_c, itemStackRawRubber)) {
                    this.setIsEnabled(false);
                }
                this.totalHarvested += itemStackRawRubber.func_190916_E();
                int age = Math.max(10, Math.round((4.0f + this.field_145850_b.field_73012_v.nextFloat()) * (float)WarpDriveConfig.TREE_FARM_HARVEST_LOG_DELAY_TICKS));
                PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(blockPosValuable).translate(0.5), 0.8f, 0.8f, 0.2f, age, 0, 50);
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.LASER_LOW, SoundCategory.BLOCKS, 4.0f, 0.5f);
                this.field_145850_b.func_175698_g(blockPosValuable);
                this.tickCurrentTask = WarpDriveConfig.TREE_FARM_TAP_RUBBER_LOG_DELAY_TICKS;
                return EnumTaskResult.CONTINUE;
            }
        }
        boolean isLeaf = Dictionary.isLeaf(blockStateValuable.func_177230_c());
        if (isLog || this.breakLeaves && isLeaf) {
            int energyCost = isLog ? this.energyHarvestingLog : this.energyHarvestingLeaf;
            this.isPowered = this.laserMedium_consumeExactly(energyCost, false);
            if (!this.isPowered) {
                return EnumTaskResult.RETRY;
            }
            ++this.totalHarvested;
            int age = Math.max(10, Math.round((4.0f + this.field_145850_b.field_73012_v.nextFloat()) * (float)WarpDriveConfig.MINING_LASER_MINE_DELAY_TICKS));
            PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(blockPosValuable).translate(0.5), 0.2f, 0.7f, 0.4f, age, 0, 50);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.LASER_LOW, SoundCategory.BLOCKS, 4.0f, 1.0f);
            this.harvestBlock(blockPosValuable, blockStateValuable);
            this.tickCurrentTask = isLog ? WarpDriveConfig.TREE_FARM_HARVEST_LOG_DELAY_TICKS : (this.enableSilktouch ? WarpDriveConfig.TREE_FARM_SILKTOUCH_LEAF_DELAY_TICKS : WarpDriveConfig.TREE_FARM_BREAK_LEAF_DELAY_TICKS);
            return EnumTaskResult.CONTINUE;
        }
        return EnumTaskResult.CONTINUE;
    }

    private void updateParameters() {
        int maxRadius = WarpDriveConfig.TREE_FARM_MAX_RADIUS_NO_LASER_MEDIUM + (int)Math.floor(this.cache_laserMedium_factor * (double)WarpDriveConfig.TREE_FARM_MAX_RADIUS_PER_LASER_MEDIUM);
        this.radiusX_actual = Math.min(this.radiusX_requested, maxRadius);
        this.radiusZ_actual = Math.min(this.radiusZ_requested, maxRadius);
        this.axisAlignedBBSoil = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - this.radiusX_actual), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - this.radiusZ_actual), (double)(this.field_174879_c.func_177958_n() + this.radiusX_actual), (double)(this.field_174879_c.func_177956_o() + 8), (double)(this.field_174879_c.func_177952_p() + this.radiusZ_actual));
        this.axisAlignedBBScan = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - this.radiusX_actual), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() - this.radiusZ_actual), (double)(this.field_174879_c.func_177958_n() + this.radiusX_actual), (double)(this.field_174879_c.func_177956_o() + 1 + (this.tapTrees ? 8 : 0)), (double)(this.field_174879_c.func_177952_p() + this.radiusZ_actual));
        this.maxDistance = WarpDriveConfig.TREE_FARM_MAX_DISTANCE_NO_LASER_MEDIUM + (int)Math.floor(this.cache_laserMedium_factor * (double)WarpDriveConfig.TREE_FARM_MAX_DISTANCE_PER_MEDIUM);
        this.energyScanning = WarpDriveConfig.TREE_FARM_SCAN_ENERGY_PER_SURFACE * (1 + 2 * this.radiusX_actual) * (1 + 2 * this.radiusZ_actual);
        this.energyTappingWetSpot = WarpDriveConfig.TREE_FARM_TAP_WET_SPOT_ENERGY_PER_BLOCK;
        this.energyTappingRubberLog = WarpDriveConfig.TREE_FARM_TAP_RUBBER_LOG_ENERGY_PER_BLOCK;
        this.energyHarvestingLog = this.enableSilktouch ? WarpDriveConfig.TREE_FARM_SILKTOUCH_LOG_ENERGY_PER_BLOCK : WarpDriveConfig.TREE_FARM_HARVEST_LOG_ENERGY_PER_BLOCK;
        this.energyHarvestingLeaf = this.enableSilktouch ? WarpDriveConfig.TREE_FARM_SILKTOUCH_LEAF_ENERGY_PER_BLOCK : WarpDriveConfig.TREE_FARM_HARVEST_LEAF_ENERGY_PER_BLOCK;
        this.energyPlanting = WarpDriveConfig.TREE_FARM_PLANT_ENERGY_PER_BLOCK;
    }

    @Override
    protected boolean calculation_start() {
        boolean isStarting = super.calculation_start();
        if (isStarting) {
            if (WarpDriveConfig.LOGGING_COLLECTION) {
                WarpDrive.logger.info(String.format("Calculation initiated for %s", this));
            }
            this.blockPosSoils = new ArrayList(0);
            this.blockPosValuables = new ArrayList(0);
            new ThreadCalculation(this).start();
        }
        return isStarting;
    }

    private void calculation_done(ArrayList<BlockPos> blockPosSoils, ArrayList<BlockStatePos> blockPosValuables) {
        if (WarpDriveConfig.LOGGING_COLLECTION) {
            WarpDrive.logger.info(String.format("Calculation done for %s", this));
        }
        if (blockPosSoils == null || blockPosValuables == null) {
            this.blockPosSoils = new ArrayList(0);
            this.blockPosValuables = new ArrayList(0);
            this.currentState = 1;
            this.tickCurrentTask = WarpDriveConfig.TREE_FARM_WARM_UP_DELAY_TICKS;
        } else {
            this.blockPosSoils = blockPosSoils;
            this.blockPosValuables = blockPosValuables;
        }
        this.indexSoil = 0;
        this.indexValuable = 0;
        this.calculation_done();
    }

    private static ArrayList<BlockPos> calculate_getSoilPositions(@Nonnull IBlockAccess blockAccess, @Nonnull AxisAlignedBB axisAlignedBB) throws ExceptionChunkNotLoaded {
        boolean isSafeThread = Commons.isSafeThread();
        int xMin = (int)axisAlignedBB.field_72340_a;
        int xMax = (int)axisAlignedBB.field_72336_d;
        int yMin = (int)axisAlignedBB.field_72338_b;
        int yMax = (int)axisAlignedBB.field_72337_e;
        int zMin = (int)axisAlignedBB.field_72339_c;
        int zMax = (int)axisAlignedBB.field_72334_f;
        int volume = (xMax - xMin) * (yMax - yMin) * (zMax - zMin);
        ArrayList<BlockPos> blockPosSoils = new ArrayList<BlockPos>(volume);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                IBlockState blockStateAbove;
                mutableBlockPos.func_181079_c(x, yMax + 1, z);
                IBlockState iBlockState = blockStateAbove = isSafeThread ? blockAccess.func_180495_p((BlockPos)mutableBlockPos) : Commons.getBlockState_noChunkLoading(blockAccess, (BlockPos)mutableBlockPos);
                if (blockStateAbove == null) {
                    throw new ExceptionChunkNotLoaded(String.format("Soil calculation aborted %s", Commons.format(blockAccess, (BlockPos)mutableBlockPos)));
                }
                do {
                    boolean isAirAbove = blockStateAbove.func_177230_c().isAir(blockStateAbove, blockAccess, (BlockPos)mutableBlockPos);
                    mutableBlockPos.func_185336_p(mutableBlockPos.func_177956_o() - 1);
                    IBlockState blockStateCandidate = blockAccess.func_180495_p((BlockPos)mutableBlockPos);
                    if (isAirAbove && Dictionary.isSoil(blockStateCandidate.func_177230_c())) {
                        if (WarpDriveConfig.LOGGING_COLLECTION) {
                            WarpDrive.logger.info(String.format("Found soil %s", Commons.format(blockAccess, (BlockPos)mutableBlockPos)));
                        }
                        blockPosSoils.add(mutableBlockPos.func_185334_h());
                        mutableBlockPos.func_185336_p(mutableBlockPos.func_177956_o() - 1);
                        IBlockState iBlockState2 = blockStateAbove = isSafeThread ? blockAccess.func_180495_p((BlockPos)mutableBlockPos) : Commons.getBlockState_noChunkLoading(blockAccess, (BlockPos)mutableBlockPos);
                        if (blockStateAbove != null) continue;
                        throw new ExceptionChunkNotLoaded(String.format("Soil calculation aborted %s", Commons.format(blockAccess, (BlockPos)mutableBlockPos)));
                    }
                    blockStateAbove = blockStateCandidate;
                } while (mutableBlockPos.func_177956_o() > yMin);
            }
        }
        if (WarpDriveConfig.LOGGING_COLLECTION) {
            WarpDrive.logger.info(String.format("Found %d soils", blockPosSoils.size()));
        }
        return blockPosSoils;
    }

    private static ArrayList<BlockStatePos> calculate_getValuableStatePositions(@Nonnull IBlockAccess blockAccess, @Nonnull AxisAlignedBB axisAlignedBB, boolean breakLeaves, int maxLogDistance, Comparator<BlockStatePos> comparator) throws ExceptionChunkNotLoaded {
        boolean isSafeThread = Commons.isSafeThread();
        int xMin = (int)axisAlignedBB.field_72340_a;
        int xMax = (int)axisAlignedBB.field_72336_d;
        int yMin = (int)axisAlignedBB.field_72338_b;
        int yMax = (int)axisAlignedBB.field_72337_e;
        int zMin = (int)axisAlignedBB.field_72339_c;
        int zMax = (int)axisAlignedBB.field_72334_f;
        int volume = (xMax - xMin) * (yMax - yMin) * (zMax - zMin);
        HashSet<BlockPos> logPositions = new HashSet<BlockPos>(volume);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int y = yMin; y <= yMax; ++y) {
            for (int x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    IBlockState blockState;
                    mutableBlockPos.func_181079_c(x, y, z);
                    IBlockState iBlockState = blockState = isSafeThread ? blockAccess.func_180495_p((BlockPos)mutableBlockPos) : Commons.getBlockState_noChunkLoading(blockAccess, (BlockPos)mutableBlockPos);
                    if (blockState == null) {
                        throw new ExceptionChunkNotLoaded(String.format("Valuable calculation aborted %s", Commons.format(blockAccess, (BlockPos)mutableBlockPos)));
                    }
                    Block block = blockState.func_177230_c();
                    if (!Dictionary.isLog(block) || logPositions.contains(mutableBlockPos)) continue;
                    if (WarpDriveConfig.LOGGING_COLLECTION) {
                        WarpDrive.logger.info(String.format("Found tree base %s", Commons.format(blockAccess, (BlockPos)mutableBlockPos)));
                    }
                    logPositions.add(mutableBlockPos.func_185334_h());
                }
            }
        }
        if (logPositions.isEmpty()) {
            if (WarpDriveConfig.LOGGING_COLLECTION) {
                WarpDrive.logger.info("Found no valuable");
            }
            return new ArrayList<BlockStatePos>();
        }
        HashSet<Block> blockResults = breakLeaves ? Dictionary.getLogsAndLeaves() : Dictionary.getLogs();
        Set<BlockStatePos> blockStatePositions = Commons.getConnectedBlockStatePos(blockAccess, logPositions, Commons.DIRECTIONS_UP_CONE, Dictionary.getLogsAndLeaves(), blockResults, maxLogDistance);
        ArrayList<BlockStatePos> blockStatePosList = new ArrayList<BlockStatePos>(blockStatePositions);
        blockStatePosList.sort(comparator);
        if (WarpDriveConfig.LOGGING_COLLECTION) {
            WarpDrive.logger.info(String.format("Found %d valuables", blockStatePosList.size()));
        }
        return blockStatePosList;
    }

    private int comparatorSortLogsAndLeaves(@Nonnull BlockStatePos o1, @Nonnull BlockStatePos o2) {
        if (o1.blockPos.func_177958_n() == this.field_174879_c.func_177958_n() && o1.blockPos.func_177952_p() == this.field_174879_c.func_177952_p()) {
            if (o2.blockPos.func_177958_n() == this.field_174879_c.func_177958_n() && o2.blockPos.func_177952_p() == this.field_174879_c.func_177952_p()) {
                return o1.blockPos.func_177956_o() - o2.blockPos.func_177956_o();
            }
            return -1;
        }
        if (o2.blockPos.func_177958_n() == this.field_174879_c.func_177958_n() && o2.blockPos.func_177952_p() == this.field_174879_c.func_177952_p()) {
            return 1;
        }
        if (o1.blockPos.func_177956_o() != o2.blockPos.func_177956_o()) {
            return o2.blockPos.func_177956_o() - o1.blockPos.func_177956_o();
        }
        if (Dictionary.isLeaf(o1.blockState.func_177230_c())) {
            if (Dictionary.isLeaf(o2.blockState.func_177230_c())) {
                return (o1.blockPos.func_177958_n() - this.field_174879_c.func_177958_n()) * (o1.blockPos.func_177958_n() - this.field_174879_c.func_177958_n()) + (o1.blockPos.func_177952_p() - this.field_174879_c.func_177952_p()) * (o1.blockPos.func_177952_p() - this.field_174879_c.func_177952_p()) - ((o2.blockPos.func_177958_n() - this.field_174879_c.func_177958_n()) * (o2.blockPos.func_177958_n() - this.field_174879_c.func_177958_n()) + (o2.blockPos.func_177952_p() - this.field_174879_c.func_177952_p()) * (o2.blockPos.func_177952_p() - this.field_174879_c.func_177952_p()));
            }
            return -1;
        }
        if (Dictionary.isLeaf(o2.blockState.func_177230_c())) {
            return 1;
        }
        int rangeDifference = (o1.blockPos.func_177958_n() - this.field_174879_c.func_177958_n()) * (o1.blockPos.func_177958_n() - this.field_174879_c.func_177958_n()) + (o1.blockPos.func_177952_p() - this.field_174879_c.func_177952_p()) * (o1.blockPos.func_177952_p() - this.field_174879_c.func_177952_p()) - ((o2.blockPos.func_177958_n() - this.field_174879_c.func_177958_n()) * (o2.blockPos.func_177958_n() - this.field_174879_c.func_177958_n()) + (o2.blockPos.func_177952_p() - this.field_174879_c.func_177952_p()) * (o2.blockPos.func_177952_p() - this.field_174879_c.func_177952_p()));
        if (rangeDifference == 0) {
            if (o1.blockPos.func_177958_n() != o2.blockPos.func_177958_n()) {
                return o1.blockPos.func_177958_n() - o2.blockPos.func_177958_n();
            }
            return o1.blockPos.func_177952_p() - o2.blockPos.func_177952_p();
        }
        return rangeDifference;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("radiusX", this.radiusX_requested);
        tagCompound.func_74768_a("radiusZ", this.radiusZ_requested);
        tagCompound.func_74757_a("breakLeaves", this.breakLeaves);
        tagCompound.func_74757_a("tapTrees", this.tapTrees);
        tagCompound.func_74768_a("currentState", this.currentState);
        return tagCompound;
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.radiusX_requested = tagCompound.func_74762_e("radiusX");
        this.radiusX_requested = Commons.clamp(1, WarpDriveConfig.TREE_FARM_totalMaxRadius, this.radiusX_requested);
        this.radiusZ_requested = tagCompound.func_74762_e("radiusZ");
        this.radiusZ_requested = Commons.clamp(1, WarpDriveConfig.TREE_FARM_totalMaxRadius, this.radiusZ_requested);
        this.breakLeaves = tagCompound.func_74767_n("breakLeaves");
        this.tapTrees = tagCompound.func_74767_n("tapTrees");
        this.currentState = tagCompound.func_74762_e("currentState");
    }

    @Override
    public Object[] getEnergyRequired() {
        String units = this.energy_getDisplayUnits();
        return new Object[]{true, EnergyWrapper.convert(this.energyScanning, units), EnergyWrapper.convert(this.energyTappingWetSpot, units), EnergyWrapper.convert(this.energyTappingRubberLog, units), EnergyWrapper.convert(this.energyHarvestingLog, units), EnergyWrapper.convert(this.energyHarvestingLeaf, units), EnergyWrapper.convert(this.energyPlanting, units)};
    }

    private Object[] state() {
        int return_countValuables;
        int return_indexValuable;
        int energy = this.laserMedium_getEnergyStored(true);
        String status = this.getStatusHeaderInPureText();
        if (this.currentState != 0) {
            return_indexValuable = this.indexValuable;
            return_countValuables = this.blockPosValuables.size();
        } else {
            return_indexValuable = 0;
            return_countValuables = 0;
        }
        return new Object[]{status, this.currentState != 0, energy, this.totalHarvested, return_indexValuable, return_countValuables};
    }

    private Object[] radius(Object[] arguments) {
        try {
            if (arguments.length == 1 && arguments[0] != null) {
                this.radiusZ_requested = this.radiusX_requested = Commons.clamp(1, WarpDriveConfig.TREE_FARM_totalMaxRadius, Commons.toInt(arguments[0]));
                this.func_70296_d();
            } else if (arguments.length == 2) {
                this.radiusX_requested = Commons.clamp(1, WarpDriveConfig.TREE_FARM_totalMaxRadius, Commons.toInt(arguments[0]));
                this.radiusZ_requested = Commons.clamp(1, WarpDriveConfig.TREE_FARM_totalMaxRadius, Commons.toInt(arguments[1]));
                this.func_70296_d();
            }
        }
        catch (NumberFormatException exception) {
            this.radiusX_requested = WarpDriveConfig.TREE_FARM_totalMaxRadius;
            this.radiusZ_requested = WarpDriveConfig.TREE_FARM_totalMaxRadius;
        }
        return new Integer[]{this.radiusX_requested, this.radiusZ_requested};
    }

    private Object[] breakLeaves(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            try {
                this.breakLeaves = Commons.toBool(arguments[0]);
                this.func_70296_d();
            }
            catch (Exception exception) {
                return new Object[]{this.breakLeaves};
            }
        }
        return new Object[]{this.breakLeaves};
    }

    private Object[] silktouch(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            try {
                this.enableSilktouch = Commons.toBool(arguments[0]);
                this.func_70296_d();
            }
            catch (Exception exception) {
                return new Object[]{this.enableSilktouch};
            }
        }
        return new Object[]{this.enableSilktouch};
    }

    private Object[] tapTrees(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            try {
                this.tapTrees = Commons.toBool(arguments[0]);
                this.func_70296_d();
            }
            catch (Exception exception) {
                return new Object[]{this.tapTrees};
            }
        }
        return new Object[]{this.tapTrees};
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] state(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.state();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] radius(Context context, Arguments arguments) {
        return this.radius(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] breakLeaves(Context context, Arguments arguments) {
        return this.breakLeaves(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] silktouch(Context context, Arguments arguments) {
        return this.silktouch(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] tapTrees(Context context, Arguments arguments) {
        return this.tapTrees(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "state": {
                return this.state();
            }
            case "radius": {
                return this.radius(arguments);
            }
            case "breakLeaves": {
                return this.breakLeaves(arguments);
            }
            case "silktouch": {
                return this.silktouch(arguments);
            }
            case "tapTrees": {
                return this.tapTrees(arguments);
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }

    @Override
    public WarpDriveText getStatusHeader() {
        int energy = this.laserMedium_getEnergyStored(true);
        WarpDriveText textState = new WarpDriveText(Commons.getStyleWarning(), "warpdrive.error.internal_check_console", new Object[0]);
        if (this.currentState == 0) {
            textState = new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.laser_tree_farm.status_line.idle", new Object[0]);
        } else if (this.currentState == 1) {
            textState = new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.laser_tree_farm.status_line.warming_up", new Object[0]);
        } else if (this.currentState == 2) {
            textState = this.breakLeaves ? new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.laser_tree_farm.status_line.scanning_all", new Object[0]) : new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.laser_tree_farm.status_line.scanning_logs", new Object[0]);
        } else if (this.currentState == 4) {
            textState = !this.tapTrees ? (!this.enableSilktouch ? (this.breakLeaves ? new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.laser_tree_farm.status_line.harvesting_all", new Object[0]) : new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.laser_tree_farm.status_line.harvesting_logs", new Object[0])) : (this.breakLeaves ? new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.laser_tree_farm.status_line.harvesting_all_with_silktouch", new Object[0]) : new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.laser_tree_farm.status_line.harvesting_logs_with_silktouch", new Object[0]))) : (!this.enableSilktouch ? (this.breakLeaves ? new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.laser_tree_farm.status_line.tapping_all", new Object[0]) : new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.laser_tree_farm.status_line.tapping_logs", new Object[0])) : (this.breakLeaves ? new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.laser_tree_farm.status_line.tapping_all_with_silktouch", new Object[0]) : new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.laser_tree_farm.status_line.tapping_logs_with_silktouch", new Object[0])));
        } else if (this.currentState == 3) {
            textState = new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.laser_tree_farm.status_line.planting", new Object[0]);
        }
        if (energy <= 0) {
            textState.appendSibling(new WarpDriveText(Commons.getStyleWarning(), "warpdrive.mining_laser.status_line._insufficient_energy", new Object[0]));
        } else if (this.currentState != 0 && this.currentState != 1 && !this.isPowered) {
            textState.appendSibling(new WarpDriveText(Commons.getStyleWarning(), "warpdrive.mining_laser.status_line._insufficient_energy", new Object[0]));
        }
        return textState;
    }

    private class ThreadCalculation
    extends Thread {
        private final WeakReference<TileEntity> weakTileEntity;
        private final String stringTileEntity;

        ThreadCalculation(TileEntity tileEntity) {
            this.weakTileEntity = new WeakReference<TileEntity>(tileEntity);
            this.stringTileEntity = tileEntity.toString();
        }

        @Override
        public void run() {
            TileEntity tileEntity;
            ArrayList blockPosSoils = null;
            ArrayList blockStatePosValuables = null;
            try {
                tileEntity = (TileEntity)this.weakTileEntity.get();
                if (!(tileEntity instanceof TileEntityLaserTreeFarm)) {
                    if (WarpDriveConfig.LOGGING_COLLECTION) {
                        WarpDrive.logger.error(String.format("%s Scanning aborted", this));
                    }
                } else {
                    World blockAccess = tileEntity.func_145831_w();
                    AxisAlignedBB axisAlignedBBSoil = ((TileEntityLaserTreeFarm)tileEntity).axisAlignedBBSoil;
                    AxisAlignedBB axisAlignedBBScan = ((TileEntityLaserTreeFarm)tileEntity).axisAlignedBBScan;
                    boolean breakLeaves = ((TileEntityLaserTreeFarm)tileEntity).breakLeaves;
                    int maxDistance = ((TileEntityLaserTreeFarm)tileEntity).maxDistance;
                    Comparator comparator = (arg_0, arg_1) -> ThreadCalculation.lambda$run$0((TileEntityLaserTreeFarm)tileEntity, arg_0, arg_1);
                    tileEntity = null;
                    if (WarpDriveConfig.LOGGING_COLLECTION) {
                        WarpDrive.logger.debug(String.format("%s Calculation started for %s", this, this.stringTileEntity));
                    }
                    blockPosSoils = TileEntityLaserTreeFarm.calculate_getSoilPositions((IBlockAccess)blockAccess, axisAlignedBBSoil);
                    blockStatePosValuables = TileEntityLaserTreeFarm.calculate_getValuableStatePositions((IBlockAccess)blockAccess, axisAlignedBBScan, breakLeaves, maxDistance, comparator);
                    if (WarpDriveConfig.LOGGING_COLLECTION) {
                        WarpDrive.logger.debug(String.format("%s Calculation done: %s soil positions, %s valuables positions", this, blockPosSoils.size(), blockStatePosValuables.size()));
                    }
                }
            }
            catch (Exception exception) {
                blockPosSoils = null;
                blockStatePosValuables = null;
                if (!(exception instanceof ExceptionChunkNotLoaded)) {
                    exception.printStackTrace(WarpDrive.printStreamError);
                    WarpDrive.logger.error(String.format("%s Calculation failed for %s", this, this.stringTileEntity));
                }
                WarpDrive.logger.warn(String.format("%s Calculation aborted to prevent chunkloading for %s", this, this.stringTileEntity));
            }
            tileEntity = (TileEntity)this.weakTileEntity.get();
            if (tileEntity instanceof TileEntityLaserTreeFarm) {
                ((TileEntityLaserTreeFarm)tileEntity).calculation_done(blockPosSoils, blockStatePosValuables);
            }
        }

        private static /* synthetic */ int lambda$run$0(TileEntityLaserTreeFarm rec$, BlockStatePos x$0, BlockStatePos x$1) {
            return rec$.comparatorSortLogsAndLeaves(x$0, x$1);
        }
    }
}

