/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.detection;

import cr0s.warpdrive.block.BlockAbstractHorizontalSpinningContainer;
import cr0s.warpdrive.block.ItemBlockAbstractBase;
import cr0s.warpdrive.block.detection.TileEntityEnvironmentalSensor;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.EnumHorizontalSpinning;
import cr0s.warpdrive.data.EnumTier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEnvironmentalSensor
extends BlockAbstractHorizontalSpinningContainer {
    private static final AxisAlignedBB AABB_DOWN = new AxisAlignedBB(0.125, 0.6875, 0.125, 0.875, 1.0, 0.875);
    private static final AxisAlignedBB AABB_UP = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.3125, 0.875);
    private static final AxisAlignedBB AABB_NORTH = new AxisAlignedBB(0.125, 0.125, 0.6875, 0.875, 0.875, 1.0);
    private static final AxisAlignedBB AABB_SOUTH = new AxisAlignedBB(0.125, 0.125, 0.0, 0.875, 0.875, 0.3125);
    private static final AxisAlignedBB AABB_WEST = new AxisAlignedBB(0.6875, 0.125, 0.125, 1.0, 0.875, 0.875);
    private static final AxisAlignedBB AABB_EAST = new AxisAlignedBB(0.0, 0.125, 0.125, 0.3125, 0.875, 0.875);
    private static final AxisAlignedBB AABB_FULL = field_185505_j;

    public BlockEnvironmentalSensor(String registryName, EnumTier enumTier) {
        super(registryName, enumTier, Material.field_151573_f);
        this.func_149663_c("warpdrive.detection.environmental_sensor");
    }

    @Nonnull
    public TileEntity func_149915_a(@Nonnull World world, int metadata) {
        return new TileEntityEnvironmentalSensor();
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos) {
        return this.getBlockBoundsFromState(blockState);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos) {
        return this.getBlockBoundsFromState(blockState);
    }

    private AxisAlignedBB getBlockBoundsFromState(IBlockState blockState) {
        if (blockState == null) {
            return AABB_FULL;
        }
        switch (((EnumHorizontalSpinning)((Object)blockState.func_177229_b(BlockProperties.HORIZONTAL_SPINNING))).facing) {
            case DOWN: {
                return AABB_DOWN;
            }
            case UP: {
                return AABB_UP;
            }
            case NORTH: {
                return AABB_NORTH;
            }
            case SOUTH: {
                return AABB_SOUTH;
            }
            case WEST: {
                return AABB_WEST;
            }
            case EAST: {
                return AABB_EAST;
            }
        }
        return AABB_FULL;
    }

    public boolean func_185481_k(@Nonnull IBlockState blockState) {
        EnumFacing enumFacing = ((EnumHorizontalSpinning)((Object)blockState.func_177229_b(BlockProperties.HORIZONTAL_SPINNING))).facing;
        return enumFacing == EnumFacing.DOWN;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess blockAccess, @Nonnull IBlockState blockState, @Nonnull BlockPos blockPos, @Nonnull EnumFacing enumFacing) {
        EnumFacing enumFacingState = ((EnumHorizontalSpinning)((Object)blockState.func_177229_b(BlockProperties.HORIZONTAL_SPINNING))).facing;
        return enumFacing == enumFacingState.func_176734_d() ? BlockFaceShape.CENTER_BIG : BlockFaceShape.UNDEFINED;
    }

    public boolean func_149730_j(@Nonnull IBlockState blockState) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState blockState) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos, @Nonnull EnumFacing facing) {
        BlockPos blockPosSide = blockPos.func_177972_a(facing);
        boolean doesSideBlockRendering = blockAccess.func_180495_p(blockPosSide).doesSideBlockRendering(blockAccess, blockPosSide, facing);
        return !doesSideBlockRendering;
    }

    public boolean func_149662_c(@Nonnull IBlockState blockState) {
        return false;
    }

    public boolean doesSideBlockRendering(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos, @Nonnull EnumFacing side) {
        return false;
    }

    public boolean isSideSolid(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos, @Nonnull EnumFacing side) {
        EnumFacing enumFacing = ((EnumHorizontalSpinning)((Object)blockState.func_177229_b(BlockProperties.HORIZONTAL_SPINNING))).facing;
        return enumFacing.func_176734_d() == side;
    }

    @Override
    @Nullable
    public ItemBlock createItemBlock() {
        return new ItemBlockAbstractBase((Block)this, false, true);
    }

    @Override
    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumHand enumHand, @Nonnull EnumFacing enumFacing, float hitX, float hitY, float hitZ) {
        return super.func_180639_a(world, blockPos, blockState, entityPlayer, enumHand, enumFacing, hitX, hitY, hitZ);
    }
}

