/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.detection;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IVideoChannel;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.BlockAbstractRotatingContainer;
import cr0s.warpdrive.block.detection.TileEntityMonitor;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.CameraRegistryItem;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.render.ClientCameraHandler;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class BlockMonitor
extends BlockAbstractRotatingContainer {
    public BlockMonitor(String registryName, EnumTier enumTier) {
        super(registryName, enumTier, Material.field_151573_f);
        this.func_149663_c("warpdrive.detection.monitor");
    }

    @Nonnull
    public TileEntity func_149915_a(@Nonnull World world, int metadata) {
        return new TileEntityMonitor();
    }

    @Override
    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumHand enumHand, @Nonnull EnumFacing enumFacing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (!world.field_72995_K || enumHand != EnumHand.MAIN_HAND) {
            return super.func_180639_a(world, blockPos, blockState, entityPlayer, enumHand, enumFacing, hitX, hitY, hitZ);
        }
        ItemStack itemStackHeld = entityPlayer.func_184586_b(enumHand);
        if (itemStackHeld.func_190926_b() && enumFacing == blockState.func_177229_b((IProperty)BlockProperties.FACING) && (tileEntity = world.func_175625_s(blockPos)) instanceof TileEntityMonitor) {
            int videoChannel = ((TileEntityMonitor)tileEntity).getVideoChannel();
            if (!IVideoChannel.isValid(videoChannel)) {
                Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)((TileEntityMonitor)tileEntity).getStatus());
                return true;
            }
            CameraRegistryItem camera = WarpDrive.cameras.getCameraByVideoChannel(world, videoChannel);
            if (camera == null || entityPlayer.func_70093_af()) {
                Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)((TileEntityMonitor)tileEntity).getStatus());
                return true;
            }
            Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.monitor.viewing_camera", new Object[]{new WarpDriveText(Commons.getStyleValue(), videoChannel), camera.blockPos.func_177958_n(), camera.blockPos.func_177956_o(), camera.blockPos.func_177952_p()}));
            ClientCameraHandler.setupViewpoint(camera.type, entityPlayer, entityPlayer.field_70177_z, entityPlayer.field_70125_A, blockPos, blockState, camera.blockPos, world.func_180495_p(camera.blockPos));
            return true;
        }
        return super.func_180639_a(world, blockPos, blockState, entityPlayer, enumHand, enumFacing, hitX, hitY, hitZ);
    }
}

