/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.detection;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.BlockAbstractHorizontalSpinningContainer;
import cr0s.warpdrive.block.detection.TileEntitySiren;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.EnumHorizontalSpinning;
import cr0s.warpdrive.data.EnumTier;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSiren
extends BlockAbstractHorizontalSpinningContainer {
    private static final AxisAlignedBB AABB_INDUSTRIAL_DOWN_NORTH = new AxisAlignedBB(0.0, 0.1875, 0.1875, 1.0, 0.8125, 0.8125);
    private static final AxisAlignedBB AABB_INDUSTRIAL_DOWN_SOUTH = new AxisAlignedBB(0.0, 0.1875, 0.1875, 1.0, 0.8125, 0.8125);
    private static final AxisAlignedBB AABB_INDUSTRIAL_DOWN_WEST = new AxisAlignedBB(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 1.0);
    private static final AxisAlignedBB AABB_INDUSTRIAL_DOWN_EAST = new AxisAlignedBB(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 1.0);
    private static final AxisAlignedBB AABB_INDUSTRIAL_UP_NORTH = new AxisAlignedBB(0.0, 0.1875, 0.1875, 1.0, 0.8125, 0.8125);
    private static final AxisAlignedBB AABB_INDUSTRIAL_UP_SOUTH = new AxisAlignedBB(0.0, 0.1875, 0.1875, 1.0, 0.8125, 0.8125);
    private static final AxisAlignedBB AABB_INDUSTRIAL_UP_WEST = new AxisAlignedBB(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 1.0);
    private static final AxisAlignedBB AABB_INDUSTRIAL_UP_EAST = new AxisAlignedBB(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 1.0);
    private static final AxisAlignedBB AABB_INDUSTRIAL_NORTH = new AxisAlignedBB(0.0, 0.1875, 0.1875, 1.0, 0.8125, 0.8125);
    private static final AxisAlignedBB AABB_INDUSTRIAL_SOUTH = new AxisAlignedBB(0.0, 0.1875, 0.1875, 1.0, 0.8125, 0.8125);
    private static final AxisAlignedBB AABB_INDUSTRIAL_WEST = new AxisAlignedBB(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 1.0);
    private static final AxisAlignedBB AABB_INDUSTRIAL_EAST = new AxisAlignedBB(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 1.0);
    private static final AxisAlignedBB AABB_MILITARY_DOWN = new AxisAlignedBB(0.0, 0.3125, 0.0, 1.0, 0.6875, 1.0);
    private static final AxisAlignedBB AABB_MILITARY_UP = new AxisAlignedBB(0.0, 0.3125, 0.0, 1.0, 0.6875, 1.0);
    private static final AxisAlignedBB AABB_MILITARY_NORTH = new AxisAlignedBB(0.0, 0.3125, 0.4375, 1.0, 0.6875, 0.8125);
    private static final AxisAlignedBB AABB_MILITARY_SOUTH = new AxisAlignedBB(0.0, 0.3125, 0.1875, 1.0, 0.6875, 0.5625);
    private static final AxisAlignedBB AABB_MILITARY_WEST = new AxisAlignedBB(0.4375, 0.3125, 0.0, 0.8125, 0.6875, 1.0);
    private static final AxisAlignedBB AABB_MILITARY_EAST = new AxisAlignedBB(0.1875, 0.3125, 0.0, 0.5625, 0.6875, 1.0);
    private static final AxisAlignedBB AABB_FULL = field_185505_j;
    private final boolean isIndustrial;

    public BlockSiren(String registryName, EnumTier enumTier, boolean isIndustrial) {
        super(registryName, enumTier, Material.field_151573_f);
        this.isIndustrial = isIndustrial;
        this.func_149663_c("warpdrive.detection.siren_" + (isIndustrial ? "industrial" : "military") + "." + enumTier.func_176610_l());
    }

    @Nonnull
    public TileEntity func_149915_a(@Nonnull World world, int metadata) {
        return new TileEntitySiren();
    }

    public boolean getIsIndustrial() {
        return this.isIndustrial;
    }

    public int func_180651_a(@Nonnull IBlockState blockState) {
        return 0;
    }

    public int func_149717_k(@Nonnull IBlockState blockState) {
        return 0;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos) {
        return this.getBlockBoundsFromState(blockState);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos) {
        return this.getBlockBoundsFromState(blockState);
    }

    private AxisAlignedBB getBlockBoundsFromState(IBlockState blockState) {
        if (blockState == null) {
            return AABB_FULL;
        }
        if (this.isIndustrial) {
            switch ((EnumHorizontalSpinning)((Object)blockState.func_177229_b(BlockProperties.HORIZONTAL_SPINNING))) {
                case DOWN_NORTH: {
                    return AABB_INDUSTRIAL_DOWN_NORTH;
                }
                case DOWN_SOUTH: {
                    return AABB_INDUSTRIAL_DOWN_SOUTH;
                }
                case DOWN_WEST: {
                    return AABB_INDUSTRIAL_DOWN_WEST;
                }
                case DOWN_EAST: {
                    return AABB_INDUSTRIAL_DOWN_EAST;
                }
                case UP_NORTH: {
                    return AABB_INDUSTRIAL_UP_NORTH;
                }
                case UP_SOUTH: {
                    return AABB_INDUSTRIAL_UP_SOUTH;
                }
                case UP_WEST: {
                    return AABB_INDUSTRIAL_UP_WEST;
                }
                case UP_EAST: {
                    return AABB_INDUSTRIAL_UP_EAST;
                }
                case NORTH: {
                    return AABB_INDUSTRIAL_NORTH;
                }
                case SOUTH: {
                    return AABB_INDUSTRIAL_SOUTH;
                }
                case WEST: {
                    return AABB_INDUSTRIAL_WEST;
                }
                case EAST: {
                    return AABB_INDUSTRIAL_EAST;
                }
            }
            return AABB_FULL;
        }
        switch (((EnumHorizontalSpinning)((Object)blockState.func_177229_b(BlockProperties.HORIZONTAL_SPINNING))).facing) {
            case DOWN: {
                return AABB_MILITARY_DOWN;
            }
            case UP: {
                return AABB_MILITARY_UP;
            }
            case NORTH: {
                return AABB_MILITARY_NORTH;
            }
            case SOUTH: {
                return AABB_MILITARY_SOUTH;
            }
            case WEST: {
                return AABB_MILITARY_WEST;
            }
            case EAST: {
                return AABB_MILITARY_EAST;
            }
        }
        return AABB_FULL;
    }

    public boolean func_185481_k(@Nonnull IBlockState blockState) {
        EnumFacing enumFacing = ((EnumHorizontalSpinning)((Object)blockState.func_177229_b(BlockProperties.HORIZONTAL_SPINNING))).facing;
        return enumFacing == EnumFacing.DOWN;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess blockAccess, @Nonnull IBlockState blockState, @Nonnull BlockPos blockPos, @Nonnull EnumFacing enumFacing) {
        EnumFacing enumFacingState = ((EnumHorizontalSpinning)((Object)blockState.func_177229_b(BlockProperties.HORIZONTAL_SPINNING))).facing;
        return enumFacing == enumFacingState.func_176734_d() ? BlockFaceShape.CENTER_BIG : BlockFaceShape.UNDEFINED;
    }

    public boolean func_149730_j(@Nonnull IBlockState blockState) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState blockState) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos, @Nonnull EnumFacing facing) {
        BlockPos blockPosSide = blockPos.func_177972_a(facing);
        boolean doesSideBlockRendering = blockAccess.func_180495_p(blockPosSide).doesSideBlockRendering(blockAccess, blockPosSide, facing);
        return !doesSideBlockRendering;
    }

    public boolean func_149662_c(@Nonnull IBlockState blockState) {
        return false;
    }

    public boolean doesSideBlockRendering(@Nonnull IBlockState blockState, IBlockAccess blockAccess, BlockPos blockPos, EnumFacing side) {
        return false;
    }

    public boolean isSideSolid(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos, @Nonnull EnumFacing side) {
        EnumFacing enumFacing = ((EnumHorizontalSpinning)((Object)blockState.func_177229_b(BlockProperties.HORIZONTAL_SPINNING))).facing;
        return enumFacing.func_176734_d() == side;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(@Nonnull ItemStack itemStack, @Nullable World world, @Nonnull List<String> list, @Nonnull ITooltipFlag advancedItemTooltips) {
        super.func_190948_a(itemStack, world, list, advancedItemTooltips);
        int range = MathHelper.func_76141_d((float)WarpDriveConfig.SIREN_RANGE_BLOCKS_BY_TIER[this.enumTier.getIndex()]);
        String unlocalizedName_withoutTier = this.func_149739_a().replace("." + this.enumTier.func_176610_l(), "");
        Commons.addTooltip(list, new TextComponentTranslation(unlocalizedName_withoutTier + ".tooltip.usage", new Object[]{new WarpDriveText(Commons.getStyleValue(), range)}).func_150254_d());
    }
}

