/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.detection;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IVideoChannel;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.TileEntityAbstractBase;
import cr0s.warpdrive.block.TileEntityAbstractMachine;
import cr0s.warpdrive.block.detection.BlockCamera;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.EnumCameraType;
import cr0s.warpdrive.data.EnumComponentType;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.item.ItemComponent;
import cr0s.warpdrive.network.PacketHandler;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.Optional;

public class TileEntityCamera
extends TileEntityAbstractMachine
implements IVideoChannel {
    private int videoChannel = -1;
    private static final int REGISTRY_UPDATE_INTERVAL_TICKS = 300;
    private static final int PACKET_SEND_INTERVAL_TICKS = 1200;
    private static final TileEntityAbstractBase.UpgradeSlot upgradeSlotRecognitionRange = new TileEntityAbstractBase.UpgradeSlot("camera.recognition_range", ItemComponent.getItemStackNoCache(EnumComponentType.DIAMOND_CRYSTAL, 1), WarpDriveConfig.CAMERA_RANGE_UPGRADE_MAX_QUANTITY);
    private final CopyOnWriteArrayList<Result> results = new CopyOnWriteArrayList();
    private Vec3d vCamera = null;
    private int packetSendTicks = 10;
    private int registryUpdateTicks = 20;
    private boolean hasImageRecognition = false;
    private AxisAlignedBB aabbRange = null;
    private int tickSensing = 0;

    public TileEntityCamera() {
        this.peripheralName = "warpdriveCamera";
        this.addMethods(new String[]{"videoChannel", "getResults", "getResultsCount", "getResult"});
        this.doRequireUpgradeToInterface();
        this.CC_scripts = Collections.singletonList("recognize");
        this.registerUpgradeSlot(upgradeSlotRecognitionRange);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            --this.packetSendTicks;
            if (this.packetSendTicks <= 0) {
                this.packetSendTicks = 1200;
                PacketHandler.sendVideoChannelPacket(this.field_145850_b, this.field_174879_c, this.videoChannel);
            }
        } else {
            --this.registryUpdateTicks;
            if (this.registryUpdateTicks <= 0) {
                this.registryUpdateTicks = 300;
                if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                    WarpDrive.logger.info(this + " Updating registry (" + this.videoChannel + ")");
                }
                WarpDrive.cameras.updateInRegistry(this.field_145850_b, this.field_174879_c, this.videoChannel, EnumCameraType.SIMPLE_CAMERA);
            }
            return;
        }
        if (this.isEnabled && this.hasImageRecognition) {
            --this.tickSensing;
            if (this.tickSensing < 0) {
                this.tickSensing = WarpDriveConfig.CAMERA_IMAGE_RECOGNITION_INTERVAL_TICKS;
                for (Result result2 : this.results) {
                    result2.markForUpdate();
                }
                int countAdded = 0;
                int countOld = this.results.size();
                List entitiesInRange = this.field_145850_b.func_175647_a(Entity.class, this.aabbRange, entity -> entity != null && entity.func_70089_S() && !entity.func_82150_aj() && (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).func_175149_v()));
                for (Entity entity2 : entitiesInRange) {
                    Vec3d vEntity = new Vec3d(entity2.field_70165_t, entity2.field_70163_u, entity2.field_70161_v);
                    RayTraceResult rayTraceResult = this.field_145850_b.func_72933_a(this.vCamera, vEntity);
                    if (rayTraceResult != null) continue;
                    boolean isNew = true;
                    for (Result result3 : this.results) {
                        if (!result3.equals(entity2)) continue;
                        result3.update(entity2);
                        isNew = false;
                        break;
                    }
                    if (!isNew) continue;
                    ++countAdded;
                    this.results.add(new Result(entity2));
                }
                this.results.removeIf(result -> !result.isUpdated());
                int countRemoved = countOld + countAdded - this.results.size();
                if (countAdded > 0 || countRemoved > 0) {
                    this.sendEvent("opticalSensorResultsChanged", countAdded, countRemoved);
                }
            }
        }
    }

    @Override
    protected void doUpdateParameters(boolean isDirty) {
        super.doUpdateParameters(isDirty);
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.updateBlockState(blockState, BlockProperties.ACTIVE, this.isEnabled);
        int range = WarpDriveConfig.CAMERA_RANGE_BASE_BLOCKS + WarpDriveConfig.CAMERA_RANGE_UPGRADE_BLOCKS * this.getUpgradeCount(upgradeSlotRecognitionRange);
        boolean bl = this.hasImageRecognition = range > 0;
        if (this.hasImageRecognition && blockState.func_177230_c() instanceof BlockCamera) {
            EnumFacing enumFacing = (EnumFacing)blockState.func_177229_b((IProperty)BlockProperties.FACING);
            float radius = (float)range / 2.0f;
            this.vCamera = new Vec3d((double)((float)this.field_174879_c.func_177958_n() + 0.5f + 0.6f * (float)enumFacing.func_82601_c()), (double)((float)this.field_174879_c.func_177956_o() + 0.5f + 0.6f * (float)enumFacing.func_96559_d()), (double)((float)this.field_174879_c.func_177952_p() + 0.5f + 0.6f * (float)enumFacing.func_82599_e()));
            Vec3d vCenter = new Vec3d((double)((float)this.field_174879_c.func_177958_n() + 0.5f + (radius + 0.5f) * (float)enumFacing.func_82601_c()), (double)((float)this.field_174879_c.func_177956_o() + 0.5f + (radius + 0.5f) * (float)enumFacing.func_96559_d()), (double)((float)this.field_174879_c.func_177952_p() + 0.5f + (radius + 0.5f) * (float)enumFacing.func_82599_e()));
            this.aabbRange = new AxisAlignedBB(vCenter.field_72450_a - (double)radius, vCenter.field_72448_b - (double)radius, vCenter.field_72449_c - (double)radius, vCenter.field_72450_a + (double)radius, vCenter.field_72448_b + (double)radius, vCenter.field_72449_c + (double)radius);
        }
    }

    @Override
    public int getVideoChannel() {
        return this.videoChannel;
    }

    @Override
    public void setVideoChannel(int parVideoChannel) {
        if (this.videoChannel != parVideoChannel && IVideoChannel.isValid(parVideoChannel)) {
            this.videoChannel = parVideoChannel;
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info(this + " Video channel set to " + this.videoChannel);
            }
            this.func_70296_d();
            this.packetSendTicks = 0;
            this.registryUpdateTicks = 0;
        }
    }

    @Override
    public void func_145843_s() {
        if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
            WarpDrive.logger.info(this + " invalidated");
        }
        WarpDrive.cameras.removeFromRegistry(this.field_145850_b, this.field_174879_c);
        super.func_145843_s();
    }

    @Override
    public void onChunkUnload() {
        if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
            WarpDrive.logger.info(this + " onChunkUnload");
        }
        WarpDrive.cameras.removeFromRegistry(this.field_145850_b, this.field_174879_c);
        super.onChunkUnload();
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.videoChannel = tagCompound.func_74762_e("frequency") + tagCompound.func_74762_e("videoChannel");
        if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
            WarpDrive.logger.info(this + " readFromNBT");
        }
        NBTTagList tagList = tagCompound.func_150295_c("results", 10);
        for (NBTBase tagResult : tagList) {
            NBTTagCompound tagCompoundResult = (NBTTagCompound)tagResult;
            try {
                Result result = new Result(new Vector3(tagCompoundResult.func_74769_h("posX"), tagCompoundResult.func_74769_h("posY"), tagCompoundResult.func_74769_h("posZ")), new Vector3(tagCompoundResult.func_74769_h("motionX"), tagCompoundResult.func_74769_h("motionY"), tagCompoundResult.func_74769_h("motionZ")), tagCompoundResult.func_74779_i("type"), Objects.requireNonNull(tagCompoundResult.func_186857_a("uniqueId")), tagCompoundResult.func_74779_i("name"));
                this.results.add(result);
            }
            catch (Exception exception) {
                WarpDrive.logger.error(String.format("%s Exception while reading previous result %s", this, tagCompoundResult));
                exception.printStackTrace(WarpDrive.printStreamError);
            }
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("videoChannel", this.videoChannel);
        if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
            WarpDrive.logger.info(this + " writeToNBT");
        }
        if (!this.results.isEmpty()) {
            NBTTagList tagList = new NBTTagList();
            for (Result result : this.results) {
                NBTTagCompound tagCompoundResult = new NBTTagCompound();
                tagCompoundResult.func_74780_a("posX", result.position.x);
                tagCompoundResult.func_74780_a("posY", result.position.y);
                tagCompoundResult.func_74780_a("posZ", result.position.z);
                tagCompoundResult.func_74780_a("motionX", result.motion.x);
                tagCompoundResult.func_74780_a("motionY", result.motion.y);
                tagCompoundResult.func_74780_a("motionZ", result.motion.z);
                tagCompoundResult.func_74778_a("type", result.type);
                if (result.uniqueId != null) {
                    tagCompoundResult.func_186854_a("uniqueId", result.uniqueId);
                }
                if (result.name != null) {
                    tagCompoundResult.func_74778_a("name", result.name);
                }
                tagList.func_74742_a((NBTBase)tagCompoundResult);
            }
            tagCompound.func_74782_a("results", (NBTBase)tagList);
        } else {
            tagCompound.func_82580_o("results");
        }
        return tagCompound;
    }

    @Nonnull
    private WarpDriveText getSensorStatus() {
        if (!this.hasImageRecognition) {
            return new WarpDriveText();
        }
        if (this.results.isEmpty()) {
            return new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.optical_sensor.status_line.no_result", new Object[0]);
        }
        return new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.optical_sensor.status_line.result_count", this.results.size());
    }

    @Override
    public WarpDriveText getStatus() {
        WarpDriveText textScanStatus = this.getSensorStatus();
        if (textScanStatus.func_150260_c().isEmpty()) {
            return super.getStatus();
        }
        return super.getStatus().append((ITextComponent)textScanStatus);
    }

    public Object[] videoChannel(@Nonnull Object[] arguments) {
        if (arguments.length == 1) {
            this.setVideoChannel(Commons.toInt(arguments[0]));
        }
        return new Integer[]{this.getVideoChannel()};
    }

    private Object[] getResults() {
        if (this.results == null) {
            return null;
        }
        Object[] objectResults = new Object[this.results.size()];
        int index = 0;
        for (Result result : this.results) {
            objectResults[index++] = new Object[]{result.type, result.name == null ? "" : result.name, result.position.x, result.position.y, result.position.z, result.motion.x, result.motion.y, result.motion.z};
        }
        return objectResults;
    }

    private Object[] getResultsCount() {
        if (this.results != null) {
            return new Integer[]{this.results.size()};
        }
        return new Integer[]{-1};
    }

    private Object[] getResult(@Nonnull Object[] arguments) {
        if (arguments.length == 1 && this.results != null) {
            Result result;
            int index;
            try {
                index = Commons.toInt(arguments[0]);
            }
            catch (Exception exception) {
                return new Object[]{false, "!ERROR!", "!ERROR!", 0, 0, 0, 0, 0, 0};
            }
            if (index >= 0 && index < this.results.size() && (result = this.results.get(index)) != null) {
                return new Object[]{true, result.type, result.name == null ? "" : result.name, result.position.x, result.position.y, result.position.z, result.motion.x, result.motion.y, result.motion.z};
            }
        }
        return new Object[]{false, "!ERROR!", "!ERROR!", 0, 0, 0, 0, 0, 0};
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] videoChannel(Context context, Arguments arguments) {
        return this.videoChannel(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getResults(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getResults();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getResultsCount(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getResultsCount();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getResult(Context context, Arguments arguments) {
        return this.getResult(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "videoChannel": {
                return this.videoChannel(arguments);
            }
            case "getResults": {
                return this.getResults();
            }
            case "getResultsCount": {
                return this.getResultsCount();
            }
            case "getResult": {
                return this.getResult(arguments);
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }

    @Override
    public String toString() {
        return String.format("%s %d %s", this.getClass().getSimpleName(), this.videoChannel, Commons.format(this.field_145850_b, this.field_174879_c));
    }

    private static final class Result {
        public Vector3 position;
        public Vector3 motion;
        public String type;
        public UUID uniqueId;
        public String name;
        private boolean isUpdated;

        Result(@Nonnull Vector3 position, @Nonnull Vector3 motion, @Nonnull String type, @Nonnull UUID uniqueId, @Nonnull String name) {
            this.position = position;
            this.motion = motion;
            this.type = type;
            this.uniqueId = uniqueId;
            this.name = name;
            this.isUpdated = false;
        }

        Result(@Nonnull Entity entity) {
            this(new Vector3(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), new Vector3(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y), Dictionary.getId(entity), entity.func_110124_au(), entity.func_70005_c_());
            this.isUpdated = true;
        }

        void markForUpdate() {
            this.isUpdated = false;
        }

        void update(@Nonnull Entity entity) {
            this.uniqueId = entity.func_110124_au();
            this.position.x = entity.field_70165_t;
            this.position.y = entity.field_70163_u + (double)entity.func_70047_e();
            this.position.z = entity.field_70161_v;
            this.motion.x = entity.field_70159_w;
            this.motion.y = entity.field_70181_x;
            this.motion.z = entity.field_70179_y;
            this.isUpdated = true;
        }

        boolean isUpdated() {
            return this.isUpdated;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object instanceof Entity) {
                Entity entity = (Entity)object;
                return (this.uniqueId == null || entity.func_110124_au().equals(this.uniqueId)) && entity.func_70005_c_().equals(this.name) && Dictionary.getId(entity).equals(this.type);
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Result that = (Result)object;
            return (this.uniqueId == null || that.uniqueId == null || that.uniqueId.equals(this.uniqueId)) && that.name.equals(this.name) && that.type.equals(this.type);
        }

        public int hashCode() {
            return this.type.hashCode() + this.name.hashCode();
        }
    }
}

