/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.detection;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.TileEntityAbstractBase;
import cr0s.warpdrive.block.TileEntityAbstractEnergyCoreOrController;
import cr0s.warpdrive.block.detection.BlockCloakingCoil;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.CloakedArea;
import cr0s.warpdrive.data.EnergyWrapper;
import cr0s.warpdrive.data.EnumComponentType;
import cr0s.warpdrive.data.SoundEvents;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.item.ItemComponent;
import cr0s.warpdrive.network.PacketHandler;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class TileEntityCloakingCore
extends TileEntityAbstractEnergyCoreOrController {
    private static final int CLOAKING_CORE_SOUND_UPDATE_TICKS = 40;
    private static final int DISTANCE_INNER_COILS_BLOCKS = 2;
    private static final int LASER_REFRESH_TICKS = 100;
    private static final int LASER_DURATION_TICKS = 110;
    private static final float[] innerCoilColor_r = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 0.75f, 0.25f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 1.0f};
    private static final float[] innerCoilColor_g = new float[]{0.0f, 0.25f, 0.75f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.5f, 0.25f, 0.0f, 0.0f};
    private static final float[] innerCoilColor_b = new float[]{0.25f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f, 1.0f, 0.75f};
    private static final TileEntityAbstractBase.UpgradeSlot upgradeSlotTransparency = new TileEntityAbstractBase.UpgradeSlot("cloaking.transparency", ItemComponent.getItemStackNoCache(EnumComponentType.DIAMOND_CRYSTAL, 6), 1);
    private final boolean[] isValidInnerCoils = new boolean[]{false, false, false, false, false, false};
    private final int[] distanceOuterCoils_blocks = new int[]{0, 0, 0, 0, 0, 0};
    private int minX = 0;
    private int minY = 0;
    private int minZ = 0;
    private int maxX = 0;
    private int maxY = 0;
    private int maxZ = 0;
    private boolean isFullyTransparent = false;
    private boolean isCloaking = false;
    private int volume = 0;
    private int energyRequired = 0;
    private int updateTicks = 0;
    private int laserDrawingTicks = 0;
    private boolean soundPlayed = false;
    private int soundTicks = 0;

    public TileEntityCloakingCore() {
        this.peripheralName = "warpdriveCloakingCore";
        this.CC_scripts = Arrays.asList("enable", "disable");
        this.registerUpgradeSlot(upgradeSlotTransparency);
    }

    @Override
    protected void onConstructed() {
        super.onConstructed();
        this.energy_setParameters(WarpDriveConfig.CLOAKING_MAX_ENERGY_STORED, 16384, 0, "EV", 2, "HV", 0);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.soundTicks;
        if (this.soundTicks < 0) {
            this.soundTicks = 40;
            this.soundPlayed = false;
        }
        boolean isRefreshNeeded = false;
        --this.updateTicks;
        if (this.updateTicks <= 0) {
            boolean shouldBeCloaking;
            this.isFullyTransparent = this.hasUpgrade(upgradeSlotTransparency);
            this.updateTicks = (!this.isFullyTransparent ? 20 : 10) * WarpDriveConfig.CLOAKING_FIELD_REFRESH_INTERVAL_SECONDS;
            this.isCloaking = WarpDrive.cloaks.isAreaExists(this.field_145850_b, this.field_174879_c);
            boolean hasEnoughPower = this.energy_consume(this.energyRequired, !this.isAssemblyValid || !this.isEnabled);
            boolean bl = shouldBeCloaking = this.isAssemblyValid && this.isEnabled && hasEnoughPower;
            if (!this.isCloaking) {
                if (shouldBeCloaking) {
                    this.updateCoils(true, true);
                    isRefreshNeeded = true;
                    CloakedArea area = WarpDrive.cloaks.updateCloakedArea(this.field_145850_b, this.field_174879_c, this.isFullyTransparent, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
                    if (!this.soundPlayed) {
                        this.soundPlayed = true;
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.CLOAK, SoundCategory.BLOCKS, 4.0f, 1.0f);
                    }
                    area.sendCloakPacketToPlayersEx(false);
                }
            } else if (shouldBeCloaking) {
                CloakedArea area = WarpDrive.cloaks.getCloakedArea(this.field_145850_b, this.field_174879_c);
                if (area == null) {
                    WarpDrive.logger.error(String.format("Cloaked area lost %s", Commons.format(this.field_145850_b, this.field_174879_c)));
                } else {
                    area.sendCloakPacketToPlayersEx(false);
                }
            } else {
                if (WarpDriveConfig.LOGGING_CLOAKING) {
                    WarpDrive.logger.info(String.format("%s Disabled, cloak field going down...", this));
                }
                if (this.isEnabled) {
                    if (!this.isAssemblyValid) {
                        if (WarpDriveConfig.LOGGING_CLOAKING) {
                            WarpDrive.logger.info(String.format("%s Coil(s) lost, cloak field is collapsing...", this));
                        }
                        this.energy_consume(this.energy_getEnergyStored());
                    } else if (!hasEnoughPower && WarpDriveConfig.LOGGING_CLOAKING) {
                        WarpDrive.logger.info(String.format("%s Low power, cloak field is collapsing...", this));
                    }
                }
                this.updateCoils(true, false);
                this.disableCloakingField();
            }
        }
        --this.laserDrawingTicks;
        if (isRefreshNeeded || this.laserDrawingTicks <= 0) {
            this.laserDrawingTicks = 100;
            if (this.isEnabled && this.isAssemblyValid) {
                this.drawLasers();
            }
        }
    }

    @Override
    public void onBlockBroken(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState) {
        this.setIsEnabled(false);
        this.updateCoils(false, false);
        this.disableCloakingField();
        super.onBlockBroken(world, blockPos, blockState);
    }

    @Override
    protected boolean doScanAssembly(boolean isDirty, WarpDriveText textReason) {
        boolean isValid = super.doScanAssembly(isDirty, textReason);
        int maxOuterCoilDistance = WarpDriveConfig.CLOAKING_MAX_FIELD_RADIUS - WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS;
        boolean isRefreshNeeded = false;
        int countIntegrity = 1;
        StringBuilder messageInnerCoils = new StringBuilder();
        StringBuilder messageOuterCoils = new StringBuilder();
        for (EnumFacing direction : EnumFacing.values()) {
            int oldCoilDistance;
            BlockPos blockPos = new BlockPos((Vec3i)this.field_174879_c.func_177967_a(direction, 2));
            boolean isInnerValid = this.field_145850_b.func_180495_p(blockPos).func_177230_c() instanceof BlockCloakingCoil;
            if (isInnerValid) {
                BlockCloakingCoil.setBlockState(this.field_145850_b, blockPos, true, this.isCloaking, false, direction);
            }
            if (isInnerValid != this.isValidInnerCoils[direction.ordinal()]) {
                isRefreshNeeded = true;
                this.isValidInnerCoils[direction.ordinal()] = isInnerValid;
            }
            if (this.isValidInnerCoils[direction.ordinal()]) {
                ++countIntegrity;
            } else {
                if (messageInnerCoils.length() != 0) {
                    messageInnerCoils.append(", ");
                }
                messageInnerCoils.append(direction.name());
            }
            int newCoilDistance = 0;
            for (int distance = 3; distance < maxOuterCoilDistance; ++distance) {
                if (!(this.field_145850_b.func_180495_p(blockPos = blockPos.func_177972_a(direction)).func_177230_c() instanceof BlockCloakingCoil)) continue;
                BlockCloakingCoil.setBlockState(this.field_145850_b, blockPos, true, this.isCloaking, true, direction);
                newCoilDistance = distance;
                break;
            }
            if (newCoilDistance != (oldCoilDistance = this.distanceOuterCoils_blocks[direction.ordinal()])) {
                BlockPos blockPosOld;
                if (oldCoilDistance > 0 && this.field_145850_b.func_180495_p(blockPosOld = this.field_174879_c.func_177967_a(direction, oldCoilDistance)).func_177230_c() instanceof BlockCloakingCoil) {
                    BlockCloakingCoil.setBlockState(this.field_145850_b, blockPos, false, false, false, EnumFacing.DOWN);
                }
                isRefreshNeeded = true;
                this.distanceOuterCoils_blocks[direction.ordinal()] = Math.max(0, newCoilDistance);
            }
            if (newCoilDistance > 0) {
                ++countIntegrity;
                continue;
            }
            if (messageOuterCoils.length() != 0) {
                messageOuterCoils.append(", ");
            }
            messageOuterCoils.append(direction.name());
        }
        float integrity = (float)countIntegrity / 13.0f;
        if (messageInnerCoils.length() > 0 && messageOuterCoils.length() > 0) {
            textReason.append(Commons.getStyleWarning(), "warpdrive.cloaking_core.missing_channeling_and_projecting_coils", Math.round(100.0f * integrity), messageInnerCoils, messageOuterCoils);
        } else if (messageInnerCoils.length() > 0) {
            textReason.append(Commons.getStyleWarning(), "warpdrive.cloaking_core.missing_channeling_coils", Math.round(100.0f * integrity), messageInnerCoils);
        } else if (messageOuterCoils.length() > 0) {
            textReason.append(Commons.getStyleWarning(), "warpdrive.cloaking_core.missing_projecting_coils", Math.round(100.0f * integrity), messageOuterCoils);
        } else {
            textReason.append(Commons.getStyleCorrect(), "warpdrive.cloaking_core.valid", new Object[0]);
        }
        isValid = isValid && countIntegrity >= 13;
        this.minX = this.field_174879_c.func_177958_n() - this.distanceOuterCoils_blocks[4] - WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS;
        this.maxX = this.field_174879_c.func_177958_n() + this.distanceOuterCoils_blocks[5] + WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS;
        this.minY = Math.max(0, this.field_174879_c.func_177956_o() - this.distanceOuterCoils_blocks[0] - WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS);
        this.maxY = Math.min(255, this.field_174879_c.func_177956_o() + this.distanceOuterCoils_blocks[1] + WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS);
        this.minZ = this.field_174879_c.func_177952_p() - this.distanceOuterCoils_blocks[2] - WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS;
        this.maxZ = this.field_174879_c.func_177952_p() + this.distanceOuterCoils_blocks[3] + WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS;
        if (this.isCloaking && isValid && isRefreshNeeded) {
            WarpDrive.cloaks.updateCloakedArea(this.field_145850_b, this.field_174879_c, this.isFullyTransparent, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }
        if (this.isEnabled && isValid) {
            this.updateVolumeAndEnergyRequired();
        }
        return isValid;
    }

    private void updateVolumeAndEnergyRequired() {
        int energyRequired_new;
        int volume_new = 0;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(this.field_174879_c);
        if (!this.isFullyTransparent) {
            for (int y = this.minY; y <= this.maxY; ++y) {
                for (int x = this.minX; x <= this.maxX; ++x) {
                    for (int z = this.minZ; z <= this.maxZ; ++z) {
                        mutableBlockPos.func_181079_c(x, y, z);
                        if (this.field_145850_b.func_175623_d((BlockPos)mutableBlockPos)) continue;
                        ++volume_new;
                    }
                }
            }
            energyRequired_new = volume_new * WarpDriveConfig.CLOAKING_TIER1_ENERGY_PER_BLOCK;
        } else {
            for (int y = this.minY; y <= this.maxY; ++y) {
                for (int x = this.minX; x <= this.maxX; ++x) {
                    for (int z = this.minZ; z <= this.maxZ; ++z) {
                        mutableBlockPos.func_181079_c(x, y, z);
                        if (this.field_145850_b.func_180495_p((BlockPos)mutableBlockPos).func_177230_c() == Blocks.field_150350_a) continue;
                        ++volume_new;
                    }
                }
            }
            energyRequired_new = volume_new * WarpDriveConfig.CLOAKING_TIER2_ENERGY_PER_BLOCK;
        }
        this.volume = volume_new;
        this.energyRequired = energyRequired_new;
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(String.format("%s Requiring %d EU for %d blocks", this, this.energyRequired, this.volume));
        }
    }

    @Override
    protected void doUpdateParameters(boolean isDirty) {
    }

    private void updateCoils(boolean isConnected, boolean isActive) {
        if (isConnected) {
            this.updateBlockState((IBlockState)null, BlockProperties.ACTIVE, isActive);
        }
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            if (this.isValidInnerCoils[direction.ordinal()]) {
                this.updateCoil(isConnected, isActive, direction, 2);
            }
            if (this.distanceOuterCoils_blocks[direction.ordinal()] <= 0) continue;
            this.updateCoil(isConnected, isActive, direction, this.distanceOuterCoils_blocks[direction.ordinal()]);
        }
    }

    private void updateCoil(boolean isConnected, boolean isActive, EnumFacing direction, int distance) {
        BlockPos blockPos = this.field_174879_c.func_177967_a(direction, distance);
        IBlockState blockState = this.field_145850_b.func_180495_p(blockPos);
        if (blockState.func_177230_c() instanceof BlockCloakingCoil) {
            if (isConnected) {
                if (distance == 2) {
                    BlockCloakingCoil.setBlockState(this.field_145850_b, blockPos, true, isActive, false, EnumFacing.DOWN);
                } else {
                    BlockCloakingCoil.setBlockState(this.field_145850_b, blockPos, true, isActive, true, direction);
                }
            } else {
                BlockCloakingCoil.setBlockState(this.field_145850_b, blockPos, false, false, true, EnumFacing.DOWN);
            }
        }
    }

    private void drawLasers() {
        float b;
        float g;
        float r;
        if (!this.isCloaking) {
            r = 0.75f;
            g = 0.5f;
            b = 0.5f;
        } else if (!this.isFullyTransparent) {
            r = 0.0f;
            g = 1.0f;
            b = 0.25f;
        } else {
            r = 0.0f;
            g = 0.25f;
            b = 1.0f;
        }
        for (EnumFacing direction : EnumFacing.values()) {
            if (!this.isValidInnerCoils[direction.ordinal()] || this.distanceOuterCoils_blocks[direction.ordinal()] <= 0) continue;
            PacketHandler.sendBeamPacketToPlayersInArea(this.field_145850_b, new Vector3((double)this.field_174879_c.func_177958_n() + 0.5 + 2.3 * (double)direction.func_82601_c(), (double)this.field_174879_c.func_177956_o() + 0.5 + 2.3 * (double)direction.func_96559_d(), (double)this.field_174879_c.func_177952_p() + 0.5 + 2.3 * (double)direction.func_82599_e()), new Vector3((double)this.field_174879_c.func_177958_n() + 0.5 + (double)(this.distanceOuterCoils_blocks[direction.ordinal()] * direction.func_82601_c()), (double)this.field_174879_c.func_177956_o() + 0.5 + (double)(this.distanceOuterCoils_blocks[direction.ordinal()] * direction.func_96559_d()), (double)this.field_174879_c.func_177952_p() + 0.5 + (double)(this.distanceOuterCoils_blocks[direction.ordinal()] * direction.func_82599_e())), r, g, b, 110, new AxisAlignedBB((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ));
        }
        for (int i = 0; i < 5; ++i) {
            EnumFacing start = EnumFacing.field_82609_l[i];
            for (int j = i + 1; j < 6; ++j) {
                EnumFacing stop = EnumFacing.field_82609_l[j];
                if (start.func_176734_d() == stop) continue;
                int mapIndex = this.field_145850_b.field_73012_v.nextInt(innerCoilColor_b.length);
                r = innerCoilColor_r[mapIndex];
                g = innerCoilColor_g[mapIndex];
                b = innerCoilColor_b[mapIndex];
                PacketHandler.sendBeamPacketToPlayersInArea(this.field_145850_b, new Vector3((double)this.field_174879_c.func_177958_n() + 0.5 + 2.3 * (double)start.func_82601_c() + 0.2 * (double)stop.func_82601_c(), (double)this.field_174879_c.func_177956_o() + 0.5 + 2.3 * (double)start.func_96559_d() + 0.2 * (double)stop.func_96559_d(), (double)this.field_174879_c.func_177952_p() + 0.5 + 2.3 * (double)start.func_82599_e() + 0.2 * (double)stop.func_82599_e()), new Vector3((double)this.field_174879_c.func_177958_n() + 0.5 + 2.3 * (double)stop.func_82601_c() + 0.2 * (double)start.func_82601_c(), (double)this.field_174879_c.func_177956_o() + 0.5 + 2.3 * (double)stop.func_96559_d() + 0.2 * (double)start.func_96559_d(), (double)this.field_174879_c.func_177952_p() + 0.5 + 2.3 * (double)stop.func_82599_e() + 0.2 * (double)start.func_82599_e()), r, g, b, 110, new AxisAlignedBB((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ));
            }
        }
    }

    public void disableCloakingField() {
        if (WarpDrive.cloaks.isAreaExists(this.field_145850_b, this.field_174879_c)) {
            WarpDrive.cloaks.removeCloakedArea(this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c);
            if (!this.soundPlayed) {
                this.soundPlayed = true;
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.DECLOAK, SoundCategory.BLOCKS, 4.0f, 1.0f);
            }
        }
    }

    @Override
    public WarpDriveText getStatusHeader() {
        if (this.field_145850_b == null) {
            return super.getStatusHeader();
        }
        WarpDriveText textStatus = !this.isAssemblyValid ? this.textValidityIssues : (!this.isEnabled ? new WarpDriveText(Commons.getStyleNormal(), "warpdrive.cloaking_core.disabled", this.isFullyTransparent ? 2 : 1, this.volume) : (!this.isCloaking ? new WarpDriveText(Commons.getStyleWarning(), "warpdrive.cloaking_core.low_power", this.isFullyTransparent ? 2 : 1, this.volume) : new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.cloaking_core.cloaking", this.isFullyTransparent ? 2 : 1, this.volume)));
        return super.getStatusHeader().append((ITextComponent)textStatus);
    }

    @Override
    public Object[] getEnergyRequired() {
        String units = this.energy_getDisplayUnits();
        double updateRate = (!this.isFullyTransparent ? 20 : 10) * WarpDriveConfig.CLOAKING_FIELD_REFRESH_INTERVAL_SECONDS;
        double energyRate = (double)this.energyRequired / updateRate;
        return new Object[]{true, EnergyWrapper.convert((long)Math.ceil(energyRate), units)};
    }

    @Override
    public boolean energy_canInput(EnumFacing from) {
        return true;
    }
}

