/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.detection;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IVideoChannel;
import cr0s.warpdrive.block.TileEntityAbstractMachine;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.network.PacketHandler;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Optional;

public class TileEntityMonitor
extends TileEntityAbstractMachine
implements IVideoChannel {
    private int videoChannel = -1;
    private static final int PACKET_SEND_INTERVAL_TICKS = 1200;
    private int packetSendTicks = 10;

    public TileEntityMonitor() {
        this.peripheralName = "warpdriveMonitor";
        this.addMethods(new String[]{"videoChannel"});
        this.doRequireUpgradeToInterface();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            --this.packetSendTicks;
            if (this.packetSendTicks <= 0) {
                this.packetSendTicks = 1200;
                PacketHandler.sendVideoChannelPacket(this.field_145850_b, this.field_174879_c, this.videoChannel);
            }
        }
    }

    @Override
    public int getVideoChannel() {
        return this.videoChannel;
    }

    @Override
    public void setVideoChannel(int parVideoChannel) {
        if (this.videoChannel != parVideoChannel && IVideoChannel.isValid(parVideoChannel)) {
            this.videoChannel = parVideoChannel;
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info(this + " Monitor video channel set to " + this.videoChannel);
            }
            this.func_70296_d();
            this.packetSendTicks = 0;
        }
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.videoChannel = tagCompound.func_74762_e("frequency") + tagCompound.func_74762_e("videoChannel");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("videoChannel", this.videoChannel);
        return tagCompound;
    }

    public Object[] videoChannel(Object[] arguments) {
        if (arguments.length == 1) {
            this.setVideoChannel(Commons.toInt(arguments[0]));
        }
        return new Integer[]{this.getVideoChannel()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] videoChannel(Context context, Arguments arguments) {
        return this.videoChannel(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "videoChannel": {
                return this.videoChannel(arguments);
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }

    @Override
    public String toString() {
        return String.format("%s %d %s", this.getClass().getSimpleName(), this.videoChannel, Commons.format(this.field_145850_b, this.field_174879_c));
    }
}

