/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.detection;

import cr0s.warpdrive.block.TileEntityAbstractMachine;
import cr0s.warpdrive.block.detection.BlockSiren;
import cr0s.warpdrive.client.SirenSound;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.SoundEvents;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySiren
extends TileEntityAbstractMachine {
    private EnumSirenState enumSirenState = EnumSirenState.STOPPED;
    private boolean isIndustrial = false;
    private float range = 0.0f;
    private int tickUpdate = 0;
    @SideOnly(value=Side.CLIENT)
    private SirenSound sound;

    public TileEntitySiren() {
        this.peripheralName = "warpdriveSiren";
        this.doRequireUpgradeToInterface();
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        this.range = WarpDriveConfig.SIREN_RANGE_BLOCKS_BY_TIER[this.enumTier.getIndex()];
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.isIndustrial = ((BlockSiren)blockState.func_177230_c()).getIsIndustrial();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        --this.tickUpdate;
        if (this.tickUpdate > 0) {
            return;
        }
        this.tickUpdate = 10;
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.sound == null) {
            this.setSound();
        }
        switch (this.enumSirenState) {
            case STOPPED: {
                if (this.isPlaying()) {
                    this.enumSirenState = EnumSirenState.STOPPING;
                    break;
                }
                if (!this.isPowered()) break;
                this.enumSirenState = EnumSirenState.STARTING;
                break;
            }
            case STARTING: {
                if (this.startSound()) {
                    this.enumSirenState = EnumSirenState.STARTED;
                    break;
                }
                this.enumSirenState = EnumSirenState.STOPPING;
                break;
            }
            case STARTED: {
                if (!this.isPowered()) {
                    this.enumSirenState = EnumSirenState.STOPPING;
                    break;
                }
                if (this.isPlaying()) break;
                this.enumSirenState = EnumSirenState.STARTING;
                break;
            }
            case STOPPING: {
                if (this.isPlaying()) {
                    this.stopSound();
                    break;
                }
                this.enumSirenState = EnumSirenState.STOPPED;
                break;
            }
            default: {
                this.enumSirenState = this.isPlaying() ? EnumSirenState.STOPPING : EnumSirenState.STOPPED;
            }
        }
    }

    @Override
    public void onChunkUnload() {
        if (this.field_145850_b.field_72995_K && this.isPlaying()) {
            this.stopSound();
        }
        super.onChunkUnload();
    }

    @Override
    public void func_145843_s() {
        if (this.field_145850_b.field_72995_K && this.isPlaying()) {
            this.stopSound();
        }
        super.func_145843_s();
    }

    @SideOnly(value=Side.CLIENT)
    private void setSound() {
        this.sound = new SirenSound(this.isIndustrial ? SoundEvents.SIREN_INDUSTRIAL : SoundEvents.SIREN_RAID, this.range, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
    }

    @SideOnly(value=Side.CLIENT)
    private boolean startSound() {
        if (!this.isPlaying()) {
            try {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.sound);
                return true;
            }
            catch (IllegalArgumentException exception) {
                return false;
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    void stopSound() {
        Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)this.sound);
    }

    @SideOnly(value=Side.CLIENT)
    boolean isPlaying() {
        return Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)this.sound);
    }

    private boolean isPowered() {
        return this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
    }

    public static enum EnumSirenState {
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

