/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.detection;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.TileEntityAbstractMachine;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.Optional;

public class TileEntitySpeaker
extends TileEntityAbstractMachine {
    private final float rateDecayPerTick = WarpDriveConfig.SPEAKER_RATE_MAX_MESSAGES / (float)WarpDriveConfig.SPEAKER_RATE_PERIOD_TICKS;
    private AxisAlignedBB aabbRange = null;
    private float rateMessaging = 0.0f;
    private final Queue<String> messagesToSpeak = new LinkedList<String>();

    public TileEntitySpeaker() {
        this.peripheralName = "warpdriveSpeaker";
        this.addMethods(new String[]{"speak"});
        this.CC_scripts = Collections.singletonList("speak");
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        float range = WarpDriveConfig.SPEAKER_RANGE_BLOCKS_BY_TIER[this.enumTier.getIndex()];
        this.aabbRange = new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() - range), (double)((float)this.field_174879_c.func_177956_o() - range), (double)((float)this.field_174879_c.func_177952_p() - range), (double)((float)this.field_174879_c.func_177958_n() + range) + 1.0, (double)((float)this.field_174879_c.func_177956_o() + range) + 1.0, (double)((float)this.field_174879_c.func_177952_p() + range) + 1.0);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.rateMessaging = Math.max(0.0f, this.rateMessaging - this.rateDecayPerTick);
        if (this.isEnabled && !this.messagesToSpeak.isEmpty() && this.rateMessaging + 1.0f < WarpDriveConfig.SPEAKER_RATE_MAX_MESSAGES) {
            String messageRaw = this.messagesToSpeak.remove();
            WarpDriveText messageFormatted = new WarpDriveText(null, messageRaw, new Object[0]);
            List playersInRange = this.field_145850_b.func_175647_a(EntityPlayerMP.class, this.aabbRange, entityPlayerMP -> entityPlayerMP != null && entityPlayerMP.func_70089_S() && !entityPlayerMP.func_175149_v());
            for (EntityPlayerMP entityPlayerMP2 : playersInRange) {
                Commons.addChatMessage((ICommandSender)entityPlayerMP2, (ITextComponent)messageFormatted);
            }
            this.rateMessaging += 1.0f;
        }
    }

    public Object[] speak(Object[] arguments) {
        int size = this.messagesToSpeak.size();
        if (arguments.length == 1) {
            if ((float)size >= WarpDriveConfig.SPEAKER_QUEUE_MAX_MESSAGES) {
                return new Object[]{false, "You're speaking too fast... breath!"};
            }
            this.messagesToSpeak.add(Commons.toString(arguments[0]));
            ++size;
        }
        return new Object[]{true, size};
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] speak(Context context, Arguments arguments) {
        return this.speak(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "speak": {
                return this.speak(arguments);
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }

    @Override
    public String toString() {
        return String.format("%s %s %s messages queued", this.getClass().getSimpleName(), Commons.format(this.field_145850_b, this.field_174879_c), this.messagesToSpeak.size());
    }
}

