/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.energy;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IWarpTool;
import cr0s.warpdrive.block.BlockAbstractContainer;
import cr0s.warpdrive.block.energy.ItemBlockCapacitor;
import cr0s.warpdrive.block.energy.TileEntityCapacitor;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumDisabledInputOutput;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.event.ModelBakeEventHandler;
import cr0s.warpdrive.render.BakedModelCapacitor;
import ic2.api.energy.tile.IExplosionPowerOverride;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IExplosionPowerOverride", modid="ic2")})
public class BlockCapacitor
extends BlockAbstractContainer
implements IExplosionPowerOverride {
    public static final IProperty<EnumDisabledInputOutput> CONFIG = PropertyEnum.func_177709_a((String)"config", EnumDisabledInputOutput.class);
    public static final IUnlistedProperty<EnumDisabledInputOutput> DOWN = Properties.toUnlisted((IProperty)PropertyEnum.func_177709_a((String)"down", EnumDisabledInputOutput.class));
    public static final IUnlistedProperty<EnumDisabledInputOutput> UP = Properties.toUnlisted((IProperty)PropertyEnum.func_177709_a((String)"up", EnumDisabledInputOutput.class));
    public static final IUnlistedProperty<EnumDisabledInputOutput> NORTH = Properties.toUnlisted((IProperty)PropertyEnum.func_177709_a((String)"north", EnumDisabledInputOutput.class));
    public static final IUnlistedProperty<EnumDisabledInputOutput> SOUTH = Properties.toUnlisted((IProperty)PropertyEnum.func_177709_a((String)"south", EnumDisabledInputOutput.class));
    public static final IUnlistedProperty<EnumDisabledInputOutput> WEST = Properties.toUnlisted((IProperty)PropertyEnum.func_177709_a((String)"west", EnumDisabledInputOutput.class));
    public static final IUnlistedProperty<EnumDisabledInputOutput> EAST = Properties.toUnlisted((IProperty)PropertyEnum.func_177709_a((String)"east", EnumDisabledInputOutput.class));

    public BlockCapacitor(String registryName, EnumTier enumTier) {
        super(registryName, enumTier, Material.field_151573_f);
        this.func_149663_c("warpdrive.energy.capacitor." + enumTier.func_176610_l());
        this.func_180632_j(this.func_176223_P().func_177226_a(CONFIG, (Comparable)((Object)EnumDisabledInputOutput.DISABLED)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{CONFIG}, new IUnlistedProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST});
    }

    @Nonnull
    public IBlockState func_176203_a(int metadata) {
        return this.func_176223_P();
    }

    public int func_176201_c(@Nonnull IBlockState blockState) {
        return 0;
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState blockState, IBlockAccess blockAccess, BlockPos blockPos) {
        if (!(blockState instanceof IExtendedBlockState)) {
            WarpDrive.logger.error(String.format("%s Invalid call to getExtendedState() with invalid state %s %s", this, blockState, Commons.format(blockAccess, blockPos)));
            return blockState;
        }
        TileEntity tileEntity = blockAccess.func_175625_s(blockPos);
        if (!(tileEntity instanceof TileEntityCapacitor)) {
            WarpDrive.logger.error(String.format("%s Invalid TileEntityCapacitor instance for %s %s: %s", this, blockState, Commons.format(blockAccess, blockPos), tileEntity));
            return blockState;
        }
        TileEntityCapacitor tileEntityCapacitor = (TileEntityCapacitor)tileEntity;
        return ((IExtendedBlockState)blockState).withProperty(DOWN, (Object)tileEntityCapacitor.getMode(EnumFacing.DOWN)).withProperty(UP, (Object)tileEntityCapacitor.getMode(EnumFacing.UP)).withProperty(NORTH, (Object)tileEntityCapacitor.getMode(EnumFacing.NORTH)).withProperty(SOUTH, (Object)tileEntityCapacitor.getMode(EnumFacing.SOUTH)).withProperty(WEST, (Object)tileEntityCapacitor.getMode(EnumFacing.WEST)).withProperty(EAST, (Object)tileEntityCapacitor.getMode(EnumFacing.EAST));
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos) {
        return super.func_176221_a(blockState, blockAccess, blockPos);
    }

    @Nonnull
    public TileEntity func_149915_a(@Nonnull World world, int metadata) {
        return new TileEntityCapacitor();
    }

    @Override
    @Nullable
    public ItemBlock createItemBlock() {
        return new ItemBlockCapacitor((Block)this);
    }

    public int func_180651_a(@Nonnull IBlockState blockState) {
        return this.func_176201_c(blockState);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(@Nonnull CreativeTabs creativeTab, @Nonnull NonNullList<ItemStack> list) {
        ItemStack itemStack = new ItemStack((Block)this, 1, 0);
        list.add((Object)itemStack);
        if (this.enumTier != EnumTier.CREATIVE) {
            itemStack = new ItemStack((Block)this, 1, 0);
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74768_a("energy", WarpDriveConfig.CAPACITOR_MAX_ENERGY_STORED_BY_TIER[this.enumTier.getIndex()]);
            itemStack.func_77982_d(tagCompound);
            list.add((Object)itemStack);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void modelInitialisation() {
        super.modelInitialisation();
        ResourceLocation registryName = this.getRegistryName();
        assert (registryName != null);
        for (EnumDisabledInputOutput enumDisabledInputOutput : CONFIG.func_177700_c()) {
            String variant = String.format("%s=%s", new Object[]{CONFIG.func_177701_a(), enumDisabledInputOutput});
            ModelBakeEventHandler.registerBakedModel(new ModelResourceLocation(registryName, variant), BakedModelCapacitor.class);
        }
    }

    public boolean shouldExplode() {
        return false;
    }

    public float getExplosionPower(int tier, float defaultPower) {
        return defaultPower;
    }

    @Override
    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumHand enumHand, @Nonnull EnumFacing enumFacing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K || enumHand != EnumHand.MAIN_HAND) {
            return super.func_180639_a(world, blockPos, blockState, entityPlayer, enumHand, enumFacing, hitX, hitY, hitZ);
        }
        ItemStack itemStackHeld = entityPlayer.func_184586_b(enumHand);
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (!(tileEntity instanceof TileEntityCapacitor)) {
            return super.func_180639_a(world, blockPos, blockState, entityPlayer, enumHand, enumFacing, hitX, hitY, hitZ);
        }
        TileEntityCapacitor tileEntityCapacitor = (TileEntityCapacitor)tileEntity;
        if (!itemStackHeld.func_190926_b() && itemStackHeld.func_77973_b() instanceof IWarpTool) {
            if (entityPlayer.func_70093_af()) {
                tileEntityCapacitor.setMode(enumFacing, tileEntityCapacitor.getMode(enumFacing).getPrevious());
            } else {
                tileEntityCapacitor.setMode(enumFacing, tileEntityCapacitor.getMode(enumFacing).getNext());
            }
            ItemStack itemStack = new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(blockState));
            switch (tileEntityCapacitor.getMode(enumFacing)) {
                case INPUT: {
                    Commons.addChatMessage((ICommandSender)entityPlayer, Commons.getChatPrefix(itemStack).func_150257_a((ITextComponent)new TextComponentTranslation("warpdrive.energy.side.changed_to_input", new Object[]{enumFacing.name()})));
                    return true;
                }
                case OUTPUT: {
                    Commons.addChatMessage((ICommandSender)entityPlayer, Commons.getChatPrefix(itemStack).func_150257_a((ITextComponent)new TextComponentTranslation("warpdrive.energy.side.changed_to_output", new Object[]{enumFacing.name()})));
                    return true;
                }
            }
            Commons.addChatMessage((ICommandSender)entityPlayer, Commons.getChatPrefix(itemStack).func_150257_a((ITextComponent)new TextComponentTranslation("warpdrive.energy.side.changed_to_disabled", new Object[]{enumFacing.name()})));
            return true;
        }
        return super.func_180639_a(world, blockPos, blockState, entityPlayer, enumHand, enumFacing, hitX, hitY, hitZ);
    }
}

