/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.energy;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractBase;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumComponentType;
import cr0s.warpdrive.data.EnumDisabledInputOutput;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.item.ItemComponent;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class TileEntityCapacitor
extends TileEntityAbstractEnergy {
    private static final String TAG_MODE_SIDE = "modeSide";
    private static final EnumDisabledInputOutput[] MODE_DEFAULT_SIDES = new EnumDisabledInputOutput[]{EnumDisabledInputOutput.INPUT, EnumDisabledInputOutput.INPUT, EnumDisabledInputOutput.OUTPUT, EnumDisabledInputOutput.OUTPUT, EnumDisabledInputOutput.OUTPUT, EnumDisabledInputOutput.OUTPUT};
    private static final TileEntityAbstractBase.UpgradeSlot upgradeSlotEfficiency = new TileEntityAbstractBase.UpgradeSlot("capacitor.efficiency", ItemComponent.getItemStackNoCache(EnumComponentType.SUPERCONDUCTOR, 1), WarpDriveConfig.CAPACITOR_EFFICIENCY_PER_UPGRADE.length - 1);
    private EnumDisabledInputOutput[] modeSide = (EnumDisabledInputOutput[])MODE_DEFAULT_SIDES.clone();

    public TileEntityCapacitor() {
        this.peripheralName = "warpdriveCapacitor";
        this.doRequireUpgradeToInterface();
        this.registerUpgradeSlot(upgradeSlotEfficiency);
    }

    @Override
    protected void onConstructed() {
        super.onConstructed();
        this.energy_setParameters(WarpDriveConfig.CAPACITOR_MAX_ENERGY_STORED_BY_TIER[this.enumTier.getIndex()], WarpDriveConfig.CAPACITOR_FLUX_RATE_INPUT_BY_TIER[this.enumTier.getIndex()], WarpDriveConfig.CAPACITOR_FLUX_RATE_OUTPUT_BY_TIER[this.enumTier.getIndex()], WarpDriveConfig.CAPACITOR_IC2_SINK_TIER_NAME_BY_TIER[this.enumTier.getIndex()], 2, WarpDriveConfig.CAPACITOR_IC2_SOURCE_TIER_NAME_BY_TIER[this.enumTier.getIndex()], 2);
    }

    private double getEfficiency() {
        int upgradeCount = this.getValidUpgradeCount(upgradeSlotEfficiency);
        return WarpDriveConfig.CAPACITOR_EFFICIENCY_PER_UPGRADE[upgradeCount];
    }

    @Override
    public long energy_getEnergyStored() {
        if (this.enumTier == EnumTier.CREATIVE) {
            return (long)WarpDriveConfig.CAPACITOR_MAX_ENERGY_STORED_BY_TIER[0] / 2L;
        }
        return super.energy_getEnergyStored();
    }

    @Override
    public int energy_getPotentialOutput() {
        if (this.enumTier == null) {
            if (Commons.throttleMe("TileEntityCapacitor.notier")) {
                new RuntimeException(String.format("%s no tier defined yet, probably an invalid call, please report to mod author", this)).printStackTrace(WarpDrive.printStreamError);
            }
            return (int)Math.round((double)this.energy_getEnergyStored() * this.getEfficiency());
        }
        return (int)Math.round(Math.min((double)this.energy_getEnergyStored() * this.getEfficiency(), (double)WarpDriveConfig.CAPACITOR_FLUX_RATE_OUTPUT_BY_TIER[this.enumTier.getIndex()]));
    }

    @Override
    public boolean energy_consume(long amount_internal, boolean simulate) {
        if (this.enumTier == EnumTier.CREATIVE) {
            return true;
        }
        long amountWithLoss = Math.round((double)amount_internal / this.getEfficiency());
        if (this.energy_getEnergyStored() >= amountWithLoss) {
            if (!simulate) {
                super.energy_consume(amountWithLoss);
            }
            return true;
        }
        return false;
    }

    @Override
    public void energy_consume(long amount_internal) {
        if (this.enumTier == EnumTier.CREATIVE) {
            return;
        }
        long amountWithLoss = Math.round(amount_internal > 0L ? (double)amount_internal / this.getEfficiency() : (double)amount_internal * this.getEfficiency());
        super.energy_consume(amountWithLoss);
    }

    @Override
    public boolean energy_canInput(EnumFacing from) {
        if (from != null) {
            return this.modeSide[from.ordinal()] == EnumDisabledInputOutput.INPUT;
        }
        for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
            if (this.modeSide[enumFacing.ordinal()] != EnumDisabledInputOutput.INPUT) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean energy_canOutput(EnumFacing to) {
        if (to != null) {
            return this.modeSide[to.ordinal()] == EnumDisabledInputOutput.OUTPUT;
        }
        for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
            if (this.modeSide[enumFacing.ordinal()] != EnumDisabledInputOutput.OUTPUT) continue;
            return true;
        }
        return false;
    }

    protected EnumDisabledInputOutput getMode(EnumFacing facing) {
        return this.modeSide[facing.ordinal()];
    }

    void setMode(EnumFacing facing, EnumDisabledInputOutput enumDisabledInputOutput) {
        this.modeSide[facing.ordinal()] = enumDisabledInputOutput;
        this.func_70296_d();
        this.energy_refreshConnections();
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        byte[] bytes = new byte[EnumFacing.values().length];
        for (EnumFacing enumFacing : EnumFacing.values()) {
            bytes[enumFacing.ordinal()] = (byte)this.modeSide[enumFacing.ordinal()].getIndex();
        }
        tagCompound.func_74773_a(TAG_MODE_SIDE, bytes);
        return tagCompound;
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        byte[] bytes = tagCompound.func_74770_j(TAG_MODE_SIDE);
        if (bytes.length != 6) {
            this.modeSide = (EnumDisabledInputOutput[])MODE_DEFAULT_SIDES.clone();
        } else {
            boolean isUpdated = false;
            for (EnumFacing enumFacing : EnumFacing.values()) {
                isUpdated |= this.modeSide[enumFacing.ordinal()] != EnumDisabledInputOutput.get(bytes[enumFacing.ordinal()]);
                this.modeSide[enumFacing.ordinal()] = EnumDisabledInputOutput.get(bytes[enumFacing.ordinal()]);
            }
            if (isUpdated && this.func_145830_o() && this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            }
        }
    }

    @Override
    public NBTTagCompound writeItemDropNBT(NBTTagCompound tagCompound) {
        tagCompound = super.writeItemDropNBT(tagCompound);
        return tagCompound;
    }

    @Override
    public String toString() {
        if (this.enumTier == null) {
            return String.format("%s %s", this.getClass().getSimpleName(), Commons.format(this.field_145850_b, this.field_174879_c));
        }
        return String.format("%s %s %8d", this.getClass().getSimpleName(), Commons.format(this.field_145850_b, this.field_174879_c), this.energy_getEnergyStored());
    }
}

