/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.energy;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.api.computer.IEnanReactorLaser;
import cr0s.warpdrive.block.TileEntityAbstractLaser;
import cr0s.warpdrive.block.energy.TileEntityEnanReactorCore;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.EnergyWrapper;
import cr0s.warpdrive.data.ReactorFace;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.network.PacketHandler;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.Optional;

public class TileEntityEnanReactorLaser
extends TileEntityAbstractLaser
implements IEnanReactorLaser {
    private ReactorFace reactorFace = ReactorFace.UNKNOWN;
    private int energyStabilizationRequest = 0;
    private Vector3 vLaser;
    private String reactorSignatureName;
    private WeakReference<TileEntityEnanReactorCore> weakReactorCore;

    public TileEntityEnanReactorLaser() {
        this.peripheralName = "warpdriveEnanReactorLaser";
        this.addMethods(new String[]{"side", "stabilize"});
        this.laserMedium_maxCount = 1;
        this.laserMedium_directionsValid = new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN};
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        if (this.reactorFace == ReactorFace.UNKNOWN) {
            this.onBlockUpdateDetected();
        }
        this.vLaser = new Vector3(this).translate(0.5);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.energyStabilizationRequest > 0) {
            this.doStabilize(this.energyStabilizationRequest);
            this.energyStabilizationRequest = 0;
        }
    }

    @Nonnull
    public ReactorFace getReactorFace() {
        return this.reactorFace != null ? this.reactorFace : ReactorFace.UNKNOWN;
    }

    public void setReactorFace(@Nonnull ReactorFace reactorFace, TileEntityEnanReactorCore reactorCore) {
        if (this.reactorFace != reactorFace && this.reactorFace != ReactorFace.UNKNOWN && this.getReactorCore() != null) {
            return;
        }
        this.reactorSignatureName = reactorCore != null ? reactorCore.getSignatureName() : "";
        IBlockState blockState_old = this.field_145850_b.func_180495_p(this.field_174879_c);
        IBlockState blockState_new = reactorFace.facingLaserProperty != null ? blockState_old.func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockProperties.FACING, (Comparable)reactorFace.facingLaserProperty) : blockState_old.func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockProperties.FACING, (Comparable)EnumFacing.DOWN);
        this.updateBlockState(blockState_old, blockState_new);
        if (this.reactorFace == reactorFace) {
            return;
        }
        this.reactorFace = reactorFace;
        this.weakReactorCore = reactorCore != null && reactorFace != ReactorFace.UNKNOWN ? new WeakReference<TileEntityEnanReactorCore>(reactorCore) : null;
    }

    @Nullable
    private TileEntityEnanReactorCore getReactorCore() {
        TileEntityEnanReactorCore reactorCore;
        if (this.reactorFace == ReactorFace.UNKNOWN) {
            return null;
        }
        TileEntityEnanReactorCore tileEntityEnanReactorCore = reactorCore = this.weakReactorCore != null ? (TileEntityEnanReactorCore)this.weakReactorCore.get() : null;
        if (reactorCore == null) {
            BlockPos blockPos = this.field_174879_c.func_177982_a(-this.reactorFace.x, -this.reactorFace.y, -this.reactorFace.z);
            TileEntity tileEntity = this.field_145850_b.func_175625_s(blockPos);
            if (tileEntity instanceof TileEntityEnanReactorCore) {
                reactorCore = (TileEntityEnanReactorCore)tileEntity;
                this.weakReactorCore = new WeakReference<TileEntityEnanReactorCore>(reactorCore);
            } else {
                WarpDrive.logger.error(String.format("%s Invalid TileEntityEnanReactorCore %s: %s", this, Commons.format(this.field_145850_b, this.field_174879_c), tileEntity));
                this.reactorFace = ReactorFace.UNKNOWN;
            }
        }
        return reactorCore;
    }

    @Override
    public void onBlockUpdateDetected() {
        super.onBlockUpdateDetected();
        TileEntityEnanReactorCore reactorCore = this.getReactorCore();
        if (reactorCore != null) {
            reactorCore.onBlockUpdateDetected();
        } else {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(this.field_174879_c);
            for (ReactorFace reactorFace : ReactorFace.getLasers()) {
                TileEntity tileEntity;
                if (reactorFace.indexStability < 0) continue;
                mutableBlockPos.func_181079_c(this.field_174879_c.func_177958_n() - reactorFace.x, this.field_174879_c.func_177956_o() - reactorFace.y, this.field_174879_c.func_177952_p() - reactorFace.z);
                if (!this.field_145850_b.func_175668_a((BlockPos)mutableBlockPos, true) || !((tileEntity = this.field_145850_b.func_175625_s((BlockPos)mutableBlockPos)) instanceof TileEntityEnanReactorCore)) continue;
                ((TileEntityEnanReactorCore)tileEntity).onBlockUpdateDetected();
            }
        }
    }

    @Override
    protected boolean doScanAssembly(boolean isDirty, WarpDriveText textReason) {
        boolean isValid = super.doScanAssembly(isDirty, textReason);
        if (this.reactorFace == ReactorFace.UNKNOWN) {
            textReason.append(Commons.getStyleWarning(), "warpdrive.enan_reactor.status_line.missing_reactor_core", new Object[0]);
            return false;
        }
        return isValid;
    }

    protected int stabilize(int energy) {
        if (energy <= 0) {
            return 0;
        }
        if (this.laserMedium_direction == null) {
            WarpDrive.logger.warn(String.format("ReactorLaser %s on %s side doesn't have a laser medium, unable to stabilize %d", Commons.format(this.field_145850_b, this.field_174879_c), this.reactorFace.name, energy));
            return 0;
        }
        if (this.reactorFace == ReactorFace.UNKNOWN) {
            WarpDrive.logger.warn(String.format("ReactorLaser %s on %s side doesn't have a core to stabilize %d", Commons.format(this.field_145850_b, this.field_174879_c), this.reactorFace.name, energy));
            return 0;
        }
        if (this.energyStabilizationRequest > 0) {
            WarpDrive.logger.debug(String.format("%s Stabilization already requested for %s", this, energy));
            return -energy;
        }
        this.energyStabilizationRequest = energy;
        return energy;
    }

    private void doStabilize(int energy) {
        if (energy <= 0) {
            WarpDrive.logger.error(String.format("ReactorLaser %s on %s side can't stabilize without energy, please report to mod author %d", Commons.format(this.field_145850_b, this.field_174879_c), this.reactorFace.name, energy));
            return;
        }
        if (this.laserMedium_direction == null) {
            WarpDrive.logger.warn(String.format("ReactorLaser %s on %s side no longer has a laser medium, unable to stabilize %d", Commons.format(this.field_145850_b, this.field_174879_c), this.reactorFace.name, energy));
            return;
        }
        TileEntityEnanReactorCore reactorCore = this.getReactorCore();
        if (reactorCore == null) {
            WarpDrive.logger.warn(String.format("ReactorLaser %s on %s side no longer has a core to stabilize %d", Commons.format(this.field_145850_b, this.field_174879_c), this.reactorFace.name, energy));
            return;
        }
        if (!this.laserMedium_consumeExactly(energy, false)) {
            WarpDrive.logger.warn(String.format("ReactorLaser %s on %s side doesn't have enough energy %d/%d while core can output %d/%d", Commons.format(this.field_145850_b, this.field_174879_c), this.reactorFace.name, this.laserMedium_getEnergyStored(true), energy, reactorCore.energy_getPotentialOutput(), reactorCore.energy_getEnergyStored()));
            return;
        }
        if (WarpDriveConfig.LOGGING_ENERGY && WarpDriveConfig.LOGGING_LUA) {
            WarpDrive.logger.info(String.format("ReactorLaser %s on %s side stabilizing %d", Commons.format(this.field_145850_b, this.field_174879_c), this.reactorFace.name, energy));
        }
        reactorCore.decreaseInstability(this.reactorFace, energy);
        Vector3 vReactorCore = reactorCore.getCenter();
        if (vReactorCore == null) {
            WarpDrive.logger.warn(String.format("ReactorLaser %s on %s side has a core %s with no center defined, can't stabilize %d", Commons.format(this.field_145850_b, this.field_174879_c), this.reactorFace.name, reactorCore, energy));
        } else {
            PacketHandler.sendBeamPacket(this.field_145850_b, this.vLaser, vReactorCore, 0.1f, 0.2f, 1.0f, 25, 50, 100);
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        if (this.reactorFace != null && this.reactorFace != ReactorFace.UNKNOWN) {
            tagCompound.func_74778_a("reactorFace", this.reactorFace.func_176610_l());
        }
        tagCompound.func_74768_a("energyStabilizationRequest", this.energyStabilizationRequest);
        return tagCompound;
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.reactorFace = ReactorFace.get(tagCompound.func_74779_i("reactorFace"));
        if (this.reactorFace == null) {
            this.reactorFace = ReactorFace.UNKNOWN;
        }
        this.energyStabilizationRequest = tagCompound.func_74762_e("energyStabilizationRequest");
    }

    @Override
    public NBTTagCompound writeItemDropNBT(NBTTagCompound tagCompound) {
        tagCompound = super.writeItemDropNBT(tagCompound);
        tagCompound.func_82580_o("reactorFace");
        tagCompound.func_82580_o("energyStabilizationRequest");
        return tagCompound;
    }

    @Override
    public Object[] getEnergyRequired() {
        String units = this.energy_getDisplayUnits();
        return new Object[]{true, EnergyWrapper.convert(this.energyStabilizationRequest, units)};
    }

    @Override
    public Object[] stabilize(Object[] arguments) {
        block3: {
            if (arguments.length == 1) {
                try {
                    int energy = Commons.toInt(arguments[0]);
                    return new Object[]{this.stabilize(energy)};
                }
                catch (Exception exception) {
                    if (!WarpDriveConfig.LOGGING_LUA) break block3;
                    WarpDrive.logger.error(String.format("%s LUA error on stabilize(): Integer expected for 1st argument %s", this, arguments[0]));
                }
            }
        }
        return new Object[]{this.energyStabilizationRequest};
    }

    @Override
    public Object[] side() {
        if (this.reactorFace == null || this.reactorFace.enumTier == null) {
            return new Object[]{null, null, null};
        }
        return new Object[]{this.reactorFace.indexStability, this.reactorFace.enumTier.func_176610_l(), this.reactorSignatureName};
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] stabilize(Context context, Arguments arguments) {
        return this.stabilize(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] side(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.side();
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "stabilize": {
                return this.stabilize(arguments);
            }
            case "side": {
                return this.side();
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }
}

