/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.energy;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.TileEntityAbstractLaser;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.EnergyWrapper;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.item.ItemIC2reactorLaserFocus;
import cr0s.warpdrive.network.PacketHandler;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.common.Optional;

public class TileEntityIC2reactorLaserMonitor
extends TileEntityAbstractLaser {
    private int ticks = WarpDriveConfig.IC2_REACTOR_COOLING_INTERVAL_TICKS;
    public EnumFacing facing = null;
    private boolean isValid = false;

    public TileEntityIC2reactorLaserMonitor() {
        this.laserMedium_maxCount = 1;
        this.peripheralName = "warpdriveIC2reactorLaserCooler";
        this.doRequireUpgradeToInterface();
    }

    @Optional.Method(modid="ic2")
    private IReactor findReactor() {
        for (EnumFacing facing : EnumFacing.values()) {
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(facing, 2));
            if (tileEntity == null) continue;
            IReactor output = null;
            if (tileEntity instanceof IReactor) {
                output = (IReactor)tileEntity;
            } else if (tileEntity instanceof IReactorChamber) {
                BlockPos blockPos;
                IReactor reactor = ((IReactorChamber)tileEntity).getReactorInstance();
                if (reactor == null || (blockPos = reactor.getCoreTe().func_174877_v()).func_177958_n() != this.field_174879_c.func_177958_n() + 3 * facing.func_82601_c() || blockPos.func_177956_o() != this.field_174879_c.func_177956_o() + 3 * facing.func_96559_d() || blockPos.func_177952_p() != this.field_174879_c.func_177952_p() + 3 * facing.func_82599_e()) continue;
                output = reactor;
            }
            if (output == null) continue;
            BlockPos blockPos = this.field_174879_c.func_177972_a(facing);
            IBlockState blockState = this.field_145850_b.func_180495_p(blockPos);
            Block block = blockState.func_177230_c();
            boolean isAir = block.isAir(blockState, (IBlockAccess)this.field_145850_b, blockPos);
            this.isValid = isAir || block instanceof BlockFluidBase || block instanceof IReactorChamber || !blockState.func_185904_a().func_76218_k();
            this.facing = facing;
            return output;
        }
        this.isValid = false;
        this.facing = null;
        return null;
    }

    @Optional.Method(modid="ic2")
    private boolean coolReactor(IReactor reactor) {
        for (int x = 0; x < 9; ++x) {
            for (int y = 0; y < 6; ++y) {
                ItemStack itemStack = reactor.getItemAt(x, y);
                if (itemStack == null || !(itemStack.func_77973_b() instanceof ItemIC2reactorLaserFocus)) continue;
                int heatInLaserFocus = itemStack.func_77952_i();
                int heatEnergyCap = (int)Math.floor(Math.min((double)this.laserMedium_getEnergyStored(false) / WarpDriveConfig.IC2_REACTOR_ENERGY_PER_HEAT, (double)heatInLaserFocus));
                int heatToTransfer = Math.min(heatEnergyCap, WarpDriveConfig.IC2_REACTOR_COOLING_PER_INTERVAL);
                if (heatToTransfer > 0 && this.laserMedium_consumeExactly((int)Math.ceil((double)heatToTransfer * WarpDriveConfig.IC2_REACTOR_ENERGY_PER_HEAT), false)) {
                    ItemIC2reactorLaserFocus.addHeat(itemStack, -heatToTransfer);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    @Optional.Method(modid="ic2")
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.ticks;
        if (this.ticks <= 0) {
            this.ticks = WarpDriveConfig.IC2_REACTOR_COOLING_INTERVAL_TICKS;
            IReactor reactor = this.findReactor();
            this.updateBlockState();
            if (reactor == null) {
                return;
            }
            if (this.coolReactor(reactor)) {
                Vector3 vMonitor = new Vector3(this).translate(0.5);
                PacketHandler.sendBeamPacket(this.field_145850_b, vMonitor, new Vector3(reactor.getPosition()).translate(0.5), 0.0f, 0.8f, 1.0f, 20, 0, 20);
            }
        }
    }

    private void updateBlockState() {
        IBlockState blockStateNew = this.func_145838_q().func_176223_P().func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(this.isValid)).func_177226_a((IProperty)BlockProperties.FACING, (Comparable)(this.facing != null ? this.facing : EnumFacing.DOWN));
        this.updateBlockState(blockStateNew, null, null);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("ticks", this.ticks);
        return tagCompound;
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.ticks = tagCompound.func_74762_e("ticks");
    }

    @Override
    @Optional.Method(modid="ic2")
    public WarpDriveText getStatus() {
        if (this.field_145850_b == null) {
            return super.getStatus();
        }
        if (this.facing != null) {
            return super.getStatus().append(Commons.getStyleCorrect(), "warpdrive.ic2_reactor_laser_cooler.reactor_found", this.facing.name().toLowerCase());
        }
        return super.getStatus().append(Commons.getStyleWarning(), "warpdrive.ic2_reactor_laser_cooler.no_reactor", new Object[0]);
    }

    @Override
    public Object[] getEnergyRequired() {
        String units = this.energy_getDisplayUnits();
        long energyPerTick = (long)Math.ceil((double)WarpDriveConfig.IC2_REACTOR_COOLING_PER_INTERVAL * WarpDriveConfig.IC2_REACTOR_ENERGY_PER_HEAT / (double)WarpDriveConfig.IC2_REACTOR_COOLING_INTERVAL_TICKS);
        return new Object[]{true, EnergyWrapper.convert(energyPerTick, units)};
    }
}

