/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.forcefield;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.forcefield.BlockAbstractForceField;
import cr0s.warpdrive.block.forcefield.ItemBlockForceFieldRelay;
import cr0s.warpdrive.block.forcefield.TileEntityForceFieldRelay;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.EnumForceFieldUpgrade;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.item.ItemForceFieldUpgrade;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockForceFieldRelay
extends BlockAbstractForceField {
    public static final PropertyEnum<EnumForceFieldUpgrade> UPGRADE = PropertyEnum.func_177709_a((String)"upgrade", EnumForceFieldUpgrade.class);
    private static final AxisAlignedBB AABB_RELAY = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0);

    public BlockForceFieldRelay(String registryName, EnumTier enumTier) {
        super(registryName, enumTier, Material.field_151573_f);
        this.func_149663_c("warpdrive.force_field.relay." + enumTier.func_176610_l());
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockProperties.FACING_HORIZONTAL, (Comparable)EnumFacing.NORTH).func_177226_a(UPGRADE, (Comparable)((Object)EnumForceFieldUpgrade.NONE)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockProperties.ACTIVE, BlockProperties.FACING_HORIZONTAL, UPGRADE});
    }

    @Nonnull
    public IBlockState func_176203_a(int metadata) {
        return this.func_176223_P().func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf((metadata & 8) != 0)).func_177226_a((IProperty)BlockProperties.FACING_HORIZONTAL, (Comparable)EnumFacing.func_82600_a((int)Commons.clamp(2, 5, metadata & 7)));
    }

    public int func_176201_c(@Nonnull IBlockState blockState) {
        return ((Boolean)blockState.func_177229_b((IProperty)BlockProperties.ACTIVE) != false ? 8 : 0) | ((EnumFacing)blockState.func_177229_b((IProperty)BlockProperties.FACING_HORIZONTAL)).func_176745_a() & 7;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos) {
        TileEntity tileEntity = blockAccess.func_175625_s(blockPos);
        if (tileEntity instanceof TileEntityForceFieldRelay) {
            return blockState.func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(((TileEntityForceFieldRelay)tileEntity).isConnected)).func_177226_a(UPGRADE, (Comparable)((Object)((TileEntityForceFieldRelay)tileEntity).getUpgrade()));
        }
        return blockState;
    }

    @Override
    @Nullable
    public ItemBlock createItemBlock() {
        return new ItemBlockForceFieldRelay((Block)this);
    }

    public int func_149717_k(@Nonnull IBlockState blockState) {
        return 255;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos) {
        return AABB_RELAY;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos) {
        return AABB_RELAY;
    }

    public boolean func_185481_k(@Nonnull IBlockState blockState) {
        return false;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess blockAccess, @Nonnull IBlockState blockState, @Nonnull BlockPos blockPos, @Nonnull EnumFacing facing) {
        EnumForceFieldUpgrade enumForceFieldUpgrade;
        TileEntity tileEntity;
        if (facing == EnumFacing.DOWN) {
            return BlockFaceShape.SOLID;
        }
        if (facing == EnumFacing.UP && (tileEntity = blockAccess.func_175625_s(blockPos)) instanceof TileEntityForceFieldRelay && (enumForceFieldUpgrade = ((TileEntityForceFieldRelay)tileEntity).getUpgrade()) == EnumForceFieldUpgrade.CAMOUFLAGE) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149730_j(@Nonnull IBlockState blockState) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState blockState) {
        return false;
    }

    @Nonnull
    public TileEntity func_149915_a(@Nonnull World world, int metadata) {
        return new TileEntityForceFieldRelay();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos, @Nonnull EnumFacing facing) {
        BlockPos blockPosSide = blockPos.func_177972_a(facing);
        boolean doesSideBlockRendering = blockAccess.func_180495_p(blockPosSide).doesSideBlockRendering(blockAccess, blockPosSide, facing.func_176734_d());
        if (facing != EnumFacing.DOWN) {
            return !doesSideBlockRendering;
        }
        return true;
    }

    public boolean func_149662_c(@Nonnull IBlockState blockState) {
        return true;
    }

    public boolean doesSideBlockRendering(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos, @Nonnull EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public boolean isSideSolid(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos, @Nonnull EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    @Override
    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumHand enumHand, @Nonnull EnumFacing enumFacing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return super.func_180639_a(world, blockPos, blockState, entityPlayer, enumHand, enumFacing, hitX, hitY, hitZ);
        }
        if (enumHand != EnumHand.MAIN_HAND) {
            return true;
        }
        ItemStack itemStackHeld = entityPlayer.func_184586_b(enumHand);
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (!(tileEntity instanceof TileEntityForceFieldRelay)) {
            return super.func_180639_a(world, blockPos, blockState, entityPlayer, enumHand, enumFacing, hitX, hitY, hitZ);
        }
        TileEntityForceFieldRelay tileEntityForceFieldRelay = (TileEntityForceFieldRelay)tileEntity;
        if (entityPlayer.func_70093_af()) {
            EnumForceFieldUpgrade enumForceFieldUpgrade = tileEntityForceFieldRelay.getUpgrade();
            if (enumForceFieldUpgrade != EnumForceFieldUpgrade.NONE) {
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    ItemStack itemStackDrop = ItemForceFieldUpgrade.getItemStackNoCache(enumForceFieldUpgrade, 1);
                    EntityItem entityItem = new EntityItem(world, entityPlayer.field_70165_t, entityPlayer.field_70163_u + 0.5, entityPlayer.field_70161_v, itemStackDrop);
                    entityItem.func_174868_q();
                    boolean isSuccess = world.func_72838_d((Entity)entityItem);
                    if (!isSuccess) {
                        Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.upgrade.result.spawn_denied", entityItem));
                        return true;
                    }
                }
                tileEntityForceFieldRelay.setUpgrade(EnumForceFieldUpgrade.NONE);
                Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.upgrade.result.dismounted", new TextComponentTranslation(enumForceFieldUpgrade.name(), new Object[0])));
                return true;
            }
            Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.upgrade.result.no_upgrade_to_dismount", new Object[0]));
            return true;
        }
        if (itemStackHeld.func_190926_b()) {
            Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)tileEntityForceFieldRelay.getStatus());
            return true;
        }
        if (itemStackHeld.func_77973_b() instanceof ItemForceFieldUpgrade) {
            if (EnumForceFieldUpgrade.get((int)itemStackHeld.func_77952_i()).maxCountOnRelay <= 0) {
                Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.upgrade.result.invalid_upgrade_for_relay", new Object[0]));
                return true;
            }
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                if (itemStackHeld.func_190916_E() < 1) {
                    Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.upgrade.result.not_enough_upgrades", new Object[0]));
                    return true;
                }
                itemStackHeld.func_190918_g(1);
                if (tileEntityForceFieldRelay.getUpgrade() != EnumForceFieldUpgrade.NONE) {
                    ItemStack itemStackDrop = ItemForceFieldUpgrade.getItemStackNoCache(tileEntityForceFieldRelay.getUpgrade(), 1);
                    EntityItem entityItem = new EntityItem(world, entityPlayer.field_70165_t, entityPlayer.field_70163_u + 0.5, entityPlayer.field_70161_v, itemStackDrop);
                    entityItem.func_174868_q();
                    boolean isSuccess = world.func_72838_d((Entity)entityItem);
                    if (!isSuccess) {
                        Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.upgrade.result.spawn_denied", entityItem));
                        return true;
                    }
                }
            }
            EnumForceFieldUpgrade enumForceFieldUpgrade = EnumForceFieldUpgrade.get(itemStackHeld.func_77952_i());
            tileEntityForceFieldRelay.setUpgrade(enumForceFieldUpgrade);
            Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.upgrade.result.mounted", new TextComponentTranslation(enumForceFieldUpgrade.name(), new Object[0])));
            return true;
        }
        return super.func_180639_a(world, blockPos, blockState, entityPlayer, enumHand, enumFacing, hitX, hitY, hitZ);
    }
}

