/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.forcefield;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBeamFrequency;
import cr0s.warpdrive.block.TileEntityAbstractEnergyConsumer;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.ForceFieldRegistry;
import cr0s.warpdrive.data.Vector3;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

public abstract class TileEntityAbstractForceField
extends TileEntityAbstractEnergyConsumer
implements IBeamFrequency {
    protected int beamFrequency = -1;
    protected boolean isConnected = false;
    protected Vector3 vRGB;

    public TileEntityAbstractForceField() {
        this.addMethods(new String[]{"beamFrequency"});
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        if (IBeamFrequency.isValid(this.beamFrequency)) {
            ForceFieldRegistry.updateInRegistry(this);
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean new_isConnected = IBeamFrequency.isValid(this.beamFrequency);
        if (this.isConnected != new_isConnected) {
            this.isConnected = new_isConnected;
            this.func_70296_d();
        }
    }

    @Override
    public void onBlockBroken(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState) {
        ForceFieldRegistry.removeFromRegistry(this);
        super.onBlockBroken(world, blockPos, blockState);
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
    }

    @Override
    public int getBeamFrequency() {
        return this.beamFrequency;
    }

    @Override
    public void setBeamFrequency(int parBeamFrequency) {
        if (this.beamFrequency != parBeamFrequency && IBeamFrequency.isValid(parBeamFrequency)) {
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info(String.format("%s Beam frequency set from %d to %d", this, this.beamFrequency, parBeamFrequency));
            }
            if (this.func_145830_o()) {
                ForceFieldRegistry.removeFromRegistry(this);
            }
            this.beamFrequency = parBeamFrequency;
            this.vRGB = IBeamFrequency.getBeamColor(this.beamFrequency);
        }
        this.func_70296_d();
        if (this.func_145830_o()) {
            ForceFieldRegistry.updateInRegistry(this);
        }
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.setBeamFrequency(tagCompound.func_74762_e("beamFrequency"));
        this.isConnected = tagCompound.func_74767_n("isConnected");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("beamFrequency", this.beamFrequency);
        tagCompound.func_74757_a("isConnected", this.isConnected);
        return tagCompound;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tagCompound = super.func_189517_E_();
        tagCompound.func_82580_o("beamFrequency");
        return tagCompound;
    }

    public Object[] beamFrequency(Object[] arguments) {
        if (arguments != null && arguments.length == 1 && arguments[0] != null) {
            int beamFrequencyRequested;
            try {
                beamFrequencyRequested = Commons.toInt(arguments[0]);
            }
            catch (Exception exception) {
                String message = String.format("%s LUA error on beamFrequency(): Boolean expected for 1st argument %s", this, arguments[0]);
                if (WarpDriveConfig.LOGGING_LUA) {
                    WarpDrive.logger.error(message);
                }
                return new Object[]{this.beamFrequency, message};
            }
            this.setBeamFrequency(beamFrequencyRequested);
        }
        return new Object[]{this.beamFrequency};
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] beamFrequency(Context context, Arguments arguments) {
        return this.beamFrequency(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "beamFrequency": {
                return this.beamFrequency(arguments);
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }

    @Override
    public String toString() {
        return String.format("%s Beam '%d' %s", this.getClass().getSimpleName(), this.beamFrequency, Commons.format(this.field_145850_b, this.field_174879_c));
    }
}

