/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.hull;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockBase;
import cr0s.warpdrive.api.IDamageReceiver;
import cr0s.warpdrive.block.hull.ItemBlockHull;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.data.Vector3;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHullGlass
extends BlockColored
implements IBlockBase,
IDamageReceiver {
    private final EnumTier enumTier;

    public BlockHullGlass(@Nonnull String registryName, @Nonnull EnumTier enumTier) {
        super(Material.field_151592_s);
        this.enumTier = enumTier;
        this.func_149711_c(WarpDriveConfig.HULL_HARDNESS[enumTier.getIndex()]);
        this.func_149752_b(WarpDriveConfig.HULL_BLAST_RESISTANCE[enumTier.getIndex()] * 5.0f / 3.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149647_a(WarpDrive.creativeTabHull);
        this.func_149663_c("warpdrive.hull." + enumTier.func_176610_l() + ".glass.");
        this.setRegistryName(registryName);
        WarpDrive.register(this, new ItemBlockHull((Block)this));
        this.func_149715_a(0.6666667f);
    }

    @Nonnull
    public EnumPushReaction func_149656_h(@Nonnull IBlockState blockState) {
        return EnumPushReaction.BLOCK;
    }

    public boolean func_149662_c(@Nonnull IBlockState blockState) {
        return false;
    }

    public boolean func_185481_k(@Nonnull IBlockState blockState) {
        return true;
    }

    public boolean func_149637_q(@Nonnull IBlockState blockState) {
        return false;
    }

    public boolean func_149721_r(@Nonnull IBlockState blockState) {
        return true;
    }

    @Override
    @Nonnull
    public EnumTier getTier(ItemStack itemStack) {
        return this.enumTier;
    }

    @Override
    @Nonnull
    public IRarity getForgeRarity(@Nonnull ItemStack itemStack) {
        return this.getTier(itemStack).getForgeRarity();
    }

    @Override
    @Nullable
    public ItemBlock createItemBlock() {
        return new ItemBlockHull((Block)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void modelInitialisation() {
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos, @Nonnull EnumFacing facing) {
        BlockPos blockPosSide = blockPos.func_177972_a(facing);
        IBlockState blockStateSide = blockAccess.func_180495_p(blockPosSide);
        if (blockStateSide.func_177230_c().isAir(blockStateSide, blockAccess, blockPosSide)) {
            return true;
        }
        EnumFacing opposite = facing.func_176734_d();
        if (blockStateSide.func_177230_c() instanceof BlockGlass || blockStateSide.func_177230_c() instanceof BlockHullGlass) {
            return blockState.func_177230_c().func_176201_c(blockState) != blockStateSide.func_177230_c().func_176201_c(blockStateSide);
        }
        return !blockStateSide.doesSideBlockRendering(blockAccess, blockPosSide, opposite);
    }

    @Override
    public float getBlockHardness(IBlockState blockState, World world, BlockPos blockPos, DamageSource damageSource, int damageParameter, Vector3 damageDirection, int damageLevel) {
        return WarpDriveConfig.HULL_HARDNESS[this.enumTier.getIndex()];
    }

    @Override
    public int applyDamage(IBlockState blockState, World world, BlockPos blockPos, DamageSource damageSource, int damageParameter, Vector3 damageDirection, int damageLevel) {
        if (damageLevel <= 0) {
            return 0;
        }
        if (this.enumTier == EnumTier.BASIC) {
            world.func_175698_g(blockPos);
        } else {
            world.func_180501_a(blockPos, WarpDrive.blockHulls_glass[this.enumTier.getIndex() - 1].func_176223_P().func_177226_a((IProperty)field_176581_a, blockState.func_177229_b((IProperty)field_176581_a)), 2);
        }
        return 0;
    }
}

