/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.hull;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IDamageReceiver;
import cr0s.warpdrive.block.BlockAbstractOmnipanel;
import cr0s.warpdrive.block.hull.ItemBlockHull;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.data.Vector3;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockColored;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockHullOmnipanel
extends BlockAbstractOmnipanel
implements IDamageReceiver {
    public BlockHullOmnipanel(String registryName, EnumTier enumTier) {
        super(registryName, enumTier, Material.field_151592_s);
        this.func_149711_c(WarpDriveConfig.HULL_HARDNESS[enumTier.getIndex()]);
        this.func_149752_b(WarpDriveConfig.HULL_BLAST_RESISTANCE[enumTier.getIndex()] * 5.0f / 3.0f);
        this.func_149715_a(0.6666667f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149663_c("warpdrive.hull." + enumTier.func_176610_l() + ".omnipanel.");
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.WHITE));
        this.func_149647_a(WarpDrive.creativeTabHull);
    }

    @Override
    @Nullable
    public ItemBlock createItemBlock() {
        return new ItemBlockHull(this);
    }

    @Nonnull
    public EnumPushReaction func_149656_h(@Nonnull IBlockState blockState) {
        return EnumPushReaction.BLOCK;
    }

    @Override
    public float getBlockHardness(IBlockState blockState, World world, BlockPos blockPos, DamageSource damageSource, int damageParameter, Vector3 damageDirection, int damageLevel) {
        return WarpDriveConfig.HULL_HARDNESS[this.enumTier.getIndex()];
    }

    @Override
    public int applyDamage(IBlockState blockState, World world, BlockPos blockPos, DamageSource damageSource, int damageParameter, Vector3 damageDirection, int damageLevel) {
        if (damageLevel <= 0) {
            return 0;
        }
        if (this.enumTier == EnumTier.BASIC) {
            world.func_175698_g(blockPos);
        } else {
            world.func_180501_a(blockPos, WarpDrive.blockHulls_omnipanel[this.enumTier.getIndex() - 1].func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, blockState.func_177229_b((IProperty)BlockColored.field_176581_a)), 2);
        }
        return 0;
    }
}

