/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.hull;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockBase;
import cr0s.warpdrive.api.IDamageReceiver;
import cr0s.warpdrive.block.BlockAbstractBase;
import cr0s.warpdrive.block.hull.ItemBlockHullSlab;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.data.Vector3;
import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHullSlab
extends BlockAbstractBase
implements IBlockBase,
IDamageReceiver {
    private static final AxisAlignedBB AABB_HALF_DOWN = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    private static final AxisAlignedBB AABB_HALF_UP = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_HALF_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.5);
    private static final AxisAlignedBB AABB_HALF_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_HALF_EAST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0);
    private static final AxisAlignedBB AABB_HALF_WEST = new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_FULL = field_185505_j;
    public static final PropertyEnum<EnumVariant> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumVariant.class);
    final EnumTier enumTier;
    private final IBlockState blockStateHull;

    public BlockHullSlab(@Nonnull String registryName, @Nonnull EnumTier enumTier, @Nonnull IBlockState blockStateHull) {
        super(registryName, enumTier, Material.field_151576_e);
        this.field_149787_q = false;
        this.func_149713_g(0);
        this.field_149783_u = true;
        this.enumTier = enumTier;
        this.blockStateHull = blockStateHull;
        this.func_149711_c(WarpDriveConfig.HULL_HARDNESS[enumTier.getIndex()]);
        this.func_149752_b(WarpDriveConfig.HULL_BLAST_RESISTANCE[enumTier.getIndex()] * 5.0f / 3.0f);
        this.func_149663_c("warpdrive.hull." + enumTier.func_176610_l() + ".slab." + EnumDyeColor.func_176764_b((int)blockStateHull.func_177230_c().func_176201_c(blockStateHull)).func_176762_d());
        this.func_180632_j(this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumVariant.PLAIN_DOWN)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    @Nonnull
    public IBlockState func_176203_a(int metadata) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumVariant.get(metadata)));
    }

    public int func_176201_c(@Nonnull IBlockState blockState) {
        return ((EnumVariant)((Object)blockState.func_177229_b(VARIANT))).ordinal();
    }

    @Nonnull
    public EnumPushReaction func_149656_h(@Nonnull IBlockState blockState) {
        return EnumPushReaction.BLOCK;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(@Nonnull CreativeTabs creativeTab, @Nonnull NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
        list.add((Object)new ItemStack((Block)this, 1, 2));
        list.add((Object)new ItemStack((Block)this, 1, 6));
        list.add((Object)new ItemStack((Block)this, 1, 8));
        list.add((Object)new ItemStack((Block)this, 1, 12));
        list.add((Object)new ItemStack((Block)this, 1, 13));
        list.add((Object)new ItemStack((Block)this, 1, 14));
        list.add((Object)new ItemStack((Block)this, 1, 15));
    }

    public int func_180651_a(@Nonnull IBlockState blockState) {
        int metadata = this.func_176201_c(blockState);
        return metadata <= 1 ? 0 : (metadata <= 5 ? 2 : (metadata <= 7 ? 6 : (metadata <= 11 ? 8 : metadata)));
    }

    public int func_149717_k(@Nonnull IBlockState blockState) {
        EnumVariant variant = (EnumVariant)((Object)blockState.func_177229_b(VARIANT));
        if (variant.getIsDouble() || variant.getFacing().func_96559_d() != 0) {
            return 255;
        }
        return 0;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos) {
        return this.getBlockBoundsFromState(blockState);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos) {
        return this.getBlockBoundsFromState(blockState);
    }

    private AxisAlignedBB getBlockBoundsFromState(IBlockState blockState) {
        if (blockState == null) {
            return AABB_FULL;
        }
        return ((EnumVariant)((Object)blockState.func_177229_b(VARIANT))).getAxisAlignedBB();
    }

    public boolean func_185481_k(@Nonnull IBlockState blockState) {
        EnumVariant variant = (EnumVariant)((Object)blockState.func_177229_b(VARIANT));
        return variant.getIsDouble() || variant.getFacing() == EnumFacing.UP;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess blockAccess, @Nonnull IBlockState blockState, @Nonnull BlockPos blockPos, @Nonnull EnumFacing enumFacing) {
        EnumVariant variant = (EnumVariant)((Object)blockState.func_177229_b(VARIANT));
        if (variant.getIsDouble()) {
            return BlockFaceShape.SOLID;
        }
        return enumFacing == variant.getFacing() ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_149730_j(@Nonnull IBlockState blockState) {
        return ((EnumVariant)((Object)blockState.func_177229_b(VARIANT))).getIsDouble();
    }

    public boolean func_149686_d(@Nonnull IBlockState blockState) {
        return ((EnumVariant)((Object)blockState.func_177229_b(VARIANT))).getIsDouble();
    }

    @Override
    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int metadata, @Nonnull EntityLivingBase entityLivingBase, @Nonnull EnumHand enumHand) {
        IBlockState blockState = this.func_176203_a(metadata);
        if (((EnumVariant)((Object)blockState.func_177229_b(VARIANT))).getIsDouble()) {
            return blockState;
        }
        if (metadata == 0) {
            EnumVariant variant = facing != EnumFacing.DOWN && (facing == EnumFacing.UP || hitY <= 0.5f) ? EnumVariant.PLAIN_DOWN : EnumVariant.PLAIN_UP;
            return blockState.func_177226_a(VARIANT, (Comparable)((Object)variant));
        }
        if (metadata == 6) {
            EnumVariant variant = facing != EnumFacing.DOWN && (facing == EnumFacing.UP || hitY <= 0.5f) ? EnumVariant.TILED_DOWN : EnumVariant.TILED_UP;
            return blockState.func_177226_a(VARIANT, (Comparable)((Object)variant));
        }
        if (metadata == 2) {
            if (facing != EnumFacing.DOWN && facing != EnumFacing.UP) {
                switch (facing) {
                    case NORTH: {
                        return blockState.func_177226_a(VARIANT, (Comparable)((Object)EnumVariant.PLAIN_SOUTH));
                    }
                    case SOUTH: {
                        return blockState.func_177226_a(VARIANT, (Comparable)((Object)EnumVariant.PLAIN_NORTH));
                    }
                    case WEST: {
                        return blockState.func_177226_a(VARIANT, (Comparable)((Object)EnumVariant.PLAIN_EAST));
                    }
                    case EAST: {
                        return blockState.func_177226_a(VARIANT, (Comparable)((Object)EnumVariant.PLAIN_WEST));
                    }
                }
            }
            if (Math.abs(hitX - 0.5f) > Math.abs(hitZ - 0.5f)) {
                EnumVariant variant = hitX > 0.5f ? EnumVariant.PLAIN_EAST : EnumVariant.PLAIN_WEST;
                return blockState.func_177226_a(VARIANT, (Comparable)((Object)variant));
            }
            EnumVariant variant = hitZ > 0.5f ? EnumVariant.PLAIN_SOUTH : EnumVariant.PLAIN_NORTH;
            return blockState.func_177226_a(VARIANT, (Comparable)((Object)variant));
        }
        if (metadata == 8) {
            if (facing != EnumFacing.DOWN && facing != EnumFacing.UP) {
                switch (facing) {
                    case NORTH: {
                        return blockState.func_177226_a(VARIANT, (Comparable)((Object)EnumVariant.TILED_SOUTH));
                    }
                    case SOUTH: {
                        return blockState.func_177226_a(VARIANT, (Comparable)((Object)EnumVariant.TILED_NORTH));
                    }
                    case WEST: {
                        return blockState.func_177226_a(VARIANT, (Comparable)((Object)EnumVariant.TILED_EAST));
                    }
                    case EAST: {
                        return blockState.func_177226_a(VARIANT, (Comparable)((Object)EnumVariant.TILED_WEST));
                    }
                }
            }
            if (Math.abs(hitX - 0.5f) > Math.abs(hitZ - 0.5f)) {
                EnumVariant variant = hitX > 0.5f ? EnumVariant.TILED_EAST : EnumVariant.TILED_WEST;
                return blockState.func_177226_a(VARIANT, (Comparable)((Object)variant));
            }
            EnumVariant variant = hitZ > 0.5f ? EnumVariant.TILED_SOUTH : EnumVariant.TILED_NORTH;
            return blockState.func_177226_a(VARIANT, (Comparable)((Object)variant));
        }
        return BlockHullSlab.func_176220_d((int)metadata);
    }

    public int func_149745_a(@Nonnull Random random) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos, @Nonnull EnumFacing facing) {
        EnumVariant variant = (EnumVariant)((Object)blockState.func_177229_b(VARIANT));
        BlockPos blockPosSide = blockPos.func_177972_a(facing);
        boolean doesSideBlockRendering = blockAccess.func_180495_p(blockPosSide).doesSideBlockRendering(blockAccess, blockPosSide, facing.func_176734_d());
        if (facing != variant.getFacing()) {
            return !doesSideBlockRendering;
        }
        return !doesSideBlockRendering;
    }

    public boolean func_149662_c(@Nonnull IBlockState blockState) {
        return ((EnumVariant)((Object)blockState.func_177229_b(VARIANT))).getIsDouble();
    }

    public boolean doesSideBlockRendering(@Nonnull IBlockState blockState, IBlockAccess blockAccess, BlockPos blockPos, EnumFacing side) {
        EnumVariant variant = (EnumVariant)((Object)blockState.func_177229_b(VARIANT));
        return variant.getIsDouble() || variant.getFacing() == side;
    }

    public boolean isSideSolid(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos, @Nonnull EnumFacing side) {
        EnumFacing enumFacing = ((EnumVariant)((Object)blockState.func_177229_b(VARIANT))).getFacing();
        return enumFacing == side;
    }

    @Nonnull
    public MapColor func_180659_g(IBlockState blockState, IBlockAccess blockAccess, BlockPos blockPos) {
        return this.blockStateHull.func_185909_g(blockAccess, blockPos);
    }

    @Override
    @Nonnull
    public EnumTier getTier(ItemStack itemStack) {
        return this.enumTier;
    }

    @Override
    @Nonnull
    public IRarity getForgeRarity(@Nonnull ItemStack itemStack) {
        return this.enumTier.getForgeRarity();
    }

    @Override
    @Nullable
    public ItemBlock createItemBlock() {
        return new ItemBlockHullSlab(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void modelInitialisation() {
    }

    @Override
    public float getBlockHardness(IBlockState blockState, World world, BlockPos blockPos, DamageSource damageSource, int damageParameter, Vector3 damageDirection, int damageLevel) {
        return WarpDriveConfig.HULL_HARDNESS[this.enumTier.getIndex()];
    }

    @Override
    public int applyDamage(IBlockState blockState, World world, BlockPos blockPos, DamageSource damageSource, int damageParameter, Vector3 damageDirection, int damageLevel) {
        if (damageLevel <= 0) {
            return 0;
        }
        if (this.enumTier == EnumTier.BASIC) {
            world.func_175698_g(blockPos);
        } else {
            world.func_180501_a(blockPos, WarpDrive.blockHulls_slab[this.enumTier.getIndex() - 1][this.blockStateHull.func_177230_c().func_176201_c(this.blockStateHull)].func_176223_P().func_177226_a(VARIANT, blockState.func_177229_b(VARIANT)), 2);
        }
        return 0;
    }

    static /* synthetic */ AxisAlignedBB access$000() {
        return AABB_HALF_DOWN;
    }

    static /* synthetic */ AxisAlignedBB access$100() {
        return AABB_HALF_UP;
    }

    static /* synthetic */ AxisAlignedBB access$200() {
        return AABB_HALF_NORTH;
    }

    static /* synthetic */ AxisAlignedBB access$300() {
        return AABB_HALF_SOUTH;
    }

    static /* synthetic */ AxisAlignedBB access$400() {
        return AABB_HALF_EAST;
    }

    static /* synthetic */ AxisAlignedBB access$500() {
        return AABB_HALF_WEST;
    }

    static /* synthetic */ AxisAlignedBB access$600() {
        return AABB_FULL;
    }

    public static enum EnumVariant implements IStringSerializable
    {
        PLAIN_DOWN("plain_down", false, true, EnumFacing.DOWN, BlockHullSlab.access$000()),
        PLAIN_UP("plain_up", false, true, EnumFacing.UP, BlockHullSlab.access$100()),
        PLAIN_NORTH("plain_north", false, true, EnumFacing.NORTH, BlockHullSlab.access$200()),
        PLAIN_SOUTH("plain_south", false, true, EnumFacing.SOUTH, BlockHullSlab.access$300()),
        PLAIN_WEST("plain_west", false, true, EnumFacing.WEST, BlockHullSlab.access$400()),
        PLAIN_EAST("plain_east", false, true, EnumFacing.EAST, BlockHullSlab.access$500()),
        TILED_DOWN("tiled_down", false, false, EnumFacing.DOWN, BlockHullSlab.access$000()),
        TILED_UP("tiled_up", false, false, EnumFacing.UP, BlockHullSlab.access$100()),
        TILED_NORTH("tiled_north", false, false, EnumFacing.NORTH, BlockHullSlab.access$200()),
        TILED_SOUTH("tiled_south", false, false, EnumFacing.SOUTH, BlockHullSlab.access$300()),
        TILED_WEST("tiled_west", false, false, EnumFacing.WEST, BlockHullSlab.access$400()),
        TILED_EAST("tiled_east", false, false, EnumFacing.EAST, BlockHullSlab.access$500()),
        PLAIN_FULL("plain_full", true, true, EnumFacing.DOWN, BlockHullSlab.access$600()),
        TILED_FULL_X("tiled_full_x", true, false, EnumFacing.DOWN, BlockHullSlab.access$600()),
        TILED_FULL_Y("tiled_full_y", true, false, EnumFacing.DOWN, BlockHullSlab.access$600()),
        TILED_FULL_Z("tiled_full_z", true, false, EnumFacing.DOWN, BlockHullSlab.access$600());

        private final String name;
        private final boolean isDouble;
        private final boolean isPlain;
        private final EnumFacing facing;
        private final AxisAlignedBB axisAlignedBB;
        public static final int length;
        private static final HashMap<Integer, EnumVariant> ID_MAP;

        private EnumVariant(String name, @Nonnull boolean isDouble, @Nonnull boolean isPlain, EnumFacing facing, AxisAlignedBB axisAlignedBB) {
            this.name = name;
            this.isDouble = isDouble;
            this.isPlain = isPlain;
            this.facing = facing;
            this.axisAlignedBB = axisAlignedBB;
        }

        public static EnumVariant get(int metadata) {
            return ID_MAP.get(metadata);
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public boolean getIsDouble() {
            return this.isDouble;
        }

        public boolean getIsPlain() {
            return this.isPlain;
        }

        public EnumFacing getFacing() {
            return this.facing;
        }

        public AxisAlignedBB getAxisAlignedBB() {
            return this.axisAlignedBB;
        }

        static {
            ID_MAP = new HashMap();
            length = EnumVariant.values().length;
            for (EnumVariant variant : EnumVariant.values()) {
                ID_MAP.put(variant.ordinal(), variant);
            }
        }
    }
}

