/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cr0s.warpdrive.CommonProxy;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.BlockAbstractContainer;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.EnumComponentType;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.data.SoundEvents;
import cr0s.warpdrive.item.ItemComponent;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BlockShipCore
extends BlockAbstractContainer {
    public BlockShipCore(String registryName, EnumTier enumTier) {
        super(registryName, enumTier, Material.field_151573_f);
        this.func_149663_c("warpdrive.movement.ship_core." + enumTier.func_176610_l());
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockProperties.FACING_HORIZONTAL, (Comparable)EnumFacing.NORTH));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockProperties.ACTIVE, BlockProperties.FACING_HORIZONTAL});
    }

    @Nonnull
    public IBlockState func_176203_a(int metadata) {
        return this.func_176223_P().func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf((metadata & 8) != 0)).func_177226_a((IProperty)BlockProperties.FACING_HORIZONTAL, (Comparable)EnumFacing.func_82600_a((int)Commons.clamp(2, 5, metadata & 7)));
    }

    public int func_176201_c(@Nonnull IBlockState blockState) {
        return ((Boolean)blockState.func_177229_b((IProperty)BlockProperties.ACTIVE) != false ? 8 : 0) | ((EnumFacing)blockState.func_177229_b((IProperty)BlockProperties.FACING_HORIZONTAL)).func_176745_a();
    }

    @Nonnull
    public TileEntity func_149915_a(@Nonnull World world, int metadata) {
        return new TileEntityShipCore();
    }

    @Override
    public void getDrops(@Nonnull NonNullList<ItemStack> itemStacks, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState, int fortune) {
        TileEntity tileEntity = blockAccess.func_175625_s(blockPos);
        if (tileEntity instanceof TileEntityShipCore && ((TileEntityShipCore)tileEntity).jumpCount == 0) {
            super.getDrops(itemStacks, blockAccess, blockPos, blockState, fortune);
            return;
        }
        if (blockAccess instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)blockAccess;
            EntityPlayer entityPlayer = CommonProxy.getFakePlayer(null, worldServer, blockPos);
            EntityTNTPrimed entityTNTPrimed = new EntityTNTPrimed((World)worldServer, (double)((float)blockPos.func_177958_n() + 0.5f), (double)((float)blockPos.func_177956_o() + 0.5f), (double)((float)blockPos.func_177952_p() + 0.5f), (EntityLivingBase)entityPlayer);
            entityTNTPrimed.func_184534_a(10 + worldServer.field_73012_v.nextInt(10));
            worldServer.func_72838_d((Entity)entityTNTPrimed);
            itemStacks.add((Object)ItemComponent.getItemStackNoCache(EnumComponentType.CAPACITIVE_CRYSTAL, 1));
            if (fortune > 0 && worldServer.field_73012_v.nextBoolean()) {
                itemStacks.add((Object)ItemComponent.getItemStackNoCache(EnumComponentType.CAPACITIVE_CRYSTAL, 1));
            }
            if (fortune > 1 && worldServer.field_73012_v.nextBoolean()) {
                itemStacks.add((Object)ItemComponent.getItemStackNoCache(EnumComponentType.CAPACITIVE_CRYSTAL, 1));
            }
            if (fortune > 1 & worldServer.field_73012_v.nextBoolean()) {
                itemStacks.add((Object)ItemComponent.getItemStackNoCache(EnumComponentType.POWER_INTERFACE, 1));
            }
        }
    }

    public float func_180647_a(@Nonnull IBlockState blockState, @Nonnull EntityPlayer entityPlayer, @Nonnull World world, @Nonnull BlockPos blockPos) {
        boolean willBreak = true;
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof TileEntityShipCore && ((TileEntityShipCore)tileEntity).jumpCount == 0) {
            willBreak = false;
        }
        return (willBreak ? 0.02f : 1.0f) * super.func_180647_a(blockState, entityPlayer, world, blockPos);
    }

    @Override
    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumHand enumHand, @Nonnull EnumFacing enumFacing, float hitX, float hitY, float hitZ) {
        if (enumHand != EnumHand.MAIN_HAND) {
            return super.func_180639_a(world, blockPos, blockState, entityPlayer, enumHand, enumFacing, hitX, hitY, hitZ);
        }
        ItemStack itemStackHeld = entityPlayer.func_184586_b(enumHand);
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (!(tileEntity instanceof TileEntityShipCore)) {
            return super.func_180639_a(world, blockPos, blockState, entityPlayer, enumHand, enumFacing, hitX, hitY, hitZ);
        }
        TileEntityShipCore tileEntityShipCore = (TileEntityShipCore)tileEntity;
        if (itemStackHeld.func_190926_b()) {
            if (world.field_72995_K && entityPlayer.func_70093_af()) {
                boolean bl = tileEntityShipCore.showBoundingBox = !tileEntityShipCore.showBoundingBox;
                if (tileEntityShipCore.showBoundingBox) {
                    world.func_184133_a(null, blockPos, SoundEvents.LASER_LOW, SoundCategory.BLOCKS, 4.0f, 2.0f);
                } else {
                    world.func_184133_a(null, blockPos, SoundEvents.LASER_LOW, SoundCategory.BLOCKS, 4.0f, 1.4f);
                }
                Commons.addChatMessage((ICommandSender)entityPlayer, tileEntityShipCore.getBoundingBoxStatus());
                return true;
            }
            if (!world.field_72995_K && !entityPlayer.func_70093_af()) {
                Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)tileEntityShipCore.getStatus());
                return true;
            }
        }
        return super.func_180639_a(world, blockPos, blockState, entityPlayer, enumHand, enumFacing, hitX, hitY, hitZ);
    }

    public void func_190948_a(@Nonnull ItemStack itemStack, @Nullable World world, @Nonnull List<String> list, @Nonnull ITooltipFlag advancedItemTooltips) {
        super.func_190948_a(itemStack, world, list, advancedItemTooltips);
        Commons.addTooltip(list, new TextComponentTranslation("tile.warpdrive.movement.ship_core.tooltip.constrains", new Object[]{new WarpDriveText(Commons.getStyleValue(), WarpDriveConfig.SHIP_SIZE_MAX_PER_SIDE_BY_TIER[this.enumTier.getIndex()]), new WarpDriveText(Commons.getStyleValue(), WarpDriveConfig.SHIP_MASS_MIN_BY_TIER[this.enumTier.getIndex()]), new WarpDriveText(Commons.getStyleValue(), WarpDriveConfig.SHIP_MASS_MAX_BY_TIER[this.enumTier.getIndex()]), new WarpDriveText(Commons.getStyleValue(), WarpDriveConfig.SHIP_MASS_MAX_ON_PLANET_SURFACE), new WarpDriveText(Commons.getStyleValue(), WarpDriveConfig.SHIP_MASS_MIN_FOR_HYPERSPACE)}).func_150254_d());
    }
}

