/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cr0s.warpdrive.block.BlockAbstractBase;
import cr0s.warpdrive.block.movement.BlockTransporterContainment;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.EnumTier;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTransporterScanner
extends BlockAbstractBase {
    protected static final AxisAlignedBB AABB_HALF_DOWN = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);

    public BlockTransporterScanner(String registryName, EnumTier enumTier) {
        super(registryName, enumTier, Material.field_151573_f);
        this.func_149663_c("warpdrive.movement.transporter_scanner");
        this.func_149713_g(255);
        this.field_149783_u = true;
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockProperties.ACTIVE});
    }

    @Nonnull
    public IBlockState func_176203_a(int metadata) {
        return this.func_176223_P().func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(metadata != 0));
    }

    public int func_176201_c(@Nonnull IBlockState blockState) {
        return (Boolean)blockState.func_177229_b((IProperty)BlockProperties.ACTIVE) != false ? 1 : 0;
    }

    public boolean func_149662_c(@Nonnull IBlockState blockState) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState blockState) {
        return false;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess blockAccess, @Nonnull IBlockState blockState, @Nonnull BlockPos blockPos, @Nonnull EnumFacing enumFacing) {
        return enumFacing == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean isSideSolid(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos, @Nonnull EnumFacing enumFacing) {
        return enumFacing == EnumFacing.DOWN;
    }

    public int getLightValue(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos) {
        return (Boolean)blockState.func_177229_b((IProperty)BlockProperties.ACTIVE) != false ? 13 : 0;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos) {
        return AABB_HALF_DOWN;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos) {
        return AABB_HALF_DOWN;
    }

    public Collection<BlockPos> getValidContainment(World world, BlockPos blockPos) {
        ArrayList<BlockPos> vContainments = new ArrayList<BlockPos>(8);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(blockPos);
        boolean isScannerPosition = true;
        for (int x = blockPos.func_177958_n() - 1; x <= blockPos.func_177958_n() + 1; ++x) {
            for (int z = blockPos.func_177952_p() - 1; z <= blockPos.func_177952_p() + 1; ++z) {
                mutableBlockPos.func_181079_c(x, blockPos.func_177956_o(), z);
                Block blockBase = world.func_180495_p((BlockPos)mutableBlockPos).func_177230_c();
                if (!(blockBase instanceof BlockTransporterContainment || isScannerPosition && blockBase instanceof BlockTransporterScanner)) {
                    return null;
                }
                isScannerPosition = !isScannerPosition;
                mutableBlockPos.func_189536_c(EnumFacing.UP);
                if (!world.func_175623_d((BlockPos)mutableBlockPos)) {
                    return null;
                }
                mutableBlockPos.func_189536_c(EnumFacing.UP);
                if (!world.func_175623_d((BlockPos)mutableBlockPos)) {
                    return null;
                }
                if (!(blockBase instanceof BlockTransporterContainment)) continue;
                vContainments.add(new BlockPos(x, blockPos.func_177956_o(), z));
            }
        }
        return vContainments;
    }
}

